SET NOCOUNT ON
GO

BEGIN TRAN

BEGIN TRY

	USE $(varBMS)
	DECLARE @P1 INT	

	INSERT [dbo].[OPTIONS] ([PARAMETER], [PARAMETER_VALUE]) VALUES ('AUDIT', 'Y')
	INSERT [dbo].[OPTIONS] ([PARAMETER], [PARAMETER_VALUE]) VALUES ('HISTORY', 'Y')
	INSERT [dbo].[OPTIONS] ([PARAMETER], [PARAMETER_VALUE]) VALUES ('HISTORY_DATABASE', '$(varBMS_HISTORY)')

	-- BEGIN INSERT APPLICATION ICONS

	DECLARE @DATE_NOW DATETIME
	SET @DATE_NOW = GETUTCDATE()
	
	set @p1=0
	exec usp_Insert_Icon @ID=@p1 output,@ICON_FLAG_ID=NULL,@GROUP=N'APPLICATION_ICON',@SUBGROUP=N'BED_CLEANING_ICON', 
	@ICON_TYPE_CODE=N'BED_NEEDS_CLEAN',@ICON_TYPE_CODE_SYSTEM=N'2.12.24.51',@ICON_TYPE_CODE_SYSTEM_NAME=N'ApplicationIcons',@ICON_TYPE_DISPLAY_NAME=N'Bed Needs Cleaning', 
	@IMAGE_BYTES=N'iVBORw0KGgoAAAANSUhEUgAAABQAAAAUCAYAAACNiR0NAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAQaSURBVDhPjZRdUFRlGMcfjU1ta6ZmmmlqposuqpsumumqLqKmoDHdUqtpyjFx0sqxyRFBQEqssWETJVJYdmWBQvkIFixwQb5Foi+DlEAQ9rC7ICDJ2e2wy8eC+u9/ZJmhBpoufvO8855zfvs/z/uclWAw4AqFQmogOKNqEyFVC7Aux0T42iRraEYNzIbUIKvb7VG9Ho86MaEpMj4+PjUyOoaeKx7iRW/fIHr1uhwKr3nJoBf9g1fh9g6j6owT5861QNO0aXEpXrXWmYeGym1ob9qMX+q2oq1mCaq510TaSF4M2rZvwYXX38XPKWakm79AkcMBv6b55HLPgOp0xKO79h5oF1fB37EGvqXo5H4vKSWRZM1qaA/fDU+yCcczPkfx6TMUTvikr9+rNlbtRX3+SrQWCXy/CzBCPMQdZpDVT9rIJnIHWUn2CtTWaGSfMKO4rBp+PxMODAypjc5EHN1/F8yxgmu68Ba5ThTBrQGiERfZTe4kwmtR+o8ZoPlMyLJQWOJcLEzCkWQj9rwjKM8R/NggGLrAB0bnk928QpgGDxIKsV4w4xAM9xvg7TbBmmlGSWlYqDBhy9kkHP/UiE3Rgi0bBXHbBJbPBArT3uhmokQKKbq5glCGXwWuXt6TakBNsQm5NjPKHIsSttYm4ejHRqx7TrBvhyD7kGDXTkFmgsC/nYKHyCrByFOCHovA0yX4nv2Oec2Ak9km5NvNcFQsEp6vScKXnxjxxkuCg+xTgU2QyFe0PsmmRwhC7Jn6hMD5keBYuiA/Q5D0gWBDlAHFORTmLiH8KsWI9c8LNr8lMB/gwzGCsQcEs5R1UJrB9IkfCvbsYn2fshcELz5twLe5JnxDYdnihC16wgNGvGoS7KDoayZ13T8/GnOPCxrfFqRwAlLYgtQ4Qfp+wXtvCtZFGlBinxf+45WbnUlIO2jEbvavjinUR+aT4VEKMwXjHYKB3wTeVp7sD0zeyTcoEGzdaECB5V891E+5vj4Rxw4bkfksG0/Z7cF9jCd6ggxxrYZH6Gp46DmXAz8J0hIiUHnSBDsHu7Q8fCj9bq96tiYezngD2u8TBPRk95J9HJcFGYdbH/Lb6Gvua38IumpWoPv8WlgtqfxSwkLX6Ijamp+MkWdWA7pM7x1luESYBNfmBdDTLTDMtc54BCbdryDHmsbBDn96PYqittgs6DNtwHBkFAZ3rsVQ68sYcpMucpFcCld9HWawM5pfigl97Qk4cvgQThXy38bv90lDfaNqt9iRnZ6FnKxs2PKssJ0idmL9D2zZsOfYYLFkITY2DoWFRQgEgj5pbm6arayuRkVtDcob6lBeTb4jp/8PtSivqEJJSTF6ey9jenpqTia0sfaZKZ/Cqmg6/kUs7C1X9Xu1P5Vg4LpyYy6oTE/+1fE3+IhjYwK8buoAAAAASUVORK5CYII=', 
	@IMAGE_BYTES_INACTIVE=N'iVBORw0KGgoAAAANSUhEUgAAABQAAAAUCAYAAACNiR0NAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAANsSURBVDhPjVTXSmRBFJy/8kXBgGCOYA4YHhTMOSOILwrmiKKgmHMWFRNm3DFnx4Tgi9ec2HmovXXgzrKrLjtQXOjuqa5Tp07rXl5eTj8+PhT1qzw9PSnPz8/fQtvn2be3N+X9/V1wdnamnJ+f8/8G3e3t7dvNzQ2Ojo4Ex8fH/8Tp6SlUAqgEuLi4wOXlJYaHhzE7O4uHh4d3nXpA4UJ3dzfGx8dlc3Bw8BMGBgYwOjqKiYkJNDc3Izc3F+np6aiqqkJBQQE6Oztxf39/pzs4OFA6OjrQ29uLhYUFzM/PfwnuraysoKenBzExMXBxcYG/vz8qKipQUlIi64+Pj3e6k5MTpa+vT26qr68Xst3dXWxtbWFzc1Owvb0tNszNzSE7O1vICBLxfHV1Nbq6unCn/nQ0lOUkJiYiKipKvLi6uoKqHBsbGwKS6fV6FBUVwc3NDU5OTkhOTpZLDQaDqGSVfxAmJSXB19cXxcXF4sfU1BT29vaEbH19XdSwRBLSu/7+fiwtLWFtbU0ITQrVG6QpPGRtbS23BwQEICMjQ0hXV1dRXl4OV1dX2eM5+qmV39TUhJqaGvHQpHBkZERKMDc3R3BwMDIzMxEUFCQ25OXlyQXu7u4ICwtDbW2t2ELf6GNZWRnq6uqkqSbCoaEhpKSkwMbGBhERESgsLJSvg4MD7O3t4ejoiJCQEKSmpkpc8vPzERoaCisrK2nml4RpaWmwsLAQj6gsNjYWnp6eQmZpaSkKw8PDhZjgmpmZmZTLdHyp0NbWFt7e3vDz8zNFg0qYu8jISElBdHS0XOjh4SEWsfRPhIwNSw4MDASVsptURjJOBT2bnJzE2NiYTBOzx1KdnZ0/e6h1OScnR8ry8fERdWxAW1ubhPrw8FAitLOzI6FXh0GI4+Li0NDQII0ydZmEzFRWVhbs7OykCV5eXnKzRqYFXPtyfXFxUeafs11ZWfk7h9fX10pra6t0lSVQIck4t1RCZSSgOg1USVD5/v7+n6PHWW5paRHv4uPj5eWYmZmRGWaol5eXhZzfv8Fx5Br/Qw7JoToNCltfWlpq6lhjY6Nki+vfgb7xDJuTkJAghOrjfKebnp7+yUkh2EWOIT39H/CVYv7a29ulfPUVN+rUV/bH6+urQX0cBapqE7S17748yz0+/Uaj0aDy6H8BRsOnq/LgcFUAAAAASUVORK5CYII=', 
	@ORDER_INDEX=1,@ACTIVE=1,@PUBLISHED=1,@PATIENT_OR_ROOMBED=NULL,@IMAGE_NAME=N'BedNeedsCleaning.png',@ICON_NAME=N'Bed Needs Cleaning',@SHORT_DESCRIPTION=N'Bed Needs Cleaning Icon',
	@LONG_DESCRIPTION=N'Bed Needs Cleaning Icon',@COMMENT=NULL,@MOUSE_OVER_TEXT=N'Bed Needs Cleaning',@FACILITY_UID=NULL,
	@FACILITY_ICON_NAME=NULL,@FACILITY_DESCRIPTION=NULL,@FACILITY_COMMENT=NULL,@FACILITY_MOUSE_OVER_TEXT=NULL,@FACILITY_PATIENT_OR_ROOMBED=' ',
	@FACILITY_ACTIVE=0,@FACILITY_ORDER_INDEX=0,@ENTERED_BY=N'softinfo\bmsuser',@ENTERED_DATE=@DATE_NOW,
	@LAST_EDIT_BY=N'softinfo\bmsuser',@LAST_EDIT_DATE=@DATE_NOW

	set @p1=0
	exec usp_Insert_Icon @ID=@p1 output,@ICON_FLAG_ID=NULL,@GROUP=N'APPLICATION_ICON',@SUBGROUP=N'BED_CLEANING_ICON', 
	@ICON_TYPE_CODE=N'CLEANING_BED',@ICON_TYPE_CODE_SYSTEM=N'2.12.24.51',@ICON_TYPE_CODE_SYSTEM_NAME=N'ApplicationIcons',@ICON_TYPE_DISPLAY_NAME=N'Cleaning Bed', 
	@IMAGE_BYTES=N'iVBORw0KGgoAAAANSUhEUgAAABQAAAAUCAYAAACNiR0NAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAQMSURBVDhPlVNbbJNlGH7dZDcm3mk0kniKoqkxxJggF4YSiAvDE/V4AXrhYqLgnRgSCMELNCFGo8lAIQG3zk3d2u7Q9v/bDjcZc2vX7lwCQndgxXZt/87237pDNx6fv91Mg3jBxZPv/d//fZ/veQ+f6Hrm2tLigjY3t6Bl9cXbI/s/fsbrxDxzkzMz2vh4JCLz87lcLB5HIDiCPv8o/P3hIgJhBHgGB8IIDYbRHyz6/v1fiBkr+K5cvQ5/XwCKqi6IPreoeT0qan/4AMovVfA07+FpKaCjxYIe1YJejwVd7Raovxb963D//Drt3ejrPAZbUz3qG5rTMpvJa60tzfA1bkJiqBypkQ1IDVYgNUzw/KOpAu2nKzDVUwFtrOhbR3KQsUN3I/VnJdxttaivbzcIVzSX045+1xNAXIBZIkvkBf42wRsvCbZuFpw8JshF6E8S0yW4IbgZ3wGv21DoLip0Ox3wu57BMhOu+wXTAwI9Jqj5QlBeJhAR7NkhiA+tERrE65gow/L0Lqgug9BVJFTcDvS5TIj1CjxnBWe/FBw5IHjnFcGTjwq2UGHdV1R4lURR4loJxstJWFVCmM1rquJAr9OEKx2Chm8E774s2EBlLzwrqH5b0HJGsPrXWpmlZIb9H0JDocuBAZ8JiZDgKJVtfFCw6THBmeOCU58Lhr1M/JuYJAyV42vkUzwnblW41sORThPSoyyzSlB2l2CfRRBWBd8eFnTZBCvGMCaKpa6SMMdzyVA4eRtCo4dj3SZc+l3w4vOCh+4XHHhf8BPLP/KRoKeFiWnCUESVSVbSYRUEW0keKUc+VtpDKlQNwgsmBKlot1lwsFpweD/xsaD1lGCym0RGDzn5VQ5lzMPLvhbYagSpEBUm+SCUkimvEwYUwWs7i8EnDgm2bxEutiARoKI6wewllq4LrN8JLNzPva8KBlwkzFTBp95CGGbJQd68+SnBJ/sE+/cKHrhP0HZa4OSUDf/xg4IMFR79lFtQLrj3HoHaUIZ8bhd8HhLWr+2h22XHSOfTiPTwZi5w9ZuCQx8Kdm7lynwvOMe9fHyj4K1KweXfuKcnuAUPC57jJX1tJNQr4VWsRcJMdkUzCEPKI1jg9gdchJMT5k5etAuifDkR9tDNIZxvZPlBQYzw0O5kO7KX2dfUNnQYJTcqadH1Za3nYhdCne8hF93Gd2zmezbjpsYzY0Y+bsZKgvZc8XspasbyDO1c0bcU2w79xmdwOxtRW2dPy8TElKYoHtibauFz1xVu8nFiXsJotIeP3oBhG30qfPPdFr5VK2OtjG1CTc1JnPvRmpax0eFlr9cLm90Fu+M8bI6OO0Ihx+5Gc7MN3d0X8pLJJEPZTCKSTESJG3eOGSMnGtGzqcj8fHrgHxM2aVgtP/fcAAAAAElFTkSuQmCC', 
	@IMAGE_BYTES_INACTIVE=N'iVBORw0KGgoAAAANSUhEUgAAABQAAAAUCAYAAACNiR0NAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAANgSURBVDhPnVRLKG1hFN4YmpKBwogJAyUjA1FIBkxkJOUxUMrARJEkTCQG8iqO9/v9Ju9HXud4vw/yKtQ+ed5T9w6++3/rtk/E5Nq12v/+/399e61vfWtpr6+vVrvdrr+9velq/d9Gv/f3d/3h4UE/V4+mNn7d399jc3MT6+vr2NjYcBj3LBYLtra2YDabP519vHd2doa1tTWMjY3ZCahPTEygoqICTU1NaG1tRXNzs1hHRwcGBgYwODiI7u5utLS0OM54zvu0qakpdHV10demPT8/6/39/aivr8f8/DwWFxexsLDgeDc0NKC8vBzj4+NYXl6WM8N4n2tmwB8L4MvLiz48PCwRHBwc4PT0FEzh6upKIgoLC0NAQACys7OFlqOjI+zu7jpsf38fVqsVIyMjaGtr+xehAUieJicnMTMzg52dHeTk5MDZ2RmapiE0NBRzc3MCyIgM297exsnJCYjhABwdHZUIyQW5zMvLQ2pqKqKiouDt7S0RFhQUSFH29vakUIZ9AWTKBCSp5LKoqAiRkZFwcXGBv78/4uLiUFZWBqbGVD+Ccf1thMyfpM7OziItLQ0eHh7w8fFBbm6ucMfoyS1pMGREcH5/C8j8aUtLS4iIiICTkxNiYmIEKCsrCyaTCYeHh+JsALJANIJ+y6ESpegtMDAQ7u7uSEhIkPSTk5NFa3SiM42ZVFdXi2ZZHFb5S1EI2NnZiZCQECQmJiIlJUXASktLQY7JIWXFVHt6elBYWIiSkhKp/MXFhdz5VGUCsjMoD17OzMxEUFCQpDs9PY2qqiqsrKyIRouLi0Wf0dHR4kPN0v8TIDuBEfr6+kq68fHxcHNzkwqzU7ifkZEhKaanp4sKXF1dJfXb21sBdLQeq0wOuMkIY2NjkZSUhODgYEmZuvT09ER4eLioIT8/H15eXvDz85Nuur6+lpQFkCOLgOSFVVNhi/X19YF9TLHzvLKyErW1tVIQdlJNTQ3q6uqwuroqHDKY9vZ2m0wbyoUTh23Fv5GTy8tLWZMzNeZwc3Mj38fHx1LVu7s72aM+eT40NITGxkabptB1orNTGAnXDJ/GNfeMfePboMe4yzdbVk0sm6Z68zcHQm9vr7TeT4z0sAnU6PujPT09mdXEOX98fPyRqdEvfmomnKt6WP4CPr7InCVCj6gAAAAASUVORK5CYII=', 
	@ORDER_INDEX=2,@ACTIVE=1,@PUBLISHED=1,@PATIENT_OR_ROOMBED=NULL,@IMAGE_NAME=N'CleaningBed.png',@ICON_NAME=N'Cleaning Bed',@SHORT_DESCRIPTION=N'Cleaning Bed Icon',@LONG_DESCRIPTION=N'Cleaning Bed Icon', 
	@COMMENT=NULL,@MOUSE_OVER_TEXT=N'Cleaning Bed',@FACILITY_UID=NULL,@FACILITY_ICON_NAME=NULL,@FACILITY_DESCRIPTION=NULL, 
	@FACILITY_COMMENT=NULL,@FACILITY_MOUSE_OVER_TEXT=NULL,@FACILITY_PATIENT_OR_ROOMBED=' ',@FACILITY_ACTIVE=0,@FACILITY_ORDER_INDEX=0, 
	@ENTERED_BY=N'softinfo\bmsuser',@ENTERED_DATE=@DATE_NOW,@LAST_EDIT_BY=N'softinfo\bmsuser',@LAST_EDIT_DATE=@DATE_NOW

	set @p1=0
	exec usp_Insert_Icon @ID=@p1 output,@ICON_FLAG_ID=NULL,@GROUP=N'APPLICATION_ICON',@SUBGROUP=N'BED_CLEANING_ICON', 
	@ICON_TYPE_CODE=N'BED_CLEANED',@ICON_TYPE_CODE_SYSTEM=N'2.12.24.51',@ICON_TYPE_CODE_SYSTEM_NAME=N'ApplicationIcons',@ICON_TYPE_DISPLAY_NAME=N'Bed Cleaned', 
	@IMAGE_BYTES=N'iVBORw0KGgoAAAANSUhEUgAAABQAAAAUCAYAAACNiR0NAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAPRSURBVDhPfZRfbFN1FMevDIUEFdmI+GB8comCPkFYgIEhCgENxL3oHkCiMeIbCWqEBUaiLyRjjJgYCS6Ttb0tGWrYiro5ls4BXdvZ4jrqaNe/67912739c+9GsvXer+d3b7fV6fbwye/3O79zvz3n/M4plxeng7MzkpDNFwhJEFeiQD7E8vtsXhbyBVnITE4IkUg4xMmyNCtJMmLxKYSiAiKxZTAbI0lkiETpvuQbG88hkc7hnt2J7u6ex5wkPxa83hH0WK/A9ssXGOg+iz9+a/g3fXS2NqCfL9nvlNZfz8De2wC77Sq+v/Yd2o03RC5bmBecDjvuW99CavA5TA5VYsJZtYSb9o+Iq1VI1VchbaS9n3w8lcg4KyF4NiPsOorWa01oN/3MBIuCyzkIn20nEOSAKBEuI0X7MeJjooo4TjiJeMk3wSEX2A/DD5dgMHeJXJ4Eh1wO+PrfgBIgpwgHlYQ1YnSepLWDQ7Gag8LR+Wniyw1QvBuhxp8AEhUQ/YdJsBkGU+eS4MP+fSj6yTlEH1JECluTJHaPw3wd7SvojluLmS1bkTxZj+zgDigxEhwnwUcrCCpMkCJUKGUWnUqCxa+J9bqYtG0HvKc/h7PjNCa9r0FlpRlfs4ogS5lSZdGpE7qocoKJcZBfqMbwuU/h6D+GxOhLmGN1ZTWPrRShbZ8WGTwk1KsXXPXReohSXrcZgbp6OLveRSa8iUR0MZWJriZYZEUeeAY4vwUwrQUsFOH2pxDdfhR3v/0MsQcvU930DtDqvLrgXhRjazA7vA2Zrz7EzImtwAEOhVdexMCpj+C4exAzwXWaGItMYaVZTdBHKRfpQZJ/v4qe1rMY3X+IHuNJBGt3wXHzHQihZ7VH0CJbaKsVBZ0OsLZhjrnABvT+fhj2Y3WQNlbDffxt+D2vay++2FKldP83Qn1SHBix1UKltlEpypi3En+2HEHgzQ/gajyCpO95qOP6xLB0tZQZrCuiFRBGD5Y1tqQIbrcLY/d362OXJmjcwndqYGs+g4B1L+aYnY0gG7dy2I9Qe81GDsBsbNEnRZbnhb8euDE88AmmRndCDNZADNUgMPQe+vouIDT8PrJjNRACuyH4a5exC9nwHsrgFNpaL+O64abIRaNx4datTvq3aAFvaILF2ExcAm9sAm+6iBv8Re1sMV7+D2aydfBXKN1vcKGxEW1t10Xu4cjI3O3bVhiMHTDyXYRVgzd3wmL5CSa+c9G2cFe+mszkb/oR7QYDZdQ7z+XEKbcwnQ6lUvFQOpVYJKXt42RfspXfL+zZd4xsdiokFaY9/wDtHqtHYACtMgAAAABJRU5ErkJggg==', 
	@IMAGE_BYTES_INACTIVE=N'iVBORw0KGgoAAAANSUhEUgAAABQAAAAUCAYAAACNiR0NAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAALVSURBVDhPpVXLSypxFJ4/0MIiJKhNtBELWkS0kNwUErhwYZuU3g8LspdRgSY9yEelphVtbkUPjaCZ6HUv3Lv47nwnfqKRtmhxmJlzvvl+5ztzzhnNMIxf7+/v+vPzs9jT09OXVi1O/8vLi/7w8KBfXl5eaK+vr79Nw+3tLa6vr3Fzc1Nh9NHu7u5QLBYFR4zC8vn+/h7xeBwbGxt/tLe3Nz2fz2NlZUVsbW0N4XC4wkygxObm5sS/vr4u19XVVZJga2sLfr8fk5OThsZ0k8kkFhYWEI1Gsb29jVgsVrKdnR0kEglMTEzA6XQKKfH0E7e3t4fd3V0MDw9jamrqgzCVSslJmUwGuVwO2Wy2ZKenp+IfHBxEc3Mz+vv7hYSqiD05OcHx8TFGR0cxOztrsIb6wcEBNjc3kU6nJUgCRX5+fo7l5WW0tbXBYrGgqakJQ0NDYBIkJSETIOH09HQl4dHRkQRJTEKCWQJKra+vR11dHVpbW+HxeCRLZkjSmoTMkAAlh7WxWq1CZrfb4fV6EQqFpK7E1SRUmTG7s7MzIR0YGBCylpYW+Hw+qTXJqIa4qoQE8kT2UyQSETLWtre3F42NjSJ7cXERh4eHEiMZE6hJyCBrRpl8eWlpCR0dHXA4HBgbG5P2UF1Asm8JVVYjIyNwu93o6elBe3u73FPB54/2LSElqybu6upCQ0MDOjs7MT8/L1LLO6CmZPYU+5Ag1o1yWTObzYa+vj4pg+o3JbWq5PJJoSS2DceKs9nd3S1tsr+/L8VXWZWTqg9U0dgEcI4ZZLtw3JgxSbkAKJU+kn424mnmYviYFO5CvkBCVSdmyUngVlENrMax/MpE1FcPBAJcIIZ2dXWlc1bZKuPj43ISjduFZm6Qkk/Fyq9mVjLHLpcLZncYmlnsv9yBfNHcFiULBoOyqsp9X90TNzMzI4eaKv9puq6nHx8fLwqFwo/M/JVcmL+DzH9VxwRL34SBdgAAAABJRU5ErkJggg==', 
	@ORDER_INDEX=3,@ACTIVE=1,@PUBLISHED=1,@PATIENT_OR_ROOMBED=NULL,@IMAGE_NAME=N'BedCleaned.png',@ICON_NAME=N'Bed Cleaned',@SHORT_DESCRIPTION=N'Bed Cleaned Icon',@LONG_DESCRIPTION=N'Bed Cleaned Icon', 
	@COMMENT=NULL,@MOUSE_OVER_TEXT=N'Bed Cleaned',@FACILITY_UID=NULL,@FACILITY_ICON_NAME=NULL,@FACILITY_DESCRIPTION=NULL, 
	@FACILITY_COMMENT=NULL,@FACILITY_MOUSE_OVER_TEXT=NULL,@FACILITY_PATIENT_OR_ROOMBED=' ',@FACILITY_ACTIVE=0,@FACILITY_ORDER_INDEX=0, 
	@ENTERED_BY=N'softinfo\bmsuser',@ENTERED_DATE=@DATE_NOW,@LAST_EDIT_BY=N'softinfo\bmsuser',@LAST_EDIT_DATE=@DATE_NOW

	set @p1=0
	exec usp_Insert_Icon @ID=@p1 output,@ICON_FLAG_ID=NULL,@GROUP=N'APPLICATION_ICON',@SUBGROUP=N'BED_CLEANING_ICON', 
	@ICON_TYPE_CODE=N'EMS_NOTIFIED',@ICON_TYPE_CODE_SYSTEM=N'2.12.24.51',@ICON_TYPE_CODE_SYSTEM_NAME=N'ApplicationIcons',@ICON_TYPE_DISPLAY_NAME=N'EMS Notified (displayed on EMS pages)', 
	@IMAGE_BYTES=N'iVBORw0KGgoAAAANSUhEUgAAABQAAAAUCAYAAACNiR0NAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAK5SURBVDhPtZRLSBtRFIavLkRdSBdd90EFFVwUuuiq9UFpEqKVUi1ddVdMkajYanUMmMQkNYhVCNb6QHyhohUfiLYUi6ALraaC6EJRrLiJ5oGvZHAmk79nTCxYU7qIDvwcZjjzzX/vf+Yyt8uxcXjgcbucjogkM9yu3U0mioIPl3SJosizQCDgviQeiOW5WuD29i8MD4+gvb0LLS3taG5uJbX9pVa0tXWhs3MQvb39WFj4gZOTk9NFnnMoSRI6OnqQkpIMpTIdxcXvUFDwBhpNEak4VIug1ZahpESL3Nx7SExMRH7+a3g8notAQRBgMNQgKekOOC4Ps7MdWF6eIgfjpJFT2e1fsbr6HePjOhQWxiM6miEtTQGn03kRyPM8zGYrSkvLMD1dj8VFDbzeXmr8QvpMGiFNYnf3I2Zm8mAyXUNCQhSysp7B7Q7mem7JPO+jJgu5tGJn5xsmJ9Xk5DE1G6m1iWTDyooGAwOPyPlLNDTcRlxcdAgYZsmyw+pqM8rLDTg+XoLDYUBd3Q0KKRsHB5+wtWVAfX0yxsbUFIINTU0piI1l/wdynAX7+/PY29NiYuIhuruVGBx8gb6+p+jpycDS0nMIgh6NjckEPFvyPxyaTDXQ63XY2LBhbe0JfD4zgd9jaCgHc3OvcHjYCJfrLdbXVbBaryM+Xgbm0raEBQowGj/QGNwlwC2Mjt7E/LyKwlFiauo+pf6AUs6imob+/gRKOQoxMQwKRQ59xBVubCTU1tqQmiqPAkNGBkN6OkNmJoNaLb8YfCbfy1XuY4xBpcqmsQkDpMjJgR0WixGVlZXQ6XSoqKi4II7jUFVVRdOgpz4dpT5AWxM8X8L8ywHwvEip+nF0JJHk6qe9C9aggs+9Xj+lLUKS/H/Olqs/HCI9xkIOJSFS0Nn7gYAkMtoDO5E3qUakEOPnbyttSt8cBefqAAAAAElFTkSuQmCC', 
	@IMAGE_BYTES_INACTIVE=N'iVBORw0KGgoAAAANSUhEUgAAABQAAAAUCAYAAACNiR0NAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAJTSURBVDhPtZRNS+JRFMb/BGIu/BaB+A1MFwku1IXQV7AWIYTgoiQT1LJAdB8K9qaYGegqWoRogiCKg4TtlHKl+IalKDrWM/9zZxxqjHFhXTjcV36cc5/nXq7ZbJaen59b9Xp9riAGzypzo9Gojy9qPGvAvb6+tr6IB57V/l5gpVJBLBbD8fExfD4fvF7vp+H3+3F+fo5QKIRcLofhcMiK/JAhP8Hp6SmkUinUajVMJhM2NzdhMBg+hNFoZHurq6tYWlrCxsYG2u32NJC/UOzt7UEikWB7exvJZBKFQgGZTOZvUDb39/eIRqNYX1/HwsIClEolGo3GNHAwGODg4ABbW1u4vb3F3d0deBuA1vv9PgsaPz094ebmBmazGWKxGDqdDq3Wb10/lEyHnU4ny/Lx8RFXV1cIh8Oge+31euh2uyzTk5MTpNNpdnZxcfH/wP39fezs7KDT6aBcLsPhcCAYDKJareLh4YFBLi4u2J253W4IhcLZwN3dXVZqqVTC5eUlU5kUJeVpnEqlWIkul2s2kDKw2+0oFovIZrPgnyMrPxAIIB6Po1arsTntWa1WiESi2Rnq9XqQz87Ozpg4BCJVr6+vkUgkWH90dIS1tTUIBAJoNBpW0ZQoZBuPx8NsI5PJIJfLsby8DIVCAZVKhZWVFbZGc+rpHMdx0Gq1n9vm7e0N+Xweh4eHoHukkkigf8NiscBmszHB6FwkEmGWmspw8kGQfV5eXphVJkGWeT+nMUHoydELm7Tv/xzm/cYmGY7mBb0r+Sc3Ho/zPLnM93PFH8aPX4PlXOaZLTgGAAAAAElFTkSuQmCC', 
	@ORDER_INDEX=4,@ACTIVE=1,@PUBLISHED=1,@PATIENT_OR_ROOMBED=NULL,@IMAGE_NAME=N'EMSNotified.png',@ICON_NAME=N'EMS Notified',@SHORT_DESCRIPTION=N'EMS Notified Icon',@LONG_DESCRIPTION=N'EMS Notified Icon', 
	@COMMENT=NULL,@MOUSE_OVER_TEXT=N'EMS Notified',@FACILITY_UID=NULL,@FACILITY_ICON_NAME=NULL,@FACILITY_DESCRIPTION=NULL, 
	@FACILITY_COMMENT=NULL,@FACILITY_MOUSE_OVER_TEXT=NULL,@FACILITY_PATIENT_OR_ROOMBED=' ',@FACILITY_ACTIVE=0,@FACILITY_ORDER_INDEX=0, 
	@ENTERED_BY=N'softinfo\bmsuser',@ENTERED_DATE=@DATE_NOW,@LAST_EDIT_BY=N'softinfo\bmsuser',@LAST_EDIT_DATE=@DATE_NOW

	set @p1=0
	exec usp_Insert_Icon @ID=@p1 output,@ICON_FLAG_ID=NULL,@GROUP=N'APPLICATION_ICON',@SUBGROUP=N'SYSTEM_ICON', 
	@ICON_TYPE_CODE=N'BED_OOS_VISTA',@ICON_TYPE_CODE_SYSTEM=N'2.12.24.51',@ICON_TYPE_CODE_SYSTEM_NAME=N'ApplicationIcons',@ICON_TYPE_DISPLAY_NAME=N'Bed Out Of Service (Thru VistA)', 
	@IMAGE_BYTES=N'iVBORw0KGgoAAAANSUhEUgAAABQAAAAUCAYAAACNiR0NAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAMDSURBVDhPnZRBSBRRGMfHDkJIGxaYlAdLJUjTUxFYUHgMpA5ehTAvJUYH8SYomgadCiQNxbTM0IOURGpGeSpxO3UJnJBqWdjlmTjr7uzOe9+/773dWdesxAb+zMx73/ebN+/9v89KuvEVUlK4ibhwU0nhEglXKeG6rkiurgp3dla4IyPCffpEuG8XRDIc5rhUJo7zOE7nKikFs2xLKRVH7rW5CbxfBO4/AJqagPMXgFOngMoq4OIloPUWMPIYCAYBqbalMithEa8oO/rlC9S9e1BnzkIeOgyZnw9lWQBL343274cqLoaqq4MaHgbC4Ww6s9YslQHS8jLUtWuQR49CcqIvDaEcoH42c3l5kGVloI4OUChkoAYoNZC/om7fhiwoMMm7SQP1hwyYF6D6+4FEIgP0PIGJCagTJ0zAbrDceR3vaei5c8CHD2mgCoUErl/P7tFegP6+yn37gJ4eUDzOwMVFgcuXQYWFoJISUGnplvQelZf/XSdPgo4fN1uF5mZQNMpA9hhu3AC1tYEGB0FjY6DR0fR9fBz0/DmIt2SHnj0DTU2ZWFlfD/AZUDjMwK4ugb4+0MoKSJ/UXqUU5NAQ0NsL+vGDgZ2dAt3dIPbgnmH6454Hqf2ogaFQ5pdbW0EaOj0Nev0a9OoVaG4OND8PevMmrYWFLflj796BZmagGhuB9vbML3/8KNDQACoqAlVUgCor06qqAlVXb6mmBuTLH9fvXJb6QHHzZuZQIhGBlpb/sk22grhqcPcuKJFYs4i7BCYnTRn5FeCX27886XvQGLu2FlhaShvbNIdIxNhGBgLZGt7N4H6te+xdNTAAuG4OUJ/W589QfDhSGzW3u/zh2cxzdajTp6HYcn7H2Vqh34C+fWdzPwJxD6SiI6ADAajfFTgIOlYCXLkKvHgJrK9vb1+el0xt65L6JbgMDDw09Yk7rN6MerqBvl5g/AnwdWVHGrM8a9OJBlPJn3ZsI2I7sajtpDZsh+K2I2O2423YsR1y7BjxnOIYznMczuPcpHmOfvoFhRyZvFj8+uAAAAAASUVORK5CYII=', 
	@IMAGE_BYTES_INACTIVE=N'iVBORw0KGgoAAAANSUhEUgAAABQAAAAUCAYAAACNiR0NAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAKqSURBVDhPpVRNS3JBFL7/z4JIjBZmghZitgjRiFYFgSsRW5Qa0aKENNqE9EFJhRGJmlCLPnQRRAY1t081tXjec0aub5/va3XhYe7MnHnmzDnPOcrT01Pu+flZlMtlQf+iVquJarUq54VCQaRSKbG2tibi8bjIZDLi6urqgx3b8jk6n1eIrIRXHy3i8PAQS0tL8Pv9GBwchN1uR19fH4aGhhAMBrGxsYFcLoeXl5fXR0FcZYUWhbZ6fn6OxcVFDAwMoLOzE21tbWhpaUFra6scGe3t7ejq6sLw8DDIc6iq2iAlLrVBeHp6Cp/PB5PJ1DiskXw1Wq1WzM7O4vr6WpJKQo4f3xIKhaDX65sm0y5hB2KxGCqVSp2QE7C9vQ2+7X8efbav0+ngdDpxdHRUJ+SsjY+P/4hMu4BjHIlEQNlWlYODAzEyMiKTYDabYbFYGujp6cG/YLPZpC2Hip26u7tTlfX1dTExMYHp6WmsrKyA9NbA5uYmOByfYWtrCzs7O9J2dHQUU1NTEEKoSjgcFgsLC7i4uHijqWYnrMXV1VVEo1FQ+FRlbm5OzM/PgzX4k49UIvXYIOQns/qZdHd3F+l0GlRuoDLD/v4+stnsl6D4I5lMwuv1YmZmpv7k4+Nj4fF4YDQa0dvbK8tMKzWHwwEN/f390PB6jW05oZwHmZSbmxsxOTn5a9lwHqgP1CslkUj8StgulwsnJyd1YXNzuL29lbIxGAzf9rS7uxvLy8ugivtLyNk9OztDIBCQQm2mBLk6uKVxdrWO86bbMCnpSIrb7XbLJLHH79HR0QH2amxsDHt7e3h8fHzbvsjV6nv9cfPkZ3B9MtgLBkuLg88VdHl5+UG2RFVT7u/v09y6acw/PDzkS6VSnjbyvPYVeJ/aVb5YLMpzJBdpS2PmD+QqhZqroWrQAAAAAElFTkSuQmCC', 
	@ORDER_INDEX=1,@ACTIVE=1,@PUBLISHED=1,@PATIENT_OR_ROOMBED=NULL,@IMAGE_NAME=N'BedOutOfService(Vista).png',@ICON_NAME=N'Bed Out Of Service Vista',@SHORT_DESCRIPTION=N'Bed Out Of Service (Vista)',@LONG_DESCRIPTION=N'Bed Out Of Service (Vista)', 
	@COMMENT=NULL,@MOUSE_OVER_TEXT=N'Bed Out Of Service (Vista)',@FACILITY_UID=NULL,@FACILITY_ICON_NAME=NULL,@FACILITY_DESCRIPTION=NULL, 
	@FACILITY_COMMENT=NULL,@FACILITY_MOUSE_OVER_TEXT=NULL,@FACILITY_PATIENT_OR_ROOMBED=' ',@FACILITY_ACTIVE=0,@FACILITY_ORDER_INDEX=0, 
	@ENTERED_BY=N'softinfo\bmsuser',@ENTERED_DATE=@DATE_NOW,@LAST_EDIT_BY=N'softinfo\bmsuser',@LAST_EDIT_DATE=@DATE_NOW
	
	set @p1=0
	exec usp_Insert_Icon @ID=@p1 output,@ICON_FLAG_ID=NULL,@GROUP=N'APPLICATION_ICON',@SUBGROUP=N'SYSTEM_ICON', 
	@ICON_TYPE_CODE=N'BED_OOS_BEDBOARD',@ICON_TYPE_CODE_SYSTEM=N'2.12.24.51',@ICON_TYPE_CODE_SYSTEM_NAME=N'ApplicationIcons',@ICON_TYPE_DISPLAY_NAME=N'Bed Out Of Service (Thru Bed Board)', 
	@IMAGE_BYTES=N'iVBORw0KGgoAAAANSUhEUgAAABQAAAAUCAYAAACNiR0NAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAOWSURBVDhPnVRLaFNZGL6KdooVN4IiKj6qtlLUlZ2FGx8rcSku1JUiYnXhKIiPhY+KLn1Up1RRsBUZFcQHitJ2cBTcWaFJ2iY3uU36SNukOcnUJM3NfZxvvpO2ak0DMgd+7j33fP/3v75ztVDAE4qEAyKoe34yrwgOhIQR0UWv7hXGgCGCfC/GTfhFev0ipHsNzTRz4yi5JNDSDBw6BLS3lYZNnpArp0kpxUxImR2H++ABUpWVCJf9hvTmzcCLF4Btlw4vZbIk4VhrKyJr1yKgaeikGTSzthbweP4H4eAgUseOoYskwZUrMbBzJ/QFCxDn3r18GUilZiRltSUyfP0aY6tWIbx0KTL378NlVslLl9C/eDHMjRuBrq5fJ5R9fTD37cMws4kfOADXNOHQ3YrHEd2xA7FZs2BfvAgMDxeRFmcYi8E+exbRuXPRv3490m/f4p9Pn3C7uRm+zk6k6uoQ4lls0SI4V68WDWg6oetCvnyJzPLl6GF2sYMHYabT+OPMGVQsXIh7LS3IP3mCvhUroPM8U1UF+HwA/abWdEKWlD98GNE5c9BTVobUyZPIff2KuhMnUD5vHpoePoRDTGLPHvhnz8YQMY4aUCIxA6GK8u4dUozuZfTeLVvgfPwIk/07wmmXl5ej8e5dJuPCIk5fvbqggOy2bYCuz0BImWT27kWQoM8q+qlTAMu1HAf19fWoqanBX48fg/emkFFk9258JrZ/0ybkP3woJnTDYfRu2IAvBIV27UJO9YZLEYyMjKC7u5vSm9SelEi3taFn61bo8+fDPH4cyOcn8AUd2raQz57BR+F616xB5v37bxFViXoggL/b2xFlFXSYcOT1S716hQAnnqBWwQDfCeNxAerOqKhA9Px5yB+mlqfjuQsXUMlAzSz5+zw53PFxRNimCFvkUE6wrIkM7YYGMbZkCQZZct7vnyZWJeh7zH7/0aNo6+goEvK/zDy4bBlGOUw8fw6ZyyW13PbtYoC9C/CvMkqxisZGJK5fh7hxA6KhAXE+o9euYfTWLSRv3oTgWYLfksQNnT4ND5NRPw5QDVKIpGZduSKSLEmJ2UdTTyVcZWrqQzShJjq5nzrzc68k1k0bXbcOePQIMptNam46beHpUzi1vyNbVY18dTUcml3C1JkyhcvytkilxTdvCu1wpbQ1R8oOaVkGr53h3v7TkE1Nhrxz55u5fJ+yH78XcArf2mpw6gYHYjiu++U/DBwEsOIyj3UAAAAASUVORK5CYII=', 
	@IMAGE_BYTES_INACTIVE=N'iVBORw0KGgoAAAANSUhEUgAAABQAAAAUCAYAAACNiR0NAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAMRSURBVDhPlVRbK3VRFN2PPPoP3vwG19w9KYTcI3JPQsqLJ7cXJDwoyTUUefAiEXI9hyihb7tFSfYml+9wDoY1Zt+WYyPfqtVZqzX3mGOOOebR9vb2/hweHhr7+/te++DgwDg6OjJ0XTd4Pj4+lvPnOOv+L07XXC7XX/ywZmdn0d7ejq2trZ/C5E1hubSXlxfjq8jHx0fMzMwgKysLUVFRKC0txcrKCp6fn78FVljmt4Bra2tIT09HaGgogoODERYWhvLycigZ/h/w6upKygwJCUFycjKqq6sRFxeHyMhIDA8P4/7+/kvQbxmSXWZmJpKSkjA9PS2s+vr6kJCQgKKiIpyenv4e8PLyEo2NjYiIiEBTUxOenp7w+vqK6+trVFZWip4DAwMwTdMGamN4c3OD3t5eREdHIzs7G6urq1hYWEBPTw+2t7fR2toqZScmJmJkZMTWIC9AsmAXMzIypBHNzc2iVVVVFfz8/CTR/Pw8UlJS5D0vLw8nJyfC3lpegGTX1tYm7FhuZ2cn7u7uUFZWBl9fXwFk2fX19dLxmJgYDA0N4fb21g7ILA6HQ2xCixQXF2NnZwf0YmFhIXx8fNDd3Q3FABsbG8KSDmD3z8/P7YC0SUNDg2QmINkp08Pj8QijgIAAsQsXGdXV1SEwMFDKpra2ki8uLpCTk4OgoCDJqmb7PYhvu7u7Ui4XqyHLkpISxMbGoqurSxJziYbqYiwtLYkmLGVzc/NjRqjhlxE8Ozt7bwDHb3FxUbROTU19/0YAVWajpaVFstEe1MlabrdbyvP398fg4KBXR6kv5SBoR0eHsBTAyclJg1lyc3NtE8DyqB21oqU+L5ZOT6alpWF5eZlNNLWamhojPDxcqPf392NiYgKjo6MYGxvD+Pi4nAnKs3XnG+OoX3x8vDSTjVQNMzXlJYNTQbPSCvy1NgNZEseNSXn/+E5H8Bt+Pzc3R2eY2sPDg5vjVVFRIaXl5+ejoKBAfr/afLPeGV9bW4v19XWryx5NdcyhBNWVBvrU1JSu/l1+vRnvdDp1fq8aoiss5xvERvmDCoy4rAAAAABJRU5ErkJggg==', 
	@ORDER_INDEX=2,@ACTIVE=1,@PUBLISHED=1,@PATIENT_OR_ROOMBED=NULL,@IMAGE_NAME=N'BedOutOfService(BedBoard).png',@ICON_NAME=N'Bed Out Of Service BedBoard',@SHORT_DESCRIPTION=N'Bed Out Of Service (BedBoard)',@LONG_DESCRIPTION=N'Bed Out Of Service (BedBoard)', 
	@COMMENT=NULL,@MOUSE_OVER_TEXT=N'Bed Out Of Service (BedBoard)',@FACILITY_UID=NULL,@FACILITY_ICON_NAME=NULL,@FACILITY_DESCRIPTION=NULL, 
	@FACILITY_COMMENT=NULL,@FACILITY_MOUSE_OVER_TEXT=NULL,@FACILITY_PATIENT_OR_ROOMBED=' ',@FACILITY_ACTIVE=0,@FACILITY_ORDER_INDEX=0, 
	@ENTERED_BY=N'softinfo\bmsuser',@ENTERED_DATE=@DATE_NOW,@LAST_EDIT_BY=N'softinfo\bmsuser',@LAST_EDIT_DATE=@DATE_NOW
	
	set @p1=0
	exec usp_Insert_Icon @ID=@p1 output,@ICON_FLAG_ID=NULL,@GROUP=N'APPLICATION_ICON',@SUBGROUP=N'SYSTEM_ICON', 
	@ICON_TYPE_CODE=N'BED_ISOLATION',@ICON_TYPE_CODE_SYSTEM=N'2.12.24.51',@ICON_TYPE_CODE_SYSTEM_NAME=N'ApplicationIcons',@ICON_TYPE_DISPLAY_NAME=N'Bed In Isolation', 
	@IMAGE_BYTES=N'iVBORw0KGgoAAAANSUhEUgAAABQAAAAUCAYAAACNiR0NAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAR3SURBVDhPfZRrbA1pGMcPgiA+ILFoN2hD9gNFbdzjtqo+ECzCNiGh8WEtartLNk2KZNdl41Jptx+EbmmtRs+KzepxK6o9FEVvpBVMq2ndqtPmnM7Muczp/PaZc1IViX2TJ+9M5pn/+zz///95HbqmvTBNUw0EAqoZ9Kt+v6H6DU12n+oLmarW3KRqfztVPfOYqp88rmrVVarPDKiGfLdzDUNXdd0bftY6PYrDZ/iM0tJSTufl0dLSApZFY0MDzZ0a+tu3sHcvxMZCdBSMGQP79lH7/DmF16/jPHcOV5GL1tZW7BUKhXwOj8erpqamMnHiRI4cPoLb7ebfa9e4cPceNVlZdA0bRmDgQCq/XcWzmFg64uK4uWcPv2Yc44cdP3Ls6FEaGhrDgJZltTvsVm9JhWlpaSxZlMCixYv588EDSiWaEhN5P2gQtdu2UXD/PkXZ2bybNo22CRO4lZHBHxcvUl5RgRkM9gAKqmq/NTU1sXrFChwOB19v3kzJgQP4Zszg3saNnL9xg/P19fxTVUXzmjXQpw/PV60iSwpxPXpEfV0dLxsb0TSt3dEN2NXVRXFJCd8I6NTevakYNYqm6Giypb2csjLyCwrIkiiXw7qk6tYBA8hYvZrU3bv5XijLlupfv37dAxiuWVa1COIeMYLOXr24NHIkifPn85MI4XQ6yc7NpUB4fbpsGaG+famWg39ZvpzEDRvIOX0ar8fzCaBUibTAuHEgiWVC+Bzh9CsRLF9cUFVTg0s4O5efj5KUBCLWJaFlrxzofvwYw+f7CNAmVlpm4UIYOhSKivBJxU7Z46dMYYb8mHfqFKV37pAnUehyYUgHb6X13K1bOSu0vGlr+wjwzRtYvx769QPhUbzQzQJXrlwhJiaGWIkDUs1fcshBoeD+3Lmo/fvjli4qnzzBsG3TLQqiIgkJsGABwm7Y4N1LcrghSsfHx0tKAoUizsmzZ8k+c4Yy4dMjlITKyyM+DAOGQohMMH06HD/+AejjBxv0ovguSbjbk55O8dWruJ4+5VJODq0CyPbtWM3NAijGRk5j6lQQzyF++tzSdJ1dO3cKIyu4KdNULAIWX77M+yVLQPi0du0SwM5OleRkkBHjwoXPgtkfvBJbDh1iwaZNFNy9S3phIa4XL/CLA+z/rbg4AezoUFm5EsRTHDwItbWRqK7uCbGLzbFHKvo9JYXUdevI3b+fVAG+Ld1ZW7aExbSiogRQ11UyMyMtjx6N+ANmzYrsdsycCWJuli4lJIIpw4fzePBg6ocMoUIso44dC+PHw+zZWMnJAhgKqXL/gHDB2rUweTJMmhTZRdUuiZYvhuOUGXdLBG0B5syJCGjHvHkgA8Dt21h1dZ9MyqtX8FAmRW6a8F5VTUvJLXZ/l8T06C/JTNlB+00xf41QUlklOQ/DVGCaPbeNaQYid89nVoPXw89HDvPbiRO8NPT/Fc0MBU2Hrrc9Mk2vomltiqarEu2KZkjI7ve3K2rHO6Wh8ZliGB2KZQWUQMATyfmQJ/9oqhIMehXBqvwPM0PZs4/zOesAAAAASUVORK5CYII=', 
	@IMAGE_BYTES_INACTIVE=N'iVBORw0KGgoAAAANSUhEUgAAABQAAAAUCAYAAACNiR0NAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAPMSURBVDhPfVRrK6ZdGL3/gr8w+SYf8EX5IlJyJjkWci6HcRaDnEszDjMhJGfSUI4TOYswUyQfJDw0SMj9IOdxWLPX9b7PPE3vzLtrd++92/e117XWui7t5uZm98ePH/rDw4P++Pio39/f63d3d/Ll/uTkRJ+bm9MHBgb0L1++6Ds7O7/ume7e3t7K/evra4OmNnfz8/Po6OjA0dERXl9fsbe3B6PRiPPzc/T09CAmJgYRERGIiorC58+fsbW1hbGxMVmPjo7i7OwMHE9PT/fa1dWVnpaWBmtra3z48AELCwsYHx+HQiXBgoOD4efnh+zsbFnHx8fj06dPcvft27eorq4WABwvLy9GjakSYW5uLlxcXGROT09jZWUFmZmZ8PLywvv37zE7O4uWlhYkJiYiNjZW1kT49etXKMrMAVVUnbvv37/D19cXmqYhICAADQ0NSE1NRWFhoSD+9u0blpaWZO/t7Y28vDyMjIzI2ebmJvb396H0MGqmgOqLmZkZeHh4wMLCQn4KDAxEeXm58MX029vbUVxcDH9/f3h6egpSZsbU6+rqcHx8bA4omNXY3t6Gu7s73Nzc4OrqCicnJ0HV19eH5uZmNDY2Cp980NHREaGhofJwW1sblB6/B6TCu7u78nJpaanw5OzsDCsrK3HB+vo6FhcX0d3djaKiIkEaFhaGkpISrK2tQVnHHFBJjo2NDbx7907UJGekYWhoCDY2NrC3t5eUGXBiYgLDw8OCjhTxH56dnp6aA9J3VVVVIkxZWRmUoU0siChv3ryRSU6VySVFWogBqTzBKFDmgIeHh8jPzxeSdV0Xg5sG17SSra2t2Kq3txednZ1obW1FSkqKBKbS4kOqzNRUWSE9PV3Q/GkwKG0SEhKCgoICSXF1dRVdXV3CeVNTEyvGqLFeaWy+VFNTQx7+GJCHqkzF7D4+PpicnBTzE0BOTo6Io0Q0amwELCW+vLy8/Ndg/9aqqBsUFCQU0EZUfmpqSv5XXBo11SF0isAS6+/vF8dzsj5Nk3tyzKZAD7JRVFZWIi4uTgSqr68XMcPDw40a2w65YcqRkZHIyMiQtPg1TabECuGXjYKGp7r0KFNl4KysLHz8+NGoPT8/65eXl0JwRUUFkpOTkZSUJF8+wrKige3s7ODg4ICEhARBSQE5+cjg4KCofHBw8Hul0C6qgf6aTJkGj46OhqWlpViKD5MCg8Eg90iFAmXuNqr1/NN7/jLYZMlxbW0tLi4u/lc0FeqJoqyqhYHt2zRVG5K1coBBoVZgDAaeKSQG1T//c493lf14vvYTlUTRSHl+h2cAAAAASUVORK5CYII=', 
	@ORDER_INDEX=3,@ACTIVE=1,@PUBLISHED=1,@PATIENT_OR_ROOMBED=NULL,@IMAGE_NAME=N'BedInIsolation.png',@ICON_NAME=N'Bed In Isolation',@SHORT_DESCRIPTION=N'Bed In Isolation',@LONG_DESCRIPTION=N'Bed In Isolation', 
	@COMMENT=NULL,@MOUSE_OVER_TEXT=N'Bed In Isolation',@FACILITY_UID=NULL,@FACILITY_ICON_NAME=NULL,@FACILITY_DESCRIPTION=NULL, 
	@FACILITY_COMMENT=NULL,@FACILITY_MOUSE_OVER_TEXT=NULL,@FACILITY_PATIENT_OR_ROOMBED=' ',@FACILITY_ACTIVE=0,@FACILITY_ORDER_INDEX=0, 
	@ENTERED_BY=N'softinfo\bmsuser',@ENTERED_DATE=@DATE_NOW,@LAST_EDIT_BY=N'softinfo\bmsuser',@LAST_EDIT_DATE=@DATE_NOW
	
	set @p1=0
	exec usp_Insert_Icon @ID=@p1 output,@ICON_FLAG_ID=NULL,@GROUP=N'APPLICATION_ICON',@SUBGROUP=N'SYSTEM_ICON', 
	@ICON_TYPE_CODE=N'DISCH_ORDERED',@ICON_TYPE_CODE_SYSTEM=N'2.12.24.51',@ICON_TYPE_CODE_SYSTEM_NAME=N'ApplicationIcons',@ICON_TYPE_DISPLAY_NAME=N'Discharge Ordered', 
	@IMAGE_BYTES=N'iVBORw0KGgoAAAANSUhEUgAAABQAAAAUCAYAAACNiR0NAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAASaSURBVDhPhVRrTBRnFJ0VtWGBdQFBEKRSKZaAmoraYKRNGrXWgLRGBFEoIg8VsDxWHouoKchjaUrxUfGBif1haq0FJdiIQYmiRU2phmLUOIDysFKHlt1hARc4PbP+6EvtJjffztz7nTnfPed+wm99vQ/MslEyGU0MWZK5yqZByTxolrq7uqUL9T9I1adPSufqaqXW1lbWGKVBeZB1snWPccAkSU/7pN/7+yRiiYLF8sw8Pm5B2y/NuHb1e1y79h2uX69G05WTOHiwCJmZGUhJ/hTLli3D1q2foL7+a9y4UWOtu9L0LVpaGjA8ZILyI9aQMDJikc7Xf4Pc3HncPB2bNyvhgQ0b3LFunRcqK8tx9uwFPkciOFiL6GhXbNniwRp3pGdMh8EwH3funLcCjo+P9wsmkyyVl+u4WUBenhN27XLHnj1eBPdDRkY46up+xO3bT3HkSDVSU+Kwbdsi7NwZwHwAEhJeY70NTp3Kxb17IoaGRhRAk1RamoqICEecOROH9vYV6Ory47qSX05lfIYHD4rQ2VmItjY9N0Yw9wEuX9YjJ+dDklBDp3sPBw4cRXf3r/2CLMuSwZCGNWumsTcFJB6L2tqpLPBkD71RXu6OwkIXlJTM4PNstLa+wZq56OkpQX7+JoLZY+PGOfy/B6L46O+ATrh6NR/Dw3nsy5twcxOg0aitfUxOtoFWK2DSJIE5DQHfJctS6PWRyM62o1gLUVxcjkePep8DlpWlITzcCRcv7mBxOnvmAX//CbCx8SfT1Xj82JVHE+DjIyA2dipbsgQdHSXYsSOKgPYUSQH84t+Azmho0BNwM/s2E4GBtpg82Qd790ZgbGwJzOa5yMpyh5eXgKoqO/YrDQUFMXyneRmgIy5dyqb0BjQ2JsHX15uAM7Bv32oYjfH8SCWtEg07OxX7qWYPM+iGaGzf/kLAdB7ZmYA6AsZRwUDMnu1oZbh///uQ5TlUdw0SE4Nga6tCWZk9GaZTrPUEdHgZQy2Z6QlYTOCP4OfnDLVa8eRWghVQrDj28y1MmTIRpaVa9PamMbfh1QwbG3XsVzLOnVuOWbNcqLIHiooycevWl7RUGOLjNQgKEiiehgy3Yffu9a/qoRMZ5hAwkwZfQNvYQqV6nceJQ0XFSixe7AwHB1taKAADAyvw8GERlV9LQLv/Hvm5sZ1w82YZVS7G0aOenFsBCxeqsXbt25yimQgIELB0qS9OnMhiTSaePPmKtom2GvsftlFmWRm9yEgHzq0yajpu8sThwxocO+ZAUXw4LfNx6NA01NT4oanpY9y9G8HT5HP0lhNUTdaL/jK2iXdfRYUOUVECh96Dys2lVVwIprVGVZU7V2+GK5nbMifQNm4Em0dBtKxXUf136EkDzd7Vb72+GhpOsx8LsGmTPUJCBYSEqLBq1URrhIUJXJWwQWioDXMTGIL1fUyMwDlW03LBZPg5J6i7XxgbG32m3GX37/+M48fLyDKR4Akc9sQXRBLfKZHIuiRrXW5OCn1pQHNzM8X6wyKMWsw/8WIUlRgYGBY7Ox6LHR09jN7/jXaxR2wXu8Se7l5xdHREJLeWPwFTnxqBI79J6gAAAABJRU5ErkJggg==', 
	@IMAGE_BYTES_INACTIVE=N'iVBORw0KGgoAAAANSUhEUgAAABQAAAAUCAYAAACNiR0NAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAOuSURBVDhPjVRJLGVbFH0DiSaaERMTBpiJRCKmEswobRASRInS933f99SkGIkgEiE1KaKX6KIrXemKqIcgIeQ9/Se69e/aFf6vnyr5N9lxz7nnLWuvtc5WnZyc/Li+vtZcXl5qrq6upLi+ubnRHBwcaAYHBzWfP3/W9PT0aFZWVuQcv/Mc31mnp6caPgqWWnV/f//X8/MzVldXMTExITU1NYXR0VF8+vQJycnJiImJgYuLCyIjI9HX14fp6Wk5NzY2hvn5edze3oKPgnWruru70/T39yMxMVF+EBwcjJCQEPj6+sLb2xuNjY3o7u5GUFAQHB0dZZ/fee7Dhw8oKCgQMnyenp60KlKvqanBu3fvEB8fj5SUFGRlZSE6OlrWZLS2toampibZI0hqaqq8BwYGCpH29nZsbW2R6U/AsrIyAezo6MDCwgKWlpawuLiIubk5WZPBxsYGvn79KsU9RVuRg/80Li4ODQ0NODw81KoocHl5Odzc3DA+Pg6tVovW1lZUVFSgqqoKRUVFyMjIQE5ODqqrq0Xb4+NjbG9vSyeUiUzz8vKgVqt/BRwZGYHiFPLz82FqagpjY2PRkZrxXUdHR4B5Zn19HWlpadL6+/fvhcD+/v5PQC7c3d1Fr7OzMxDY2toaurq6qKurw/LyMmJjY2FhYQF/f398+/ZNAMmcgGFhYb8H7O3tlZbZuq2tLfT19UHD2OLe3p7Ex9zcHLW1tfj+/bt08iYgGV5cXIDAVlZWr4BKK2JUREQEDAwMRLvNzU0UFhYiKirqzwwJqAQeX758eQWkETs7O+J4aGgo9PT0kJub+8rwj4B0mQEnQwbZxsYGhoaG4jI1PDo6QmVlpZhDY5g7hvpNhgQkw87OTlhaWsLExAQlJSWYnZ3F8PCwxMPe3h5dXV3CkMBvakhAmtLW1gYzMzOJCW8GmTk4OMDIyEgiQgkImJ6e/nuGL8GenJyEMj0kKgSws7ODl5cXPD09RQInJye0tLTg/PxcXM/MzJRg/xKbl6vn4eEBZUzJ1eJAoBkEZkZLS0tlTTAaR4MGBgaQlJQkVy88PPyfHBKQPyQg72Z2drYAcO+lPn78iPr6eslkcXGxaJeQkCDt8rbQfWqtSKGV8TU0NCRgAQEBcHZ2lnJ1dX0tzkKu+fff3318fODn5yeysBNlIGtVj4+P95xljEFzc7MwpDYM73+L31jcfzlHYyjHzMwMtX1QPTw8LCiDUc1SDFHv7u7+71KmizzK2FIrOGqF3OLfs7hTNnu9z60AAAAASUVORK5CYII=', 
	@ORDER_INDEX=4,@ACTIVE=1,@PUBLISHED=1,@PATIENT_OR_ROOMBED=NULL,@IMAGE_NAME=N'DischargeOrdered.png',@ICON_NAME=N'Discharge Ordered',@SHORT_DESCRIPTION=N'Discharge Ordered',@LONG_DESCRIPTION=N'Discharge Ordered', 
	@COMMENT=NULL,@MOUSE_OVER_TEXT=N'Discharge Ordered',@FACILITY_UID=NULL,@FACILITY_ICON_NAME=NULL,@FACILITY_DESCRIPTION=NULL, 
	@FACILITY_COMMENT=NULL,@FACILITY_MOUSE_OVER_TEXT=NULL,@FACILITY_PATIENT_OR_ROOMBED=' ',@FACILITY_ACTIVE=0,@FACILITY_ORDER_INDEX=0, 
	@ENTERED_BY=N'softinfo\bmsuser',@ENTERED_DATE=@DATE_NOW,@LAST_EDIT_BY=N'softinfo\bmsuser',@LAST_EDIT_DATE=@DATE_NOW
	
	set @p1=0
	exec usp_Insert_Icon @ID=@p1 output,@ICON_FLAG_ID=NULL,@GROUP=N'APPLICATION_ICON',@SUBGROUP=N'SYSTEM_ICON', 
	@ICON_TYPE_CODE=N'ANTIC_DISCH_APP',@ICON_TYPE_CODE_SYSTEM=N'2.12.24.51',@ICON_TYPE_CODE_SYSTEM_NAME=N'ApplicationIcons',@ICON_TYPE_DISPLAY_NAME=N'Anticipated Discharge or Discharge Appointment', 
	@IMAGE_BYTES=N'iVBORw0KGgoAAAANSUhEUgAAABQAAAAUCAYAAACNiR0NAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAASZSURBVDhPhVR5TBR3GB0tgmjTJtVEm9AiaRt7Wf9o0TYp1qQBRWtQSRbqUQWlCliBcnqjHIIcVq3BRDFG2ibGiEDKirIIW0A0gIByCsO9wAIz67Kru13YfX279tBE7SRfZn5H3rz3vkMY0vR26eUxSR4fl3Sy7t8w6PXS4IBGqq5US2UqpVRZVSE96GiXZFmW9Dq9pP/7rjwuSdoRjTSm1UhDmh5RsFj+fAw+PT0taGpS4969m2hp+QMNjSpcuJCD2JgYhIWGY9Xq1YiL243q6mK0tVbyXjkaGsrQ1l6LSYvJDgFimQholdTqIiQmfomEBA9ERroj6kd3hIS8jU2b3sOpnzNx6VIBFIr1WLZsDrZvd0NU1AKGO+LjPZCV5YWOjnIHoM1mkwWD4bF08mQCNm4UEBv7KuMD7N37EXbseAuhoZ/ixo1CdHX1ISfnJ2zb9gX3F5Dph9i16x2uBRw86ITCwsNUOAiz2WIHNEjp6T8gMNAFly+HorGxEnV1Nbh+vRBKZTGjFCUlN3DnTj2KipRcF6C5uRqlpUUEXop9+2aQgDfOns3D0JBWFoxGo5SREUFJs1BZeQom2tHfD7IC6utHsHNnNLy9fXDxYgF9M1DeFJkAfX0TZLcWMTFOCAr6BAcOpEAU+/8BjERAwCyUlaVBkow80GNszIri4irMn+8GQRCwaNFnyMsrweioDUYj0NbWg/37fcnSiT9dgtTUbBIZehZQpUol4AQ0GhPpG5Cb+xvWrAlkbMa8eW7w9w90+Gl/2tt7KNWXiXGi10tw9Ojx5wGmkIEBvb1mXLlSTdMjyOp3tLaOY8uWMMyd+yaSk4+ToZUqNPTvhYBRDsmlpcmYmJiEVmvGkSMpWLz4Y74TmcV8Ji0A06ZNx+bNobTDgu5uLSWvfDnDmzePYnLSRu/uwsPjfbi6utDw75GSkgUvr+VwcZlJ+UGUZmJSxgm4goCvvEjybHZBNr0borwQRyI8Pb9CRUUdBgfHoFY3IDg4DAsXLmIH/YoHD3qRlOTnSMozHhoMRikzM5J+vUFmBxAeHk5mM+Hs/DpNz2V7PcS1ayLrbxAqVRd8fNbA3X0B9uxJREbGtyyX2QT0ZFKeynJmZhS2bn2NXu3jQQbBQ1hjyazDPgwPm1no/fwehk4H5OcX8acRSE8/wVLxJ+Cs50tWKGajquqEo2xu39axO0YoV6Y0CwYGgJqah0zaKO/oMDJiRGenFocOradkZwIu/a9s7JKPHdvNLLpSWgKz18H+7cC5c7dw+nQprl69RakNOH++nBKV9K+aNdiN2toGDpPltGUGGT8FODHxSMrOjsaGDQKz+S6lfEOzV3L6fM2S8aYsX6SlrWL9rcDhwz488+EdP557M8NzuD/d0SlJSRn2ASELJpNFUip/cUyQ4GAn+PkJ7AiBdfkk7N/2UCierO3vdesErF0rsBoEjjln7n1OMsfYEAS0WacswBSnjApnzuzh+FIghhEXF/DSSIgPcNyNjv6OLBPptxqyrJsUrFPmeg5G0Wq1iaOjerGlWRTvN3WKzff/P+z3mpraxM5OUTQ/fiSS292/ALcmXrTyJBtlAAAAAElFTkSuQmCC', 
	@IMAGE_BYTES_INACTIVE=N'iVBORw0KGgoAAAANSUhEUgAAABQAAAAUCAYAAACNiR0NAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAOqSURBVDhPhVRHS2VrELyuxB8guBNcudKd4MKlAcWEETMGzDmAOeeFgigIoii6UTFhzgEXYo4ozlExi94rpmem3ql+PMZhhvGDj3POd/tWd1dVf5qzs7MfOp1Oe3Nzo/267u/vtaenp9rZ2Vnt+Pi4PPf29iTk9vZWy/9w8X+Xl5faq6srxiua19fXf6Cug4MDrK6uYm1tDZubm1heXkZTUxNSUlIQFRUFBwcHpKamYm5uDltbWxLHmJ2dHby9vRECKtYzAbVTU1NIT09HXFwcwsPDERkZCX9/f3h6eqKmpgbt7e3ybmlpCT8/P0RERMhmfFFRkYByfX5+6jQPDw/aqqoquLq6ClBsbCwSExMRGBiIkJAQjIyMQFEU1NXVISAgQM4JFBoaCm9vb4nt7OzE0dERnp+f/wMsKSmBs7MzWltbpe3FxUUMDw9jcHAQQ0ND8r6wsIC+vj4MDAxgY2MDo6OjiI+PF3DS0tDQgPPzc53m8fFRW1ZWBicnJ0xOTuLl5QWqUJKRPLFqa2trScbWWK1KE05OToQmtu7r64ucnBz+9hOQFbIaVT0cHh5CFVC+jYyMoNFoYGZmhra2Nqiq4unpCbu7u0hLS5OEwcHBKC0txfHx8a+AbJGAFxcXshsbG6VyJiOwu7u7VMilWkhUpwPINbv8I+D19bW009PTI8SzKlYTFBQEQ0NDFBcXS4W02beAJFwVCQQtKCiAubm5PHt7e0VRPT09UZp0kBa2/NcKqeb7+7uoamJiAgMDA+GHLrCysoK+vr60r04E2/sekAZXpZf2KISFhQVmZmZEdU4IuTI1NUVzczP29/eRnZ0tovzCIX1YXl4OHx8fdHd3Izo6WipjNbQCx3BsbEz29PQ0bG1tYWxsjIyMDOEzISHhd1EI6OXlhY6ODpGfGXNzc8Xk6tBjZWVFPHl3d4euri5JWlFRgby8vD8DfjU2bbO0tISJiQnMz8+LmqSBZ6yQE8MktA+r/E0UtsyqSDatwkCCkaf6+noZN05QS0sLqqurZWLoQY5nUlKSzH5YWNhPH/Leq6yshIuLi2SkTUg2xyozM1Naz8/PlzN+Z2VlobCwUGJjYmJEaTqBt45qJZ1GvSG0/f39MuT0mo2NDezt7eHo6Cib71+/eWZnZyfieHh4yBy7ubmJtQTw4+NDbkcSX1tbK23wSkpOTv7r5g3zfyyrI7+q4d8JuKxejIr6VNQJUba3txXVKop6K3+7Gbe+vq6onlTUcSTGyr+tEXJWLBEnIAAAAABJRU5ErkJggg==', 
	@ORDER_INDEX=5,@ACTIVE=1,@PUBLISHED=1,@PATIENT_OR_ROOMBED=NULL,@IMAGE_NAME=N'AnticipatedDischarge.png',@ICON_NAME=N'Anticipated Discharge',@SHORT_DESCRIPTION=N'Anticipated Discharge',@LONG_DESCRIPTION=N'Anticipated Discharge', 
	@COMMENT=NULL,@MOUSE_OVER_TEXT=N'Anticipated Discharge',@FACILITY_UID=NULL,@FACILITY_ICON_NAME=NULL,@FACILITY_DESCRIPTION=NULL, 
	@FACILITY_COMMENT=NULL,@FACILITY_MOUSE_OVER_TEXT=NULL,@FACILITY_PATIENT_OR_ROOMBED=' ',@FACILITY_ACTIVE=0,@FACILITY_ORDER_INDEX=0, 
	@ENTERED_BY=N'softinfo\bmsuser',@ENTERED_DATE=@DATE_NOW,@LAST_EDIT_BY=N'softinfo\bmsuser',@LAST_EDIT_DATE=@DATE_NOW
	
	set @p1=0
	exec usp_Insert_Icon @ID=@p1 output,@ICON_FLAG_ID=NULL,@GROUP=N'APPLICATION_ICON',@SUBGROUP=N'SYSTEM_ICON', 
	@ICON_TYPE_CODE=N'INTER_TRF',@ICON_TYPE_CODE_SYSTEM=N'2.12.24.51',@ICON_TYPE_CODE_SYSTEM_NAME=N'ApplicationIcons',@ICON_TYPE_DISPLAY_NAME=N'Interward Transfer', 
	@IMAGE_BYTES=N'iVBORw0KGgoAAAANSUhEUgAAABQAAAAUCAYAAACNiR0NAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAATvSURBVDhPfZQJTFRXFEAH1IaqaGssTRsbrRvWWJNWxYhbF4sGl5QiMEpE2YYZBhhARkZlBkQQERSkVqtYF9RoQQRNqo0asYAgisOio2yfAWWHMRoFQcDTP6jRpsafnOS/925O7s2970mMtZU1TY1GU3NTvamttUWk1dRupq3N1CFSXVVhulGUZyq6nm+6XV5iamxoEM/aRV7GmeObmxtNzY11JmNtlSDp6enuQvy6ujqpv19FTU0ZtbWl1NffobysgJSUXQQHh+DhsY7Vq905fuIQglBKXd1tMVZPdXUJ7e1NZgWi65nkxYsXpsePn3DseBwxW+zYGjGZqHARjS2BPhMIVThwbH8q8ZHbWDRvOiuX26DbMInojWKMmcippGeE0N3zCNH1cEAoCDX4K2Yhk0kIDrPGN/ALvBQ2OK36CF2sFwXFei7nFaKJCsHZfTye8tH4BY1hrdcwFHIJe379mrKyq3R0PHkprKi4g6d0IvKIL4nUp6KtLSKipoCw8svENNRwoK+fg/39JLQ2EW4oRCsUohOuI8/YiUr9KXHaUcTFref8hasvhdVVBnxcJqNI+olw0z1W5hazOCObJelZLM06x9KzZ1kusuzMGRxPZeL4ZxarCm6hNDawKd2fCI0Nnh5LOHDg2Cth5V1k0imEpq7A41IaVlNnMHqmHfZqNeOXLWX4uHEMGz8eW6kbdioV1hMmMnK2PWuKbhBTGE9U9FgU3is4eiT9pbCq0oBs1RRU+5exOnsvM7/9kY3qOLINtbjIlEgkEoZILJBv28nvgoBPiJqZcxxwzjzFxsNORG74GKXChbS0zDcZ+rrZItu1gPB7V0j+u5TCOw8R2nsJCNFhaWHBSKthRKQcJPt5H+fbn7Lvwg1kORdRbZ9FZOhwlP5u/xX6uNqi2GFPREspfrdaCKlqJ6G7BwdtJBaWlgy2Gsoc9VZWXzGguN1AXC+EVeoJjp2BLtT6lfD0WxlKbfFP/g71vSLWbL2Mf1Yxm7ufMS8uBoshg8QsBzPbUY63JhPvPZdQPeolSBzq0NhZ7xBW3cVHLNlvx1x0LSVElreyqaIJ/8YOvlFrkAyyxGq4NR5J+/itshVd2X2UrU+Rld8kLHa2KHxHyb7mDJMWEFZdhPPeazhFZfFz3AUmLZQONGXoZza4XviLYH0zztoMnPfk4lNYgDppHrr1r0t+qynmDGUJ4mGDHl2OkcTzZSRfvMv3zl4DQnPZ05X+aP4pI+lcKbF59ShLilEl2L+7Kb6u5sH+AXVHDS45bbieyMF9/x9MdXLmg8/HMsRmDCO+msbCDTpWnbyGR9EjAsoNqBMW/L/kygoD3tJJBOywQ1VxlfmZpdilnGBufDwL42NZtDORRYmJLNwSxZzoGGbuO41jdinhGeloo6eh2zgCpVL6ZmwqK+7itdYWefBQtIeWoz4iQ3PUC02aDxHpAURmhw6gyw5h80kF4eL+plRPtJvns1X7IdHRo1Ao3Djy+qa0tDSzPd6DQPlI5O4S1v0iwdtNRCrBy1XE5RXiv3nfR2StswR3ce0nvlAy309Yt24lhw+ffCjp7+9/bn4cHzy4R1ZWMlFRUgKViwgKdEAVtPi9hAQvEc8dCQ1dy+7dyeTl5fdK+vp6b4n3WTDT1d0nGAxGITe3WMjPvyVcu6Z/P2JMbn6xGHNTMBrrhM7OTv2/6con8Pg1DAYAAAAASUVORK5CYII=', 
	@IMAGE_BYTES_INACTIVE=N'iVBORw0KGgoAAAANSUhEUgAAABQAAAAUCAYAAACNiR0NAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAPASURBVDhPfVVHSGRREBxFEPQmelE8ePbqRUG8iR6MmHPOOScUMWKOFwNGBFFRMYsBc9w1IcYxYcYveNCVXaX2dcso4roDDX/m9a/XXV3VIzs6Ojq8uLiQLi8vpZubm09xe3sr7e/vS0tLS9Li4qK0sbEhnZ+ff8m7urqSCEMuPrLn5+cniM/T0xNOT09xcHCAw8NDnJycYH19HRUVFYiKioKHhwdcXFzQ2trK58fHxxCXcYiLCQIC65fs9fVVenh4QFNTE1JSUhAfH4/o6GgOLy8vBAUFoa6uDllZWTA2Noa5uTkiIyMRGxuLmJgYJCQk8CUCDALrngFFpfDz84OrqysCAwPh4+PDFVlZWSEjIwPLy8uYmppCWloabG1t4e7uDl9fXzg5OfFzfn4+1tbWcHd39wa4u7sLe3t7hIWFobe3F5OTkxgfH0dfXx/m5+e5PaJgdXUVQ0NDmJiY4KiqqkJwcDDi4uKQk5OD4eHhN0Diwc7ODqmpqVhYWEBzczNKSkpQXFyM8vJy5rGyspKfi4qK+Pe2tja+tLq6GhEREXBzc0Ntbe0b4N7eHhwdHZGbm8t86enpQV9fn9syMTGBtrY2dHR0mD+iQldXl8/b29vR2dmJxMREpqmxsfEDkPjIzs7mSgwMDJCUlISVlRV4e3tDJpNBWVkZ6enpEPLhigwNDbniwsJC/k7ci84+AB0cHJCcnMwcdXd3Y2trC0KXPG0lJSWoqalxu0KHLBvKoelSdaGhoayGT4A0FDqcm5vjwYyNjWFnZwfh4eFcnaqqKvz9/dHS0oKBgQEQTSMjIyybkJCQr4DEIclCTIpbq6+vx+bmJotaRUWFQc3MzJiKgoICpuNbQJoytayokKqjCZL2iEMCU1dXR2ZmJstodHQUs7Oz3Am9822FJBtKzsvL40Sq2MjIiIeiqamJmpoabpfcRIqgKVM3/+RQUeHMzAwTTnLo6elhtxAgte3s7Iyuri50dHSgv7+fKyS7fjsUhbBpemVlZVypqakptLS0oKGhwfoMCAhgaREwgVIXX1om61GFRPjg4CBKS0v5mcxPQe3TNGniZE8CIYcIZ/AZLQuy4LtsCJBWE6mdhErWIusRML1I3CmCqqMzyiMuFRuHhP3ulOvra3YJrSvSo4WFBWxsbHizWFtbfwr6nYJyLC0teUORjz09PdHQ0HAve3l5+U3L8ezsjAdB7dBt1AJx87+g9umctEo2FAP9Q4A/xIKQU4glKd/e3pZPT0/LhWPkQnP/DcoReuQc8Vcif3x8/PkXxR5Aas0omLcAAAAASUVORK5CYII=', 
	@ORDER_INDEX=6,@ACTIVE=1,@PUBLISHED=1,@PATIENT_OR_ROOMBED=NULL,@IMAGE_NAME=N'InterwardTransfer.png',@ICON_NAME=N'Interward Transfer',@SHORT_DESCRIPTION=N'Interward Transfer',@LONG_DESCRIPTION=N'Interward Transfer', 
	@COMMENT=NULL,@MOUSE_OVER_TEXT=N'Interward Transfer',@FACILITY_UID=NULL,@FACILITY_ICON_NAME=NULL,@FACILITY_DESCRIPTION=NULL, 
	@FACILITY_COMMENT=NULL,@FACILITY_MOUSE_OVER_TEXT=NULL,@FACILITY_PATIENT_OR_ROOMBED=' ',@FACILITY_ACTIVE=0,@FACILITY_ORDER_INDEX=0, 
	@ENTERED_BY=N'softinfo\bmsuser',@ENTERED_DATE=@DATE_NOW,@LAST_EDIT_BY=N'softinfo\bmsuser',@LAST_EDIT_DATE=@DATE_NOW
	
	set @p1=0
	exec usp_Insert_Icon @ID=@p1 output,@ICON_FLAG_ID=NULL,@GROUP=N'APPLICATION_ICON',@SUBGROUP=N'SYSTEM_ICON', 
	@ICON_TYPE_CODE=N'PATIENT_ICON',@ICON_TYPE_CODE_SYSTEM=N'2.12.24.51',@ICON_TYPE_CODE_SYSTEM_NAME=N'ApplicationIcons',@ICON_TYPE_DISPLAY_NAME=N'Patient', 
	@IMAGE_BYTES=N'iVBORw0KGgoAAAANSUhEUgAAABQAAAAUCAYAAACNiR0NAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAUJSURBVDhPbZRpTFRXFIAHFakxWrRputhorFo1pnaNsa2tbbRqNdYlmGha0Lo0onUH0bIMiyKrIJSqVYpYcQOxCiLIYxmHGYaBAdnGQUAEZJlxBtkF7PD1Mqampv3x5dy559zvvHfvfSOra2wN7e/tkXpbqiWrqULqM+slS3ut1GZplnqMbVL3/9BuapHazI1St6lesrY0SgNGi9Rs6ZGS0zMlWWurSdPd1UtlmYGKshpKK+opNjyixNBEuaGaMkONiP+mlrK71egMlaJOT0W5gSr9PQwNek7EnUDWaWyRNAV6tnlfwsVLyWZfLVs8brHBLYXv3S/bcN6fiLNHom28/kAyuwOU7AouYIPvbZy98tnhm0ZqhoqQkCPIek2NklJ9DyePHBZ7dzFvaxlvTP2WseOn8+bED5g05SMmTX6XV16dxOQps3hr0mzenvEN81YlsFoOX3kMsMKtnuupTUSFRyHrMddJyoJq1vpo+SbAymK5lWV7m5kwbTHjxjjgOHYUM+btYu6as0z/bDuOjo5MeH0Mo0eP5fNN2SwJgZWHWrieVUH00WDxyu11kqKgkh8PqVh7pAOnIPhOFM389CdkMhl2dnZ8ufEa66NgXUg/M+fvY5iYH24n4/2FB1kTCU5hJq4qSjkWEYjM0tYg5QjhjiAFW8It/CAKNkbDrPmuNqG9/UiWbs1gawy4ChZt/tMmG8rNWeJvq90Q0UFK7kMij4YjazM1S4p8A/tC1ew63oPrSdgWC+8t+EfowKrdEu7xcCABvnaJtcmGDbNj+e4MW+2+X1tJV9RyNEwI201NUk5eOZ7RWg7G97HvLLifh48XbbctHGE/ChdPCb8Lj3DxyWPca1PFvB1zl+5hb2wfe0Qjn/h20pVDwjAhNDcLYSn+pwo5nNiPPBH8kuGTpc+EL41+GZf9ScxfvoOJ0+YwdfYCVu88i/x8JwFJVrwvQkhiJ5nqWsLDQp8Jb6vLCI7XEpk2QEgqRKTBF8ufCUc6OOB6+BaHL5vx/v0+QVe6CEuHozeeEJHSR6ioj0rpRtLWERoWMiQ0SrmqEqIuFnJaMUBMNpzOhYWrnp2y/UgH9oTfIl4DpxRwUuR+yR7kZFYXp6ReTmRCXFY/WboHBIeJa9NhNkk5Sh2/Xb3DRe0gZ9RwoQCWOO18LjwQLXGpBOLVgzbiBOfUTzif188fSrisGST7Tj3BoULYbTRKSmUR8WnlpFRAkliYWgor1u2yCYePGC4OLJUbd+FK8SDJgmu6QVKLxFgnmpeJ3/ou1GVCGCQOpUN8KQrVbS5kF5FR9xfpDZDfDsvWbnl+sQNir1PcCxk1g9yoeioY4OZdK6kG0aTmKTfr29Hoq4VQPGGb+b6UrcohSVWE+rGVc0U1rNzkyljH8TbhEO/M/hDnPW6k6I3ktFhJa+ons8EqgJsPB1AaO9EaqsSfgxCaxR5mKtSkaiop7YSr5Q9xC43BI/Q43hFx+ESewT0wBs/wOKR7HWhNoDBZUbWAphnyjFBseYrubgNHAsW1sZg7JY22UuxBHQ3dUCOkjQMgGtPU9yK1j0W+DQwdUCviAwtUiVgn1lVWNRMUKPawtbk1S6+vQplfSL6uHI2ulALdHUEJmuI7L5Av5oZQFRdRWFSErrCEvJJilOU6buflCuEhZAkJ51TR0ceQy32Q+8rx8/UReNuir5/3fxE5uZ8X/r5eBMi98RFjL39P/Px+xlfuxd9a1ncPpAl1sQAAAABJRU5ErkJggg==', 
	@IMAGE_BYTES_INACTIVE=N'iVBORw0KGgoAAAANSUhEUgAAABQAAAAUCAYAAACNiR0NAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAANrSURBVDhPnVTJK71RGP7IsFBSEjsyLcQ/ICnFQlkoQzYkSkqxMJQhZLiGa4rILJllYVqQe2W6XPOQIQtThmQusn143q/7xUa/foun853zve/zDs97jnJ1daX//Pw0PDw8GJ6fn/8JtH16ehLQ5+XlRb6np6cNyv39vfnj4wOHh4eCo6MjnJyc/Inj42PNlj60Pz8/R2dnJxRG29jYQEFBAfLz81FcXIzc3FxkZ2cjMzNTkJWVpe1zcnJQVlaGyspKFBYWaj6zs7Oorq6GwpTX1tbEKS8vDykpKfDx8YGzszPc3d3h7e0NT09PuLi4wMvLCx4eHvDz80N0dLQEZ2CChPX19Srh+vq6RCoqKpJMmZWvry8cHR0FQUFBiImJQWBgIJycnODm5gYHBwckJSWhtLRU/AwGg0rIhprNZpSUlKC8vFxQVVUlzoqiwMrKComJiWLMMoODg+WMCA0NhV6vh06ng9FoVAmpDkvmYU1NDerq6tDQ0CCOJLS1tUVqaiqampoEycnJQsZ/4eHhYku/hYUF8RVRSMiGNjc3o6WlBa2trQgJCdEIMzIy0N3djd7eXsTHx8u5tbU10tPTxZZ+i4uLqK2tVQlXVlbQ2NiInp4ezTEsLEwjpOp9fX3SX1dXVy279vZ2dHV1id/y8rJKSFFI2NbWhuHhYQwNDWFkZETKYSZsPlWMiIgQ9QMCApCWliYBaDcwMCCryWSS0oVwdXVVMpucnMT4+LisJCChvb29CDY4OIiOjg6Mjo5iamoKExMTYmsBhaVAQkh2RqL0nCeukZGRQmhnZyf9XVpakvO5uTnMzMz8As94OTRC1j82NgZmyuYyQFRUlEbIceCs8h9BRX9+035ra0u9KRwb9pBl7O7uSqTt7W3ExcUJoY2NjczX/v6+kPK/BZb9zs4O9vb2ZH6FkBmyVF7y09NT3N7eIjY2Vhtsjsbj46M8HAcHBxoYhOBjwXMOvowN+zM/P4+bmxvpVUJCglwxZkj4+/uLsszk7OxMgv7ExcWFvD5ayewJs/wml3J4/Xhz2GSOAu8rjel0fX2Ny8tLkIQrwYqYfUVFhary5uam9ODt7Q3fe/B9JN7f33+BZTMoVwu4f319lYyF8O7uzsgeUGEq9RcY2IKfdmwFK2RVSn9/v4mXnk8Q37f/gcWX6xeHm1ppNQU4VQAAAABJRU5ErkJggg==', 
	@ORDER_INDEX=12,@ACTIVE=1,@PUBLISHED=1,@PATIENT_OR_ROOMBED=NULL,@IMAGE_NAME=N'PatientSymbol.png',@ICON_NAME=N'Patient Symbol',@SHORT_DESCRIPTION=N'Patient Symbol',@LONG_DESCRIPTION=N'Patient Symbol', 
	@COMMENT=NULL,@MOUSE_OVER_TEXT=N'Patient',@FACILITY_UID=NULL,@FACILITY_ICON_NAME=NULL,@FACILITY_DESCRIPTION=NULL, 
	@FACILITY_COMMENT=NULL,@FACILITY_MOUSE_OVER_TEXT=NULL,@FACILITY_PATIENT_OR_ROOMBED=' ',@FACILITY_ACTIVE=0,@FACILITY_ORDER_INDEX=0, 
	@ENTERED_BY=N'softinfo\bmsuser',@ENTERED_DATE=@DATE_NOW,@LAST_EDIT_BY=N'softinfo\bmsuser',@LAST_EDIT_DATE=@DATE_NOW
	
	set @p1=0
	exec usp_Insert_Icon @ID=@p1 output,@ICON_FLAG_ID=NULL,@GROUP=N'APPLICATION_ICON',@SUBGROUP=N'SYSTEM_ICON', 
	@ICON_TYPE_CODE=N'ROOM_BED_ICON',@ICON_TYPE_CODE_SYSTEM=N'2.12.24.51',@ICON_TYPE_CODE_SYSTEM_NAME=N'ApplicationIcons',@ICON_TYPE_DISPLAY_NAME=N'Room/Bed', 
	@IMAGE_BYTES=N'iVBORw0KGgoAAAANSUhEUgAAABQAAAAUCAYAAACNiR0NAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAATPSURBVDhPjZR9UNN1HMfHg4iAggHjeN6YgGxsIhsCY4zhcEzYBIeAkwc3NnDgRBjjUVGhIwEz4+ESUyAEQaUzM3vSYVnnRWnWZXk9UGrWeXVmV931dN29+/ADLas/+uN9v9++9/u+9nl6f1jBCVH7OGkiByc11hH+vyWY+zaFnn9XqsDBilCunN76wRHU3T6Ompuj8xpD7YP3+bNbo9h+4yisM8Oo+vgItlwbgPndPhjeOoCSi90ovrgPibU6sJZlih0NdyexG+ew4/ez9HwV7bhAmnqgNnrfAwda8Qpa6Bv795Oovj2Kys8GUf7hAIxXemG40odEWx4BVWKH7etxBtby8/Ow0D8XvdwB89s9ML/TC9N0Dwxv7EfphW5SF4ode2F+/ylsvfEMTO/1o/TSE9BPdWIjSWJd9xdwJwFb/3gReaNNCEviY4HbAri6usBt0UJ4sZfC098HTiwWnElLOQGQNhbAeLkXm17rwoaX2pF3tg3xldkPR9j04ylK7TxqKR3vQF+w6HKgMALmy31Ur34oO8vg4ePFnDuznKA+aIX+9S7kPrsT6yZbEFeu/gfwp+eY1G13JhCwPJy5GC7lw/btCdR+cxy2eyeRMJvWfKTS5kIUnOtA9lg91KN1EBpV/wH87QXUUITsqFDmIkcuhPWLEViuP43KmUHI20qYc1cXFyi6Tcg5tROqw9uhHLBCUKL8N7DllzOopoL7PwCKmAZUfT4E07WD4ChWMECeWsKkqRqqwep+C+QHKhCjVzwMbPjhFBqpjls/GYR/ZAhzkUuAoqm90I7UIWZDKjz9vCGkSDTjjcgctiG9txIyijT5MQOiC+T3gRNo+fUM7HdPwv7dJCwfHYLfsjkgb40Yaweqma7P/mYLOMg93YqsMTsUvRbI9pmQ2F4CSasekbqUOWDNV8fQSA2pvTOOGpKZ5suPF8wAQpP5MFztR2wx1We+GTEb06AarqXIyghWDHFLAVbU68DLSZoDVt88ivp7NP1fkrVujcAw/SR8I4IYQMiq5dhEo5EzuQM+YWzmzN3LA5KmfEi7jBA3F0Bky4VgmxZczSqweKp4h3VmiMZiAlVkJQvVb9aXj3ADmctB4ijoTu/C+jO7EW/VwtnJmRluf0pdsrsIK+zrEVOVjajyTIRTo1i8NfGOyuuHsY2iqyBfmqmTerLXfSA7lgvNRCPUIzYoD20DW8hlgK4sZ4RrEiEkYKRpDbil6QhTxc8By8mblZ8Oooy2R9nVPuSeaCZHLGYi9AllI4McMTtnab1bIKIo3Ra6MdDZ1Ln5MkQYlAgtTEWIMm4OWHa5BxW0FIwElO0qAlvEhfsST7gv9sAiby/48cMgLF8LaacRCdSEwBTyursb3KjzHr5LEKQWIyRfiuB0IQGVcY7SN/fPG70T2mMNUPZYoOyvguJxM6SPlkBs10FCxRfvKISobrZmWYjQyxGmS0ZQlgSBGgkCSEHkKhY3Y+XUZlqSRhoNPW2O/PMd0NHm0Ew2Q0XDnE7pyvabkdBGDWjIA79ai2iLGjyqW3ixAsH5KQjQJsBXvRKB8liwQqX8S0n2PCTXb0BCdQ7iqzSIq8iCyJQJweYM8ItWI7pQjqg8GXi5yeBqE8FZK2EaEJIRR2mKEJQmZGDBMgH+BJyfQWG6qu81AAAAAElFTkSuQmCC', 
	@IMAGE_BYTES_INACTIVE=N'iVBORw0KGgoAAAANSUhEUgAAABQAAAAUCAYAAACNiR0NAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAOwSURBVDhPlZT5K+1rFMa3CGUIpciY6QeReTxHpswzmWdCMoscU6ZzlCGSkiE5HcMxz/MYwjUk/EPP3c9y6Mrt1t21evf+7vf9fNd61rNehYODQ5+bm9uxq6vr/w5nZ+fjfwYZCk9Pz79WVlZwdHSE/f39/4y9vT1sb29jfX0dy8vL+P37N379+oXJyUmJrKwsKHx9fY/Pz8/x/PyMh4cHWV9eXv41np6eZM/l5SUODg6wubkp4Lm5OczOziI7O/sVqPzIxtvbW9kwMjIiGxgzMzOYmprCxMSExNjYGBYWFrCzs4P5+Xn8/PlTnjHS0tI+Ah8fH9Hd3Q0nJyeoq6tDTU0NmpqaMDAwgL6+PhQKBVRUVGBiYoL8/Hx5IV8yPDyMoaEhJCcnfwReX19LyYeHhzA0NBSAnZ2dlES9qqqqoKur+w5ubm4WYF9fH3p7e5GYmPgReHNzI6WfnJzAyspKDiq7iLOzM5yenoJaS1l/Mi0oKBB5vn//js7OTsTGxn4G3t/fi+CWlpZyUGkp0Wt1dRVbW1soLS2V56qqqqiurkZ/fz9aW1vR1NSEqKioz8C7uzvs7u5+AtIuS0tL8PDwEOCXL1+kzLa2NjQ0NKC2thbh4eEfgVdXV6COGxsbsLCwkIMEjI+Po6urCyEhIdKc6OhoaV57ezvq6+tRWVmJsrIy+f/dNsyMGjFYnrm5uQB9fHzQ0tIiXedva2trDAwMiG6EsVElJSUoLCxEUFDQK5BdZWb0I4P+egPSQuyw6POnGWFhYVIqMyOMFuKU+Pv7vwI5UhcXFzJ2/D49PQ0zMzMBODo6ijWol7GxsTzT0tJCXl4eKioqZM3IyEBKSgr8/Pyg8Pb2PqbgtAVHiXPKuTQ1NZXD9vb2UuLg4CBSU1PF2AyWXlRUhMzMTCQlJSEuLk7kEeDa2ppkx7FjJ0dHR9+BNjY20oCOjg6xhq2t7Tv069evAoyJiUFERASUrFfg4uKidJZaMXp6et4nwsjICI2NjQKrq6uT0jQ0NATK0oODgxEZGSmrWIpAzuTbrVFcXCxZaGtrywEdHR2ZmoSEBJSXl0sT2ChC2Xk9PT3JLDAwUIZA4eXldczb5G3Qf/z4IXagWWtqamQyeC1RfHbzTbPQ0FAEBASIbsrGyuri4iLAE16SLJUG5mzy5mDZ1O3bt28yYsycYJbMbGlu2oeZEai8qF+ByvSvcnJykJubi/T0dDnArsXHx8sh6sNsqBEzojUIYJmEuLu7Q3n1C4wXyd9HkHIT6/J5WAAAAABJRU5ErkJggg==', 
	@ORDER_INDEX=13,@ACTIVE=1,@PUBLISHED=1,@PATIENT_OR_ROOMBED=NULL,@IMAGE_NAME=N'RoomBedSymbol.png',@ICON_NAME=N'Room Bed Symbol',@SHORT_DESCRIPTION=N'Room Bed Symbol',@LONG_DESCRIPTION=N'Room Bed Symbol', 
	@COMMENT=NULL,@MOUSE_OVER_TEXT=N'Room Bed',@FACILITY_UID=NULL,@FACILITY_ICON_NAME=NULL,@FACILITY_DESCRIPTION=NULL, 
	@FACILITY_COMMENT=NULL,@FACILITY_MOUSE_OVER_TEXT=NULL,@FACILITY_PATIENT_OR_ROOMBED=' ',@FACILITY_ACTIVE=0,@FACILITY_ORDER_INDEX=0, 
	@ENTERED_BY=N'softinfo\bmsuser',@ENTERED_DATE=@DATE_NOW,@LAST_EDIT_BY=N'softinfo\bmsuser',@LAST_EDIT_DATE=@DATE_NOW
	
	set @p1=0
	exec usp_Insert_Icon @ID=@p1 output,@ICON_FLAG_ID=NULL,@GROUP=N'APPLICATION_ICON',@SUBGROUP=N'SYSTEM_ICON', 
	@ICON_TYPE_CODE=N'NUMI_LEVEL_OF_CARE_MET',@ICON_TYPE_CODE_SYSTEM=N'2.12.24.51',@ICON_TYPE_CODE_SYSTEM_NAME=N'ApplicationIcons',@ICON_TYPE_DISPLAY_NAME=N'NUMI (Met)', 
	@IMAGE_BYTES=N'iVBORw0KGgoAAAANSUhEUgAAABQAAAAUCAYAAACNiR0NAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAPhSURBVDhPdZRdbFNlGMfPOe3p12ZXWspKt+HoKIMtdKs9px9r2QdryQZrJR1ru60MQSAmcyYkJhLxwjvjjZosGkOMXkDUeKOL0SuJkQs/MgOJJuA3MMa+2IeRBY0x/n3e9+zQbnEXT057nvf5nf/zf5/3FQRBOE8x8X8hCdKERDmZnhbBTL9FHiLFZjX0XrhMgfKgIsiCAVbZAmu9HY9E3XB218DWugUVXjtMgpHnJVFcV7fG4Op4QqQFMl9shKOvBi2XUui5/iRys2dRnH8O2btj6J4swv9KDLZ9W2AkqFEyboTqQJF/2eyywvdGFEeWx1BcPYfMwihSS6eRun8GvatPIffXsxj5+zySN0/CM9oIgyCBLCiHakD2NZPLguaPkuh/cBY906cRnssjND+ApssHsXM8jEdfVdDwXgLq91kcWRxD+o+nUftCgAPL2i+1vHM8gsOro+icGoGykEPLZBpVXR7I1VZYd9th2+uA7Lag9vkAwssF9MyeQXLlFFyFeoI+3AcNaD/gQfvcCLqmj0OZGcBj3z0Oc20F7IlqBK70IjydR/huHsGrGbR+m4F6Jwfl1lEk751C8Os05K0WvXUNuOtCGzqXTyB8O4foyhC2DflgrrERiP4vDyE8lYNKEZ7RwOrNAQ6MTQ2ifek43EWf7iPNGdGDkxnEZ4ahEiD0Y5a3tuPFVrTdL1LxUa6QgXksDkK9NcCDCYgvHcOuN2MlYGXQCeXnfoTv5BGZK2DfF4cgGkXs+aAL0XuDiJCqlq8Oo/5lBb7XImh8t4MrVG9rUFbT/GkKksXAoMIE80n9lVSQLywZuEJAAwHf7+BqGHTvhwfg6NoOq98O2WWGsraeA2dJxOe9MFaZNGBlyAXlJ6aQPKKWlV/6IW+zYPvoHsT/HNFao1zinyfgvxCHwS6vBzKFnyQhWdcUmjxWtH6T1sym4ujvw/A+08Q9aZroRtuDY4itDGP/vyew+50EjOVAajuyMMg3tXT0RAH+t+I8wXzhKskjZ18dJJOErXkf969hPMrbNlSSwt80i1TaFNZy9Ul/GZCUOA/VPRwNZjgbD+Zn48X9cNMIVbV74Djo5YWNF9v5CPGPzxRow/pg8trWA0VZ4rIj8wVtMRsLekYX9VFh41L6zfPMc7KpTJ22KfptY6KT0fxxkivTFejzxkekLJgtrIv6l0J8IsquvxKQvTTX2uB/O8Hbj8zSqWCFTIkeNODMs9CNLOrOBbjHG+7T9UCWZAPqLvhoDjsRvJbhQ6/SJoR+yKLlyz40vB7jZ3zjxazv8mebJMB8tTU54Eh54UzXoarDA/OOis1A/P1/UXmw/nK/mwIAAAAASUVORK5CYII=', 
	@IMAGE_BYTES_INACTIVE=N'iVBORw0KGgoAAAANSUhEUgAAABQAAAAUCAYAAACNiR0NAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAL6SURBVDhPdZTLS3JRFMXtQVHRwzKEoqIIgqhIsGaZk0bRUIImBREhRQVpDRR1ECJoRlCZ9lR7vzUIgs+/bX2ubed6r9Rgc+/dZ5/f3Y91jslkMvmKlvvNqqqqcsqqq6u197/if/ymQvEFeitCUASgvr4eVqsVQ0NDGB8fR39/PywWi6zRGFe5t/gt2cmCAjF4YmICOzs7uLq6wvv7O/L5PF5eXnBycoKVlRX09fUJtKamphJaBjKgpaUFbrcbHx8f+P7+xuvrq4AIzeVy4isUCshms5idnf0tyxJQwfx+P76+vnB/fy+bMpkM9vb2sLq6iuXlZXg8HhwfH2tZz8/Pa9X9VFrOkJtYGkG0eDyO0dFRtLW1obu7Gz09PWhtbYXL5cLd3R0eHx8l+6mpKX3ZJeDY2JgE3dzcIJ1O4+joSAYwPDyMSCSC6+tr8R8eHuLg4EB6e3FxgaenJ+zv70urDBmur6/L4uXlJR4eHjA9PY2Ojg4BsXwCaITSCKNxnZk6nc4ykHT+lWUy4PT0VEpbWFjA8/OztpFgGitRQJXA2tpaGTgwMIBUKiUwQlki5bC7u4vb21sZTCwWw9LSkkjG6/UKkDA+uScUCqGuro5QU459Oj8/NwA5deqQ2RDq8/mkz11dXWhubsbZ2ZnEE8gfhsNhNDU1lYCDg4NIJpMSQGMwS6bO3t7etJKpQ/a6sbHRAGSGwWCwnKHZbJZJqWZzKHNzc9IT6pLipu/z8xNbW1sGIMumMvgjbco8chsbG7LAAFUKj19tba3ojP2jTll2Q0OD1iLGs+SZmRmjbOx2uyYN9oXZspTt7W2R0MjICGw2m2ykjxJSMA6svb3dCORUmTazVKLlk0NRUtG/86dKl7rsSkNRtw1PRiAQkMxUBnq9MSNl6uQsLi7KPaC7xspAOgnd3NwUIHujJq9/0p9IJORMs8cVd6IRyEUK1OFwiA55dil66pQnKBqNyvVG7f5yuUrJ//5YkNPS29srt/Xk5KQMprOz8y+Q+P8DF+MKO0Gx9PMAAAAASUVORK5CYII=', 
	@ORDER_INDEX=8,@ACTIVE=1,@PUBLISHED=1,@PATIENT_OR_ROOMBED=NULL,@IMAGE_NAME=N'NumiGreen.png',@ICON_NAME=N' Numi (Met)',@SHORT_DESCRIPTION=N'Numi (Met)',@LONG_DESCRIPTION=N'Numi (Met)', 
	@COMMENT=NULL,@MOUSE_OVER_TEXT=N'Numi (Met)',@FACILITY_UID=NULL,@FACILITY_ICON_NAME=NULL,@FACILITY_DESCRIPTION=NULL, 
	@FACILITY_COMMENT=NULL,@FACILITY_MOUSE_OVER_TEXT=NULL,@FACILITY_PATIENT_OR_ROOMBED=' ',@FACILITY_ACTIVE=0,@FACILITY_ORDER_INDEX=0, 
	@ENTERED_BY=N'softinfo\bmsuser',@ENTERED_DATE=@DATE_NOW,@LAST_EDIT_BY=N'softinfo\bmsuser',@LAST_EDIT_DATE=@DATE_NOW
	
	set @p1=0
	exec usp_Insert_Icon @ID=@p1 output,@ICON_FLAG_ID=NULL,@GROUP=N'APPLICATION_ICON',@SUBGROUP=N'SYSTEM_ICON', 
	@ICON_TYPE_CODE=N'NUMI_LEVEL_OF_CARE_NOT_MET',@ICON_TYPE_CODE_SYSTEM=N'2.12.24.51',@ICON_TYPE_CODE_SYSTEM_NAME=N'ApplicationIcons',@ICON_TYPE_DISPLAY_NAME=N'NUMI (Not Met)', 
	@IMAGE_BYTES=N'iVBORw0KGgoAAAANSUhEUgAAABQAAAAUCAYAAACNiR0NAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAKfSURBVDhPfZTPaxNBFMdnt2nSJiHBSgz9cTA0CS3YUrDQQxH8cVAQ7E0UBD2IoF56bO1/IJ4LHoQeFD2JexGKv1FPnlQQ1INWBEFBQWgQpHl+3u5MMklTD1925s28z/vOm901xpgVFG1TGEYmn4/MwEBkstko0HF/fysWBMH2nIRjHiFxCsJQTCYjmXRa5vv6ZCmVktVsVtaKRblG7DzzCjKDg0IBAdzKtYyYmgQB4EgOMV4HslWvi0xPi8zMiMzOJmP0fXRUrgLao2CKd0ETYKAwtMj4b7ksMjUlMjYmQgHBNRVFWJdCQaRWE5mclLe43KdGOp2aKD4mmy9pUqkkUqlIk+qbzF/i5Cbra2gdNZgrvEkLpFqVDaA1harb5KQ4ZOMckwbHlJERaaoj9EILEd8P5CgaRxPojXOcy4kMD8eFUro37ie3pT24q5uGhqRJ42Mgjh9b4Gc9KvqFFH5AXWpMn9oCwAvqLrkgE9WZ/KYPgkOFNS3giQV+tHOFrBLLaZ9dTPMA3mnftonOaO+4LWGxF/CHBzxC4jHnkHh8Gi7uAz0suh4u6QYCKnXnHD6zDs+xvogOosPoi21Jay9GfpK71wFX/Io9gGdZv4jKJJzeYa/2d9wBL+ywyfXwmz3yJ31XSbrd7ZC4XlzJAecANmySf2QHfO/1cJ69Jz0D8W2j+xQJHTDD4LmX5Hr4wPbwnbe2DEyb/8eLKfCyf8t6jFMEHMg99QU+Qfyrl6yxBWIbfozx7vYPxn7LBK7b3mhFB3VH8lvhYvrcRMfb7uynZ+l5nrc8qJ/Ya6w3q6+U//tLvuW2XUkzvgLUP1I3bAvQU/boO9kF63ToL1YBL5N0D70C8Brpxd1gru9i1jPR7fBhjyodlQsk70L/gbT2/wNLIV58ug9PhQAAAABJRU5ErkJggg==', 
	@IMAGE_BYTES_INACTIVE=N'iVBORw0KGgoAAAANSUhEUgAAABQAAAAUCAYAAACNiR0NAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAJ9SURBVDhPhZRZayJBFIVbE2NUBKMmBo24gAn4oIaIuO8LiktMRJGA8UEEQQWf86t8n/ltd/pcpypt62QeLt21fXXq3FulKIrypcZeHwaDYX99fb03mUx7s9nM/0ajUfZh/Nw6tU/5rQaJUBeRCqGrqytyu9309PREyWSSstksxWIxCoVCZLfbefzi4oJUsFz7l8HquBMwASoWi7RcLmmz2dB2u6Xdbsf/iOl0StFolCwWC2+ugx6AgCHC4TB9fHzQer2m+XxOb29v1O/3qdfr0WAwoPF4zButVitqNpusVqdUgTcMCwaDDFssFry40+lQPp+nl5cXen5+pkwmw32ATyYTBqNts9kYKo8MyTc3NzQcDunz85MVIQDDJIfDQXd3d7wQisrlMkNHoxHNZjPeSKpEtgBMpVLszevrK8OgEIkAsNFoSMWAu1wubgMKCwC+v78XXip77Nztdun9/V2qw4JcLsfAer3OAAQyDTXCUwgAELbIIz88PPBxhTqhUADb7bYE3t7e8vHFBpiLxGFTZBx1uI9EIkcT9EC/38/ZR10ihAXCawhBcqxW6wH4+Pj4XyAqQL0x5PP5zs4V2WZgIBD4EdhqtXgcyuAT/EJbKBRjuBQMRMkgKfpJwsNarSY3dDqd5PV6ZVt4mU6nv7OMoi4UCkcqMRH1BUXValWOwW+YLwQIIO740V2GNyIZ4osCRn3hiomF5/oqlQq/ASePQzweP1GpLQ+xkejDF0o9Ho/2xfl+bS4vL6Xh2kX/+kdmUVLa54+Ton8PUUbaY+qBUIqEoSZ1sEOWz3TyQwAw7nipVCL4hMQlEgmuRc3rcqLw1zmgtg9WILM/QCT0D/LOSmuszoqjAAAAAElFTkSuQmCC', 
	@ORDER_INDEX=9,@ACTIVE=1,@PUBLISHED=1,@PATIENT_OR_ROOMBED=NULL,@IMAGE_NAME=N'NumiRed.png',@ICON_NAME=N'Numi (Not Met)',@SHORT_DESCRIPTION=N'Numi (Not Met)',@LONG_DESCRIPTION=N'Numi (Not Met)', 
	@COMMENT=NULL,@MOUSE_OVER_TEXT=N'Numi (Not Met)',@FACILITY_UID=NULL,@FACILITY_ICON_NAME=NULL,@FACILITY_DESCRIPTION=NULL, 
	@FACILITY_COMMENT=NULL,@FACILITY_MOUSE_OVER_TEXT=NULL,@FACILITY_PATIENT_OR_ROOMBED=' ',@FACILITY_ACTIVE=0,@FACILITY_ORDER_INDEX=0, 
	@ENTERED_BY=N'softinfo\bmsuser',@ENTERED_DATE=@DATE_NOW,@LAST_EDIT_BY=N'softinfo\bmsuser',@LAST_EDIT_DATE=@DATE_NOW
	
	set @p1=0
	exec usp_Insert_Icon @ID=@p1 output,@ICON_FLAG_ID=NULL,@GROUP=N'APPLICATION_ICON',@SUBGROUP=N'SYSTEM_ICON', 
	@ICON_TYPE_CODE=N'NUMI_LEVEL_OF_CARE_NOT_REVIEWED',@ICON_TYPE_CODE_SYSTEM=N'2.12.24.51',@ICON_TYPE_CODE_SYSTEM_NAME=N'ApplicationIcons',@ICON_TYPE_DISPLAY_NAME=N'NUMI (Not Reviewed)', 
	@IMAGE_BYTES=N'iVBORw0KGgoAAAANSUhEUgAAABQAAAAUCAYAAACNiR0NAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAOOSURBVDhPhZRZaFNZGMfvvdlumrU3uYk20ZhpI1pbreCC4oLUrWIpgow4otYKw6CoqKiouIIKrogoLrghivjkfbDSwUpxZMZhHizOgzCjONOKxaWoTWvaJrl/v3Nuk6ax0oc/ybnnfL/zrUcQBGE3SRtaIp1hGvKs0EiHkC+LxQafL4xIpBSRUaUoCsXg8YZhMiswmRwk8zc2fQx+Y3ZTkiSER8RQWTkP27fV4NrVajTcm4vGhqm4caUYG9Z5EYvJdJ4BTRBFMR/cD7TZZJSPn4Yd25fhWfNKIEnCUtJC0izSFNJYvGtRsWenHTabAcuDGkCr1YqKiuk4ffJHJLrWkOFy0nToiRIk40WkYUh2hOjbD6QokArg9g03VFX61kNRFBCNlmH/3mro3KsaNN4fgX27ZSQ+Kkh/8RPMD6RV1N914/BBJ3rjQehfArh8wQW7PCBsQXO6FFRVzUBbSzXBSMkonv3l5jdfOueibwHo3SriH1V4PCLWrpah60GkuwJ4/dKHlT+xnGbrIGhqoBgnjk0mw0VIdY5DKq5wyNZNBQiFJHTHVVoHcfyIEz5FQsd7P/QelTxU8fmtH7euu/lFHGqxyFokEsUfj8rIaAblajjJB703gPY2P1xOEZfPu/g6GJBw/ozhcZIuSXep6P6k4vFDL6ZMshhAs9mtjRmjoO2/Ygp1PD+YETM8tN+BiglmHDrgwET6TfV5xs6kOg3o0yeFqFlsy4RdoI2O2RD/QBXsZhWlAvRBed7aVYwrNVMXiGhq8PLQM/sMqBOw+c9CLF2SBZq1UJEZb15RFXvCAzxkhgywcZ0dI0dKtE/FobzlAtMEffywEAvmWTMeippsk9D0K92eDFIYRn76ww5SceyIlZg4LBfIwk1Q5e/cdKO8LDuKRmPv3VWQzUk+cPMGO0qKTTxfuUAkVLS+8NHUFMDjzvaiARwdM/FcsBuZYa6HP9fJUKhdcoEMzCqs3fFg9sy+Chu92D/La1bJ+OdvBZ0fDE94Fald6u96cOqok6/Zd+ZZb4eK3yh3tWTjcORNSqbLJUnA+l/s+L3Ji7f/+7gRGIDahxWHgZiX7W/8uK95UEcTo/oHmeX8t3BxlRUXz7p4oZ43K2j514dWEvv/oN6Do4cdqJpvhbs/bwNHb7AHNkCvSOUcK9bWynwEt5BWrZB5vsIhegcpmsHsWA4ffGcja2CxsOdNAEvJUGe/AlETCXMFMmflAAAAAElFTkSuQmCC', 
	@IMAGE_BYTES_INACTIVE=N'iVBORw0KGgoAAAANSUhEUgAAABQAAAAUCAYAAACNiR0NAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAL8SURBVDhPrZQ5S2tRFIWvGgcUwaigojgVQbAQKwsLAyKIpaJiExCxdUAUNGCRIkTtRGxsTCGYoEIIRIsXSCEkIgaccMApcQhOv2G9rK3nehOV17zicJMzfHvtUdM0zZ5cvv+4tGAShvSVnZ2N0tJS1NbWoq6uDlVVVTCbzeC+yWRCVlbWtzefDFGnH2ZmZqK6uhrt7e0YHx/H8vIyvF4vNjY2sLi4iMHBQdTX1+v3MzIy0sFfwNzcXDQ1NWFiYgK7u7t4fX3F29ubfF9eXvD8/IxEIoFoNIqRkRHk5OQILA36AeRhc3Mz5ubm8Pj4iPf3dwHE43Hc3Nzg+vpaFoFcDw8PWFpaQklJyXeFtEA3pqendVXr6+sYGxvDxcUFbm9vcXV1JZDV1VVMTU0J/O7uDgsLC8jLyzNCNV9hYSE6OztxfHwsQD7c2dmRSy6XSxTHYjGcn5+Dd/v7+2WPhvb29tDd3Z0KLCsrg8PhEBit0jofDA8Po7y8XNTxv91ul0yfnp6KAd49OTmRZNGQJDdZAr6amhr4/X4JvIoVY3d0dISCggLMz89LLFlGTqdT4LxHhZeXl9jc3JRk6kCLxYKDgwM8PT3pQKVycnISjY2NUF+ljOdMFqGBQAAdHR0fwGRCfEzI2dkZ7u/vU4B8zH0aZEF7PB5dnRG4vb2Nrq4uFUfNxzjt7++LW8pl9aV7LObKyko5VzFWQKqky21tbV9AFjStU6Gx5ozJYfsRZgTSXZYVu6mhoeELSN9HR0f1mBhVUuHQ0JD0NAFGIEMSiUSka/Qsf04ZKWzGQhWy0eWBgQEUFRWlAAlmhldWVtDS0pJah2o49Pb2IhQKSSL4gO4zbuyO2dlZ+c99KmNtcmDwTX5+/s9AThqbzYatrS0pIz4igG6rbqHbh4eHcLvd6OvrQ3Fx8e/TRinl6GLLMVHBYBDhcFgWf6+trWFmZgZWq9UYt58VGucip0hra6v0LVuQq6enR+JVUVGRPrJSgH9+mtjGPU5oFjZD8q+7fwHFPHHrljczAQAAAABJRU5ErkJggg==', 
	@ORDER_INDEX=10,@ACTIVE=1,@PUBLISHED=1,@PATIENT_OR_ROOMBED=NULL,@IMAGE_NAME=N'NumiYellow.png',@ICON_NAME=N'Numi (Not Reviewed)',@SHORT_DESCRIPTION=N'Numi (Not Reviewed)',@LONG_DESCRIPTION=N'Numi (Not Reviewed)', 
	@COMMENT=NULL,@MOUSE_OVER_TEXT=N'Numi (Not Reviewed)',@FACILITY_UID=NULL,@FACILITY_ICON_NAME=NULL,@FACILITY_DESCRIPTION=NULL, 
	@FACILITY_COMMENT=NULL,@FACILITY_MOUSE_OVER_TEXT=NULL,@FACILITY_PATIENT_OR_ROOMBED=' ',@FACILITY_ACTIVE=0,@FACILITY_ORDER_INDEX=0, 
	@ENTERED_BY=N'softinfo\bmsuser',@ENTERED_DATE=@DATE_NOW,@LAST_EDIT_BY=N'softinfo\bmsuser',@LAST_EDIT_DATE=@DATE_NOW
	
	set @p1=0
	exec usp_Insert_Icon @ID=@p1 output,@ICON_FLAG_ID=NULL,@GROUP=N'APPLICATION_ICON',@SUBGROUP=N'SYSTEM_ICON', 
	@ICON_TYPE_CODE=N'SIMILAR_SAME_NAME',@ICON_TYPE_CODE_SYSTEM=N'2.12.24.51',@ICON_TYPE_CODE_SYSTEM_NAME=N'ApplicationIcons',@ICON_TYPE_DISPLAY_NAME=N'Similar/Same Name', 
	@IMAGE_BYTES=N'iVBORw0KGgoAAAANSUhEUgAAABQAAAAUCAYAAACNiR0NAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAASrSURBVDhPhZRpTFRXFIDRCjKAtk1M+r+lif+0WqmmmlQEhQEVEZBGaS0KVSirCjiogOIwDIug4AYYociwCDiIIMq+KDDKZkVABa0bYCnKKop+vcAYWtOmL/ly7rnv5Ms5OS9PR0dHJ3DGjBlqY+PP1d8uM1EvNVmsZYmI/4/JksXqZUtN1E5OTuq4uDi18OmUzJz5EQsWLsLK2gYLy7VTSK0Flv+KpVSKhZUUSysr8V7KGgsL3Nx2kpubw4RQPWfOXHb4n8ZbWYe7XIP3oVp8QivwlF/FM2wKL4G3lt2Hi/GRF+OuqMJLeRP3wHTs7Ow5cSJ+SmhkNJd1bqlID/yJhWwYB9kATvteYrt3hI2yVzgGvcE+cJT1fkOTOPgOYL/7BVYBo5jLxrHyuIVUuoFwhVwrFB3aeOVgLYe1AsfgMbwCykhOKSMxIZctXgVsDHrF9wqwF+8dQmFT0CC2ISOsFrnF3jaka22IjFBMCzfvyWJL5Cgb5eN4B+Zzu7YMxvtguI6a/BBsXBNwPtCF38FWfgh9zs/RL3EJ62VDJFgHt2G13paoyPApoaEY2TlAxY5jwzgFd5GTGAvvOmBQ0FsCT8+gDvUkW5FDS2YpvwYl4+pTjVfsGFtFqX3IfazX2U2PbGBoiKssE5+EtzjLH5IafRgepghRNnQl0VcQyOsGIZ58xqDvDhlhkWwOasbjLGwLbcLcfDVKpXZkQ0MjPIJzCUkH90TYGqLkVsF2BpuDaC9w5NZxG153/gZD/bx9cFsIO+kpz2Sb+2k8hdAjug0zM3OU4X8T7lHkEXFhHJfEaqKuZVDTmoFmlylqv4UUXfdnvEV02NnEu84bouta6k+Gst33LPvPg198G6tWmU0LJQYGBEbnE5r9BN+McHretNPPG54VF9OrKaem+zG1WcUMlOQI0um/mIrC/ygu8hqOl8P+hNuYmq4iIkI5tRSJgSGH4gsJv9CK7Io71S/T0PRdoZ2b1Pyh4XxVN41tI7TUtpKXWUZlZQe194Y4eOoaYaonKNPusnKl6bRwYimRScXE5LXjcGYN8c+3kdwbQGqPHwcL08i6Pka32MXTV2LaEXgmzi/EelSVD/glrISYrA+EEomEoylXyawdxk4mw+LI1/yU/w0/qhexKS6Jkxq41AmlXXD9MZSLWPQIYmt6cA2/wrG8m6LDlaLDCO3IQhinukipKEqp6WVPjAon2T42+flg5hKF87ke5M0QJYhpmYoKsWyHY004+ieTWKb5QCiWcjI7j+rnbynqHufyo1HyO15Q0D5I3IU6LHeeZoV3JmYHLrE6uBDz/ZdY5pbGUtsQ5Koi0uqahfA78R1ql6IvOkwrrKDjNdQPgmYIGgTNA9DYD3k3fudoehVR5wRpVShUFRxJLSOr8g6Nw5Df3PnPDvVm6xN7KpWKlnsUaO5SWN/OZUFR3V2K6u9R0vCAsiZBYxelDV0UNd+fzMsbHlIiZEk5l1m+fAUR7zsUf2x0dXXR0xNMRF09bdTeTdzr6TFbMBENDCRI9PWnakQuEbmx8Rfs8vWdXErxrFmzJoXvmRT/BxO1n3z6MXPnGKErzhPCeZ/NY/78L1n01QL+Av202p0Gxn8rAAAAAElFTkSuQmCC', 
	@IMAGE_BYTES_INACTIVE=N'iVBORw0KGgoAAAANSUhEUgAAABQAAAAUCAYAAACNiR0NAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAANySURBVDhPlVRZK65RGP3IPJQrv8CFSy4U5cZUprhxK6VEMss8z/NMSOYxkT5K6Mg8D4UUGUoyl4wpyjrWo/f7OEedzlurvd89rP2s9Tx7q1QqVYqOjo7ayspK7eDgoLazs/tv2Nvbq/39/dW1tbXqDz7VpK6uLmxsbODt7Q0PDw+Bp6enpq+MfZ3jvLLG3d0doaGhGBoaAgnV5ubmiI+PR1FREfLy8n5Efn4+fgL3pKSkwM/PD/X19Z+EZmZmCAkJkYmkpCSkpqYiMzNT/tnPyspCWloaEhMTf0RERAS8vLxQWFiojTA8PBzZ2dkChaC7uxvNzc2Ijo5GRkYGCgoKJPrc3Fw5UEFcXJzYVVJSoiWMjY0VyVycnp6OtbU1vL294fHxESMjIwgKChICRsE1ZWVl0uchycnJ8PHxQWlpqVZyQkICqqqqZFNbWxteX1/x9PSEm5sbnJ+fo6KiQjwaGxtDeXk5uL66ulr6DICEGsmmpqbiXWNjo0j6SD9OT09xcXGBk5MTTE9PY39/H/ze399xd3cnZPS1qalJbHJzc0NxcfFnhCSkRz09PWhoaBDjR0dHsb29LW17ezvOzs7w8vIih9zf32N1dRVMBgkp1dXVVSzTENKLwcFBVFZWYnh4GOvr6yKBFkxMTODw8FCkK2DC6Htvby9qamrg4uKiJTQxMZFTOFlXV4eHhwfxcGVlBTs7Ozg6OpJImShibm5OFOXk5MhhVOXs7KzNMgl5Sl9fH1paWnBwcCAkt7e30ioebmxsyG1YWFgQT5mkrq4udHZ2wsnJSUtID+nFwMCAnDw7O4vl5WUBpc3Pz+P5+VlKiAlh9qlgcnJSkshAvhEaGxtLqXBjZGQkoqKipM6YNcqamZnB7u6uRHV8fCwtMT4+LjXJQP4iZNiUOjU1JUQxMTEICwtDQECAeETZjJz+KS0TyXX09xshPWRCWHPM5t7eHra2tgT9/f1yS4KDgyWrvGYkCQwMhK+vL1pbWyUIEmrqkJJ5vVhfl5eXuLq6wvX1tYB1t7S0JOazHjs6OqQl6CFvEmvyW4SGhoYia3NzE4uLi99AMpYKM8zaVEpH+ecYVTg6Omoj/Hixoa+vDwMDA2m/gmN/ghYZGRlp9vD/48UXK3hTfunp6f2TRCHlWgsLC/BRZp/jlpaWsLa2hq2tLX4DIk/ILghWk7oAAAAASUVORK5CYII=', 
	@ORDER_INDEX=7,@ACTIVE=1,@PUBLISHED=1,@PATIENT_OR_ROOMBED=NULL,@IMAGE_NAME=N'samename.png',@ICON_NAME=N'Similar/Same Name',@SHORT_DESCRIPTION=N'Similar/Same Name',@LONG_DESCRIPTION=N'Similar/Same Name', 
	@COMMENT=NULL,@MOUSE_OVER_TEXT=N'Similar/Same Name',@FACILITY_UID=NULL,@FACILITY_ICON_NAME=NULL,@FACILITY_DESCRIPTION=NULL, 
	@FACILITY_COMMENT=NULL,@FACILITY_MOUSE_OVER_TEXT=NULL,@FACILITY_PATIENT_OR_ROOMBED=' ',@FACILITY_ACTIVE=0,@FACILITY_ORDER_INDEX=0, 
	@ENTERED_BY=N'softinfo\bmsuser',@ENTERED_DATE=@DATE_NOW,@LAST_EDIT_BY=N'softinfo\bmsuser',@LAST_EDIT_DATE=@DATE_NOW
	
	set @p1=0
	exec usp_Insert_Icon @ID=@p1 output,@ICON_FLAG_ID=NULL,@GROUP=N'APPLICATION_ICON',@SUBGROUP=N'SYSTEM_ICON', 
	@ICON_TYPE_CODE=N'BED_HOLD',@ICON_TYPE_CODE_SYSTEM=N'2.12.24.51',@ICON_TYPE_CODE_SYSTEM_NAME=N'ApplicationIcons',@ICON_TYPE_DISPLAY_NAME=N'Bed Hold', 
	@IMAGE_BYTES=N'iVBORw0KGgoAAAANSUhEUgAAABQAAAAUCAYAAACNiR0NAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAUFSURBVDhPbZRpTJRXFIb53Vgp4jCLwwgDDAzCsM2wCY4iIMiA7LIJyrApKIgILoDsasEFcC+KS1QU0Y7WvS5Now11ayum1lZbrS01mjZp0v5q8vTOTNMl9MdJvnt/PN8573nf6yAL8lqvDPWxSEI9LdLZPha5SWeRpwbaK1FnkUZrLBKD538rRJxD1H/X1GC1RSruVOFai4My3Oda+Wg/m388R9dzC+3fvk/rkxFavzpFh/jufnOF7lcX6Ho2QtfTETqeDNP25RAtD4/S/OAw6+8Msu6T/Sz/eCeGmlSsQMvK50fo4y75u9YSkRaHYV40AdF6whfMJalhCY3PTrON22z6/Qpdv16k/c05WsbP0PjdSdY8OcrqsUNUfbYPw8o0O7DqyX6auSH+kMFbUkf8CuNJ7K/DJ9vIJIUTmvQoat6MiBqi8vlByr8ewDy2m6J7veTf6iH7ehfZVzsJWZb8D7CFj5jZkMskyWRSjzTSzzjVL08j06mRB3tSOjZA7esTVH6zn/JHeym+v4Oi21vJu76JrIttZJxrIbB8/kTgZPkUYruXUf/yMgl91Ui8lRiqM6h5PUzVM9GdgJnv7aDQCrsmYOfbSD3dRPLJdejM8yYCXbSuyPzdcdYocHKVoM00svSHEep+O0+ZDdZvgy2630/e5/2kX+0g6VgDCYdW4VcUOxHo5OZCcKmJpF31+OXEINWq8BejpN7tplRobYXl3+klZl8VIeuzmD24goThNczdU4U2f85E4NsujpgONNDFIypeDKOK8ucdt6no+nMxf3/EplnOwx34FMbwjpMjAc2ZxJ1dy6ytZfgsnPU/Ggpg4kAdG7hH3ugulKFam45BA4spenaArA9aybi/jRkVCUjc5Oi6cjCeriOiswhNRtS/bXOTsOpMHBVT8DKFCwukotR7I/VUIkv1I2iohMKfj5N5dwvp4/vwXTEfyXQ5fp1ZRB5bgb4pF88FEXZg5eP3WP/HJeJ7K9GkRKKOC8Y9PpigihT8OzJRrAzDq2Q2Eb0l6DcWELK9CPcFYcg0rmjb0zEMVhBQl467KdQOrHi4h9W/nKLm1Umqxocof3GEkqeDlIk743AdskhP5H5i89NcbGNKlFJxVqPQeeDdmkrg3mJ8q0xMTwyxA0sf7KT2p+NUCUjF4wFKvthF0eh2Ch/vJaLHLCAKPLNmEnZwKcHbCwncX4xbZjhyLxVeG5KZ0bcITUk8rnFBdqD5015WvDj8VwLsPrOaNudBH2E9i5nqKkMrNEt4vAXjiVVE3W/BozIWmbsSdXMS3j0LcV80B2VMgACKp2vxrS0sFR4rFma1wnKtcRIJyBztQf9uoW1MTXksxvMNhLUWoB+qRG02Ivdwxa0pEfXGDFTZUSiM/jhME8CCG5spG9tj78wKu9BG2kgjKTc7CGrJxlnijEdBNJHDNcLMCwkYNOOWF4FcqUBVG4uqyYRigZAgeoYVqLHkXe5kiYhUngBnXWwn7UwjpqP1IgENROwuRVubhK4jG33vEnS1afi2ZaFuSERVPgvX+nimCQdIk/RIZ/raO8y51GFbwsKrXaSf3UDKibXMO1hLjIiT8cByoo5XY+g3o2vIsG3Tq2Ie7vVJqBpFZ1ZYsh7n+EBcInxwkAV4fBiy1IR+eQpB5YkEiBfDX4TcV+TSGiVN+kw8UsJxn29gekKIbZPTYnQoZvkJO/kiDffBJcwbSagGmV7DnxXbWHAudZHoAAAAAElFTkSuQmCC', 
	@IMAGE_BYTES_INACTIVE=N'iVBORw0KGgoAAAANSUhEUgAAABQAAAAUCAYAAACNiR0NAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAO5SURBVDhPZVTnK7VhHD5/gqysrLK3yN7ZI5ussrIyInsnIpSZ8MEmM8fehEhKoUj5X673XL+T99V7Ptx1nvs8z3Vfv2vcChsbm1ZHR0elnZ2d0tXVVenj46P09/eX5e3trXRxcZH/fi9bW1vl72VtbS3PfFfh5OR0ubq6ivv7e9zc3ODq6gpnZ2eyrq+v8fT0hMfHR9nnOj8/x8nJCQ4PD7G3t4ednR1sbm5ieXkZ2dnZUDg7OytPT0/x9fWF7u5uREVFITg4GCp2iIyMRElJiYB8fn7i5eUFz8/PeHh4wO3tLS4uLnB8fCzAW1tb/wC58fr6Khva2tqIi4tDc3MzIiIioKenh9DQUGFPxkdHR1AqlcJqZWUFc3NzmJ6extTUFNLT09UMCfj29oaCggIB7Ovrw/f3tzBT6QOVftje3hbA/f19+b22toaFhQXMzMxgYmICo6OjSElJ0QQko9raWtGrqakJ5ubmwpxg1O03GJmNj49jaGgIAwMDSExM1AS0tLSElZUVzMzMYGhoiPDwcDGIxvwGo5Fck5OTMhH1j4+P1wQ0MjIS6m1tbWIQD0hOTsb8/Dx2d3dlzKWlJbS2tiI/Px/t7e3o7+9HS0sLoqOjNQF1dHTktI+PD3HQzc0NPKSqqkoMoWbULzY2FlpaWqL74OCgyEQTNUwhYGdnJ97f37G4uAhVTkXH+vp6cXdsbEz2ydrExERixZHLy8sRFhb2D/AnNvr6+ggMDERGRgYcHBxESz8/PxmNrnNkpoIRMTY2RnFxsRAoLCyU/ApDnszQNjQ0/A21qoJIS0uTD5KSkkRwjlVWVobq6moEBQXBwsJCgJjZnJwcBAQEqAGZ8ru7u7/VolZkwaj09vbK2HTewMBAxqT7fFbdA2JMXV2dHO7r66sGXF9fx+XlJQ4ODsTJjY0NcZIHkQ1BqA+dpDmcJCQkRBjm5eWhsrISCQkJ8PLyUgOyQiz8/6HlPgHoMhnwuaenR5ymDKampsjNzUVpaalEzNPTEwpeXRSaOv6uExvAnlZUVAhDtoDxoKsdHR3SdxrGFlFH9t3d3V0NODs7K+P9dPOnTix8UVERdHV15eYhO2rW2NgoDaLLqampAkpDVPepGpAfskYEZtGHh4fFDDaA+cvMzBS3a2pqkJWVJYy4R+cZn5iYGDAVKvnUgOwjTSDwyMiIAHV1dUkcWEE2h5GhXtSS4xOQzAhGdz08PCQNCpX1FzyFL7DDfJkns5esErVh5hhusqCT/JiVJCMVISmAvb29rD/zfozBP9nSZwAAAABJRU5ErkJggg==', 
	@ORDER_INDEX=11,@ACTIVE=1,@PUBLISHED=1,@PATIENT_OR_ROOMBED=NULL,@IMAGE_NAME=N'BedHold.png',@ICON_NAME=N'BedHold',@SHORT_DESCRIPTION=N'Bed Hold',@LONG_DESCRIPTION=N'Bed Hold', 
	@COMMENT=NULL,@MOUSE_OVER_TEXT=N'Bed Hold',@FACILITY_UID=NULL,@FACILITY_ICON_NAME=NULL,@FACILITY_DESCRIPTION=NULL, 
	@FACILITY_COMMENT=NULL,@FACILITY_MOUSE_OVER_TEXT=NULL,@FACILITY_PATIENT_OR_ROOMBED=' ',@FACILITY_ACTIVE=0,@FACILITY_ORDER_INDEX=0, 
	@ENTERED_BY=N'softinfo\bmsuser',@ENTERED_DATE=@DATE_NOW,@LAST_EDIT_BY=N'softinfo\bmsuser',@LAST_EDIT_DATE=@DATE_NOW


	-- END INSERT APPLICATION ICONS

	-- BEGIN INSERT WHITEBOARD ICONS

	SET @P1 = 0
	exec usp_Insert_Icon @ID=@p1 output,@ICON_FLAG_ID=NULL,@GROUP=N'WHITEBOARD_ICON',@SUBGROUP=N'STANDARD_ICON', 
	@ICON_TYPE_CODE=NULL,@ICON_TYPE_CODE_SYSTEM=NULL,@ICON_TYPE_CODE_SYSTEM_NAME=NULL,@ICON_TYPE_DISPLAY_NAME=NULL, 
	@IMAGE_BYTES=N'iVBORw0KGgoAAAANSUhEUgAAABQAAAAUCAYAAACNiR0NAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAVgSURBVDhPLZNrUNRlFMb/UZqaZfnBdDTDtLKLzliOqTWTmjNexsrKzAbETCWlRE1NDJBlLyACKxcJRTMHGE1RnH9padxckWV32WBhWS67Igq66y67LgK6Ysqv160PZ8685znnOee8z/tKNm97bN+DXvmu84YccN+Qfb5O2dXdIbxLDjh75V63X/Z73cFzt8cr97i7Be6Re3xt8kN3k9zvaZf9frfs7nbK58vPyVKH11l2v/8BV60dXG5yY2n1Ud96C2urB4vDicXeRZ39ljB/0Nc6fPx9xU+z4yZXWq7T3OLB2tZF2/VOCgp/Qepx98g2cwcxscdYF1/CygQD63ea2PDjJVaqz/ONsoxNyotsVl4iSl3JGrWOyIQLRO26ILyeVYpqkXOW3/6sITNdi9Tr6ZONJjdhMeeZF9fCHEUXS2NcrN7hYfWPTr6MKmPpimwWf5bC4vCf+Ty6gjVxTYTttLN4x3XmiZwPf9Bz+qyd3MwDSB6/X75o8bBCdJqf4mNuyh3C07qJ2Gxm6rRYBg+dgSQ9jfTYEOFHMWjIDKbOjCVih5mwlG4WqW6zTNFC8bmb5GQeRvL2uOSq2k42qAx8kewmPNvPwvWnGDZiGlLIM4ybvIAZS+KY9elu3lm0kzEvLRDEIxn5/FyWbytlVVYXYck2ikp8ZGXmizsU6lWbrxKtMfF9lpevd5Xz5PC3RdFgQgaHEBF9lLjDsGE/RB94wDatg4/D4sXEL/D0qNmsVVewSdtMccUttFlClIDLJ1fWXmNDRi3xP7t5Y/oyQTaahUu28dRToYx87j2+S2okqgBW58HW3HsoCu+xIHyfyBvC9LkR7Mm9xu8XvKRm/yREEYS6mhbiD5rZmqwXnccyefpy8k7fI3zjMVE0gtGhc4jb7yI2H7YfDrD9yH2U+S7GvvYuTzw7AYXWxF/6PtKy9ouVPX5ZZ2ogo9BAZLS4VGkYn0Sms/cPyDgLH6/aJWISM2evYl/RbTTFsONXyBb4wpVbBPY4WxKK0NX0kZ4hCHvFy9f/bSXvpIG1URnBhHVxv5BZCqmi6Mi5AIs+jAqSzl8azUERTxbxRz48ereIP8b6mIMY6v8nDDgFoamRQ781sDXhaLDwq+9TKDLCgbJ+csshv/w2b723JIit2JhLvhmKBf7ZSiGOGCBRexpTYw9pGTlID5w9cpXeRt6ZVg7KrYQMHc6b73xAifEfTlTeI8cwwCELFJR5mTj5fUEQwvZ9Jyipg3Gh8xj2TChF5+1UN3jZo81E6ne5ZaO+gSNnGrjYDnM/3RicZGd8LoZrcMomyOoHOGMX65c6GPXiFJ4dNZGPlkcG1/1ozVb07QEu2ZzsTs9C6vNelfXGagpLaqi8OcDx6iuMnjA5+A6/jcuhorkbkwvquqCtRwh1SCgfMjzYdPyUmZy0dFLRGaCquYO0vWJCv79dvlBzkaOVNZS7+tH7ByjQGRn7yuvBojGTprBs3RYityeyPCKS8RNeDsZff3sWJ4x2yv1Q6vwHo70drTZVfD2/Vy6rNlGst2IW4KWbDxGCoXN0sHbzJsZMmBS8t0ckkjSIia9OJSZeRV3bDerFxKVeqPKJDRxXSE9NRvJ5A7KxxoHOfJmOO2Dv/s/EFohcmtw+dJYm8RMM6Gqbuey6Te9D8PTep+3WXayCtEUMYGu/SnqaeEY+oXKb2L9ab8Fsacbc0ISpoRGj1YaxqRWzMKvjMo3CmoTV2lqpqr9GjaWVurpaDA1W9FY7lUYzqXv2IJ06frL0cN4hktQa1CoVanWiMAUqtZJEdRJKtRqVSolGo0IjYuokDbs0aShVSSSrEgSmQCHqElUalEoV/wLvHVaqzALacwAAAABJRU5ErkJggg==', 
	@IMAGE_BYTES_INACTIVE=N'iVBORw0KGgoAAAANSUhEUgAAABQAAAAUCAYAAACNiR0NAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAOsSURBVDhPfVRJKLZtFH4MZWPIhrIgLAw7RSmUrSzYUCKlZEOEzPM8z0SmDDsUr2SWIfM8ljGzjBl2bK7/vc7b837+xfctTvfz3Pc51znXmZS7u7uM7+9vzfPzs+bt7U3z+vqqF/6r8rf73zpTU1Ma5fHxcebn5wcnJyc4PT3F8fGxfP9Lzs7OoAptzs/PcXNzg97eXij0sLe3h5ycHGRlZf1PsrOzkZubi4KCAhQWFsqZl5cnuqqoOuPj46iurtYBbm1tITk5GUlJSUhLS0NqaqoAUzk2NhZhYWEIDg5GeHg44uLi5D4jI0P0KQkJCRgbG0NjY6MOcGdnB5mZmXqvZWVloujp6QkzMzMYGBiIGBoawtTUFN7e3uK4pKREwGk7OTmpA3x/f9dsb28LHUpVVRWioqJgaWkJIyMjODs7w9/fH4GBgfDz84Ojo6MA29jYIDExEZWVlcjPz8f09DQaGhr+UC4uLkZ9fb1QtbCwkIiMjY2FYmdnJ5qamtDc3IyamhqEhobKm7W1teSUQczOzoq9wnZgDisqKtDe3g4PDw+JLCAgQOhaWVkJNb6REkF7enokr3Tq6+uLtrY2zM/Po66uDgr7b21tTRRLS0vFs7u7OzQajRSE9Ozt7dHS0oLu7m4x7ujoQFdXF5ycnGBubo7a2lqsrKzoAFmU1dVV8RofHy9eIyMjMTw8LMLKKooCHx8fDAwMoL+/X/ptZGQEISEh8sbWIksCC+Dm5ib6+voQExMjCqzg6OioRMn+In3eszATExMYGhqSMzo6Wu5TUlKwv7+vA2QO19fXMTg4KJ6owEIsLy+LEUU7UvDy8pI3giwtLQlFNXo29OHhoRRMIuQjvRLUxMRECkMnTDSrR3D2mYuLi4Cyqmw1thA7giwYIe/1OSQ9ziVp0YijdXFxIYbM8cHBgUyDra2tVD4oKEj0GCXtCMie1AMyZ5eXlxKVnZ2dFCc9PV2Arq+vcX9/Dy0btLa2SuUJ5urqKtQJSD39LPOSeWJE2nUmeSMdGjk4OCAiIkLmlb3HFuK9m5sbFhYWZMtw2xwdHf0BXFxcxNzcHB4eHnB1dYWXlxdJMqvOaAlAYdTsPc4uo9L2sOjf3t7K2uNw6NuGRfj4+BAwytfXF7SLVyJmW83MzGBjY0Ooc39+fn4KIIWpYJSSw6enJw29kfbu7i64G3lSmGjmRl22aq64nX4LdVm48vJyKNqGnuY4FRUV6RepukzVDcST77xXz99Ll9uG/zz/A2BiOiu6yT2JAAAAAElFTkSuQmCC', 
	@ORDER_INDEX=19,@ACTIVE=1,@PUBLISHED=1,@PATIENT_OR_ROOMBED='P',@IMAGE_NAME=N'PTOptOut.jpg',@ICON_NAME=N'Patient Opt-Out',@SHORT_DESCRIPTION=N'Patient Opt-Out',@LONG_DESCRIPTION=N'Patient Opt-Out', 
	@COMMENT=NULL,@MOUSE_OVER_TEXT=N'Patient Opt-Out',@FACILITY_UID=NULL,@FACILITY_ICON_NAME=NULL,@FACILITY_DESCRIPTION=NULL, 
	@FACILITY_COMMENT=NULL,@FACILITY_MOUSE_OVER_TEXT=NULL,@FACILITY_PATIENT_OR_ROOMBED=' ',@FACILITY_ACTIVE=0,@FACILITY_ORDER_INDEX=0, 
	@ENTERED_BY=N'softinfo\bmsuser',@ENTERED_DATE=@DATE_NOW,@LAST_EDIT_BY=N'softinfo\bmsuser',@LAST_EDIT_DATE=@DATE_NOW

	SET @P1 = 0
	exec usp_Insert_Icon @ID=@p1 output,@ICON_FLAG_ID=NULL,@GROUP=N'WHITEBOARD_ICON',@SUBGROUP=N'SITE_CONFIGURABLE_ICON', 
	@ICON_TYPE_CODE=NULL,@ICON_TYPE_CODE_SYSTEM=NULL,@ICON_TYPE_CODE_SYSTEM_NAME=NULL,@ICON_TYPE_DISPLAY_NAME=NULL, 
	@IMAGE_BYTES=N'iVBORw0KGgoAAAANSUhEUgAAABQAAAAUCAYAAACNiR0NAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAMcSURBVDhPpZNdbJNlFIDPuq+b7JeYaEQFDC7RiwHe+UNgWws6aldYB1JZuq8/W7cxt6yWVNOxOAyM+bM5hokQ4jJDTCQhhi8MyYiowcRwsRiDKLogP84LNJGLARpj7eNpZWEuEFa9ePLme7/zPjnvOecVc5Wtayj2qDUQXW71dy67BeW32Z8ZW24NxpZbfc2LLOltMk7wyyKYXAKXHlIWK/p9Oy7O/peO13OXH+bq+L1IX7PN4gfhzzMCE8qPc+DSv2NS3wvJb4XJEzk3hOcM/pqwc25sGUcGmzi6O8jRoVswvX9jHdXVGohwdvQx/vhGzx+zT2dowAXh3USYKr1Riwsi1XcmHefQG78dbeL6aeHM4bwZwvMq3OZn1f3gXQq1S1N3JB1X+SC81Wny8ylh/OAs4XC3n5X3QfWSlJKcAykqFsCb7SbnPxFOjuTPyFAbMy10laVwlSXnQIrKB6C3xeT0qDC2967/L6xSYU84wBcHhQ8HZgq1hv8lQ4fWMOEPMjYsHNg57+bYpHQG9ye0KVqTbK7sWAhbfUEO7RH2dRcguyI2K3XWzu9fC++8lL3QqcKOuhAjfcLA1kJkR9hm/faVnSvjwlDMn+laNhk603NbE2KoW9jRpsLtAcP69VQeP30u9Hc0UKFzmI1wtQpD1WF2xYSucDHS7TesyU/zmTgu9LU2UJmlcI2+FL8zzLZWIVavwsRmw/ruo3y+PCxsbwxk5spVNnfSQl9FIy8GhLYNJUj8OcMaPzSPk++Ltj/EE/ckqVp4TZnSdz2FYxbOxVPc5JomkMT7VIQtzwuN61QYrTOsz94r4MheO4PxR2jzemmtdRPxuAm73QTWuvE/XUP96hp8jho2VnioW+lh/QoPnic9uB/fyKY15YRqCzFdpUj7esM6tq+QD/qLOPB6HsO9Oj49wu4u4Y24sDMq9LyQQ6Ilh3g4h6hpo70+lxZfLo0bcgl6bZjrVOa5G/PZ+UjAaf945NVC9rxckJmj1zqLtP1FvNJclOla3CzOFLvDV8IWrVFzbYlerZSgu1QFpTRoVv61/6zmM8X8DbirpjDNOl7eAAAAAElFTkSuQmCC', 
	@IMAGE_BYTES_INACTIVE=N'iVBORw0KGgoAAAANSUhEUgAAABQAAAAUCAYAAACNiR0NAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAJXSURBVDhPrZRNS6pRFIXfv+Wg/MKvCg3Mb5QytURBA1P0gmgNpEYRWiSCIBI5EHspbOIVB4oViSkq6J9Z9+wz8RaC5r2DNXndPmedvdc+gkwm+xWJRMSTkxMxHA6vLWL4/X5RODw8/D2bzTCZTDAej5dqNBotrJlOp2i32xB8Pp/Y7/fx+vqKXq+H4XC4VIPB4EvNx8cH3t/f8fz8PAcSjD7c3Nzg9vZ2JVFtNpvF4+Mj3t7eUKvV5sDPz0+cnZ1BLpfj6OgIXq93qahOoVAgkUig0+ng4eFhDqRrE3BzcxMGg2FlsaEiFouh0WigVCp9BZ6fn2NjYwNqtRoqlWqpqI4MnJ6e4unpCXd3d4uBGo0Gq0oqlYLFDZVKBdfX1/8HGAgEUCwWcXFx8e9A6iGLHnK5HFKp1NfYpNNp3sNVr0t1lIqDgwNcXl4iHo9D8Hg8IgWz2+0imUyuBXQ6ndwd9VJgdJEy1Gq1eJ5oaj9xSDm0WCyIRqM4Pj6GsL+/LzabTby8vPCP6wCNRiOCwSC/usDsivV6na8Ne3FAMfiJQ6VSCb1eD/bIwG63Q7DZbGK1WsX9/T0/ZR3g9vY2HA4HyKlgNpvFcrmMQqHAxy+RSDiURJH4Lprq36I62pi9vT3uVGBUMZ/P4+rqiq8Qcwyr1QqTycRP3N3d5YU7OzvY2tri7aC1pKvSQAiu1Wp5Df0usD+ItDKZTAa0yxQdyhN7gREKhUBbQM7dbjdcLhfvE031+2F0IF1dYKc1CEIAyhH1kcbP8smnRhkjCGvNQsfkSqfTcXfk9A/WxYPiAhi8ugAAAABJRU5ErkJggg==', 
	@ORDER_INDEX=1,@ACTIVE=1,@PUBLISHED=1,@PATIENT_OR_ROOMBED='R',@IMAGE_NAME=N'Blue Box.png',@ICON_NAME=N'Blue Box',@SHORT_DESCRIPTION=N'Blue Box',@LONG_DESCRIPTION=N'Blue Box', 
	@COMMENT=NULL,@MOUSE_OVER_TEXT=N'Blue Box',@FACILITY_UID=NULL,@FACILITY_ICON_NAME=NULL,@FACILITY_DESCRIPTION=NULL, 
	@FACILITY_COMMENT=NULL,@FACILITY_MOUSE_OVER_TEXT=NULL,@FACILITY_PATIENT_OR_ROOMBED=' ',@FACILITY_ACTIVE=0,@FACILITY_ORDER_INDEX=0, 
	@ENTERED_BY=N'softinfo\bmsuser',@ENTERED_DATE=@DATE_NOW,@LAST_EDIT_BY=N'softinfo\bmsuser',@LAST_EDIT_DATE=@DATE_NOW

	SET @P1 = 0
	exec usp_Insert_Icon @ID=@p1 output,@ICON_FLAG_ID=NULL,@GROUP=N'WHITEBOARD_ICON',@SUBGROUP=N'EMERGENCY_ICON', 
	@ICON_TYPE_CODE=NULL,@ICON_TYPE_CODE_SYSTEM=NULL,@ICON_TYPE_CODE_SYSTEM_NAME=NULL,@ICON_TYPE_DISPLAY_NAME=NULL, 
	@IMAGE_BYTES=N'iVBORw0KGgoAAAANSUhEUgAAABQAAAAUCAYAAACNiR0NAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAARzSURBVDhPVZN9TFVlHMcP917uPff9vRsCF0liSCAM5KYy2c2BF0QxI4NF1iIV+0NwFZMQc3hBe2GGKIo016pl2drc/aOxqOxFCNHGH62t90G17vWlbG6JQJzz7XsOXIVz993znOflc77P7/tcYVuaZt9rybrIYb/hrlIMkaPppsjJNDFymH11Lt4uXLeg/zLn21M0EaHDIXyG1CVAZQVQHqLWAxXl+LywABdWPzg/zjFlXFFoXvF3pd1QDjwUxE2HCKHDkxBBYiJgsQJmC1vKZsWI0YACixmXnGbAwzm3DXCxdVCcV9fdEd+NZlwVtRDCXgI1CYAgAAmUnrLw3SbgFVHA/TYLfvBoAZ+GUMpBWSmRa3Rcq+ybV0zUQGhXHIo6LjYQwo1e9r0C3mH/7Kk+DFwcxTqXGbE0bszimvv0QGoiZB/XOSkj9+j4gQQNVGA3HY7S6mCGD8h2YTpJQFe6A++fO4f48+57Z1BtFnA7wNIUiZBzDZAz9ZD9fFcMWOagKrAnSRO5aE1AFuv0QTAbvcF8fDI8fAcW77S0taLGTpcVRiBohBwQgRyC0wn1KRloETMRGE7WRJCux9l7Bfi0Gnw5+NFdmCwDlBy7BmlqBpU1tWhNJbSGQYVMkIsJziNUKQOdxhxKKGkEZnNgjREdSwTUBQOYvf3vIofTgRJgYBBTHK0NFeN4HqFPWSBvMENeS+gK1napHjHWVQhn6CJYSftl/OJWMx5nIC821KlAefgSZlr2Y9bhxmx5JeT+t3Hjxl+oKsnHh8WEPm2FXEG3NINsA6J+BZhJYAkHNnOi3op/dlmwjtC3zpymq/P4r6AIkk4PyXsPpnY2qh/65defUJTlx1CI6T5BaKkJKBQRy9ATuJxA1gO1PMIuXt6XnPi+0YyiZC2GRr9SATMp6UB//5xrpa58LoyMoDTTjZ8387hbeMnpMrZcAT5A4Ca6e9IKaY8d0gEn0OvBwHYd1uSkIHolCoxeZjAxSAqQv/hzsPs4Cp0CrlfRUKkRUdZSCOcQ+Ai/sN0GudkBqcMJ+XUXcNqLYxsFbCorVsNQ3S2IanTsW+zftg6hXBceS9VikhlcK+B/WQU+SmCDDdJeAg+5IHW7IR9z85huNAYE7GnavSj1L76+jPDDybjVrMUfu/0oyfXju1UG3AzEHVYTuHMxUOohsNeN6R4HqjIFnDjZp0I/Pj+EQ9U+TIZ5mdtZniYH/q7z4BaDuVIYB25hDZ9hWi/QYdgJ6QhdEigdJbTPg2jYjPI8F9o6u3CifimmuxhEF+dbuf5ZBlnL/etNiOYrQCWUjXOhyE0MhSlLrxJImMRjq07f8GKs2YgkRyJ+7GTivVxzkLVutkPewdorJwyaEMtlyp1ZBJKOGg4q16bFAXQwFLqEUkceW9WbXkQa7Ni60oZJBgflNtCAYkQ1tNqI61kEPr9M82l0lYjfyowYrzZjnH+pcR5j/Dlqrx3j+6g2OyaoqwfsOFVlxDf1Fvy+w4oJ3t2JShMm1or4c4UeY8sS8T+sYqi0VZmJJQAAAABJRU5ErkJggg==', 
	@IMAGE_BYTES_INACTIVE=N'iVBORw0KGgoAAAANSUhEUgAAABQAAAAUCAYAAACNiR0NAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAOKSURBVDhPZVQ3SHRdFNzW0kLESsHCQhRRMIsBUVHMOeesmHPOOWDOOYvFdgraKGplLYK9nbUIOt/O/Oyi/hcO7+3e8+bOmTnnGlxcXDp8fHyMfn5+luDvwMBAhXnvb87PfL5z39PT02hwc3O7ycvLQ19fH3p6eiyRnZ2NgoKC//3f3d0Nxs/c3t5etLe3IzExEQYPDw9jXFwckpOTkZSUpGdKSgpCQkJga2uLiIgIZGRkID09XZGamqp95v0MgkVFRf0HGBMTg+joaAXBzcCurq6wsbHR/wRNS0sTGPfj4+MRGxtr+Y45kZGRMLi7uxsTEhKUzBPNTEyaYGtrC3d3d3BwcNB+cXEx8vPzkZOTowPIlt+agQXo7e1tDA4OFrPS0lIBmszAxcUFzOvo6Aj29vaorKxEdXU1ysrKUFhYKGDmkzFBBUiHQkNDYWdnBxpBJre3txYw80tHRwccHR3R1taGhoYGAZMADc3MzBSoNKTVLIMsrayscH19bQH7/v4G4/39HZ+fn/rIlC/nW1paUFtbi/LycslApmRpYP+UlJRo08vLC+Hh4fj4+PjFsK6uDk9PT/j6+hILOj88PCy23KMEZKq28ff3N1ZVVaG5uRnsJycnJ2nF9fz8jJ2dHYnP3ru6uhJbVkO3R0ZG0NraKjIkxTxDQECAsb6+Hp2dnRgdHdXJdPXg4ECsampqVAp1mp+f10Gvr69wdnaW64ODg2hqahIJ5hg4XtSjv78fExMTWF1dxcDAgEAfHx8FkJubi8vLS71TU66HhweYxlYlkz1Z0nVDUFCQkQ4ODQ1hdnZWgMfHxyBrNvbb2xteXl5UqhnMLPDk5KS6g3IxaI7BNGJGnjA2NqaSNjY2sL+/j/PzczkXFhYmM/4uylFUVATTYKj8xsZGSSBADjrLXVhYwObmpgAPDw9xenoqA6jjz3V/f6/DZmZmpLvpghE7tpAFcHx8/BcgTeGEEJylLy8vC/Pm5gZZWVlYWVnB2tqaZCIhNjsZC7Crq0snzc3NYX19HXt7e3KZcXJyIilMl4jMqqio0Izv7u5iaWlJldFQGsvr7pcpLIEnb29vC4xl83l2dqb2sLa2FjiZkx3fqT09IEOZYm4bjhNPW1xclDFkSUB+zOBlQeF9fX0Fxm5guewOdgl1ZnsZTON2zSHnsLNB2eAsgRLwgKmpKUxPTysoCS8QTgcJ8Pl39P4Bkqi9/KUDoHQAAAAASUVORK5CYII=', 
	@ORDER_INDEX=1,@ACTIVE=1,@PUBLISHED=1,@PATIENT_OR_ROOMBED='P',@IMAGE_NAME=N'Stretcher (Patient) (EM).png',@ICON_NAME=N'Stretcher (Patient) (EM)',@SHORT_DESCRIPTION=N'Stretcher (Patient) (EM)',@LONG_DESCRIPTION=N'Stretcher (Patient) (EM)', 
	@COMMENT=NULL,@MOUSE_OVER_TEXT=N'Stretcher (Patient) (EM)',@FACILITY_UID=NULL,@FACILITY_ICON_NAME=NULL,@FACILITY_DESCRIPTION=NULL, 
	@FACILITY_COMMENT=NULL,@FACILITY_MOUSE_OVER_TEXT=NULL,@FACILITY_PATIENT_OR_ROOMBED=' ',@FACILITY_ACTIVE=0,@FACILITY_ORDER_INDEX=0, 
	@ENTERED_BY=N'softinfo\bmsuser',@ENTERED_DATE=@DATE_NOW,@LAST_EDIT_BY=N'softinfo\bmsuser',@LAST_EDIT_DATE=@DATE_NOW

	SET @P1 = 0
	exec usp_Insert_Icon @ID=@p1 output,@ICON_FLAG_ID=NULL,@GROUP=N'WHITEBOARD_ICON',@SUBGROUP=N'STANDARD_ICON', 
	@ICON_TYPE_CODE=NULL,@ICON_TYPE_CODE_SYSTEM=NULL,@ICON_TYPE_CODE_SYSTEM_NAME=NULL,@ICON_TYPE_DISPLAY_NAME=NULL, 
	@IMAGE_BYTES=N'iVBORw0KGgoAAAANSUhEUgAAABQAAAAUCAYAAACNiR0NAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAASASURBVDhPdZNrTJtVGMcPc3SDcStDFNQPJvOLMZp9N/GjM37VGC9EkMQtc3OOOcemsJW2y5ijFnBDHCgz3MftcF27Aluh9xYKpbSwQsc6Wtq9tWSQTXDy92k1cybdh1/Oyfu853ee5zznMO9d/7ebGw/4g4CX/xVY4BvB2zwiBLkgCPx+KBiXQGSZrwluvuV30P9eHokEeWh1mWtGBjlbWQkNb248wi2Xl1iGyxXCtPt3TM+F4XSvxMXuCWJubgne2dtwu4KY8QhY9PnQ2Pgr2FowzO2TXhw53YaC0zfwsWQC+SVmFJaM47NS7VMYQ2HpOPIlFuSdMeFA2RD6Bi2orFCAPQyFudniwwcnNXi72IO8r6ew/xsjvjg2jv3HjHE5WKTFgeM6FByZwL7jPrxbbEF3/y3UVNWAPYgKJ/x4X2bDh0ed8O55GVv5z2Pr8AvAwZfi8+WLeJSXC392Og7nqbGv/B66VAFcrLpMJQthbrQtofC8CQUnrFCxZ7Gcm4x7e9PgeG0XponJJ7DT3LM3BUvPpWKEPYND+RzvVa6gbTiIqqp6sEg4zPW2RRyq0OFQiQkt23PQw9LxC8tAFtsGxthjEmge5Q2WiC6WiW62A0c/78anNQF0j66gqroObFUIcYN1EUcrrTgud6A9MRedLA1DbDeUNIpYAi7uTIEtRQyrSIx3SJJDmXEScibCicPXcLBhFUOjPlQrL5GQ7prOOIdTtZMoVcziamIO7Z6GYRK2MzF2kXD2lQwM70nF+cQUVFLsI5aE3liGIpQWqVF89Q8Mae+iKiakDHVGFyQNdpy75Hos1JCwicpOImG2KAHbtjO8SqXqWRZGKdZJm3WR8OxJFWSDf0Kl86FSefEfodHixrnmCVRfcf9P2EjCZBJ+wpLxJpX6FglukmyQsosKO2mDyjNqVIw8gsbsh1L5Y7RkaorRCWWXHfXtJBTlxM5whBZ20KKosIbEA7GMxVCTrP8JYe1ZNS6bgGFbAIqo8L4Q4eOGKfw04EBL7wI6SNhDwjZa/DplEO1yFjVhD9tOTUqPlTtAwqsU76D4lQtqtDq3MGoPoOKHanopwRC36O34Te1Gz/XlmFBNQkOiGN+lJuGUOAlF4p34ijBkZWAlYzdcoky6r2KSitB0aQC9dzZgdixAcYGe3ppwmxtMejSPOTCg86I1MRtalgoHCZdTM+FP/4/5dDGcaWI4doipORlopXvaXDcIVRgwuxahiL5lIeLlo+abaLVOY9g0T3drF/qoxGgHO55CFzWoj2K9dBx9df0YfQgYbt1BhUIJFlwVuMZoQrfRgQn/Q4w1X4e28Rq0TSrcbNTE5UbLNegaVdA3DEE7G4Lp/ibMHh/KoyWHw+vcaHXhhm0ePtrJswUs4l+i8zjMU9xL35cI9zowv74Jp/cOLnxfQW85IHCPewE6gw2WKRfM01FmYlim4qObmYXV7sLkpBsG+l8/44RJb4LiXDlYZ1urpv7nWshlZZBKpZDKaZRLYshk8ZHIpRST4axUBolMitPSMsjLJJBLJPgb8KkeqMPhH8sAAAAASUVORK5CYII=', 
	@IMAGE_BYTES_INACTIVE=N'iVBORw0KGgoAAAANSUhEUgAAABQAAAAUCAYAAACNiR0NAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAM1SURBVDhPlVTJK7VxFH6jJMKCsuFPMGUeS4YimaKQhY0dC2W+GTJknkUiZUhJ4U2xcL+ETJklN0PJyhAbsWDzuM+5ve9V3/0+WTyde/ud85zznOf3/pS7uzvDx8eH+vT0pD4/P6svLy8C/v4XtFxGLZ/RaDSqysPDw5/Pz09cXl7i6upK4k9gngbmXl9fwzwYpqamoHCK09NT1NXVoaamBrW1tRJ/AvNYw1hfX4+VlRV0d3dD4aiHh4coLy9HaWkpKioqYDAYUF1djaqqKpuorKyU87KyMqkhSDg4OGghPD4+lk5MyM/PR0tLC3p6eqSjLfT29qK5uRlZWVkoKiqSCVdXV62ER0dHksCuERERyM7ORmFhIfLy8gS5ubk6+L+goACZmZkIDw9HcXExWltbYTYEAwMDVsltbW3SKTQ0FCEhIQgICICDgwMURfkLbm5ukhMcHIySkhJRs7a2Zp3w4OBApJGUXZnI6OPjAzs7OwQGBiIxMRFxcXHw9PSEo6Oj3pj7HBkZwfr6Ovr7+y0u7+3tYWhoCH19fULE7pGRkUJsb2+PnJwcpKWlwdfXV5p4eXkJIc+5++npaWxsbEi9mELCsbEx6aQRcpecjIROTk4SXVxcEBMTI800yU1NTVhYWMDW1paVkJInJibkYtoi9Pb2hru7Ozw8PBAVFaXnBAUFoaOjA8vLy+BQdF+XPDs7i7m5OXGZUr5L9vPzQ1hYmEzMc/7mhCSkTO5vf3/fQkjJOzs7WFxcxNLSkhRoclxdXcVhuu3s7Cz7YyMSsikJh4eHQYX8OOi2vkOOzbtEQsqOjY0VE/z9/YWISEpKQkZGhjjOHBKOj4/j4uIC/Hy7uroshLu7u0K2ubkp3bmn+Ph4pKamIj09XUdKSgqSk5ORkJCA6OhoWcHk5CRub29xfn5uIeS12d7eFtspnXI1yZzAFihXy5mZmcH9/b1MqT8OtJyEfIJUVZVrwJ0y2gLPiPn5eZydnQmhyWQSx0Uyl0qXXl9f8fb2hvf39//ie465HsTNzQ06OzuhPD4+qnwsKffk5OTX4EvFOta3t7dDMd8/4+joKHjjGxsbJf4GrGloaJBaxi/wFQaGbryVMgAAAABJRU5ErkJggg==', 
	@ORDER_INDEX=18,@ACTIVE=1,@PUBLISHED=1,@PATIENT_OR_ROOMBED='P',@IMAGE_NAME=N'Flu_Risk2.png',@ICON_NAME=N'Flu Risk',@SHORT_DESCRIPTION=N'Flu Risk',@LONG_DESCRIPTION=N'Flu Risk', 
	@COMMENT=NULL,@MOUSE_OVER_TEXT=N'Flu Risk',@FACILITY_UID=NULL,@FACILITY_ICON_NAME=NULL,@FACILITY_DESCRIPTION=NULL, 
	@FACILITY_COMMENT=NULL,@FACILITY_MOUSE_OVER_TEXT=NULL,@FACILITY_PATIENT_OR_ROOMBED=' ',@FACILITY_ACTIVE=0,@FACILITY_ORDER_INDEX=0, 
	@ENTERED_BY=N'softinfo\bmsuser',@ENTERED_DATE=@DATE_NOW,@LAST_EDIT_BY=N'softinfo\bmsuser',@LAST_EDIT_DATE=@DATE_NOW

	SET @P1 = 0
	exec usp_Insert_Icon @ID=@p1 output,@ICON_FLAG_ID=NULL,@GROUP=N'WHITEBOARD_ICON',@SUBGROUP=N'SITE_CONFIGURABLE_ICON', 
	@ICON_TYPE_CODE=NULL,@ICON_TYPE_CODE_SYSTEM=NULL,@ICON_TYPE_CODE_SYSTEM_NAME=NULL,@ICON_TYPE_DISPLAY_NAME=NULL, 
	@IMAGE_BYTES=N'iVBORw0KGgoAAAANSUhEUgAAABQAAAAUCAYAAACNiR0NAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAARvSURBVDhPfZN7TJVlGMA/vnM49wvMaQvNCnW5mktXOkMT09CDIhgKcjl6QK4KyOWIgEcIL2hozKYDl1ZI1kxxrQ9cXlJxqXlZOgVUsFmO1Gm4spSN4Bx+vQfISK0/fnsv3/P+vud5vveTFk6WXRtT1UpZsk5Zl/Q0tP+xPzBWq2xI1iqldlmRVjuko9waBndmw+1QuGUT4wCetn587/YsaJ/OvZMGpLWJssI1LZ5WK91XLf+DWTwzCkx0X+mPa+kbu65Y8Vwzc/2QL9Jqr7BFJYJk/mwaQLN37tOPShzygx8H09UySOypBRKdjTIdF2X+OC/z8KKKy8ojoVoIvUGqPpr7x961TNdlDR1Nw/nhmzlwXWTa4kfHJYMQqfj1nC+/nPbl3llfLtRq/s6wX9ispatZLwQDMeAWL7v/vYqlIcfZ5lzF/QsSD4Tw3hkrt0+oaWvwpe24hlO7Hgk1uFsHQ5so62ct3JCeoKNRInXaMSYOAlfsFq4d1HH3jI6fGvxpOaAVaDiyQ+vN0EehVUPnZQMHt87n05IMalalUFPcx04xr3al8FFhOvETrrLsHQh5ERIm19NQ/SythyUu1Q/h/JcG6rb0CsVHafURPfAhZvxpgoZA9ITHGA+OqZA734uHzDk92EZB+CuN1Kwdz+laiVN7BrNnk0lcmySvUObmtz7EB+3HNhLyxMHl0T04o/4hJ7KHxW95CHvJTdQ4N1nhPcwd4832LmVpcdRtM1BT1i/suSpz45iMfZLC1KEw4/kegecJZr7gJnSEG1ugm4iXPcx7tZvgAAh+7iYVzrFUrZJFyQmy0tmoovWQTNwbdULowTaiW9D1L0LF3qyRXtwCERPYyZSAB0wN/I6sqLfZ4tJSniP+lBKHrPwurkTzfjXzXqvn9UHtBAW0Mekxgoe1MyPwYa/UNqKTN4f+RsjofeTGj6J8ucT7K4yUpomSXXa1cuekL031GqqKgilJmoMr0UbhIhv5dht5cTZyY8QYG0b4mBNMH97F5IB2Zo/7gPzF/qzPlVifbWZdtoUChxAWLFAr1w9raazTcm6fRMMuiQMfS6LJEvu2SuyukKgpl6h8V2Lu2K+Y+Mx95gXlUZCsZk2WIMNCcbqFlakWsmPMSM5otdIkZGf36jjxmY6j1XoObDegVBqo3Wzg841Gqst0VKwwEzGulvhpSRSlSpQs0fWKipItOB0WchdaSY8UwmWRauXMbj3Hdur5erteiPQDREY+LDWy1WVkQ44f+YtG40qTWZlipFCIlidYybZbyYixsiTaj8QwC1JmhFo58omeuioDex9l5BWZhMgkMjPxXq6ZNZkmipdonhClRVlJihSyuf7YbUKYFqZW6qqMfFFhpGaDkR1rTFQWm9hcaKLcKZq9zELJUtGjFAv5iRZyRGmZsX6ki4ySe0V+OML9cUR4hVak2CnqI5VFBjbl6SnLMlCabsQlSipIMOK0m8iONZERbSJN9CcpwkxCmJmFsyzEzbQQO8NCTEgf3vmCaWb+Aqi7pOmy0jd+AAAAAElFTkSuQmCC', 
	@IMAGE_BYTES_INACTIVE=N'iVBORw0KGgoAAAANSUhEUgAAABQAAAAUCAYAAACNiR0NAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAMfSURBVDhPpVTXSmtRFDw/JVgw9t47it0odg1iEIKoxNgQEyxY8EENPqhYDtiQRFE0drGBL6KfMnfPCieaKPfhXmE48WSv2bNmzYoWGxtra2ho0Ovq6v4bFRUVulZZWel9e3vDx8cH3t/f/xmfn5/weDzQqqur9YeHBxB3d3d/xe3tLQx8P8t3rN/Z2fET8submxtcXl4GcHV1FfSZRc/Pz7i/v8f3787Pz3F2dgY+19bWggl5MBS85Pr6WnB4eIjHx0fpwufzCdHJyYm0enx8DLfbHUxoFFJtKE5PT6H8Rl9fnxBdXFwICS/Z29vD/v4+FhcX/YRsgx68vr7i5eUFT09PP0CCsrIyhIeHo6mpCdvb2/B6vUK2tbWFzc1NzMzMfBFS3ezsLIaHh+FwOAIYHByE3W7HwMAACgoK0NbWhsTERBQWFmJhYUGINzY2sLq6ivHx8S9C3pabm4vIyEgUFxcHoaioSNrt7OxER0cHmpubkZKSgtTUVLlseXlZMDQ0BK2mpkZaPjg4QF5enhxkocViCUJ7ezuUPUhPT0d+fj5aWlqQk5OD+Ph4ucTlcqG/v99PyEjs7u7KwZiYGCQkJPwKtpqcnIykpCRkZmZKRyaTCdHR0ejq6oLVavW3zGjQWB4gIYt+A9UbICmJCA6ru7sbra2t0Lh/jMT6+joyMjIQFhYmPoaChVRIQl7G/3l5eXk5aActMpvN0NQL/ejoSAhtNptEQv1YQP1YQNmBqqoqGQifJIuLi0NUVJRYwnf00oASB01NVFd/sjYrKyuYn5/H9PQ0JiYmMDY2JvFhZHp6emSqERER8iRZY2OjgMpqa2tRUlLiJyQZx86kM4tTU1NCODo6CuaQ28GWqDArK0umXV9fL0Tsgm3TR6ZEU5PVl5aWMDc3h8nJyR9EtIHTo+FURSUkIdhiaWmpZJZB5ww0lSWdqpxOJ0ZGRgKKDCIq43YYrYUScXuYjuzsbLFCU3nSScaVo1e9vb3iF3PF6XErOCQq43DYGr2iIoOImaQVQqhG72GGWMwJ05vfiukPVbCttLS0QE6ZR4JR4tb8AWpk4zowHDJoAAAAAElFTkSuQmCC', 
	@ORDER_INDEX=2,@ACTIVE=1,@PUBLISHED=1,@PATIENT_OR_ROOMBED='R',@IMAGE_NAME=N'Blue Arrow.png',@ICON_NAME=N'Blue Arrow',@SHORT_DESCRIPTION=N'Blue Arrow',@LONG_DESCRIPTION=N'Blue Arrow', 
	@COMMENT=NULL,@MOUSE_OVER_TEXT=N'Blue Arrow',@FACILITY_UID=NULL,@FACILITY_ICON_NAME=NULL,@FACILITY_DESCRIPTION=NULL, 
	@FACILITY_COMMENT=NULL,@FACILITY_MOUSE_OVER_TEXT=NULL,@FACILITY_PATIENT_OR_ROOMBED=' ',@FACILITY_ACTIVE=0,@FACILITY_ORDER_INDEX=0, 
	@ENTERED_BY=N'softinfo\bmsuser',@ENTERED_DATE=@DATE_NOW,@LAST_EDIT_BY=N'softinfo\bmsuser',@LAST_EDIT_DATE=@DATE_NOW

	SET @P1 = 0
	exec usp_Insert_Icon @ID=@p1 output,@ICON_FLAG_ID=NULL,@GROUP=N'WHITEBOARD_ICON',@SUBGROUP=N'STANDARD_ICON', 
	@ICON_TYPE_CODE=NULL,@ICON_TYPE_CODE_SYSTEM=NULL,@ICON_TYPE_CODE_SYSTEM_NAME=NULL,@ICON_TYPE_DISPLAY_NAME=NULL, 
	@IMAGE_BYTES=N'iVBORw0KGgoAAAANSUhEUgAAABQAAAAUCAYAAACNiR0NAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAUMSURBVDhPbZR7TFNXHIDLIy5uKiEjc2OJMzNxmmj2j8bH2FwyxbjEONhU5hYdMkWnk03BwQCLFFBBXmJE3RQf0SlOtytPBaQgpRRE3hTaQpFXaS0PAdFC9duhblkW98eXc+85536/x7n3yozdlvBx2xNpzKSTnpkbJJu1SRocMkj9/T3SmHlQGv0fhixmadDaI41YOiR7b5c0brJKpsExKbe4VJL19VmKxm129Fo9+hYj2pYu6nUmQRdaXSvNOt1LaPUGmtp0NLUb0Le20a5rw9BjIOPKOWQjFpNUW6MnSH4V/wMl+EdqCAwvZ0dEIdvl2YKcl9gVkccuhZKt0WUEKO7z/cFcbuaXkZycgOyJtUuqvNfOxtAiVoWaWB02gm9IP+v3WfANB98wO+tCRlgXPPxiDBnGb/8wKzZIuL21hNlLw1i7r5M/s02kHzuJbMxqlCpr2tkkr2CNYoI10fCFHPwEyzfl4L27Bb942BAL6xWw8RBsToFZC3yQyWTInF3wDq7hZnEHJ9OSRMlDHVJFTSuBsWX4HXqEb5yQCb46NI7n3I9xcpIx78PdrAttxvfAA1buuM2KbVm8t3QLLi5TmOP1Az7xD7le0kj68Xhkg4OdUvn9FvYcVrIt8SFbkp8LbASk2PA/PMCiNZE4Oznh7OzENLeZuLqIa5GZi4sri1dH8m06fJ34GKm4hxNpx5ANWXsl9T0DwQllBJ0YJVBsCDw1zs70MfachL0Z4oEoLct9Ypk2w0PIZbi6ujjKnf/BN+w6C0HHLeQpjaSlTgotvZJKoyUirYKw80/Ye15ILjznp4sQKggTxGQJaaSaqa+5i8xccJrsncDDcx5BZyDy/GPy7nYIYeqLDFUVTUSf0hCT+ZSo3yE2G+SXRok4NyAwsz2mlOluHg7RZIYennOYOWs+M9zfZH/GKEeu27hVbiQ1NWVSaJIqqpo4klFBejEk34K1WxNwf2O2o8Spr04TfXN29O2fUnceuYP3lz87soy8YOJ4np3CygckpyQjG7aaRcn1pN9o4Fh2FwuXrXVsnDVnIQsWr2TuwiXMfPtdIXN1zHt9GoD8oo4pr0zlk8++4xflBGeK7BRVd5KYOvna9Fsltcjw8y17RVmviz5NZ3vYaS6X27lcDZl1sGyVn0Pm+c48flUO8NHaABZ5reFa1XMuq+GK+jl3ars5miKEo+JDv1fdTHj8WXz9gzmR00GBDrLuQ54YEy5VOw5ihgiWcq2OfD1cKOjjD7WNLBHsN8GNxhHKG7tJShSHMmLtECWryCypQ9UvJA8gp9VOvs6OeLXw8vbBydkZxdlcSi2Q3TpBfhvcEsGytUJmsJNrHELT0iaEIsOhfqN0V1NCZqmGkr5xcrufktf9GPUonC/VOkrd/GMkVWNQ2DVBQadNrD/ldqedAhE8t3scZd8wVTo9SUlC2G+1SkqVBklVx/0BhHQC1YCdzMpm3l+6Ajd3D4rbhrlnhXKRcXkvKM3PUJlALe7L+hBrE9S09nA0QZzyoHVU/G20lFbr6XwMrUNgFGN2WS17QiLJuJZPjw30Ipjhb7SPXly3ixa1TM6NgNZgJjFe9NBitkqt4gdZpqmmsrbZQVVNAzWNLWg7umnQG9GI+8raf1HX11JdU0ttdQPq+npUzXWUa8qE8DCyzKtXCk+fPolCEY0iJprYGIXgoIOY2GjB5PhfFHFRxMVEcUjsiY6NQh4nF3sOEBMt5y/Xo26FxOG96AAAAABJRU5ErkJggg==', 
	@IMAGE_BYTES_INACTIVE=N'iVBORw0KGgoAAAANSUhEUgAAABQAAAAUCAYAAACNiR0NAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAN2SURBVDhPjVRJKLVhFP4MpSiyUYiN7CyFsGNBFuxEiSysKItrqEtmyTwmMqeQDLfuQtybeZ7neYpkjIUNm+f/nnP7Lv//9/dbnN7v/c57nvOc8z7vUa6vr/UfHx+Gh4cHw8vLi9Wen59/2//po18zzWcymQzK/f29+fPzE8fHxzg5OZH1f8ZztNPTU1nPzs6gEkNvby8UZtne3kZeXh5yc3N/bEVFRcjPz0dhYSEKCgowNjaGmpoaKKS7vr6OzMxMZGRkICsrC9nZ2bIyQU5Ojnx/N71ej7i4OLi7uyMoKAg6nU4AGxsbLYCbm5sSSJY0ZmbW+Ph4pKamoqysDMXFxSCr0tJSVFVVwc/PD4qiwNbWFunp6ZicnLQAvr6+GjY2NuRwSUmJBDKI5uvrCxsbG4SGhkoFTJqSkoLk5GQEBgbCzs4OwcHBEmM2m78YsmQCVFRUSPbKykpUV1cLs4iICAElExcXFwHhnit9DQ0NKC8v/2LIktfW1uRnU1OTZNHW5uZmtLW1SRtiYmLg7OwsYPb29lIu2bW0tKC+vh7T09OyKo+Pj4bl5WXZdHR0oL29Xdauri6x7u5uDA0NgRfh5OQkzAhG8/DwQGtrKzo7OzE7O2sBJEMCkk1fXx/6+/sxPDyMnp4eawJKg+UShAx5u15eXnB1dZUKBgcHMT8/j7q6Ogvg6uqqMBsfH4fRaERSUhLc3NykREdHR2vftFJ5ebGxsZKA1TBmaWkJtbW1XwyZZWRkRHTFgz4+PvD39xd5eHp6WvsWGRkpIA4ODoiOjsbExIQQISkRNmXDTUJCgpTFPlHEMzMzWFxcxMrKCsLCwiSJt7e3BEdFRSEkJET87N3c3ByoFOtLoQ4pkcTERIyOjmJ/f18y7u3tSS95EUzGHvMfXwV7RhD2nyrZ2dkRqUkPmUmdFLi5ucHR0ZE4GchHHx4eLhqkPK6ursR3cHAgfs4A7kmAe2pYhsPCwoIAXlxcCCBNnUJSHktNS0uDKq9/TqPz83NJIgwJyB5MTU3h7u5OQMmUPQwICBBp8PDt7S0uLy//MrKm7/DwUF6YddqwZ29vb3h6eoJ6UaJ8TpGBgQG8v78LQ814RvtWBzPUtkl7BJCTmkOSOuLUofGSdnd3hS2HLfeaT/N/329tbUk8Z4GiMjDx+XDa0Dg5fmradNLi+KJ+AbAKUN7yy8grAAAAAElFTkSuQmCC', 
	@ORDER_INDEX=6,@ACTIVE=1,@PUBLISHED=1,@PATIENT_OR_ROOMBED='P',@IMAGE_NAME=N'fall.png',@ICON_NAME=N'Slip and Fall Risk',@SHORT_DESCRIPTION=N'Slip and Fall Risk',@LONG_DESCRIPTION=N'Slip and Fall Risk', 
	@COMMENT=NULL,@MOUSE_OVER_TEXT=N'Slip and Fall Risk',@FACILITY_UID=NULL,@FACILITY_ICON_NAME=NULL,@FACILITY_DESCRIPTION=NULL, 
	@FACILITY_COMMENT=NULL,@FACILITY_MOUSE_OVER_TEXT=NULL,@FACILITY_PATIENT_OR_ROOMBED=' ',@FACILITY_ACTIVE=0,@FACILITY_ORDER_INDEX=0, 
	@ENTERED_BY=N'softinfo\bmsuser',@ENTERED_DATE=@DATE_NOW,@LAST_EDIT_BY=N'softinfo\bmsuser',@LAST_EDIT_DATE=@DATE_NOW

	SET @P1 = 0
	exec usp_Insert_Icon @ID=@p1 output,@ICON_FLAG_ID=NULL,@GROUP=N'WHITEBOARD_ICON',@SUBGROUP=N'EMERGENCY_ICON', 
	@ICON_TYPE_CODE=NULL,@ICON_TYPE_CODE_SYSTEM=NULL,@ICON_TYPE_CODE_SYSTEM_NAME=NULL,@ICON_TYPE_DISPLAY_NAME=NULL, 
	@IMAGE_BYTES=N'iVBORw0KGgoAAAANSUhEUgAAABQAAAAUCAYAAACNiR0NAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAARiSURBVDhPfZRbbFRVFIZPh5l2bmd65tbOvUwL7VAqopRyh5JCW2i5qpSrKKVawqUifYA0kCAoIAFJ5SIB9U2f66OX+GAiPmFieC8m0oEgIJGYAHI+/8NQw4s+/Nlnr73Wd9Zea+9tbKlxDZ1Mu0eO5Sr+WxmtOfofn+NaP5xxjRhHLeM7sinoWgadHVI7LF0itZXGcZtjd9TxTONzZ1zeCYtbuW95MY7GykbweCBoQiAoBXiYTXClJgu5aggHIBqStB6RLCkkBeX7rzT3BbjlnYBxJC6gqwwM46keJEw2T0phWJUMFrL8nfVBTOtxl6CSJZmSVzZ3KWZcRa/rGdAth4oJ+mMZ3zckMXw++RgY/iDXpldBwY1dKId6qVbKerCr3cpe8inOiS9zUQJWu0bwy+gsJlz8MjNJIOQXsIzWyUnutUVhbgX2PC/2bGmGF6ZpLridU6niiguWoCVgQsCYjPorDR7+WhilNh5mWjbKg00ZWKUtj6vbh93ux16ksUXgJoHziqt2ejCBot8BpgXMaRuNkuO03KKjPk5j0uThtjiPesPc25nhVn+WO31p7I1B7NWBEniewC8K6pRBmRYtpyk1AjqwWYItUTZvVnKqPYPhctNQbVJfFSQdN4mGTTbMmQh7I7BNwB6Bl2tcIKhKwMRyiqqrcWSSe4RmwdoEWx/km54U3TMKGGXlzCpE6Be8rzPPrhW1nOtt4s+DOk6DYew+E1v+9jIdq7mKbaxgLOcA6wVcKMMaH2N9KWKREOl8HtOyaK4NsGW2xYqWON0z48xqiFJfE+eHd+pgfwh7u/SaoEv8oGYVJ5ULOEXADhm2VnKoI43H5+frfXV0taTJZ8IU8hGalem8pghtL8eelmLdAmV5Igl7lOVWaYWyVD2LUxzgVAFXCrjdYnEhwdypMRhOcP90grsfpXkwnOHx+Qz2J+r4l1kO96i+7gDXhvIwpBvSL70q4GLtULU0jjQJ+IoMO8LM16Fumy7guYQUhrNqwMfSsKT57/rB1WONeP0BBpbl4EyKm2/Hudtj6Y77GXtpHOj8YU+YvoVJLCvEzVPK5kKYJ8PRp+Ks4JcyzKyP8u6qGgZWZgmbfvZ21ug6B9g9X91fXUlxxvMZ7gzx4x7dYZeXDfMjPLqchk+V7SUBP0/xwYacbo+b05uz/Hy0Tt96WeTb3lTFV2sF7Ao+B1yjDHtVi0MRTq7TXTY8NDdYnH0jyeXtabpb1AwB1i9K8fhiikfD1VzYlOWn3drJoF6kjYrXGS5t2WlKtwyvCzigZ+pYjC/eSjI5ExIkKJlUxUxObMzw5KI669T2tPShdED+fXrG1iq+1U/xBXX5/YKAukbo5NMvh/2VcFJbVpevDqW4sj/FH+o0n8XhvJpzRiU4rvGgGjEgXycRJ6E5Pm7rRTL21bm+HdMr8utSH6Pq9ujWIKM7Qvw2aHL7YIg774W4cSjE6FAlowekQWmX5r1BruumXO/yc32BlxvTyrla5+EfHYsu/br+AjgAAAAASUVORK5CYII=', 
	@IMAGE_BYTES_INACTIVE=N'iVBORw0KGgoAAAANSUhEUgAAABQAAAAUCAYAAACNiR0NAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAN/SURBVDhPjZRHSywLEIVbERWzIiIG1IWgoqKYMbsQMeeICTPmnHNOmFAUxIQ5LMb1vb+t3nwl08iDB29R9NBddepUnVNjxMTEzKelpVnS09P/M/j+f3KSk5MtRlxc3N+2tjZZXV2V5eVljcXFRTNs72zPpaUlIX6/X1lZkbm5OamqqhIjISHBUl5eLjU1NVJdXa3R0tIiFRUV0t7eLvX19dLQ0GBGXV2d1NbWav7vAKyoqOgHsLS0VEpKSjQoTkxMFFdXV8nKylJwGyhPwGhKw7KyMrOO2sLCwh9APpBAIp0cHR3FMAxxcnJSwK6uLuns7NSANe8aGxsFtpWVlSawAiYlJVkA4WNTU5MWuLu7K2B0dLSMjo7K8PCwjIyMyNDQkPT390tvb690dHQoMBNBBFImIC/5CAMK/f39JSwsTNbW1mRhYcEMFj89PS1jY2MyODgoPT09gqAQAVR3iNStra3S3d2tSRTFxsZKcHCwbG9va+zt7cnW1pbG+vq6OgBgmvf19elUkIKlgb8AY5ypqSkFYHx7e3sJDAyUgIAA8fPzE29vb8nJyZGTkxPZ2dlRm83OzupKWAFM1TYZGRmWgYEBmZyc1BEBtjYROzs7iYqKkuLiYg2WT97FxYWcnZ3J7u6ugs7MzChTSEHEyMzMtLATxmAcHx8fCQkJEU9PTwkPD5fs7GxtkJqaqg1CQ0MFI5+fnysovyGDWOzSsBZY2Af7gbKzs7NeASBBQUEqTmRkpO4Vf7KK3Nxcubu7k6OjI62bn59XlghrWPdiQUm6UWS9bXl6epLb21uNh4cHeXl5kbe3N/n+/pbm5mZxcHCQg4MDHX9/f18JTExMqDhGXl6ehRck4Dur0RXg+flZA3CC3zc3N3J6eiouLi7CuT4+Psrm5qbaiinxpgkI/fz8fPHy8pLr62sFpYAA7OPjQyIiIsxr8vDwUFA3NzcpKChQDfCxCXh4eKjU2RH2eH9/VxCeX19faguuh6Lj42N1Abnx8fHqRfxrAoKOt66urgSTkwwb/IXZbTayrkdeX1+VNTaBABbCHXhYR0YUVGIXdGZPmJVLAZjw9fXVhSMM4yMUKtusw//j+Pj4jyg222BSFCOJ5Pv7e1WeRvz+/Pw094r6l5eXSoDvEOIPhOmMlJSUPxw5o2FQFONiuF8UpQHnxo5xAk02NjZ0XK7k36f3D9KiStOaeaswAAAAAElFTkSuQmCC', 
	@ORDER_INDEX=2,@ACTIVE=1,@PUBLISHED=1,@PATIENT_OR_ROOMBED='P',@IMAGE_NAME=N'Wheelchair Bound (Patient) (EM).png',@ICON_NAME=N'Wheelchair Bound (Patient) (EM)',@SHORT_DESCRIPTION=N'Wheelchair Bound (Patient) (EM)',@LONG_DESCRIPTION=N'Wheelchair Bound (Patient) (EM)', 
	@COMMENT=NULL,@MOUSE_OVER_TEXT=N'Wheelchair Bound (Patient) (EM)',@FACILITY_UID=NULL,@FACILITY_ICON_NAME=NULL,@FACILITY_DESCRIPTION=NULL, 
	@FACILITY_COMMENT=NULL,@FACILITY_MOUSE_OVER_TEXT=NULL,@FACILITY_PATIENT_OR_ROOMBED=' ',@FACILITY_ACTIVE=0,@FACILITY_ORDER_INDEX=0, 
	@ENTERED_BY=N'softinfo\bmsuser',@ENTERED_DATE=@DATE_NOW,@LAST_EDIT_BY=N'softinfo\bmsuser',@LAST_EDIT_DATE=@DATE_NOW

	SET @P1 = 0
	exec usp_Insert_Icon @ID=@p1 output,@ICON_FLAG_ID=NULL,@GROUP=N'WHITEBOARD_ICON',@SUBGROUP=N'SITE_CONFIGURABLE_ICON', 
	@ICON_TYPE_CODE=NULL,@ICON_TYPE_CODE_SYSTEM=NULL,@ICON_TYPE_CODE_SYSTEM_NAME=NULL,@ICON_TYPE_DISPLAY_NAME=NULL, 
	@IMAGE_BYTES=N'iVBORw0KGgoAAAANSUhEUgAAABQAAAAUCAYAAACNiR0NAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAQ9SURBVDhPhZN7TJVlHMcfj+8BzuU94FIogrAk/au1tdRI0iMqeDmJYSE42IFxdZ3kcpCLRAOBWZjhVJymKSgV6rRevNQIvKUTZLjEG7iC5aqptJnTFAj89JxDKH+I/fHd87zP79ln39/397wiPlRXWJGqaOVJnlpZkl5K+W917Z/0PXw+sq5oa5P1WnGcThMl9jFN/B4ANyOlouDWu1KudRS574xQj+v+Uvgzgp7TRkRp4hiNny3Q/YLUePo7/ejrHP90dYys+/HwlwnwayBdDSqiJFEngQq/HfejOG4rWbZvpPaRtcilvU+XbS/Zbx+kMLqaziNBXDuqdzl0AQXn6qYQ4nubOUGQtgBW2CB90egarkdMgtfH9XGkahrt3woJTNJpD6+O5WazYFX0R7zh+4CYqQMkWgdJmDW6EmVt+fQB3vLvJSX8M85rY/hxt3TobrlD4d4Fwcndfsx9uQXr872ETxz4Hw0SFtiLNegi1WXBtB8SNG73fAzsu6TQc05QlprM9Al3WBDcz8LgQamBUdTPDL+7OCJXcXyPoHW/J4c2eT0GDlyWLn8StB0ws/jV790uRwcOyqx7mTf5DLvKfDlWo+PEHgN7K0YCryg8uCBdtgg25thklreYP6nvCdBBt/s3n71NVrSd+q2CI9sMHN5qZGeJYcjhw6sS1q5w97zCrbM6Wg+MJSaklpky8Ce1PFtmt+iVQ2wrMXFgo579lUbq1pvYnC+BxQk6rbddz19tenrO6vnjlJ5rDYKq/BBm+F8n4qWRLgfdrkP9b+CMXcieCkFthYld5Sa2l5qpyJR/SpFdp91p1XPjjJ7rJzzoavTg8mE9TTWCeGsloc/dly7/edS6NeABka9Vs6FAYUepF9uKzWwqNFNZoFKcZkKsjlO0G6c96G7yoOM7Dy7We9J20IuTtYINuVOYFXSF8BeHBjRfup0Z0E3W8ulsKhJu0PpclbVZKmUZKnl2MyJvmaJ1/eDJpcMukCfNdV6cqvWiYYcXdZUC+5wC+XjvSWA/1oD7vDNtHeWZgnU5Jj6WoDUOlaJ0C6tTLWTEyH/ZGa1oLlct+4ZAjbsMHP3cgLbZyFefjqXU4U/YpGZmB/6NdeIlHMsmU7pSJ88tEqSSn2zBabeQFe9NepQEroxStOavDRyrHgYZ2Cen9qUM+4syk8xGZjk3ianP3CEqJJf8FMGHaSoFEpRj9yYjzpv3Y7xZEe1Dos2CcEQqWuNOA/VbjI9ArqkNh13hNJCX5EN8eCSOGF9yEw3kJDwGpb3nTVKUhC0ZR9x8CUyzKVr9FpP7HdWsleNfY6aqSE4t38wnTlW2Z5GOTG5n2QlGMqUjR6wP6dJRshvkg33xOOyRLqA3Inam0lhVYGRdtoHyD4wUp5soTDGRl2DCGWcmI9aMI9pM2lKV5CUqCTaV+IUWlkdYiA23EDNvSK79sjCVfwFjVJHPZxnYlgAAAABJRU5ErkJggg==', 
	@IMAGE_BYTES_INACTIVE=N'iVBORw0KGgoAAAANSUhEUgAAABQAAAAUCAYAAACNiR0NAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAMZSURBVDhPjZTpK7RhFMaff8pubNkm+75k35eQtVnsERIiQnwgW5L0UBIzStbsg/KR/+RyX2e6XxTj/XAy47nv33Od61xnjIiICGdVVZVZXl4uVVpa+u/zT9/1ua/n9Z3CwkLTKCoqcr++vuLt7U3q/f3dZ/k6c3R0BKOkpMR8fHzE8/Mznp6ecH9/j7u7O591e3v77bnH48HLywt2d3e9wIeHBxwcHKChoQFlZWVQLfx3qdZRW1uLnZ0dbG9ve4FUtbq6isDAQERFRUF5ipqaGlRXV/9a+nlsbCz8/PwwPT2NjY0NGDT05uYGLpcLFRUVCAoKQlZWFoqLi6H89Vk5OTmwWCzg3/X1dSwsLHgV0pPz83MsLi5CTR1hYWGIjo7+s3iWwP7+fmxubmJmZuYTeHV1hePjYzQ1NSEgIABxcXF/VnBwMAoKCjA/P4+VlRWMjY19Aq+vr3F2doa1tTUBUaUvKL2OjIxEb28v5ubmpN3BwcHvwIuLC7jdbtjtdhkQDf8NSnX0eWJiAlNTU5icnERnZ6cXyKEQdnp6KsOh/OTkZPHnJyC9i4mJgdPpxOjoKEZGRjA0NIS2tjYY6i3m5eUlTk5OBMY8MlMOhwNUwYtfoVQdEhIi6jiMgYEB9PT0oKurS3JscP8IOzw8xP7+vqR9a2tLfElLS0NoaOg3YHh4uHxvbW0VCFV2dHSIOsbOyM/PNwnb29uTpHP8HAxNbm9vl7YZIUKoli9QIgTCam5uFmX19fXyfyM7O9vUqghaWlqSPDJT9OWrSq2urq5O4kUQN4bKuLIMuACpanl5WUCzs7MytfHxcYkBLzNCOsS5ubkC4f4SxL1nFlWn8nIjPT3dpCp6RhDDOTw8LGZ3d3ejpaUFKSkp8Pf3l7ZVKsAfBA3Ky8uDEoXMzEwkJCTAUIdNqmKeNIhT02Y3NjYKhDFiS9xveqVBGRkZSE1Nlefx8fEwEhMTTcLoV19fn0zOZrPJFAljy1REqG6NYCrSIMVAUlKSF6iMdnGavExfKisrxWAqoS/6Mv1h62zLarXKFrE4eRY/cx0/AIZVqO17r0G8AAAAAElFTkSuQmCC', 
	@ORDER_INDEX=3,@ACTIVE=1,@PUBLISHED=1,@PATIENT_OR_ROOMBED='R',@IMAGE_NAME=N'Blue Caution.png',@ICON_NAME=N'Blue Caution',@SHORT_DESCRIPTION=N'Blue Caution',@LONG_DESCRIPTION=N'Blue Caution', 
	@COMMENT=NULL,@MOUSE_OVER_TEXT=N'Blue Caution',@FACILITY_UID=NULL,@FACILITY_ICON_NAME=NULL,@FACILITY_DESCRIPTION=NULL, 
	@FACILITY_COMMENT=NULL,@FACILITY_MOUSE_OVER_TEXT=NULL,@FACILITY_PATIENT_OR_ROOMBED=' ',@FACILITY_ACTIVE=0,@FACILITY_ORDER_INDEX=0, 
	@ENTERED_BY=N'softinfo\bmsuser',@ENTERED_DATE=@DATE_NOW,@LAST_EDIT_BY=N'softinfo\bmsuser',@LAST_EDIT_DATE=@DATE_NOW

	SET @P1 = 0
	exec usp_Insert_Icon @ID=@p1 output,@ICON_FLAG_ID=NULL,@GROUP=N'WHITEBOARD_ICON',@SUBGROUP=N'STANDARD_ICON', 
	@ICON_TYPE_CODE=NULL,@ICON_TYPE_CODE_SYSTEM=NULL,@ICON_TYPE_CODE_SYSTEM_NAME=NULL,@ICON_TYPE_DISPLAY_NAME=NULL, 
	@IMAGE_BYTES=N'iVBORw0KGgoAAAANSUhEUgAAABQAAAAUCAYAAACNiR0NAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAASgSURBVDhPjZRrTJNnFMfLEuO2bEs2Y7ZlX6ZfzKKOjc0ZcOLiMAoORuJ03i8JmWbIpd42dQykpYBQUTYUzZyXqHMOma+CAuVmS2lLr1oubeXSeZmgoFMKFFF+eyyJmcMs+/DLyXPe5/zf/3Oe9z0yZ4t7e0/3LemGyyLdcumlG556ydNmk9ytTdJVV4egbRRtbrfU5mmSvG6H1NXklG42t0oe702pqLRMkl265Kzy+fp4MOCHYRgU0ecfFPjxD/QyMOAbjd9H/+B9+v33GOrvFUV+bt3vpOBgAbLLZpNkNruRb9vFqngV6T95URV6yCgwk15YLzCMIrPAiHKvie8L7aTuayR7vwHNRQsKRRoyl6Ve0hmu8OnyfGQyGeMnLSZa3s3CzfeITL5L1DOITeghJrGbiA29fCzvY15iG0W/XyVXpUbWbNNKNXVOVme5eTe2MCD6+oQ5LPj2DktzYHGWIHuEJTtHWCbyqwXLcyFKDdGKborLm1BnKZA5HVqpqs7GukwDK/fA5DnKgOhrb31A+JrfCFt6hNAvDzL9i0JConMIiVEzJVJFcMQmgmdvZEpMPtHKDopqG8nJSkXmcOgljc5KUlYta/PuErcP3gmPD4j+X0KivkPSdrMzK1tcis0oVWodbM7Vk7i3l+RjEBF38j/FXnhpPBPf/5zwZQUsSmshPs/L+Zp2slSZwqHFKFVUW0j5wcTWI362n4bQWGH9Xw7fnBDCtLkJLEg6w9f5nWw9DttOwSYRU474OH+xnUxVxojDiuoGFAcayCgaRHkWgmetHCU4LWIteyphVxmkFwtODQoekHISMn/1UaZvQzUiaJKqahvIPmwiv/whOaUwYfLMJ4JTQ2MJi1oXWIdGriNfM4y6HNTn+th1zk9uCew+20eFyYsyQ9zyZZtZqqwxsudkA4fqhtl9YYBxb7wdEAgKCuKbHw0cs0LYvNWB3Iz5cRzQw3GRO26Eo4/RgsbsJT0gaLdI5ZV69hdbOX0JdhZ18PyLLweKp06fyy+i8DEnLMPMio4L5INnxPDZik3MjFzBh7MWojpkQdd8mx1KIdhkEQ6r9BwucVDlBeXP+ifHTd2nocwDRdZhJCeUNMMn85c/1d+g54KYv/QrjC1dKBXilp02naSp1nCi0kz9Hdiye+STmfpROBXeYS60PqLUM0Sp+yG62xC7Rh54PmbMWFZtyOSo+RolbT0Ymq+gSBcOHXatVFZ9gVO6BqwDsChhS6BAcbgYwz3Rmz8G0VwdpLbzEWeae3jl1XGMGTuWtAOnyT9joPYvxIv6MLk9YjikI7OLHp6vqOZs/WVcD2Czej/vhYVT1zWEsRPq/xzB1AV11/uYOGkKsxcswfUIrD1C7OYwlu4hrK7r7EgTv63d1iTViNGjs7VyrR+uiPHm7PTTLmLr3X8g2nFdjMwyo4syh9grTtMhBN1iT7sPWlo7SU9VITMZzZLFaueivoF6qxOjrRGzowmDxS7WjqexOLA2ujA1NWIyW7E0ONDZ7WidNrR1taSlbEeWl6euVCh2kCxPIjk5CXmAxBHkzyZ5w3o2Jj8mgSR5Aus3xot6QWI8fwNMLUOAd6bKLAAAAABJRU5ErkJggg==', 
	@IMAGE_BYTES_INACTIVE=N'iVBORw0KGgoAAAANSUhEUgAAABQAAAAUCAYAAACNiR0NAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAN8SURBVDhPlVRJKLZrGP4oFrKws7CRBWVlIcOCBTIPC2VaUDbKwrzhRJmnkCFTQkpC4jMm8zzPQ0hmFuapKOU673V/5/v8//Gfv/8srp73fe7nue7rfu5BtbOz89ft7a364OBAh/39fTVxeHj4S2jtXHmP546Pj9Xd3d1q1cbGxsjr6yve39/x+fkp69vb2//Cx8cH7u/vUVtbC9Xy8rJ6ZWUFycnJiI6ORl1dnRgqKysFVVVV36C1ae01NTUYHx9HZmYmVGtra+r5+XmEhYVBpVLBysoKSUlJ4iAhIQGJiYnfwH0t4uLiEBsbi97eXuTn52sIp6enkZ2dDX9/fyG1sLBASkqKHMjNzdUhLy8PBPcLCwtRUFAg99LS0jA4OPhFODU1JYbi4mK4ubkJqZmZGSIiIhASEoKgoCAEBgbC19cXfn5+8PDwgKurK1xcXODj4yOEw8PD4kwUTk5OigoSlpeXw8nJSUj/FJ6eniCHLmT+MISKigrU19cjMjLyt2TGxsawsbFBaGgoUlNTUVRUJEmhKMny6OgoysrK0NDQgJaWFt1b/qjQ3Nwc7u7uiImJQUlJCZqamtDc3IzGxka5NzExgZycHE3IJKyurkZrays6Ojrg7Oz8TSHfrL+/Hz09PWhraxPHBEm5MrE6QsplqH19fVCr1bC2ttYROjg4gG9EtVy1pJ2dnSC6urpknZubQ1ZWlkbh2NiYeOKqtA9MTU2FQE9PD6WlpZidnZVwuefl5QVGxD2qYoXw3sLCwhchU97e3o6lpSWRb2RkJJft7OzEM0EClgj3HR0dpRGomM/D7tra2vrqFHpkqEqza/rxn5Jh1re3t8FOWl1dxfr6Ory9vX96X319fQQHB8s5CVk5qB4ZGcHAwAAuLi6kfEhoa2uLvb09KNNIvG9ubuL09BTh4eFiNzAwkJZjdmkjMjIyNIRDQ0NS6Tc3N4iKipILbPirqyshpfKjoyNwiJiYmMDQ0FBqltk+Pz/HycmJKNQNB/YhPT0+Pkpx2tvbyyEqUuac4OzsDMrcg6WlJQICAvD8/IzLy0uxMbLd3V2kp6d/tZ5S4Hh6esLd3Z145XyjYi2ur6/x8vKCmZkZLC4uCiFt3H94eBBnQqikW+YhS4Ck/FZKSTL+K/CtlKH8k413WD4cEiplIAwzds61fyM+Ph7/BZ6l7cc7bMu/AT1JKTNODnTwAAAAAElFTkSuQmCC', 
	@ORDER_INDEX=7,@ACTIVE=1,@PUBLISHED=1,@PATIENT_OR_ROOMBED='P',@IMAGE_NAME=N'flight.png',@ICON_NAME=N'Flight Risk',@SHORT_DESCRIPTION=N'Flight Risk',@LONG_DESCRIPTION=N'Flight Risk', 
	@COMMENT=NULL,@MOUSE_OVER_TEXT=N'Flight Risk',@FACILITY_UID=NULL,@FACILITY_ICON_NAME=NULL,@FACILITY_DESCRIPTION=NULL, 
	@FACILITY_COMMENT=NULL,@FACILITY_MOUSE_OVER_TEXT=NULL,@FACILITY_PATIENT_OR_ROOMBED=' ',@FACILITY_ACTIVE=0,@FACILITY_ORDER_INDEX=0, 
	@ENTERED_BY=N'softinfo\bmsuser',@ENTERED_DATE=@DATE_NOW,@LAST_EDIT_BY=N'softinfo\bmsuser',@LAST_EDIT_DATE=@DATE_NOW

	SET @P1 = 0
	exec usp_Insert_Icon @ID=@p1 output,@ICON_FLAG_ID=NULL,@GROUP=N'WHITEBOARD_ICON',@SUBGROUP=N'EMERGENCY_ICON', 
	@ICON_TYPE_CODE=NULL,@ICON_TYPE_CODE_SYSTEM=NULL,@ICON_TYPE_CODE_SYSTEM_NAME=NULL,@ICON_TYPE_DISPLAY_NAME=NULL, 
	@IMAGE_BYTES=N'iVBORw0KGgoAAAANSUhEUgAAABQAAAAUCAYAAACNiR0NAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAT6SURBVDhPdZRpTJRXFIa/GQZZBmVk35nBQkWIqDUBRaLQqmyKUCn7UhGdssiiQYviQqmAilqt4kbdccGqY1pALS0hpdFYEUVr+oNoahVtWEJURFCe3pmStn/8cfLlu/e9zz3vPedeKcVdvnars0JX7mbyzqiwlXRVViIcZO/WuJjoNrnIdVKZSmrC1QnCw2D+3NGYJ74i5on/sPkMVWzmZWE+fYkJ/82H6jWjeqEheA79KlOkMhuZDmNjGDsWrK3BxgbGWYClCJUSlOb07t2F7qcmrkYtAHPzf+aVYm78+FH9ODBT8szUCOkLWwGUJAasrFnl6UmOWs1DD5GxiSQWiRgj8So7ldO6C3TO8DX8YyZCZUaVh4ZlGg23nZ3RM7pM5aNAmYy3duOZ7eIkxiVKvd0hyINX2hQGIwJ4HePP2QP76Z5mxxs/4cDTkj8muyKZK5FZWPDI0f5/QHu5DnMjsDLioo8aSS7H18mOvsqdDB6/ztO4KAYzg/i2eg9P5mnoKizhVcQstk9yNGy+fIIa7IR9uWw0QwcBtFGAs5wX/o5o7K0Mwua8cjjRTk9CGCMpTnxXWcyDj73oLd7Ow/TleFsqkZuY0DrFFezlYGFEl7nesrMAuo2BiSLLj2zI9PMyAAvnhEP1Zf7ML2Agy4X6ygJuayMYKDlIS/IKoZHhYGPP4xAfUIsztTOmS6UvirsAThJAfyP608I4HJpkAHrY2TOw7TDdlYfo251A3eYcfi3JgG+uUPxhuEET5z2V+uhEXgbYgZucLnuFAL6n0PGBgpFIG26lZ/OsaB/+Hp6GBY0rChn66gjtNXuo+mId7YdreHO2CbWNJaZGRjTFaTkZk0Vb+EyYZMQTNz3QUwCD5PQkTac1rkDYvEL1Er0liYxZgfStr6KldCM3di3k+aVGGkrKDHPRvr68Kd7NhWgtFxZFC4dKuibogRMFMFRB56fh3Msog4PNPN55CgtTBbZjlbTmlvCo+nPYZwkN50kODjYAzy/PgfJjtMTmcGxBLG/nOvDsfVGUMm/R2LEq2pMS6MzdwfCRVrh4i1h/f8PCHfFL6Tm6Xmxky9MTG7CyHI+jlYoX+88wtHaPAOayd2EaPZFedPtKeqCkI0VNR3YxfSU1vK1phnO/cSl7jQEY6htA/6FCOKqiNktjGFsVsUgUp5HneZX8kpTPrtAUHoT70DtNVLncV9INxzrQnlbA6611oveuwckbDGw5gru4z2YKJfc2hkCtmkh/FwPw5qYqONTESMkB7qYWcTAsnfvxIfRMHwUOLXakI6OIocozIhOR4e5LsHErq2dONQBOZbrRv9cHEzNznC3GcHXpZ4xUnGYwd4sArqI2SsvdxFC6/wXGOHA3Yw3DO3Sga4NjLfD193Tk5CETQG2omtq8KQb4ZJUdhX6BDAoHlFRzP7lQtI6Wnz+JpGeqKEq5OMOhaCdupuYzrM+w7oaAXRTiL7m7JBN7M2scbMcybaL+4VCQ4TGTqsDF3BFXs2/lNn4XzhrTirgfPYeeyTKkCk9RlGhXYTlfXKvDcPwavaXHaE7IoyE5k9L4QENm+kgN8eC6Nor62NVcTtzA5dg1nI9cRkN0PMPBrvTp22alRvZD1ywz2sQjcGfZUn7UZnEuKYb6tNl0Fmvo2KAhNsiLBQEe1Od78dc6S27mTKU5fT5XYoKpm+1D2wwznvopaJtgzN8GUnV2zKrpOQAAAABJRU5ErkJggg==', 
	@IMAGE_BYTES_INACTIVE=N'iVBORw0KGgoAAAANSUhEUgAAABQAAAAUCAYAAACNiR0NAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAO2SURBVDhPfZRHSyVREIVbMOBGBRO6cSe4EAQxR1SMmLNixIA5x2fOWYxgQjBnbRUVnaeIAVH/05l36mEPs5hZXF6/7rrfrTp16iru7u46Pz8/NSAg4J/Ly8tL5fpfHL95e3urioeHh76wsBB9fX3o6en5a3V3d6O3txdHR0dYWVnB6Oio9p3vf+L53NnZidTUVCienp5qUlISMjIykJOTI4vPmZmZstLS0nBxcYGHhwfU1dXJJn7n+6ysLC2e7+Pi4ozA+Ph42RwUFAQfHx8JSk5Ols08bHFxEWdnZ6ioqJD/KSkpEh8WFgZDmfKfjNjY2D/A3NxcuLq6QlEUhIeHo7m5GfPz82DZ/f392NzcRHl5OSorK1FSUoLi4mJYWFjA0tIS6enpf4AUm5nwRJ5kYmICFxcXHBwc4Pn5GQMDA5iensbGxgYaGxuxvLwsh0RGRsrhrIjJJCQkGDMkMDs7G3l5eaiuroaTk5METkxM4PX1FUNDQxgZGZGy29vbJVM2x8HBAWZmZgKjRNRUNGSrCwoKpIy2tjYEBwcLkFrd399jYWEBk5OTAiR8d3dXMmQMofX19eB+QhMTE6HQP2VlZaipqcHY2JiAGezs7CyNODw8lPJnZmZE08fHR8mGMb6+vgLk3vz8fKNtAgMD1aqqKuh0OgwODmJ9fR1ubm6yYXh4GJeXlzg+Ppbn09NTvL29wdHREaamplJRbW2tQJkU+6AYrKI2NDQIjFCW2dTUJMDo6GhsbW1haWlJDnp/f8fs7KzWjJ2dHS1Dglm2EhISovIk6jM+Pg69Xo+TkxOxg7W1tbzjpLDs7+9vxMTECJA6UhI2inYig40V4M/YUaOnpyd8fX0hNDRUNtJ319fXAuWvjY0N7OzscHNzA2ZIYGlpqfwWFRUZgbTB1NQUtre3RfTPz0/xH4GcBFVVRT+ane84cozjfDNTgigTwYphfCRDasiZfXl5Ef8RYGtrC3Nzc7EOm+Pv7y9AgijN/v6+SEVndHV1SWMEyNuCWVITTsft7a0Ei1ENADZtb29PdGXJjD8/P8fq6qoAORDMVAPyGiLw6upKhCf07u5ODE0gB7+jo0PzZ0REhFTAQ1kZfdja2mr0sEF8lUBeADz14+NDMuRE0HtWVlawt7fXvEkz8/qifdbW1mQYWC67zAtDmsISOK+EUEOWxwtT65whS2YaFRUlzWI29CwhLJfGbmlpkRHkLP+iNQgglBt4q3ATx42L955hokSnubk5KZPxvHDpPd74zI6j9xuHmGxLJxko0QAAAABJRU5ErkJggg==', 
	@ORDER_INDEX=3,@ACTIVE=1,@PUBLISHED=1,@PATIENT_OR_ROOMBED='P',@IMAGE_NAME=N'Ventilator (Patient) (EM).png',@ICON_NAME=N'Ventilator (Patient) (EM)',@SHORT_DESCRIPTION=N'Ventilator (Patient) (EM)',@LONG_DESCRIPTION=N'Ventilator (Patient) (EM)', 
	@COMMENT=NULL,@MOUSE_OVER_TEXT=N'Ventilator (Patient) (EM)',@FACILITY_UID=NULL,@FACILITY_ICON_NAME=NULL,@FACILITY_DESCRIPTION=NULL, 
	@FACILITY_COMMENT=NULL,@FACILITY_MOUSE_OVER_TEXT=NULL,@FACILITY_PATIENT_OR_ROOMBED=' ',@FACILITY_ACTIVE=0,@FACILITY_ORDER_INDEX=0, 
	@ENTERED_BY=N'softinfo\bmsuser',@ENTERED_DATE=@DATE_NOW,@LAST_EDIT_BY=N'softinfo\bmsuser',@LAST_EDIT_DATE=@DATE_NOW

	SET @P1 = 0
	exec usp_Insert_Icon @ID=@p1 output,@ICON_FLAG_ID=NULL,@GROUP=N'WHITEBOARD_ICON',@SUBGROUP=N'SITE_CONFIGURABLE_ICON', 
	@ICON_TYPE_CODE=NULL,@ICON_TYPE_CODE_SYSTEM=NULL,@ICON_TYPE_CODE_SYSTEM_NAME=NULL,@ICON_TYPE_DISPLAY_NAME=NULL, 
	@IMAGE_BYTES=N'iVBORw0KGgoAAAANSUhEUgAAABQAAAAUCAYAAACNiR0NAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAQ+SURBVDhPlZR7UFRlGIePy1Euu9yyCZX7RQsjnGoMIWQFYVlYYAFdFgRcCEWGEXTIy5gFGgozmpqmFFPZdHEyh8YOU02ZWlNaTmZRqShqk86IeEkkTbns4ek7KvqHdPGP35wz73m/53vf9/d9RyqO1y1fUy4rq+e4KavKNLneUWO5t7J2vp+yaUmQ8upzocrmpcHKuqoxSmP5A7fzR97NneOqrCjSKdJKh7SHswHQZYHONDhrhnNWuJADPSa4lEzfbzZ6jjq4cSIfzotYT7KIi5xzIqdT5GvrLk7n0j4PpPpSnUKHK+pxLwbavRk47g+/j+b6YW8+3Wxn6cwWSuLbKIw5iSPuMNWWz9hWX83F78fCaQPOE4H0t/uidhg49flIpJUa8JgLA0d19B/1hBMS7R8HUpn6IcZxYI+BygyoscF8UVTxVEgKgoLJB/jyjTgBk7j2syfX2mSOKHeAMs52PYMdIzi0YyLZUUdICYeFoqMqq0rx0yp5TzqZFaNSma6yyD5IdjQY/btpWWOh+5DEHwe9+HHHKK3CEaJCVwGTOfOVJ7OmfMN0UYG2UIOYQpykCplDbz1NwU5yopxUmFWyJoIp/Ay7miM5t9+Fb7eJGd5sWczQeUxi48KFxDwIhbEqudECICDpEfdKg2dGOpkdr94cS3nKO7QpI9j7ptuQKTpO7zVge+I7TKEwY5JKWtjwsKENzOJ7zmNOsiIHxUzP815DNJ80SQJYJioURnzR/BTGgEtkPKyS+YhKevi/AzWwZYIGVEkY56S2ZA7bXxoCdki8++IMYh/qxTJeJAoN1+pwMcsElWkBg8xLb6C57jbQKax/bVkhcX43/jfoLlwlMUDFkbSe9YsFUDPl+i8SW+ssxPr9SVrEgICKlocx459iiQG9OKbXsqpKAGsdOqX7oMTOjZFMCz4pTOm/D6C2cb+Y/RXmZtp4oVwAlxfJSufXLux/fyS2mA/EMei7L6AptJfEsINUFYSweLa4KUvtsnJqlys/7JSor7Awxa8Lc5g2y/9qWxytiD5xW3qwxiyipkSiOt+A9GyerPza6nazwpZNOgqNDcLtK5jDh6Aa+F6lRfQyLfAqSePFzyN7NFVF7lTkeiJV58rKge3u7HnLHWWLC68sN5A9eQNxYy6QHHKVtPBeAdSMunWUtKpMYX+REHAZY/hH2E0RzLXJVOT5UJrhhTTfKiu7t7rT2uTBjg16tja40FgzinxjBVOD9xHvf1acs8skBvWQGNgtQF3EB/5E8qP15JnGUpojU5bjwzM5vhSZBXBehqy0NunZvk7P2416Xl9p4OVlbtQvkKi0B2Ez5pH2eB0pUesxTaojfXIJuYlRFGXKlFjdKLX64MjyxWHVgN5IBQny7i3LPFhb487qKg9WVOh5fq6eJSV6FsySmTdTojRLoihdosB8W6kyBSaDkBf5KbekvduTPPkb582b5wvusrgAAAAASUVORK5CYII=', 
	@IMAGE_BYTES_INACTIVE=N'iVBORw0KGgoAAAANSUhEUgAAABQAAAAUCAYAAACNiR0NAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAALtSURBVDhPlZRbS2pRFIX3z7KLdrf7xcosKkmjG2lIVlAnCImIiugxHySCpOhFWg+SiIcKQsgbRoQv3eiPjLPGDKtzsvAIC3Xvub419phjbqO2tvbX5OSkGh8f/7J43ePxqIWFBbW8vKyWlpaU1+tV39WPjo4qw+l0/i4UCnh6esLDw4Osx8dHPD8/4/X1Vb55//b2Fvf391LH6y8vL3/tYV0ikYAxNjamcrkcstksMpkM+Pvu7g43NzfY39/H9PQ0HA4H+vv7MTAwAJfLhZ2dHVxeXkpdPp9/33d2dvYGJCiVSiGdTgswEolAy4fFYhHYzMwMfD4fZmdnMTIygvr6evT09CAUCsm+ZDKJ6+trnJ6efgAJpcrj42O0traiqakJ2i+BDA8Pi0LCp6amMD8/j+7ubpjNZuzu7uLq6koUHx0dvQEJ4jo/P4fNZhMF3EhIY2OjLB7A74aGBnR1dUE3Bh0dHfKf1sTjcRwcHHx4yMddWVmByWTC0NCQKCCgubn5yyK8vb1dlNMW1p+cnAj4XWE0GkVnZ6cooT9Wq7UkrHgA63goVdbU1GBjYwN7e3swdNeky8FgUDxpa2uT00sp+/cavWYtVbJxhAqQ/m1ubqKiogItLS2yygGyhlA9HPLYOvxvQLZ+bW0NlZWVZYM+H0hgX1+fREs8ZI7W19dFYbnKPtfRw97eXhkCg/N3cXEhhtKL7zr700HcZ7fb4Xa7Yejkq1gsJhlil3nzf1RSQDE6jJGh51PpD8LhsEwGc8hIlAtlMlhPGGddgJxBKtze3pZslQNlTukdgZycwcFBmTJDm6kODw8l5ZxL/c4TdWwQR7BUwPmYBFVVVUktQRxTZtLQihRhbMrW1pbER79U5SZjxE30iNEoKuL16upqOYy+86m4mF9Dj44ijMEOBAJYXV2F3++X5NMTFtXV1QmUQIKpkIHm2BFY/BagLkosLi5ibm5OIBMTE9J+vg/5uuJcF0eR5n9eVFj8z9+06A/yFmRZRtO9OwAAAABJRU5ErkJggg==', 
	@ORDER_INDEX=4,@ACTIVE=1,@PUBLISHED=1,@PATIENT_OR_ROOMBED='R',@IMAGE_NAME=N'Blue Circle.png',@ICON_NAME=N'Blue Circle',@SHORT_DESCRIPTION=N'Blue Circle',@LONG_DESCRIPTION=N'Blue Circle', 
	@COMMENT=NULL,@MOUSE_OVER_TEXT=N'Blue Circle',@FACILITY_UID=NULL,@FACILITY_ICON_NAME=NULL,@FACILITY_DESCRIPTION=NULL, 
	@FACILITY_COMMENT=NULL,@FACILITY_MOUSE_OVER_TEXT=NULL,@FACILITY_PATIENT_OR_ROOMBED=' ',@FACILITY_ACTIVE=0,@FACILITY_ORDER_INDEX=0, 
	@ENTERED_BY=N'softinfo\bmsuser',@ENTERED_DATE=@DATE_NOW,@LAST_EDIT_BY=N'softinfo\bmsuser',@LAST_EDIT_DATE=@DATE_NOW

	SET @P1 = 0
	exec usp_Insert_Icon @ID=@p1 output,@ICON_FLAG_ID=NULL,@GROUP=N'WHITEBOARD_ICON',@SUBGROUP=N'STANDARD_ICON', 
	@ICON_TYPE_CODE=NULL,@ICON_TYPE_CODE_SYSTEM=NULL,@ICON_TYPE_CODE_SYSTEM_NAME=NULL,@ICON_TYPE_DISPLAY_NAME=NULL, 
	@IMAGE_BYTES=N'iVBORw0KGgoAAAANSUhEUgAAABQAAAAUCAYAAACNiR0NAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAUJSURBVDhPbZRrTJNXGICrTucWM7MfW3bJtiz+UuM2jdmyxWQSNxOdgoIsOFEUFPEyGCKIIraUgigIom6gcUI2FcVt5sAALygqBWm5VVBqW5AKcmlXLQJWC4Vnh7rsx+aPJ9/58X7P+77nPeco2h/YE4bcT4WrxyxGbM3C7WgRzr5W8fBhl3DZnGLwBfTZbcLp6BIDdqvwdHeKoR6H6HG6RGnFDaHo7bVfGXJ7sBgttFm6sbT3ceeekyZzJ0aziRaz+X8YLa3cbjNzp82ExdTKPXMbrV2t5J3JRzFg7xGGRgsxqcV8G3mKufNDWLnpNJGaOsKTStmgLCH8P2xJLCNCWcY6VQXrlFq2qv6k6KKWrKx0FE8dnaL+VjdfB2cyccrbKBQKXn3tXeb5/0pAgodl8cP4xrrw296PX+yApJ/A6D4CtjlZHOfCJ/YZS6KtnC/qIudQLgqXo100tPzF50tjvbIJ48cxfpyCiZMmM9NHxcpEKys1QyxXgb9yVAIrVB6CVP0EJLn4SgNLkmycv2wk93CmbLnPKnQGCxv36pi7VMOkl19hvBS/NGGiN8HMj2axKDiJ0MxBgtIGCNo7QEDaEGtTbIRJlu0bldj57VoTOUf2o3A6O0R1w12i9lWy+ScPflv/YOrrb0rZZKZ9OJ2EBBXr14Xh4xvD1lwIy4LgA6NEpD9lS7qL4AxYldGPqOjip8OHUPQ5usXNula2p2uJynERfQo5nBN8MutjEndr2KvRELQyhNAkPXH5EJHRQ/QJ2JzzlIijw4TnQNQRG2XX2jmcPSa0d4sqnZHdh2uIz3/GrnMQurOAsNVrSFGrCQ9dTWDgKraor7A5/gQLFy5hY4qePTIu+sQwP+RBQt5jyiqtUpj9vMKqmjuoj+rQFD4j8Sykl4ywJiKVBQt88V0VxzL/IOZ/OY+I9WtJS1byzeIlbMuqIqMMdhdAauEAF6vbyc4+OCbsETW1d0jLqyG71M0+MUp6MRwpecLekyYK9bBoqT/h69d5K94Zt4Ndcdvw8/Nle+YVDl4cJUsMUq6/T9bBrDGhTVTrm8ku0HH8upsj5aPkXBohtxwKGuRe7cgkdM13pKftIz52Bwnx8aiVSiIjNhAYEkO+1sPx8mGu1HdwIFsem36HXWhvGjj6ez0F+hHytPBLJZzUjnK6Fo4VGVi2fDkxUd+TuCvBK9seHc37731A2rFySk0ycdUIVw2dZByUwkF50WtqDOQXN1J8Gwrr4XwdiLpRzknGfjhz9S4BgYGkqvcQuWUTU6dO8Z7RN956hx+LGinvhOrmB2QekEMZcFhFta6aU5f1XLJ6EOYRSsweykxD8jtM8d1hrnaNJekkKDiEoJANzJj9mVc4xrQZc8irqKeurYPMzLE9fNguKnXXKbxRw7VeN6UPnnGh6wkXHzzhcofby6X7bm7YocT4iIpONxfaHMya4/OvdKH/Chra7z+f8kOHQ1yr0iGqbtHwCK73DnPd5qayd4jqbtnKP1TJKmtscLMXdE+g3OTkC59FTJ/9KT8XV3C73UFGuhQ6HYNCX2fkRr2FDhlo6gOzEyySVpngRbQ8BquMbbIO0ig76fKAsbWXA/ul0G5zCJN8ILW6evSGFi+1jc2SJrlufiE3mwzUNxq43XSXWqORqpZbVOu0UpiGovDsmfJjx3JJTlaTrFGTokmWJHnRpLyY5FQVqRqVvOdJqFNUKFOVMnYPGrWSvwGQwo2zyeTZLgAAAABJRU5ErkJggg==', 
	@IMAGE_BYTES_INACTIVE=N'iVBORw0KGgoAAAANSUhEUgAAABQAAAAUCAYAAACNiR0NAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAN8SURBVDhPjVTJK+1hGP6RWCiysrOwszDkH0ApCyKSQlGGIpQk0zFPmadMEVKGZDyS8dzM8zwk87SQMTYWbJ57nvd0Dpd76y6evun9nu95p0+5vr5Wvb+/q+/v79XPz88GPD09/bH+fsZzPfRnGo1Grdzd3f36+PjA8fExzs/PcXV1JSPX/8LJyQm+4uzsDFph6OjogMJXdnd3UVBQgLi4OLi6uiImJkbWWVlZyMjI+IHMzEx8RXZ2NsbHx1FZWQmFcvf29hAcHAxzc3MoigILCwv4+/sLUVpaGpKTk38gKSlJ9hITE5GQkICxsTHU1tbqCA8PD+Hp6SlkxsbGMDIygqmpKdzc3IQ0Pz8fVEHFHImcnBwZqZQ2k5OTOsKXlxf19va2uOjl5QUzMzMhNDExkQfs7e0RFBSEsrIysfmKwsJCWefl5UGbkE+Fm5ubKCoqkg3Gz8rKSkhtbW2Rnp6OsLAweHt7o76+HhUVFSgtLZUHysvLUVJSguLiYkxPT38SbmxsyEFdXR3a2toQGxsLBwcHcYUKAgMDxb3W1lYha25ulsu051hTU4PZ2VkZlYeHB/Xq6qoseKGrq0uCHRoaKq6Eh4cjICAAubm5SElJgYeHh8S0u7tbiImWlhbMz8/rCJkUEjY0NIhRZ2cnhoaGEBUVBXd3d4mfn58fXFxcEBkZKWRMIF0eHh6W2uO9xcVFVFdX6wjX19flFRr09/djcHBQ5u3t7VhaWpJkRUREiGJ9Cfn4+Ij7IyMjGBgYwMrKCqqqqnSEa2tr8hIzxXoiJiYmxIj1RvcZeM5TU1MlntHR0QgJCZFk0JaiDIW9vLyM3t5ekU2DmZkZCTLV8XVfX1/Ex8dDpVIJGQvZxsYGjY2N2N/fx9zcHFgpBkLGkHFjPVIV1wTnvMCiZefQZVaApaWl1Ki1tTX6+vqkr9m+LClxmRdHR0dxdHQEtiFJ9CMN2fxUy/akm05OTkJI2NnZSYh4Vwj5OdB4amoKFxcXcvD9l+EefyF6cHp6ioODAzg7OxtImSCqlCyTcGFhQeJ2e3srpJeXlz/A/ZubG/mmtH+neMGfydHRUeLML4+lJC4zoMzS6+srHh8foS12w8j530BbPkLlb29vEhYh5E9NuYwjXSK2trYE+vX3UX9GlcTOzo7cZ10qPT09mqamJskgwU74X7DPaau/x/b8DckEcZ8CacwQAAAAAElFTkSuQmCC', 
	@ORDER_INDEX=8,@ACTIVE=1,@PUBLISHED=1,@PATIENT_OR_ROOMBED='P',@IMAGE_NAME=N'buckle.png',@ICON_NAME=N'Restraint',@SHORT_DESCRIPTION=N'Restraint',@LONG_DESCRIPTION=N'Restraint', 
	@COMMENT=NULL,@MOUSE_OVER_TEXT=N'Restraint',@FACILITY_UID=NULL,@FACILITY_ICON_NAME=NULL,@FACILITY_DESCRIPTION=NULL, 
	@FACILITY_COMMENT=NULL,@FACILITY_MOUSE_OVER_TEXT=NULL,@FACILITY_PATIENT_OR_ROOMBED=' ',@FACILITY_ACTIVE=0,@FACILITY_ORDER_INDEX=0, 
	@ENTERED_BY=N'softinfo\bmsuser',@ENTERED_DATE=@DATE_NOW,@LAST_EDIT_BY=N'softinfo\bmsuser',@LAST_EDIT_DATE=@DATE_NOW

	SET @P1 = 0
	exec usp_Insert_Icon @ID=@p1 output,@ICON_FLAG_ID=NULL,@GROUP=N'WHITEBOARD_ICON',@SUBGROUP=N'EMERGENCY_ICON', 
	@ICON_TYPE_CODE=NULL,@ICON_TYPE_CODE_SYSTEM=NULL,@ICON_TYPE_CODE_SYSTEM_NAME=NULL,@ICON_TYPE_DISPLAY_NAME=NULL, 
	@IMAGE_BYTES=N'iVBORw0KGgoAAAANSUhEUgAAABQAAAAUCAYAAACNiR0NAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAShSURBVDhPZZRbbNNlGIe7rTt063paD2Nr13brysqOXQdjkOHY3FhGCBuZki2TINs4CcTgOAiOoG6BjIzDIEoC0UQvNOGCFLlDEy6MxoTETFQQtMwE1BhPxDvj+virnajh4pe07+H53vf93u9veDaYeXh6UUb8mNXwmKZkO56yWx73/S9e/uMOQ/xVb2bcMOnK+ID8XGioh6YYxBoXFIX62rT9v7bGBkjpkU3xy5ZCMMBPeRkYJj0ZcbKzoawMAkEpkFa4nJOxWq7GaqBK/xeXyxbgWlOUO3Wy+f3/xpbLV+RiLkfAiWIBMzPAYEgrS8o1cMNrJddsptRcwF2fGRyy2wx0WMycdtrScRkLOQu5ibxMAVMVGjMFyQKL5DLysCSbTiVl5xdgtxfRUh7gYdQKS4ysdRZyLuCCEqMOkEzKSeVnZJIGFmfGyZfRLqdAhHL4sSqH69UFtJd52NVQxqUVxSQ6Spip99PmtjBQ6WUqUkKyPA+cyjVLWf8ASwV0CuYTTCBiCmqVeiws9RUzFnXDUyb+6C1kd40LQ4YJu8PBlWaPLk2XGVSeRxI0UZCqsCwznkzBlgi2wgRd+dAnbbYw0+3l2sYSeK4QdmiO263siHm41F6cjlmlgxsFrVC+K5uEPUvAoCqMCLbcxHi1hadDFoYiVgYjhYw0OhiJORiqtzFYa2FTg53hBifboy6Ga5yMVhczFHZzvc6hGzeS8BgFrDTGacrjz3YTfreVC8M1XNkTodDt5OqBej6dinJ2Z5SSgJcPJ1uZnWzipYEY4ZCP2+MdDHQ1cbRSF1aTwze+FLBKwFUmkr1mOkI2umJeVkbc2Kxmtnb7Ge700bPch7+0iKGOEFs6AvS2+Cl1KbbOT+vSGi63ezV7tazWDRMRYzzZqXkMmPl5xMrNXU7GB8NUhv3s3xjmi2M+vn3ZxtxRO3fHC/n6VQ9TgxXaey+7e6q5t70C+tVySx4Jjc4wUSPgWgE3afB7LfCKyj/v4fapxQysXULfmlpuToXh3VIenClnS0+Ygc4wnx8JKVYbMKrcDdLqfBK1KWCdgL0FMGIhuc/G/ISd5Ek7vC69Wcp7B0N0rwzR2xaktbmKt/bq2V0shWkryUPSThWg7lCXiYbcBeAGAbdZmD+gJ3VMOq0Wzgl4sYhPjpTStTzImmYfK5rCvDMWkX2RYuQfV0d7zCQHBVwjoFYoXWGfgFvlfNHGryd8zF/wcf+kl209Pta1ePl4XBW97eX2iSD9T4bpawtxY9xP8oS+MGP6cAwJqP1NRFPA1AzXCzhq5oeDi6iusNHW6GL96iCnRgLMn1c15zWGVEWvqfo3Srg8VkHvqgrqK10s9jt5sFkHdupS9HL+BtKTehlmvt/nxuPM5Yl6K/dnfJqhE846SM4UkTybFjPp+f4+HdDa2HEVmfhukw5tM3FPu2iY1NqgpaZfZWvAc4fc/HJc71QXM3/Kwbxgj3RGv6clXRyHLfy2v5h7o3qa65XbnMdcWMADlcb37y7L5ebqPGbX5fPVUAFfjpiZ3VnI7PMWZl+QxhaktZrdLW2V7xkzt/rzudOdx2ctudxSdR9VGPkLcXsyp1O1ZjcAAAAASUVORK5CYII=', 
	@IMAGE_BYTES_INACTIVE=N'iVBORw0KGgoAAAANSUhEUgAAABQAAAAUCAYAAACNiR0NAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAOPSURBVDhPbVRXSyNhFB18My82EEEQsaHogzV2Y8XeY+zdRMVeUDT23ntv2AsqZPB197ednXNlguzuw2WSb2455c6nREVF2RMTE9XIyMh/Ijo6WmX8793fZ8xLSEhQldjY2N+VlZXo7+/H0NAQBgcHndHX1yfnP88GBgbA+Hk2PDyM9vZ2FBUVQYmLi1PLysrQ2toqh3p0dnaipKQEtbW16OrqAv/bbDY0NDRIbltbmzO3o6MDdXV1yM3N/W7IwuLiYgn+Li8vR2lpKQwGA9zd3WE2m1FdXQ2LxQI/Pz9oEkmeXqM/8/LyvhuymE2qqqoEUU1NDQICAuDq6goPDw+EhYU5EQYFBSEzM1OQckBFRYUMZ1NnQ2pIBEwilaamJkEVGhqK9PR0GUA9CwsLZZCmO7Kzs4U6ATCXiKUhneEhm1itVvT09Ig5k5OT0NHMzc1hamoKqampcHFxgaenpwzp7u6WpvX19dI0Pz8fCleGzSg4nRsfH8f09DRWV1dlOl3e3t7G1taWBBE3NjZKDt0lALJiLmkrycnJKpFxFZis7SU0XSWIKC0tTUyIj49HUlISUlJS5Iy/GaRPuVpaWsQHRStSe3t7MTo6Ch8fH0Fkt9vh5eWF+fl5HB8fC3K6u7e3h8PDQzQ3N4scBwcHKCgokAFcK9JWTCaTSuikEB4eDqPRiIiICLi5ucmisoBIfH19Zc8oPJF7e3sLOuZzAKlTV2k4NjaGhYUFLC0tCSomBAcHi9hEtL+/L0EtiYqaBQYGCkXW0DRKxnxF2ymVji4vL0vR5eUl3t7ecH5+LgiJirS/vr5wc3Pj3LednR1cXV1hfX0dMzMzIhnNVbKyslTS5QuiYdL9/T1eXl7w+fkp02lERkaGGDMxMYGPjw/c3d3h5OREnCc7sqQx0pATNjc3cXR0JCgeHh7w/PyM9/d3bGxsiIZ0mprRMJ4z5+zsDLu7u1hcXJR14046EbKQE6+vr6WA1Ln9RLe2tgaHwyHvc3Jy5NNjPpmwIXVkQ0FIDfkVkDJfUuyYmBgp4pfw+voqQUS6DJSIOxsSEgJ/f3+RhZRppjSkLisrK+Ii90+7PIU6NXx6esLj46M89WDj29tbaJeqfIazs7MYGRn5NkWbpNIhHrIh3bu4uBA6DDb7GTSDxp2ensqic83IkB8E70RFE/wX94qbzhuFaEmJA/Td5EoxKL7egJoRFWv0C4IX9R9PF1A3jmBAgQAAAABJRU5ErkJggg==', 
	@ORDER_INDEX=4,@ACTIVE=1,@PUBLISHED=1,@PATIENT_OR_ROOMBED='P',@IMAGE_NAME=N'Lift Equipment (Patient) (EM).png',@ICON_NAME=N'Lift Equipment (Patient) (EM)',@SHORT_DESCRIPTION=N'Lift Equipment (Patient) (EM)',@LONG_DESCRIPTION=N'Lift Equipment (Patient) (EM)', 
	@COMMENT=NULL,@MOUSE_OVER_TEXT=N'Lift Equipment (Patient) (EM)',@FACILITY_UID=NULL,@FACILITY_ICON_NAME=NULL,@FACILITY_DESCRIPTION=NULL, 
	@FACILITY_COMMENT=NULL,@FACILITY_MOUSE_OVER_TEXT=NULL,@FACILITY_PATIENT_OR_ROOMBED=' ',@FACILITY_ACTIVE=0,@FACILITY_ORDER_INDEX=0, 
	@ENTERED_BY=N'softinfo\bmsuser',@ENTERED_DATE=@DATE_NOW,@LAST_EDIT_BY=N'softinfo\bmsuser',@LAST_EDIT_DATE=@DATE_NOW

	SET @P1 = 0
	exec usp_Insert_Icon @ID=@p1 output,@ICON_FLAG_ID=NULL,@GROUP=N'WHITEBOARD_ICON',@SUBGROUP=N'SITE_CONFIGURABLE_ICON', 
	@ICON_TYPE_CODE=NULL,@ICON_TYPE_CODE_SYSTEM=NULL,@ICON_TYPE_CODE_SYSTEM_NAME=NULL,@ICON_TYPE_DISPLAY_NAME=NULL, 
	@IMAGE_BYTES=N'iVBORw0KGgoAAAANSUhEUgAAABQAAAAUCAYAAACNiR0NAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAASTSURBVDhPbZN/TNR1GMc/nN/jEA5nK82aZigIp6bQppQzUFA47uAOzkQvSclTUBFFSVGMqSnTYWqilsvKFHIZ6vpq/khR06k50ZYQKCzNWqmLTHM5a3D36vM5QMz1x7P3nuf5fN6f9/M8n0dMGmlYsmZmkL5hnqaXFwq9fF6ARGkSN0l/bb5RX+kJkmbyo/JVvOOMQuWr+8teN+li5VRxjJ8t/HiyhMYj87l8qIDLhwtokFZ/oJC7dVOgORl+tfrxTm029QcL/Xll6mzjkQXcPD+f5jNPIFblBOgtDSby7Tp2C+RafUxP8kr0kjkM8m1HuV8XAtfM/FVnJs96wh9X+Rx5LifZx9h+UJa7hp+OCcQKj0HnmkB/N5b4Pvd4NRrGvygtBiYOh8S+PvaUOaU64UfluyWhyqtzGS9AUsRVzu58lqaDknD5G5KwycCdi0K++iEje4I1zEtyWCsp/VtJjQJP/Gl+OdWD6aNP+X0VV3lrmI8RPWBJ1kKazwu+221sJ2zU4AfBgc0xxPW+TYoswRbeRugc6GXSy62smX2SrBEtfl/FVT7pefl4ZD3VHz3NzTMBnK00tRNe0fBdkSovCPLsW4h7RhF6H5K6Y73MsMFrsb6HZLZwH6/0guKsuVz5StB42ET11kcIWxukyibBofeHEN+7+aFKpcTaT6lpQ+V3qEuJusS+zU9Ru8/AxT0m9m8M6lTYUq/R2mDgruzlHMdG4uTrHSo7SDrRJ6vwUeSezbkqwelPgzhZ0ZVdZY8R/lOn0dIgOLI1iqT+N2Tj23r5uKneOYecY9e67ny9Q+PQB8F8uSWYj5d3bVPou6zxoFbj3rca9y8Jaqp64Rx8Xfbr/wnVQ+7YE+zdaJREJqrWB/PZ2hA2LZKEy7IN+t+1Ru5eMPL7OWk1ghVTl5IkJ+2wPDqENqVqwukDZTzCy1vZE/h8g2BbaQhbV5gpKwhGlEwx6H/WGLl1RtpZwYltfUmz3CBjsFTX/j0eL9keIUkHgSv6G8qLzbxX0pX1i0NZlhuCKM7S9FunA7l+PJCrcnUWTViNVZbqsHT+NzWcR8tXKjMG+bBFwEzHZN4pEpTO7UbRFDOiaIKmXztqoumo4IvycLkJv/nVdXxeRWbt/4CU8GaJLf8ZkEuuXdrgGoo83SmZEcyciZKwMFPTv99v4sJewVzHOnlRqovqVKcG4BxynFkZLsaE3ZZt6NyidKkyNVIOaFQOhVMFM1zdEHNcmn5xTwDbVw7EHvlHe+/UlnixS/KEPi1MT53EqjcFjphPGNtXEcpy/Xkv46RKm+USnoyeeJxyyvnpBr16WxemjdlBQm9Zqpxukryk/lpiH7mrlmqW5JopLQjA4xjO6Oduk6x2WCpX6lMHtGF67GIm2w2I2elC314aRuZLO3FE7yItpoLU6ArsQyuxDqrCk5rM0jyDJA2lYHIgacMWkDBgN4lRlSRGVjJ6QAUJEXtJGboJ99gnEe44rXrDQjNvzwqkeJqBBdldmJfVhXy3Rl6mRv7EQImh5LpCmeY0k2UzMj7RiCvBSMYoI+nxbTYuwUzmqG78C2jWn+uluQiLAAAAAElFTkSuQmCC', 
	@IMAGE_BYTES_INACTIVE=N'iVBORw0KGgoAAAANSUhEUgAAABQAAAAUCAYAAACNiR0NAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAMpSURBVDhPdZTZK2htFMb332We53keQ2YyJEodUiQkU4hIUS6kyEaZp2SecsON8qc8Z//WabOd830Xq7X3+673Wc8anYiIiF+NjY1ua2ur297e/o9uampyq6urv4R/7IK2/nd5ebnrVFVVnby9veny8lJHR0c6ODj4kr29Pb28vOjz81MfHx+mn5+ftb+//8Pu+PhYd3d3Ojk5kVNTU+Pe39+rsrJSqampqq2tlcfIdH5+vjyHurm50evrq2nsOOfee2sSHx+vrq4u7ezsCIYuLCYnJxUZGamcnBzl5uaaLigoUExMjMbHx/X+/m6af859u8zMTMXGxmp5eVkbGxtyPI/u09OTLi4uVFpaqtDQUPMYFxenhIQEpaSkqKioyEIsKSmxf865xy4kJEQNDQ06PT3V6urqNyC5mZmZUXh4uD1ITEw0nZaWpuLiYvX19Znm378HFJmfn9fh4aGWlpb+AD4+Pgo5Pz+XVykDBdAHLSwsVH19vdA+GHfYcb65uWkyOzv7DUhhCJ3DIEse+ilA+458duR+bW3Nwh0bG/sGpOyAksuKioofLH2QoMYpFV5ZWbFQFxcXNTg4+BPw9vbWQMkJlQsyCoLBLjk5WcPDw1pYWND09LSmpqbU09PzB/Dh4UHX19fW3FdXV0afav4XMz8FWVlZGh0dtXYbGRnR0NCQOjs75XjhuTQsodLpZ2dnamtrM3bBigaLlJ6erqSkJCsIYHRAb2+vWlpa5DB/gFF2hFwQTkZGxv8yBAxQJosJ6e7uNnbk1PGa1QVod3dX29vbqqurs9bAONgiwfA5xyHANL23HNTc3Gwt53hj5AK0tbWliYkJM8I4CEb4yN8OGDscMd+wYyQNcH193QpBu2AQZAcQTpgS5vjvXFI8cl1WVqbs7Gw53pC7gA0MDHyx8x8BFB0dbduFhMOQdgrewxKnVJ28Ot6HOzc3Z7mIior6ekSvAQYr1pm3WG3DsJH8xQAQBfTTwbcB9vf3GzoMEH/UAAPE35FsGxgyJd6mNx0WFmYaW945nsfjjo4Oqy7JJRfkiwSzFwk3Ly/P8uNXlsdEA1uAEaJBfgNn4nK3nXwyKQAAAABJRU5ErkJggg==', 
	@ORDER_INDEX=5,@ACTIVE=1,@PUBLISHED=1,@PATIENT_OR_ROOMBED='R',@IMAGE_NAME=N'Blue X.png',@ICON_NAME=N'Blue X',@SHORT_DESCRIPTION=N'Blue X',@LONG_DESCRIPTION=N'Blue X', 
	@COMMENT=NULL,@MOUSE_OVER_TEXT=N'Blue X',@FACILITY_UID=NULL,@FACILITY_ICON_NAME=NULL,@FACILITY_DESCRIPTION=NULL, 
	@FACILITY_COMMENT=NULL,@FACILITY_MOUSE_OVER_TEXT=NULL,@FACILITY_PATIENT_OR_ROOMBED=' ',@FACILITY_ACTIVE=0,@FACILITY_ORDER_INDEX=0, 
	@ENTERED_BY=N'softinfo\bmsuser',@ENTERED_DATE=@DATE_NOW,@LAST_EDIT_BY=N'softinfo\bmsuser',@LAST_EDIT_DATE=@DATE_NOW

	SET @P1 = 0
	exec usp_Insert_Icon @ID=@p1 output,@ICON_FLAG_ID=NULL,@GROUP=N'WHITEBOARD_ICON',@SUBGROUP=N'STANDARD_ICON', 
	@ICON_TYPE_CODE=NULL,@ICON_TYPE_CODE_SYSTEM=NULL,@ICON_TYPE_CODE_SYSTEM_NAME=NULL,@ICON_TYPE_DISPLAY_NAME=NULL, 
	@IMAGE_BYTES=N'iVBORw0KGgoAAAANSUhEUgAAABQAAAAUCAYAAACNiR0NAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAUNSURBVDhPdZRZUFNnFMfTGdfKOC61QPvQh/ahfep0OtNxptM6rds41QfRulCnaFtFbdXWtQwghCQURCOLoFgQtHYEcelVhCKbRQhhk70khBCUJQRvTAQSSID8+kGdPtmH33znfPf//e85891zFZa+gXCvxy25rRZpymqWPLYeySHbJFmWpeEh20uxOvqlEdkg+QZahd4iORw2acjZL5WUFUiKwcGhUq9nElOHRdBPR8cQLYZntBjttBsGX0pTlw2j8TGWv3swdNho65Lp7u3l6tUsFCM2u9TUaOFQdC67osrZdbKK0IgK9kWUsDfyvqBIUMzu8OIX8fReMfsjS9gTWUFIVDWhMYXcLagj6YwWxdiQXaqt62Vr2H1Wh/ewNtxO0Ik+th6zEHS8b4aNx/rZGj7wIu9ly7EuEfew7meZz8Nk1p+o4Xa+ifPJ51G4pw0fDRAcXck6zQjr1LApepJtJz1sjoINYbBHdY8i3VV2xsPGCNgW5eLL6HHWq2CN0AcpTdwqspKa/KtoWbZL+obHhGoesC1+kKC4CbZoIFg9yfa4KdYedZKWsRLcKzgnOdksTIJjXeyIHWX7L+NsincTHGckt9RGcnImCofdLukaujkYV8pubR8hiR5CtFN8c9ZL8KlJdkZmMmD2A96k83EWB9Ph69NuoR3lO62bkLPDfKs1cLt8kOSUDBROeUiqru/maMJDDp13EHrBR2j6JN+n+9ihfErWlU/JTp+NNn4+tscruVU5yN5U2J82wb4LsDt9ioNpPRSW95KSmCYMxbdWpTcSkaIj7Moohy/Dkd/gwEU4lpCKqWUBbwTOQaF4hYbKpdidKahvwE8ZUxy+5OPHbB/hl20UVvSRPGMoKqzSdxBzsRp13ignr0OUOHAgsRdJ+hC3vJB33p4nDGdTX7UQpj6muNmCMgeic3xEXvcRmydTVNVLUmLqv4b6OgNx2TqSCl2cyvcRI0w1qRqs5vl4ngfwwfvzmTVrDobm12BsGUNyDNnlcOr2FAlCf/aOTEntAImJ56ZbFpeibyfpWjUZFS5ShTAq00hRwbtMPF/ExEggn614lUWL5vLE5M/E8FKx/wGN5iYulkBasY+M0ueUNljRThsOyw6psrqZ9Ju15DZMklIMSVnHsXXPw+MMgPFANnyxAP/X52Lv9xcV+zNmX8Jzx1GKmn1kVUCOfpzyJitnzqaISbENSXW6Rq7cbeRuB5zOe0RF2VvCbAkuewBeUWHe70tITFjMiByA+1kAo/JSvM73MA9Wc70V/miTqW01oz0tRm9E7pGq9Tpyyhq40TrBpet7sD+Zx7gzcOawzx3ID/sWsvyj+ch90xUGiBf547YvxjUcSmX/BAVmF7Ud3WinZ1l2WKQHdRVce9hMdvEd6ir98Drmitv1m2FqxI841Sx2fqXgWf8CPA4/XE+nmceEYxmDw3lU2kDX+YQz2kQUNqcsldXWk1PewqU8NTdvLaegaDX3ClcJVpMvKClbQ9lfa/7L8/9cRX7BKgoLPxG/riO0DruoMQ8QP92y3T4q1dQbKK830m4dp7rLg15Q0zUuVi96k1fEXmrNIn6RV1nc1HaNUWcU9I9hcntptzzhdMIZMctWWeoymKnSN/CorZOGdpPAMMOj/0Fv6KSxzURLaxf6ViO6tnZqdDVo4+JR3MzNKcm8mI5GHYNKpUKlEatGOYNa/XKUGpV4piZWpUapVhGlikETo0SjVPIP31+z7ntOm2kAAAAASUVORK5CYII=', 
	@IMAGE_BYTES_INACTIVE=N'iVBORw0KGgoAAAANSUhEUgAAABQAAAAUCAYAAACNiR0NAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAMaSURBVDhPlZS3SmVRFIaPYG8ltvZ2lva+gE/gOxjBiDnnhBExB9SroJhRFHPOOUfUXpt/7rfkXG8xw8wUP+ucvVf4V9rOzc1N0ufnp+f19dXz9vbmeX9/N/D9J7i6SFcfOTU15XGen5+nv76+dHJyotPTU5N/A3ou0D07O5OXmNra2uTAYmdnR2lpaUpJSfktUlNTlZSU5Lvj3wU26enpGhsbU0lJiRyobmxsKD4+3pCYmOhDQkKCXCQnJ/u+/c/j4uIUExNjDquqqr4dbm1tCQNYEs0fMON/ZmZGBQUFxsz/3s1scnLyx+Hm5qYyMjKUnZ2trKwsA9+5ubmKjY1VWVmZHh4eNDg4qMzMTLsDOTk5JjnzNkSVlZU/KXNZWFio4uJiFRUVmczLy7P0V1ZW9Pj4qOPjY9XW1hpT7gE2+fn5mp2d/WG4vr5uStXV1T7U1NQYayRGlGR3d1dzc3PGhHqhj6yoqLBzpHUZBvy0tLSoqanJZF1dnaVD5JCQEDmOo5GREUu9p6dH9fX1amhoUGNjo5qbmzU/P6/y8vLvlHGIg66uLnV2dqq7u1ulpaU2V0dHRwoNDVVAQIA59M6tyAi9jo4Ok9gtLi7+OEQBZsPDwxoaGjIFZopA5+fnCgsLU2BgoHWaAb6+vtb09LT6+/tNf2BgwHRpni/l9vZ269T4+LilglM24OLiQhEREQoKCtLy8rIFuLq6MuboMn/ItbW1b4ekvLS0pN7eXiFHR0etEaurq+bw9vZWkZGRCg4OFhvFGd3mnPmF9cLCglgOymQOiezxeMyAmpACu4ohDBkVBhhW7C6Sc9KnXABbxsjHENpc0GGiwQRj6hUdHa3w8HBtb29bygTC6f39vS4vL7W/v28wh4wNqVI/mgJwdHh4aIAJuxsVFWUOuTs4ODAQ9OnpyYLy73sccDgxMWFj0traqr6+PqupCzrJyPifMYv8s7YvLy/GmgWwlEmVJtzd3f32LfR/+9x3060xHf/4+LBSsLKO17uHSxqzt7f3X6BulAGQJevreKlPMXe8MLwa7mvzrxIbdt6VvwDRFbsxVcT4/gAAAABJRU5ErkJggg==', 
	@ORDER_INDEX=17,@ACTIVE=1,@PUBLISHED=1,@PATIENT_OR_ROOMBED='P',@IMAGE_NAME=N'WBCaution.png',@ICON_NAME=N'Caution Risk',@SHORT_DESCRIPTION=N'Caution Risk',@LONG_DESCRIPTION=N'Caution Risk', 
	@COMMENT=NULL,@MOUSE_OVER_TEXT=N'Caution Risk',@FACILITY_UID=NULL,@FACILITY_ICON_NAME=NULL,@FACILITY_DESCRIPTION=NULL, 
	@FACILITY_COMMENT=NULL,@FACILITY_MOUSE_OVER_TEXT=NULL,@FACILITY_PATIENT_OR_ROOMBED=' ',@FACILITY_ACTIVE=0,@FACILITY_ORDER_INDEX=0, 
	@ENTERED_BY=N'softinfo\bmsuser',@ENTERED_DATE=@DATE_NOW,@LAST_EDIT_BY=N'softinfo\bmsuser',@LAST_EDIT_DATE=@DATE_NOW

	SET @P1 = 0
	exec usp_Insert_Icon @ID=@p1 output,@ICON_FLAG_ID=NULL,@GROUP=N'WHITEBOARD_ICON',@SUBGROUP=N'EMERGENCY_ICON', 
	@ICON_TYPE_CODE=NULL,@ICON_TYPE_CODE_SYSTEM=NULL,@ICON_TYPE_CODE_SYSTEM_NAME=NULL,@ICON_TYPE_DISPLAY_NAME=NULL, 
	@IMAGE_BYTES=N'iVBORw0KGgoAAAANSUhEUgAAABQAAAAUCAYAAACNiR0NAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAARbSURBVDhPnZNZbJRlFIb/2TpLZ986LbS1LMVqhREiSCl0hbKWvYplp4tIC8hmtFAQimyiUKgJsgjx0sRkLo0arzThxtBiomAciN544YVIvGP+x/fvtMq1F2/+zPnOeb5zzveOsa3C3nc+ZWROuSTn/5TdyJwuNDInyuwZ42Tc9jUhP2zbCjtfh+5O6BpTR0f+986ufKxTv8fPrPi4enugsYE/CmwYJxO2DB4P1M6HpiZoaJQaoEXftUu4vm457auW8M0rrbB6sXLqJZ01WnljWrgIplXx0CXgQEpAuw0M4z95DG4nHTQF7exOOBhIOZnhNtgVckBUefancp+qy3rtAhYJ6LSDW8kBqcjJyPMhPD4Xn1SHIe2Dag+/vRTF8CpWFYVJbkg6ISJ5VWPV2+xkPRYwZc/gU9A6TDnIpf2kY27qUl5oDsEcFddIC4Osq/AzJezhSY0umuLCLHNBQnV+1TvGgRMEjCtYqsNqN5lZQQybjS/rVdRaiLlC0pe2IP3p/Fm2MaKLtHflmxWqK5IEzRZaHeqpsW6qKtCi/awo8+DR+H9v1Ggb/ZjbApjbg7ArTN8cAbWze60xWOLDnOfFnKHuJ6lWnWYjDgEr7BnTgmm0xytCpIIuZpYoqVdd7A6S2xfCPKDRj0Y5XB8aBf7ULuBr6nypNF+rma788gKy2r8xMNWZMWep/UU+7q8MjBb0zg3AsSjmkTC5dyOYA4KfT9BZG86PvDMub8q7bepwsYA1UpWbX0ot4LMCWresLeSL1fkO3mlS8ocxcmej5D7Q6BekoSKeSRbwXIkuP1cE/cU8OVgGW3TWqJiayk52CVgl4EJZQ/v6flMeeLhFwCtxchcFHdR4QzF+fz+FoZfsWxbhztlK2uomkq6M8233NFinlcwVUKszBqoFXCbg1gCP90eI6rW66gW8kcQUzIJyM8HQxgg2h4MHZ0r4tKuYO6cr2bIgTm2lOuxWx3UCvmABpwu4Srbo0N6OR9k820c0JBtdU9JlJV+J8WgoRajQxdvLtcsbig/KUrcm8ObyCVxaXw47FG/2kk27x4BrBOyWNfrC/HoiTnHMxdFVQf66kuSHgTh1VT7WzPbz5GoKLqr4VjE3e0o51qYdHpsIGzRhi4/szHHgagG7gpiHtAs9wr334mxe4Kc57WHT/ADXOgS5PtbxzRSfHyplsEOwS+U86pR12jWdBXzRAlo7XCngDhn4gGxyXMWXtberCf48H8McSmh82eSixv84yWf7S0jGPLw6L8yG2ij3tyu+QTtvFlAmHwWyVC1v1i17ZOJ++U52YVCywJcE1eOM6qME90+lGDmS5PbeBHd7ktCjPGtldT4eVOtRTso2NMqH6/U3s8Y+GBo1c+6cPHghb5t/Zb245ckzUr8eZo/y29XdMgFf9vKwUsC3pjq/+nm2m7sNHoZbfQyr/eEd0hsBhvcGGd4vHRjTPn17pS6dbfIzoj/DSIuXkRoPP6q77yY7+Qdk0k40kRlX/QAAAABJRU5ErkJggg==', 
	@IMAGE_BYTES_INACTIVE=N'iVBORw0KGgoAAAANSUhEUgAAABQAAAAUCAYAAACNiR0NAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAN2SURBVDhPnZTHSyZREMRHD4qgKIoIgghexIBixIAYMWJWjHwGECMGzH7mgDmLWcyKEea++7f1zq9lBnaPe3jMMO+96qqu6jESEhLcaWlpZkxMzH+vqKgoMz4+3kxPTzeN5OTk3w0NDXJwcCCnp6dycnLirKOjI323vx8fH/+1b5+9uLgQt9stpaWlYiQlJZk1NTUyOTmpH2dmZnTNz8/L2tqa9Pb2Sm1trYyPj8vq6qqesZd9dm5uTnp6eqSwsFCMlJQUs6KiQsrLy51VXV2t1cLCwiQuLk5SU1MlMDBQLGmCmn/P23eLi4t/ACsrKwWQuro6aWlpkebmZvHx8ZGysjLp6+uT7u5u6erqEi8vLy3U0dGhZwBHHfcBdQCRxCZgAISGhkpERIRMTEzI4OCgDA0NaUtgGxwcLMPDw9LZ2Skul0uampqUCKwVEIf5yCZM6uvrxcPDQ9rb22V2dtbp19LSkhQUFOhef3+/FuI85yACaElJiRhY3dbWppJofHR0tHh7e8vy8rKasL6+LhsbG7K7uytFRUViGIaMjIzI9PS0MsU0WgApZBuZmZkmYFScmpqSgIAACQ8Pl/39fV2Hh4dCfIiGXrAAAVtZWdEn4DgMKXwwsrKyTCTQIza5gLTLy0s5Pz/X5/X1tTw8PEh+fr5KBmxnZ0cWFxeVBEwhhWwjOzvbBGhhYUHpAwiTx8dHub29VSDeX19fJSQkRKN0f3+vhQg2LRkbG9O+NjY2/gDiJv3iCWBVVZW8vb3J09OTrpeXF7m6uhJPT08NOUB5eXkSGRmpxsGUJGCOYW2YJJ5K9MzPz08T//n56QB+fX2pJADPzs5UImNICzAR+aOjo5oUw/poMjqbm5vKwuqp+Pv7y8fHhzKDKZJ9fX2VnV3o+/tbQ00euYs6IqSAzO329rZWp3JQUJAG/fn5WX8asbGxkpGRIe/v78oaMBi1trYqCSKGqcTHYbi1taVgmEBM6FFiYqLk5ubKwMCAMoMxYChiojCKHwiuA6gM6SGNJbwA4R4XYXNzc6PvyIcZ3+g3CiwzJScnR8FhiGSyqIAElErII3t3d3cqFzCettswwmHawyiy9vb29FfnmGJVMckR1tuyYQkoZthg9tPOJ5MDAeTCmtjwBzKsZv/CKQad8WOeOUDQ7XmGvd0rWNEie7LoJffJIPn9Aw0ucX9vMT4HAAAAAElFTkSuQmCC', 
	@ORDER_INDEX=5,@ACTIVE=1,@PUBLISHED=1,@PATIENT_OR_ROOMBED='P',@IMAGE_NAME=N'Oxygen (Patient) (EM).png',@ICON_NAME=N'Oxygen (Patient) (EM)',@SHORT_DESCRIPTION=N'Oxygen (Patient) (EM)',@LONG_DESCRIPTION=N'Oxygen (Patient) (EM)', 
	@COMMENT=NULL,@MOUSE_OVER_TEXT=N'Oxygen (Patient) (EM)',@FACILITY_UID=NULL,@FACILITY_ICON_NAME=NULL,@FACILITY_DESCRIPTION=NULL, 
	@FACILITY_COMMENT=NULL,@FACILITY_MOUSE_OVER_TEXT=NULL,@FACILITY_PATIENT_OR_ROOMBED=' ',@FACILITY_ACTIVE=0,@FACILITY_ORDER_INDEX=0, 
	@ENTERED_BY=N'softinfo\bmsuser',@ENTERED_DATE=@DATE_NOW,@LAST_EDIT_BY=N'softinfo\bmsuser',@LAST_EDIT_DATE=@DATE_NOW

	SET @P1 = 0
	exec usp_Insert_Icon @ID=@p1 output,@ICON_FLAG_ID=NULL,@GROUP=N'WHITEBOARD_ICON',@SUBGROUP=N'SITE_CONFIGURABLE_ICON', 
	@ICON_TYPE_CODE=NULL,@ICON_TYPE_CODE_SYSTEM=NULL,@ICON_TYPE_CODE_SYSTEM_NAME=NULL,@ICON_TYPE_DISPLAY_NAME=NULL, 
	@IMAGE_BYTES=N'iVBORw0KGgoAAAANSUhEUgAAABQAAAAUCAYAAACNiR0NAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAASVSURBVDhPhZN7TJV1GMd/HM7hwDmcc2BWeMELiDFFLZ2lGQpyk1tyURERPBIImKJ5SW3KvEEskeVc0spmapEmy/VS6kpNpjhT8xKKoqVuNi+laSJucjl+el6YRrrqj2fv7/2939/n+T7P83tVVqhhyeo8o1aS66kV53QOs+x5a2vnBmhbVz+jbSnpqpXP7iUai4T5KW1prllbnmnQ1Aqn2sdVf7iRANfi4KrEtbES8fBbEtyMprZyBad3zoc7kXBd9to1sR369qdob0Zyq9aCWpVt0LhgxnXeQes5u4SN1gZfXBeehYsGtr2Ty6vPQWzQbQ5uCYfLRtrO+4lO9A2ilTMtZx2it3HxWxNqhQ5scKf1rIHm04rmM/raysOfFTvKEgn1ayRfTEweAWMDL3GkMgTkW0u9Nw/qDNw/5UbjcQNNp9yp1x4DjQJxF5hJMvrAL4rd70cyxv8PUgbDjHiXQF3E9oXkkHpOfhkkLhX3Tvlw+6iJ3w+buHXExIkqj0cOdaBRrPu2w2o2Dic64DrJAyE30kVCvzaSQtrIi3YREwgThxwTaHfunnTnxmFfruw3caXGg0OfmXWgm5QsfWkQZ1LK4cpBxD9/idcGwPQoF+P6txEX2EasROpggca4JBlkDK/h6PYu/HrQxIXvfDi328zeDe1AfSh2GYDipx2B4qSe+GDa3SQN6ADFB3WEvp7wQofTyN4wNXQnBz61UfeNBye+8qF6nQCL860alxXnd/UgbeiPxEif8sVFysB/wjpD04a2ifuHjOkJ2eFfsOtDT2q3ebF9jQ1VOsNNu7KvG9NC9xMu11Hv2XgprbOzR7DO0PRhbWSHPSSsm35mA1VrvdlU7IkqL1Ta5mVOXrRBYnCzlOkiru/fZT4Je/Sua5JD9Mk3M7LrXUpmvkLFUoVaLkM5XuVH2stVjPRrEljz4579G6xj3yX38gGh3e4wfngZZW/ZePdNcViUZdBuHFJ8XeFHwqBqETSJuOV/oHoVDxjV/U8Sh6xjaYEnZQs9WJbvjVqSadSuHfDgzE7F5pJeRAfvYXSP/4bGBTWL5i5jB25kQbY3KwuNFM+xs8gpwEWTjNqlPWbqqs0c/FyxdmEwY/rWyoB0aOtTTnVYuH8jUf23UpjRRdy5U1RgZ0menTnpMuX5aUbttMCObPekZosn2geKZXlDCOt9jIhe95+AtshVuUdEv2ryJnRnUY6BxTkOFkyzMzfLQUGqAGenGrUftnrx/SYvdn/kxY51XnxSqiRbKKN61hHVW4fqQ2iVBE2EB+5h2rgA5jndmO90MCfTwcx0BzPSfMhOtKNmJRm1vRu9qK6wUPWehcoyKx+vslC+WPF6Ygyj/BuI6tMof8Y9wgJqmRI7gFlTFLMzOkD5Ex3kpAos2ZfMWAHmJxq16gor28qtbC61smGlN+uLvFmz0ErRG4r0iBRCe1xkdJ+jTIoaRkG6EpAPBeIotx3kg3OcL84kHehATR5t3Lv+bQtl87woKbSwvMDK0ulWFmdbmZthITfFQNKIaJJGvkRWgsKZYGNqvJ0McTM5xk56dEfo60kRNv4C02ecM1DMOyEAAAAASUVORK5CYII=', 
	@IMAGE_BYTES_INACTIVE=N'iVBORw0KGgoAAAANSUhEUgAAABQAAAAUCAYAAACNiR0NAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAMtSURBVDhPjZTZK29hFIb33+TSTOZ5nkLmmbggdZIoZIiQIZEpGUpsZUiGMkRmV24M+Uves5+l34lzjs65+Nq7vdf3fO9a612fExoa+qOiosItLS3962psbHS7urrcjo4Ot76+/ts49hcUFLhOYWHh4dPTk15fX/X8/Pxlvb29ibW2tqbd3V29v7/r5eXljzj2EXdwcCCnqKjIvbu7E+vm5sbW7e2t7u/vbQ0MDCggIECRkZGan5/X4+Pjl1jir6+v7dvm5uYHkI9XV1e6uLjQ5eWlBQAdGhqSv7+/ysvLlZOTo/DwcC0sLNhmX/zZ2ZlOTk7Ec3V19SsQGHA2jI+PKzg4WMnJyaqsrDRoVFSUYmNjtbKyYnHn5+c6Pj62VI+OjrS4uPgV6JM+MzNjapKSklRcXKyYmBglJibKK7ylzvvy8rJOT091eHio7e1t7ezsiH2/UiZFlJESmxISElRSUqL4+HhTxjfUlpWVKSIiQqmpqaZob29PrutqfX1dY2NjH0BfA6gBakgLNUABRUdH2+IdEP/IICMjQ9PT0+YCFNNABw8+PDxoY2PDUkQNKnj/DPsMTU9PN/VhYWHKzMzUyMiIZmdn1dPT8wEkf354JreapaSk/BX2GUq852FrXHZ2tvr6+tTe3i6npqbG7e7ulp+fn6VKmqj0bf7uSQzN4Ym1vClSS0vLRw2XlpYMxI//gX1WiukR4o2o6urq5DB/+/v7Gh4etjQDAwP/qQ4gBxNLx2kSQGrv5Ofnu7SeTnV2dlodg4KC/gklhqZ4glRVVaXa2lp7d7KystytrS0bGyzQ3NxshQ4JCfkW6vvPOKIOZTxpjgGBMfhTU1MaHBy0E0kHtb83hYNQh3XostcDU5aXl2ceddLS0ty5uTlNTk5qdHRU/f391n6vFHbLYGAflAM4CI8CICY3N1eeKDM5U+V44+ROTEzYzdLb2yvvMlVbW5uamprkHfYLSr2AxcXFGYB0eaIU33IIU+Z4dnGB4XLvVjZYa2urAakNAOwEjA0AfIp8ICyHJw3o1eSARjQ0NKi6utquKcaK+qCCk0mVxQYOwHc+62A1FjaiPD8ByMKSGUwUBtMAAAAASUVORK5CYII=', 
	@ORDER_INDEX=6,@ACTIVE=1,@PUBLISHED=1,@PATIENT_OR_ROOMBED='R',@IMAGE_NAME=N'Blue Diamond.png',@ICON_NAME=N'Blue Diamond',@SHORT_DESCRIPTION=N'Blue Diamond',@LONG_DESCRIPTION=N'Blue Diamond', 
	@COMMENT=NULL,@MOUSE_OVER_TEXT=N'Blue Diamond',@FACILITY_UID=NULL,@FACILITY_ICON_NAME=NULL,@FACILITY_DESCRIPTION=NULL, 
	@FACILITY_COMMENT=NULL,@FACILITY_MOUSE_OVER_TEXT=NULL,@FACILITY_PATIENT_OR_ROOMBED=' ',@FACILITY_ACTIVE=0,@FACILITY_ORDER_INDEX=0, 
	@ENTERED_BY=N'softinfo\bmsuser',@ENTERED_DATE=@DATE_NOW,@LAST_EDIT_BY=N'softinfo\bmsuser',@LAST_EDIT_DATE=@DATE_NOW

	SET @P1 = 0
	exec usp_Insert_Icon @ID=@p1 output,@ICON_FLAG_ID=NULL,@GROUP=N'WHITEBOARD_ICON',@SUBGROUP=N'STANDARD_ICON', 
	@ICON_TYPE_CODE=NULL,@ICON_TYPE_CODE_SYSTEM=NULL,@ICON_TYPE_CODE_SYSTEM_NAME=NULL,@ICON_TYPE_DISPLAY_NAME=NULL, 
	@IMAGE_BYTES=N'iVBORw0KGgoAAAANSUhEUgAAABQAAAAUCAYAAACNiR0NAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAVKSURBVDhPPZR7UJRVGIe/XUA08pI1NeV0G8spp+lizdSU02T30rIgyqamMEQrSyuDhkBgF5C4FyWVXdGo7KJShghncXdZFliRFVhpFcQA9+p+y64tGAg8Hazxj2d+73vmfL9533PO9yoDrqHi0bF/RFhVxWhAFSM+v4gEgiKohoQ/FBaBkF+oIY8kINTgfwRVn9zvEuHAkPCH5VokIE77e4VxX7VQvN5gayh8lq6uQbo6fdjtp+joCtHePYzNMcxBxymJX8aqVJV2SYfM7d0e7A43th4ZO08y2N/P9s/LUUKBCWFtGWBjejVr0+tYk9lKUnobye9bZN5ISrqJNekWqU2kvN/E2owm1mWYpZokZpLTBW9l72FvrZ3SQmkYDowLS6uHl9N+Z8WmwyzPCPB4ukr8e0OsSjvKc6knSEwd4tm0vyQyTusnQerTaYOsfM9NfNoxXkw18kvtCcrLv5quMCKMssKk7Ebi8/08VgCP5UOCPsTqPBev5KmsKYywrihMSsEpkvJ9PJ+rkqgfYWXOPyTohknSO/i10UfxR1/ICsOnhaHlGOu2NLKqyM2TRWdILBkluczD6uw2EjbuZ8XrNTyx7icS3tzFqtT9JBc4WVMa5IXCv3mmwE9y8RF+NXr5oPxTlEDwtGhsPc6G/HpeLetn7SdBUkoHeHr9zyy4Ph5N3E0o0degaK9AiVlA3PzbuHbJahLfqeXtT7y8UuFm7Ydd7DK6KS77GsWnjgmDdZD04kZ0X5xkY1kvV926iRlzl7LsoZeZd/EVaBSFaK2CVuqiRYu5YfH9aOPu4eGXviW1ys+mbU5qDngoKapC8fsmxYHmIfK2msn/spvrbn+NOfPv482MKpYufwONZhaaKC3R0dEomhjiLryMlDfyWPrQa7LyJTyzYQfl3ztosMgKi79FCarjosHkpKK6hQdW5TBjzhIKPq6hZFsdMfNuliZx0jBKEotGG4eizGLZo0n88IeDZcvfJmb2neRXCkw2N4XF8pZ9flUcaO1m609m2cJmtLNvpLByJ5U7apgxe4E0iCJWthur0TJDM1PmMTz+ZDLC6uKBle8SddHdFH1tocnulWcoDYOhkLyUTip/bmK7oZdFdz7F3EsWsjm/nPtXJEoDhTjJBdPnqGiZN+dysnWVLI/fiBK7mPW5O9nV7MFwcJAtpZ9Jw0BINDR1sq2mg9/sEarqe7nprpXMvPBKlj6YwNw5FxOjaJipjZHnGcWtt93LLUseQRu7kPWZX/FbR4jdNi+mLhd5pVuloU8VwtzJN3VO9vZMse/IWXbLdl7aUMD8a+5AO+tSWeV0q5KoufL2r+aOZc9RUtWAoSfC3u4wdT1hTI6T6EsqUEaCPmG0tlNtPMr+E/D7sUkMfeO0DI6x03KUil1miqvrKf2uloqd9bITCwbnMJbBCfY5R6g9NoqhfwSTHBA5JWUoEVWOHauRH5sdyL+HPwYnEUMTmIbO0OI/izXIOdpUOBiQ6gfjwDgNA2PUS90vsbjPYunzoCuTw8GnBkSd2cLeli7kxKLNO0Gr3GDzjGFzn6HZPYHFK009U5JJWv7X6fXp3OYdx6HKb3pdZBXJCn3BiGg62El7Tz+eUegNTtEXhr4Q9EuOn2OK43Jtmj4Zn2d4kr7hCYYiUxw+7iKnsBTF63IZ/nQ6MTW3YbX3yPfkxNjhxHzoT5oO9WA91ElLu/08rR2HaevoPIfN3oXZfkTud2Cw2sgt+ABlz49VzZ9/XIZel01Wjp5M3Ray9FvI1ueh0+nJ1WVJMs+jz8lEn5PxP5lk6HLJ0OezOTtbemTxL8hHYGzRr9hvAAAAAElFTkSuQmCC', 
	@IMAGE_BYTES_INACTIVE=N'iVBORw0KGgoAAAANSUhEUgAAABQAAAAUCAYAAACNiR0NAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAANkSURBVDhPdVRJKP1RFP4ZEmWMLC3ZWBmyVYpIWSgLC1sRiWSeZ54xLESGyFDsJOX9KTyeecgUMsssrOw+7zu/7vs/ZPF1z733nO9+59xzr3Z9fW34/Pw0vry8GF9fX7+NXFNQe7Zryn5/fzc+Pj4ap6enjdrDw4P54+MDe3t7gt3dXaut1n6O+/v7Vh/ah4eHOD8/R3d3NzSevLq6isLCQhQUFKC4uFhGzn+iqKhI9gll07esrAwWdTAYDP8Jc3JykJWVhfz8fOTl5X1Dbm7urznXCMYRJGxra4PGOpjNZjm1vLwcFRUVciJRVVWF6upqNDQ0yOl1dXUypw99S0pKUFpaKvbs7CxaW1uhsaBLS0uorKwUZ5LU1tYKAQMyMjKQkpKC5ORkpKWlITs7W/y4Tz/GcZybm0Nzc7OucHl5WYjoxFOoKDU1FQEBAXB1dYWTkxMcHR1l9Pb2RlBQEDIzM9He3o6mpiaJI2FLS4tOSIVc5C3RgQFeXl6IiooSAk3TYG9vDzs7O/j7+yMwMBDu7u5ISkpCT08POjs7hZCxGvuHhFwkYUhICHx9feWGY2JihIigQhK6ubkhPT0dkZGRcHZ2ljIMDQ3BZDLphGyb+fl5DA4OIiEhAZ6enpJKV1eX2IrQwcEBBEmjo6MxOTmJ2NhYeHh4iBi2XmNjo66QNRweHkZiYqIo6OjowMDAgNSP6SoyRRgXFwdmxZGlYdqbm5t6DamQmyMjI9JLoaGh8PHxkUtiyraEVEfVvNn4+Hi4uLhIezHDlZUVXSEvhQsTExMie2pqCmFhYaI0IiJCUrKtIS8sODhYyFhnErF+W1tb+kthyiRkTba3twULCwtSbD8/Pyk8lRFMmbcbHh6O3t5eefcbGxvWOLab9vb2ZuQJMzMz8sjpdHBwgNPTU+n+0dFR9Pf3o6+vT25zfHxcfLi/s7Mjtoqrr6/XU15cXJRg/hjcPD4+xsnJCS4vL3Fzc/MNV1dXsn90dGTF2dmZiBCFz8/PRjYl07y/vxcSEl9cXMiobM5todbpf3d3J4R8gqKQheWfx3/RUlNYDvkFix8I272npycQlrKJaiG8vb39R/lMmwVeX1/H2tran+A+/Qj2HufsDsbX1NRAGxsbM7GR+QWpb4v2X1A+auT3RZs/E2O+ADBBQ2K/xchNAAAAAElFTkSuQmCC', 
	@ORDER_INDEX=20,@ACTIVE=1,@PUBLISHED=1,@PATIENT_OR_ROOMBED='P',@IMAGE_NAME=N'Observation.jpg',@ICON_NAME=N'23H Observation',@SHORT_DESCRIPTION=N'23H Observation',@LONG_DESCRIPTION=N'Observation of patients admitted less than 24 hours', 
	@COMMENT=NULL,@MOUSE_OVER_TEXT=N'23H Observation',@FACILITY_UID=NULL,@FACILITY_ICON_NAME=NULL,@FACILITY_DESCRIPTION=NULL, 
	@FACILITY_COMMENT=NULL,@FACILITY_MOUSE_OVER_TEXT=NULL,@FACILITY_PATIENT_OR_ROOMBED=' ',@FACILITY_ACTIVE=0,@FACILITY_ORDER_INDEX=0, 
	@ENTERED_BY=N'softinfo\bmsuser',@ENTERED_DATE=@DATE_NOW,@LAST_EDIT_BY=N'softinfo\bmsuser',@LAST_EDIT_DATE=@DATE_NOW

	SET @P1 = 0
	exec usp_Insert_Icon @ID=@p1 output,@ICON_FLAG_ID=NULL,@GROUP=N'WHITEBOARD_ICON',@SUBGROUP=N'SITE_CONFIGURABLE_ICON', 
	@ICON_TYPE_CODE=NULL,@ICON_TYPE_CODE_SYSTEM=NULL,@ICON_TYPE_CODE_SYSTEM_NAME=NULL,@ICON_TYPE_DISPLAY_NAME=NULL, 
	@IMAGE_BYTES=N'iVBORw0KGgoAAAANSUhEUgAAABQAAAAUCAYAAACNiR0NAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAARpSURBVDhPnZN9TFVlHMcP9577/nKwF2vOaTVqqy17+YeJ+IIGJoaQL5kSXREQuqKCQoHgOyDKEDNkqDOnSRYz19WSfzCcC8PyBRHu5QqImTp0tZZzLZ366XeukDT9o/XHd+d5nt9zPs/3933OUVInGIo2fWDwrU8Xpf1/lS8w+Eo8Bp+yIdNwhMsqdInOi4JGGYt6DPelrw2WXu/ur+v7zuuSPRdVbrSoKJXZBh+9Knf8KrfbpdBtkqKFm62Pc8uvwSWFu50mbncYuRMwyzyMe11O/uoYKmM5UIzcOqfKHpUrTTrQK8CeAZjK9R8eoyI1j4yob1gUU8eBsnjuBg3cCZoEZOTbTbEUTqsmN24f1V4v145rAle5ecZET4NJgJKfDrwrrfxx2ox3XBWxT10j+bVLzBl1lYlP9LItJxn6FD7Nn82kJ7uZ+2ofnsirxD19De/4Si4fs/D7SZWOr3Vgv0MuKuxbPZnR9m4SRgQY72xlUvhZEp/V58fZv+5tEkY2k/hcD28MORuqJz4TYIyjh5rcqVz/UeFUvbnfYa9R8lJYElvCGNuF0AuTRBMFqI/njgqyLEGcvRwMzSdq9+u6xjoukB69Hn9DGM17Bhz+bODXFiOzXtrDOFfwn80D0MlD28SlH/2pHzIA058T3EGSnt/N0b1mGncMAvY1G0mKqJMTO//1wgA0xt36EEyvjXd2Ej+yjkO1Vg5u0VvWM7xo5MYZhfmjy4k0nRdg20PQwa4ejNsYY+1i1itlHNhq5PNy66DPJiC3WBTN68ZTklHHfwBK+5qfSOsJPkqOon5LGNtX2FEq5LO5FzBx47RK73cKi+MzBXpGsvHLBTzaqb4eI/VI60+kjE2hdk0YO0scVOU5UPR/8M9WE33NZq4cM3Lap5A/cwaR9iaiHYFHQNsk5wBR7gbS4qbwcXEYW8VZVaGL0oUCLE1Tfb+1mLnQaCbYYMF/2MSJ/QobF40idvhOoqx6++f6IzhHtF3mw2tZOvcFgSlUFTgoz3VRssRFcZoLZY1H9f3SZKH9kIVTByy0fGnl+zorTZ8p1K7SSHixlChbuzhtD8HejFhPcaZG1fIwNix1sTbbxYosN8sz3CxLFuDKFNXXeVhA9VaO7bXSuMvG4e12DtbY+arawOZCC1MiKuT2u4gbuYWiBU425qusW+QWkIuCdAF53OSkaGTPdKMUzlZ9J/fbOBIC2fBV26ivslO30cGuMgc7SgwUpI4gZlgN2bMiKMkxslIc6aA8j8aS9zQWvquR9U44GYkCzJuh+o7utuPban8AKnWwbbWTT4qcbPpQws6xkff+MIoy7RSma+JIQMkaXgFlztRImx5OatIQPFM1lNzpqq9hm4MvKh3sLhdHa51ya04J28mGZRL2YjervG6Ksuzkp/a3Nic85Cg9BArHM01gonk6MCPO1LhXHNUst7M530FFrpOybCdrspwUpzspmOciL8VFzhy3tOwma7qbjCSN+QlaCKC78sTL+C1Zm+Lmb2d3cUPEWpNMAAAAAElFTkSuQmCC', 
	@IMAGE_BYTES_INACTIVE=N'iVBORw0KGgoAAAANSUhEUgAAABQAAAAUCAYAAACNiR0NAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAANYSURBVDhPpZRXS2RBEIXvv1FQzDmjgmDOOeeAOTuYFXNABTE9KCoiBkZBRWZUTJgj/p6z95T0zOwyb/vQ9L1dXV+fqq5qLTw83FBVVWUsKSn5r1FaWmosLCw0auXl5ebv72+8vb3JeH19lfn9/V2GWre129rU/s/PT1xeXkKrrq428ufp6QmPj48C4f/9/T2en5/x9fWFl5cXsal/7uF+2njQw8OD7Dk5OYHGcLlBwS4uLtDQ0IDU1FRkZWVhYmJCNnPQeW5uDnp6kJ+fj/b2dphMJvG9vb3F4eEhtIqKCgHS4fr6WkBBQUFISkpCQkIC/Pz80NXVhZ+fH/T09MDf319s6enpCA4Olv1nZ2e4urrCzs6OVSHDHB4ehqurK8LCwuDu7g5vb29EREQgNDQU4+PjMkdGRso67fqFws3NDR0dHTCbzdjY2PhV+PHxIbIZIoF04PDy8pI5Pj4elZWViIuL+2tdgRMTE7G3t4eVlZVfhVTHE3i6h4eHBaigDJOqOatD1KGenp5iI2xhYcEKPD8/l5BUqMpBQen4L4w2CggMDMTs7CwmJyetwJubGwnNycnpL4W2YHvfTBEjI2xwcNB6Kayr3t5eODg42FViD0bFFKB3CMbGxtDZ2fl7KSwZKjw+PkZmZiYcHR3BEH18fOyq5Trtzs7OiI6OlrJiSTU2NkJjD97d3YE5PD09xfb2thQtT2ZJ2INy3cXFReq0tbVVyqalpUUqQeOjwO44OjrCwcGBXD/rqb6+XmB0tA1XlVVOTo7AmpubUVtbi5qaGhQVFUErKCgwsgd3d3extbWF9fV1rK2tYWlpSUIJCQkRKOGEBQQEQI9KQHV1daKK/8XFxcjOzoaWl5dn3N/fF9Dq6ioWFxcxPz+PmZkZ6WM6EsJ8+fr6iiPV6/UrIKrKzc0VWEpKCrSMjAzj5uamgNj4U1NTGB0dxdDQEPr6+tDd3S1OvAR9L/TXCWVlZRYQu4t9zZ5m2Wk61bi8vIzp6WkLiOVjMBjQ1taGpqYmyY8eibwyShFBaWlpSE5OBluPMN64AKlsZGQEAwMDooi3pnJERfojbHmyGBqVUpECxcbGgiMmJgZaVFSUqb+/X9Swjpho5odhMV8sId4o65MQ9awpAFVxEMb5DyHnhn9p6VGWAAAAAElFTkSuQmCC', 
	@ORDER_INDEX=7,@ACTIVE=1,@PUBLISHED=1,@PATIENT_OR_ROOMBED='R',@IMAGE_NAME=N'Blue Heart.png',@ICON_NAME=N'Blue Heart',@SHORT_DESCRIPTION=N'Blue Heart',@LONG_DESCRIPTION=N'Blue Heart', 
	@COMMENT=NULL,@MOUSE_OVER_TEXT=N'Blue Heart',@FACILITY_UID=NULL,@FACILITY_ICON_NAME=NULL,@FACILITY_DESCRIPTION=NULL, 
	@FACILITY_COMMENT=NULL,@FACILITY_MOUSE_OVER_TEXT=NULL,@FACILITY_PATIENT_OR_ROOMBED=' ',@FACILITY_ACTIVE=0,@FACILITY_ORDER_INDEX=0, 
	@ENTERED_BY=N'softinfo\bmsuser',@ENTERED_DATE=@DATE_NOW,@LAST_EDIT_BY=N'softinfo\bmsuser',@LAST_EDIT_DATE=@DATE_NOW

	SET @P1 = 0
	exec usp_Insert_Icon @ID=@p1 output,@ICON_FLAG_ID=NULL,@GROUP=N'WHITEBOARD_ICON',@SUBGROUP=N'STANDARD_ICON', 
	@ICON_TYPE_CODE=NULL,@ICON_TYPE_CODE_SYSTEM=NULL,@ICON_TYPE_CODE_SYSTEM_NAME=NULL,@ICON_TYPE_DISPLAY_NAME=NULL, 
	@IMAGE_BYTES=N'iVBORw0KGgoAAAANSUhEUgAAABQAAAAUCAYAAACNiR0NAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAATlSURBVDhPdZRpTFRXGIb52bRNmjRpYpqYlNq41dampqk26eJSjJhKghoWrVZEseBGFTeQZRhGKsuwKKDSolYtoEUvIrYCsg3DDOs4LAMzwyLbMOMgCJQdnh7UP630x5Nzzznvfb/vfPe7x6GtyxY4MT4qjViM0rS1Thq3N0j9A2apr69bGrH2S8NzMGCzSv32bmnI1i5N9XRKExa7ZOkfkXILSySH3l5bwcT4FCaDCVNTG4amTvRGi6ATg7GZRqPxFQwmM/UtzTS0GDE1t9BqbMHcbSYt/TIOQzaLpKs1cSgkg13Bxew6rcUnUM2+oHz2huQI7r2CX9B9fGWFeCsq8ArVsD80h+y/VCiVUTiM2juliqpW3E4U8O0JC+tPDuEa0MfWIzY2BQzh8l+ODuJ+fBRnnzoWfH6YRU5JuByzcTu7h+SEFBxG7G1SRW0rniEaNoRPskEGm4PBLXgG15B/szkMtsrB2d/Msq+OsHrPA1bsLmZjmJU7eU2kJMaKIw+0S5raZnwiVLifeYarQphFzOAZMfp87q4YxCNymO9jptkS1su2mEmWrDnOOo8L+CWAazS4/GzlVpGe5HNncejv75DUNU0cjCxiT8wTdipnBBN4xY7gLV72Vk6xR8xXb7vCws+2s9GvEMflrny3Owv/RNguDHcoR8kutpCUkIDDgL1HKq8yczRKxaGkYXySYe+FSQ78AocvvWDt9ot87RaP99kevCJbWbpyB8vX+BCQCQevwi5ZLX/cq+V84nlhaOuRyrQGghI0nLw8yrEbcPKmECn0bPROY3+ClUWfbhLBBjh1HU5ngMepUl57/U3W7kzBxf8uTh4KsguaOJd47kWGKk098kuVxN6H/YlmfJV6nLbJcFz8BUeT2nn3vY8JTOtDkQVyESxS6LYcTGPhJ+tY7SYj9Eo3+RU9xMfFzRpapIpqA7Lkh3gF/s6Xmw4wb/5iAhJreH/pKvyVGhyXrMTzpzTSKiEuF3yjyoj/c4oEYRyfBwk54+RVtKOMU84aWqVK3WxjX+Dtd+Zx+tdGVjrtICC2kPVuR3Ddq8BXnsXrb7zFlh+jcPGScyAql9TSCVILxkjJh9T8cQqqO4iJF20zaLeJIz/iWl4bG7bu4xsXH7wCUrhSNMyppCIWfrSKy6px/MKv4+zpT1BKMddq4Jp6jBuqMX4rhfTyGR7quoiOE4bD4kfXaHRkPGwlIrWA+Qs+JLNsmDwDQvyM+Y6LORR+FRGP3Ga42wB3qsVYOcPtKmH2CLLqh1DXdxEbEy8a294uqbVq0gtruGcc4YNlK4i8mk9h5xQ3a/qIzihBahgi1zQl9l/SPEGuYZocETTLPEVu2wDaphZhKDIc6GuTSrXFZJZoqRqB9e4/iBo6k9P6lELLDCVPoKBrirwOUfiX3O8a40GHWHsssu6aoKh3kEqjidhYYdhnt0tFZVqyy/TUPJ0hKaeUW7pW1E+mUfcwJ0XWacosUN4Nql6osk9S29xNdJT4yv32YXHbGCiuNvF4GNpGBX+D8SmY/wfDsxd7rX3QNKsZAoPZSsxZUUOb1S41iwtSpa2mQtf4nMraOoFePNfNSbleR3WtDl11HeV6PWWNj1BrVcIwEofMjPT8ixdTCA+XES6XESEPF4Q9Rx4xN+GKUBTyUM4IjSwilBBFiNAGI5eF8A+bvLPGk4LFGwAAAABJRU5ErkJggg==', 
	@IMAGE_BYTES_INACTIVE=N'iVBORw0KGgoAAAANSUhEUgAAABQAAAAUCAYAAACNiR0NAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAANOSURBVDhPjVRJKHZhFP7WbG0VVkgpJVaS2LEyZEiUYYFEMtRPZvKZpwWFTAvJ4mbm+0zJPM/zlGQMSzbPf5/zdS+/8rN4eu97z/ue85xznvcYLi8v/7y9vSl3d3fK09OTjsfHx3/2X220a9BsJpNJMdze3prf399xeHiIo6MjWX8Cz33GyckJVGLo6uqCgVE2NzeRm5uLnJycX6OgoACFhYVyLy8vDyMjI6iuroaBdFdXV5GRkYH09HRkZmYiKytL1u+QnZ2NhIQEeHh4wM/PT84NDw+joaHB4nB9fR08xGgaGPXznt/5+fnCKjU1FV5eXoiNjUVUVJTcHR8ftzh8fn5W1tbW5GBxcTGKiopk1cB9SUkJysvLJYDRaIS3tzfCw8NRV1eH0tJSMH21IR8MmbJ2qbKyEhUVFQJ+V1VVCSIiIuDu7o7ExES4uroiLi4OjY2NEoBnp6enUV9fb0l5ZWVFDDxA2kRTU5MOOgsJCUFZWZkE9vT0FJadnZ1oaWmRUgwODloY3t/fK4uLi6itrUVrayva29vR3d0tJYiJiUFNTQ3c3NzkcEdHh9jYNCsrK0RGRiI5ORmhoaEwm80fDBcWFoRNf3+/tJ71CgsLg6Ojoziys7MTJr29vejp6YGiKEhKSpLUg4OD0dbWBpJicF02TJeR/f39YWtrK0YnJyepDx2npKRgdnZWgrIRAwMDgqGhIQlAUrrDjY0NEbSNjQ2am5vh6+srjhid0mCNrK2tER8fj+joaHHIFMfGxjA6OipYXl7+EDa9U+mBgYEICAhAWlqayICycHFxweTkpLwG1oolmJ+fl64SU1NTwpxK0V8K86cwWUcHBwfMzMxge3sbExMTsLe3F2cHBwfyj49gaWlJakbwmyrZ2toSeUkNyZD0+dPZ2VkacHx8LEwoDUbf2dkRhwTP8f0T/N7d3RU7dSvDYW5uTlJUJYSgoCD4+PjIxbOzM5kidP6/CXR6eoq9vT0LQzpkDViPm5sb9PX1CbOrqyucn5//iIuLC1xfX2N/f18aqcuGXXp5ecHr6yvU9y1sv8PDw4NuUwcz1LKBM1EcclJzWLKOLDjBYUFo+6/rVxtlx/t8EAZV+SZqj0+N4HT5LbTppN3j1PkLcqCPZiHZzTYAAAAASUVORK5CYII=', 
	@ORDER_INDEX=9,@ACTIVE=1,@PUBLISHED=1,@PATIENT_OR_ROOMBED='P',@IMAGE_NAME=N'PICC.png',@ICON_NAME=N'PICC',@SHORT_DESCRIPTION=N'PICC',@LONG_DESCRIPTION=N'PICC', 
	@COMMENT=NULL,@MOUSE_OVER_TEXT=N'PICC',@FACILITY_UID=NULL,@FACILITY_ICON_NAME=NULL,@FACILITY_DESCRIPTION=NULL, 
	@FACILITY_COMMENT=NULL,@FACILITY_MOUSE_OVER_TEXT=NULL,@FACILITY_PATIENT_OR_ROOMBED=' ',@FACILITY_ACTIVE=0,@FACILITY_ORDER_INDEX=0, 
	@ENTERED_BY=N'softinfo\bmsuser',@ENTERED_DATE=@DATE_NOW,@LAST_EDIT_BY=N'softinfo\bmsuser',@LAST_EDIT_DATE=@DATE_NOW

	SET @P1 = 0
	exec usp_Insert_Icon @ID=@p1 output,@ICON_FLAG_ID=NULL,@GROUP=N'WHITEBOARD_ICON',@SUBGROUP=N'SITE_CONFIGURABLE_ICON', 
	@ICON_TYPE_CODE=NULL,@ICON_TYPE_CODE_SYSTEM=NULL,@ICON_TYPE_CODE_SYSTEM_NAME=NULL,@ICON_TYPE_DISPLAY_NAME=NULL, 
	@IMAGE_BYTES=N'iVBORw0KGgoAAAANSUhEUgAAABQAAAAUCAYAAACNiR0NAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAQRSURBVDhPlZR9TFVlHMefe17uueec+95mEKauRqm1Fm1RFtKL5bvdkEIo7CpvskmaoGCzGoiKoai7M1IKQwtEBC7PNZJ8QQFzrWZaTBQ2Z24ZsvKPNracpN9+z+WlNzbpj+/OOc95ns/5/r7P7zxscZy0rjRL4RszbHxDupA2opIsF9+SE8F3rormFflT+Id5D/CynChekuUdmq/+NTdD44WpEmdFfnYcV8cD1+YBP88Brs4Gen1A3yukV+n5Zdy44sP1yz70/0jjP5GuiXek3gRaQ/PFul9m4NdTBljxUomjR8OtbicGLrgw0HMP0DMBv3/vxb4TJuaGFExulDGpUUU0XeOaZJQe1dF3xg10R+KPnntx84IHt3rsuPSlClYkgBdlDHRJuNnlADp1nG23YHodA6uVEHn4fjx2MhZx7fF4vO1JTDoyBeygDdH7GYJHGW6fMdB/zklScJ6PABVyZxLMQEerjMhqBjXoxrS2WMSejMHEliiM+8KLqMN349HWhxHf8TQ8n0dA/pRhV0hG/ykd17914bs6q3Bo4ejWcLvLhisdCqIJZmnQaeFDGNfsBQuSU5JEsoj7RgbnIQOPtE6FM+SBuY+hqV5F3wkDp6spw3DJlCHOqshrkMA+YxjfEkEO7GGI2vRfiXEjZKXyo6h8GU99IqGz3obWj/WhTbmo4nK7igl7GWQK39vsgDwK6O9w8d5FTo2QDonW7a60omWHAKaTw/MqGpoVsCoGjYLVaWeVOwAFXGuSwk5ZDUN6OTGKh4E/qCgLymD0JWuTJazRSh1tTOMU0wGGFwIqKgtEHwqHlF/hgUHgWEEj8zhtFAGnbVMQeHNoUwa+saK0hoCVol3+P5RRT8ZvUvF+pgn2nl/iv31lRXUN5bab2qOegPTVMTulNhKV+dbaUPSGHWxdqsJ726w4XWPFgzstYKKpx7Ahw3Okg9RCAYbsTDsKXiNgwSKFXzqi4dx+DW9tp19nF4MiXN4JKqoQ7qixY1ZbsSbZiRXJBMxLUnhnSCOHNgS32fDE5sEsw1Cx6N/lD48JGFVz1wYJ/kQ7Via7kL3QAbZiocK/rtVxvErHoYCOwLs6phYTtILypLCFi3+4pWdZHByUm7tYQgLBsn0ES3Jj6XwnWI5P4cf26AiVG6jbbqBqvYnNKw1Mz6cG30qZfjRYlvglGR0GbA8BdzDcl6sicYEDGXNdSE9wIy3Bg9TZBFw2X+GhchO1ZSb2lpioWG9HoMCOTcvsyEwz8cxyDZNXq5i4lg6OXCtisjTMSTThn+VC2jwXlvjc8L/kgd8ngC6wlHjl2AdvG9iSq2MjNWZhtol3qJ/yl5hYlWRi+QI7MmbZ4Z/hwOLnHEh91oHXn3cgZeagkl90hpUy04lFNP4n35MPRH9wFSAAAAAASUVORK5CYII=', 
	@IMAGE_BYTES_INACTIVE=N'iVBORw0KGgoAAAANSUhEUgAAABQAAAAUCAYAAACNiR0NAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAALxSURBVDhPlZRJS2tBEIXvP4s4ETEqmjjFOCWaOIuz8Yk4QIxGESRkQFBREMSNvVEXiSBqgrMgmCwcfsp5fSpcFfXxdFH07brdX9epqm4jLy/vj9frVR6P54vR39PTo4aGhtTY2JgaHh5Wvb296l/rGxsbldHU1JTMZDJ4eXnB09OT2PPzM15fX8U4z2azeHh4wOPjo8zNfx/30JdIJGC0tLSo29tb3Nzc4Pr6Gnd3d7i/v0c6ncbW1hamp6ehI8TAwAAGBwcxMTGBeDyOk5MTWUvjPjL29/dzQDouLy9xdXUlo1IKWiJ0GmQMBAIIhUIIBoOYnJyEloy+vj5sb28jlUrh/PwcZ2dn2N3dfQeasL29PXR2dqK7uxsLCwuYn5+H3++Hzp/A5+bmsLS0JNG2trYiGo3i+PhYIuYBEiHlEnh4eAhdBPh8PtlIqfymdXR0iPG7v79f/nOkirW1NRwdHWF9ff09h8wZI+Kp4+PjkjMCGO1no19XW/LZ3t4u4J2dHUQikXfJBwcHb1FQznegzz6CCNYqJcfLy8swdESKcjc2NqBbSHJH2T8BdnV1CdDtdkt+Z2dnc8CLiwusrq6iubkZXET7CdAsXltbmwQyOjqaAzJ/i4uLAvwpyFzHwwlkLhmtVPn09FRaQV+dXwMJZqUpm/1p8P4lk0mEw2E0NDSI8zeSWXEqM81wuVzK7CGexLb5jWxKra+vh+bA6XTCqKmp0TdNyb1lpehk8/4PShWMji3jcDgEqlk5IO8gu9xsbOaS0O8qbvoIoxrCKioqUFtbi8rKShhVVVVqc3MTsVhMGtOMkvlkCj7fFs4pkznTe1FaWipAgvlt6IniBV9ZWZHXZGpqSnqqrq4O1dXVUijKYjQcGT2llZeXw2q1vgEJ5dyw2WyKML4qMzMz8jzxUWC1mRe73S5SaNyk18tGE1ZWViY+jgK0WCyJkZERed9YCMphT5mREFJSUoKioiIUFhaioKBARs4/WnFxMfLz8/EXV5m07fWdUBUAAAAASUVORK5CYII=', 
	@ORDER_INDEX=8,@ACTIVE=1,@PUBLISHED=1,@PATIENT_OR_ROOMBED='R',@IMAGE_NAME=N'Green Circle.png',@ICON_NAME=N'Green Circle',@SHORT_DESCRIPTION=N'Green Circle',@LONG_DESCRIPTION=N'Green Circle', 
	@COMMENT=NULL,@MOUSE_OVER_TEXT=N'Green Circle',@FACILITY_UID=NULL,@FACILITY_ICON_NAME=NULL,@FACILITY_DESCRIPTION=NULL, 
	@FACILITY_COMMENT=NULL,@FACILITY_MOUSE_OVER_TEXT=NULL,@FACILITY_PATIENT_OR_ROOMBED=' ',@FACILITY_ACTIVE=0,@FACILITY_ORDER_INDEX=0, 
	@ENTERED_BY=N'softinfo\bmsuser',@ENTERED_DATE=@DATE_NOW,@LAST_EDIT_BY=N'softinfo\bmsuser',@LAST_EDIT_DATE=@DATE_NOW

	SET @P1 = 0
	exec usp_Insert_Icon @ID=@p1 output,@ICON_FLAG_ID=NULL,@GROUP=N'WHITEBOARD_ICON',@SUBGROUP=N'STANDARD_ICON', 
	@ICON_TYPE_CODE=NULL,@ICON_TYPE_CODE_SYSTEM=NULL,@ICON_TYPE_CODE_SYSTEM_NAME=NULL,@ICON_TYPE_DISPLAY_NAME=NULL, 
	@IMAGE_BYTES=N'iVBORw0KGgoAAAANSUhEUgAAABQAAAAUCAYAAACNiR0NAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAT+SURBVDhPbZR7TNNHAMebJdNME5csbktclrhH4pYlMwvJnHMxc+oWFiUKiK+5hWyACwxUhIiClbagvK04ATWCrwlE1FMGIiCvUlqktLws0PKQp61loCBaRT47Jdv+mH98cr/c43Pfu/vdKXoGnPueuB+JyeFO8czRItyuNjE6ZhcjI4Ni0jEqJl7CmNMhRl2DYtzZK6aG+sWTYZcYHp0URRXVQnH3rrP8iXsKm9WGrb0Ha3s/zZ3Dkn6snR3c7uz8H1abndauTtq6OrB12Onu7MI+aCc7NwfFuHNYWMw2wpR5+O+vwj/GSNA+PdujywhUFhKg/JPA2BKCVKUz35LgmDK27y/BP7YCf6WOkAOFXC3RkZaWhOKRq1/UN3SzcU85q/cM813UON4RI2wId+IV6WbDfvDa6eD7kG42xMC6PU/ZHD6E324XnpEPWRHxmDU7e7l8dZCMI5koJl09ot7czRalAU/1UzxV4CMlm2PBP87BV547WPjh57z1zics/jYOzzArX67wZWO4Dh/NNKs0sCbWweVSK5npqXLJY73CYO4gKE7HpoP38Y6fxu8gBCV08dHHi/BYsowtMXrWRraw2j+LdxcuYs5sBVt3XycgcZJ1CdMSJxcrm8k4mohidLRP6BvbCT1USUDKPX5KmyYwE9Zu24dCoeCXvVcIOQUBWgg+LpNHlPPG67P5MaKK0MPwQzJsTX6AqBjkWPoRFGOuIVHXYGd3ko6wYxMESVnoWVi6yvuFcLHHUiK1FqJk3W9SGJoFq775gm3R1wmWEwVmQNhRB8WVPaRrnwudQ6LWaCU63UDU6UfsOg17L4JfwEzC57w9fx7rNwUTndGMugBiTvURccLJrpwpdmTDvuz7FNf0SqF2JmGtoQ1VlhFN/mNi8kBZME1yfi8eHp/+K50Rz2XrzztIFI9RXwJVnpuYXIjPH6dE34NWe/i5cFgYbrVxKNuAtshNgpCya3C0An4XvXj5+DBn1kzSf1ixcjkZxcOkFk6RXAhpYoKy+jukHU57LnQIfX0L2gtGTla5OXYTkgvukXamjOxaOGeAlOxCvNav57VX/5NGxadxtg4yS+FkmZtyUx8pWvnbPHA5ha7OQlaBiQv1zzjfAJozVpZ9Np/LNS3kGOFCI4g2SD8n+OD9BS+SBob8ytUmOFsDuXXT3LQMkHxYCifkRTcYLORcM3OtFa5IThb1M0emUSYcorwfCqTwogkqh+T+psjbIIUx6iRudEiZlF5qHUffOkBqijyUcVev0Bv1nC+t50bvFMV3ZCJDP7NnzWLe3FdIOpVH1SDUukB/V17FLb68t/BNis19FNukzD5FUc8YxvYuKZQJx0Z6RI2xivxqA5VyQKlzmjxzF8uXLCA6QcVaP1+8vL8mKDwE/wBvfHxXcsViovoe3JCTFw08keMecKvTRmqqFI64XKKy1oiobaLxL6h2PqOs7z7XG020PoR6OTCzoIzEE38g9BaaZJ/aB6CTy6+TyXV3ocH1FHPHIMlJ8pRHXRPytbFSbbLRJwUdo2C7Dz2TspSDu8ZgwA1DT2XdBNhlu1W222Vb9wi0y9I+LuvsDlIS5R46HS7RIR9IndFEveX2C26ZWyTN8rvlpdQ1WzCZLVhMLdQ1N1N7uwm9USeFh1Dk5+WWHT+eiVqtQq1REadRS2JfoIl7Oer4A8RrDnBQ9lHFHUAZr5R996NRKfkb4MuWT7H2+RgAAAAASUVORK5CYII=', 
	@IMAGE_BYTES_INACTIVE=N'iVBORw0KGgoAAAANSUhEUgAAABQAAAAUCAYAAACNiR0NAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAANoSURBVDhPjVQ3SC1REN1KCwsbOwu1EGy1sNdCsDI1goWgnYWCmJ8JE+aEYk5gFsVVML6POWcx54RZFMRCm+OeeezqF+H/4nDvZWbOxDvK+fm56f39Xb27u1Ofnp4MPD4+/vX+KaNchy4zm82qcnt7++fj4wP7+/s4ODiQ81+g3nccHR1BCwzNzc1Q6GVjYwMpKSlISkr6FZSlpqYaMr6Tk5MNUDY0NISioiIoDHdlZQUxMTGIjo5GbGws4uLijJPKUVFRCA8PF6cJCQkiJ2hDWWRkJAYHB1FWVmYhXFtbQ2JiohjoSE9PR2ZmJry9veHs7Ax7e3t4eXkhIiICHh4eQkQdRsrMRkZGLITPz8/q6uqqCEmQkZEhZ3Z2NlxcXODu7g6TySQEwcHBcHR0hLW1tbzz8vJEl7ZaQ74iZMpZWVmiUFBQIIKgoCAoioL4+HhUV1ejuLgYFRUVUhZbW1tJt7S0FLm5ucjJycHY2NgX4fLysgjKy8sFdXV18PT0FEI3Nzcha2pqQmVlpZAyZTqqqqoSEhJPTEzIqdzf36sLCwvyqK+vF7LW1laEhoYKIWFnZ4fAwEBx1tHRgdraWiHnWVNTIzZTU1MWQjaFhPTc1taGlpYWtLe3y53R6aQ6cUhICLq7u9HZ2SmOqU/dmZkZlJSUWAiXlpbES19fnyj39vZieHgYPT098PPzkyZ8J2Y5+vv7oaqq6FJvfn5eSiOEi4uLMuXsFInovaGhAePj45IKU/P19YWVlZVBzM5OTk7KQNOGQRmDPTc3h66uLgl7dnZWyFxdXaVzJKR3zmpjYyOcnJyENCwsDJwOOp2enpa7QcgaMnQacSaZDqPhKB0eHoJy4vj4WKaBhGlpadja2gKz45Rsbm6isLDQkjIjGBgYwN7enoAjQEIbGxuZQRJdXFzg7OxMuu3g4CBEJCTR9va23DnDshyY5ujoKE5OTgRMnT+EvyYgIAA+Pj7y5dhhf39/KQu3i76V6HBnZ8cSIQlZA9bi+vpaomCUrKsmw+XlpYwRx4qR39zciN7p6amA+ldXV9jd3UV+fv7XtmGXXl5eoA26EH2/v76+4u3tDdq/x8PDg4B6hLaYoZUN3IlCyE3NZal3Um8Mm8P7b/gpW19fF3vuAkX7SmYWnnNFsG7/C3076Xbs/Cd+ynhxhFSkfgAAAABJRU5ErkJggg==', 
	@ORDER_INDEX=10,@ACTIVE=1,@PUBLISHED=1,@PATIENT_OR_ROOMBED='P',@IMAGE_NAME=N'Suicide Risk.png',@ICON_NAME=N'Suicide Risk',@SHORT_DESCRIPTION=N'Suicide Risk',@LONG_DESCRIPTION=N'Suicide Risk', 
	@COMMENT=NULL,@MOUSE_OVER_TEXT=N'Suicide Risk',@FACILITY_UID=NULL,@FACILITY_ICON_NAME=NULL,@FACILITY_DESCRIPTION=NULL, 
	@FACILITY_COMMENT=NULL,@FACILITY_MOUSE_OVER_TEXT=NULL,@FACILITY_PATIENT_OR_ROOMBED=' ',@FACILITY_ACTIVE=0,@FACILITY_ORDER_INDEX=0, 
	@ENTERED_BY=N'softinfo\bmsuser',@ENTERED_DATE=@DATE_NOW,@LAST_EDIT_BY=N'softinfo\bmsuser',@LAST_EDIT_DATE=@DATE_NOW

	SET @P1 = 0
	exec usp_Insert_Icon @ID=@p1 output,@ICON_FLAG_ID=NULL,@GROUP=N'WHITEBOARD_ICON',@SUBGROUP=N'SITE_CONFIGURABLE_ICON', 
	@ICON_TYPE_CODE=NULL,@ICON_TYPE_CODE_SYSTEM=NULL,@ICON_TYPE_CODE_SYSTEM_NAME=NULL,@ICON_TYPE_DISPLAY_NAME=NULL, 
	@IMAGE_BYTES=N'iVBORw0KGgoAAAANSUhEUgAAABQAAAAUCAYAAACNiR0NAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAQkSURBVDhPlZRbbFRVFIZP5+wz9xsBNCEmxMQHX9QnH4zRmJiYWEAuEipUmCllOm0tlJa2tALlIrcCLbdK5GIEQwhBoh6j1AewWC8BRbnZUiilFWixKS1QKEzPFD/Xoa0+0Cg+/Nln9l772/9aa+/RMl5xLKrKcZhr5ogyh5Ty4Httlt9cnzfK3LRgrLll4VPm5qInzcq5o8118aDEK4nR/t6zNsthrow4TK0i7jjCVQVNogu2dLjoh5bRcPlx/mwO0V8fJHkqTPJsiPtNAfhd1lofk7jQP3taFT3HFFplnsOkRdHfoEjWy9gYxmoaRc9pD50HHFxfrdFdpnGjVOeGjNeXaXTult8/uUk0hek/PxLrNyf3G3Xaam1grgCbFVa9gdUQ4m6jj47DivYlGjdzXCTKn8ba8CLWllexql4iseJZevIC/FGk0f6pHHLGx+3TYXpPOWmuMQQo9bOByQYfvQ0e2r8SWH4KvfNH0r/xBZKVz2MtG4u1aDRW+RiS656jf8vL3Fs4ho4sjebdiivH3HT/HKL+c6ftMMXkkou+c26u1SkuL3BwZ67/wUYb0jdPG5Ac0pc/+F0SIFnxDImSUbRlp3Bmr8GlOi+/fuIdTLnFxc2zMrlZ0ZWpYy19gr7S8ACkQD0se77IS3L5WG7nuqgvURz/zM13H3sGgZcM2o4atOTr9M7zYJWNoG++Y3jY0AGybi0M0lcc4GrMQe1WF19+IMCqB00xaN4vtZijkygUYJFbYPq/A21woVNivXTFdWqXuNi7YRCYbDI4v0OaMVsghcaAhkt1mDlLoLdyFd/K+P4yqaHt8N45g/qtBu2Zw9TrP8CWrNvAb/KcVBTbTZFr03PG4GS1weUMRWK+3MlHdDeURXe2zhfZbpbm+dDWyRvs+sXg2C5Je7bizrxHB9oH3xMD7TGdHTEPpTE/2qpMZXb86KRun5PjYr0z/v+APXMVJ6OKxRE/xdEA2vKoMq/Uuqg7IG0vd3Jhls7tR3Bpu7ubP+Bu11tu4ulBCtMFWD5TmY2HXHy/z82+TW4OxQ1aowKVYKtwwO1Dknkb1im1q5luEJscIGdGiLypQbSyNGWeOOjhyEceDlZ7qF7swYwaXBRoV65cdNk4VPyE7UpqdkvSbJPL/PV0RfaEADMnB8meFiY2UYBFbyrz6B4v5jYvBzZ62f6ej5UFXnbNcvFDus7FDJ32LJ0OubzXRK3yNE+8rbNzipNIaoDpE0JkTg6TMWkEkXEhtIIpyqzZ7mN/pY89a3zsXOGnqtRP2Tt+Smf6WJ/m4cNp8gqmOdkx1cXaSW5yxvmZmhoiXWAZE8NE3hCYKGoDY68Zh/eu8rHtXS+bigVQ4Ge1/NssjftZIJ3LSgsQmRRghqSWlhok7fUgM2SMjg+SIQDbVUTg0fEhZsvaX/0KnQfCjkVVAAAAAElFTkSuQmCC', 
	@IMAGE_BYTES_INACTIVE=N'iVBORw0KGgoAAAANSUhEUgAAABQAAAAUCAYAAACNiR0NAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAALnSURBVDhPlZTXSmRBFEXvt/WLYgZFaTBiwtQiiiJtzjljzqgoKloPBnAG9UEx5//Zc9eRbgZ1GH04VN26dVbtE6q8QCAQLikpcfn5+Z+sqKjIlZeXu6qqKldbW+tqampcRUWFKy4u/rS3oKDA5ebmOs93+v36+qqHhwez+/t7PT096eXlRW9vbza/vb3V1dWVrq+v9fj4aOv48C/i8/z8rNPTU3mlpaWOj5ubG3MAyKaLiwttb29rcnJSw8PDURsbG9P6+rrOzs6ie/G7u7vT4eGhPMLlVBZRAvjg4MAA3d3dmpmZ0dramra2tgw0Pz+vvr4+s52dHTv48vLSxr29PXnkAyAwoPv7+wYaGhrSxsaGwWZnZ03p9PS0VldXDT4+Pq62tjatrKzo5ORE5+fn2tzcfFdILlB2fHysnp4e9ff3myOQgYGBT0bYgBiBLi8vW7gcbkByiGTCYwMjCoCh9KOxPjIyorm5ORPQ1dVlML6jCo+OjtTZ2WnqJiYmNDg4+CUsAuc/h46OjqqlpcVGLFoU8tXc3GzF4PSvlH1cYy+Qjo4OMwQZkFahehEgG78DZE+kG5qamlRfX/8OpLpTU1Mm/bugv/fRFcAqKyvf24aCUNHGxsb/5u6rAwnVv5byWeLqOXqIyobDYSvKT1RSnNbWVpWVlSkvL08ejwKNubCwYECS+xNgb2+v6urqlJOTo6ysLHm8EDTl0tKSnUQuuFbfgdKP+PgvjdLT0xUMBuX5VLe7u6vFxUVrUnLR0NBgof+r2qwDIxr/eVNKSooBU1NT5WVkZDi6nCqzCfmhUMjC5wZ8zCl7CBNlwJKSkpSYmKi0tDSbez7Vcfk5FYWoI8FUzH9Y7Zvr2N7ebiP9RhR+qhQXF2eWnJxsMOYG5JLTS5xK61RXV6uwsFCZmZnKzs6WXzj7porkCUUxMTEGYJ6QkGAWHx8vz//xC5D/xJsiwvUfXUs0QPKCE85AsNjYWHPGIioj8z+rJQxWNKoaBwAAAABJRU5ErkJggg==', 
	@ORDER_INDEX=9,@ACTIVE=1,@PUBLISHED=1,@PATIENT_OR_ROOMBED='R',@IMAGE_NAME=N'Orange Circle.png',@ICON_NAME=N'Orange Circle',@SHORT_DESCRIPTION=N'Orange Circle',@LONG_DESCRIPTION=N'Orange Circle', 
	@COMMENT=NULL,@MOUSE_OVER_TEXT=N'Orange Circle',@FACILITY_UID=NULL,@FACILITY_ICON_NAME=NULL,@FACILITY_DESCRIPTION=NULL, 
	@FACILITY_COMMENT=NULL,@FACILITY_MOUSE_OVER_TEXT=NULL,@FACILITY_PATIENT_OR_ROOMBED=' ',@FACILITY_ACTIVE=0,@FACILITY_ORDER_INDEX=0, 
	@ENTERED_BY=N'softinfo\bmsuser',@ENTERED_DATE=@DATE_NOW,@LAST_EDIT_BY=N'softinfo\bmsuser',@LAST_EDIT_DATE=@DATE_NOW

	SET @P1 = 0
	exec usp_Insert_Icon @ID=@p1 output,@ICON_FLAG_ID=NULL,@GROUP=N'WHITEBOARD_ICON',@SUBGROUP=N'SITE_CONFIGURABLE_ICON', 
	@ICON_TYPE_CODE=NULL,@ICON_TYPE_CODE_SYSTEM=NULL,@ICON_TYPE_CODE_SYSTEM_NAME=NULL,@ICON_TYPE_DISPLAY_NAME=NULL, 
	@IMAGE_BYTES=N'iVBORw0KGgoAAAANSUhEUgAAABQAAAAUCAYAAACNiR0NAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAATASURBVDhPfZN7TJV1GMdfznkv5xzOOVxcMcm1+sO2Vq1W6482a+uuhFMpDzfxcL8rKARDA2EINk1LZm7aMqysJtX2mpqUoSWK90sICgqWCaIS4AU8wDnn0+8F6eJmfzx7fvu9333e5/k+z09KmGZaujJd1qtSLfrylLtD01ek2vU1BVP1mtKn9FULpuhVYxrtLq2h0/TyeSZdqnBLP9E1BXregO4Z0DVd5DthnHtmi7sYaI6CayJ3R/5XM6aNEN9eprfRhlSZZNJp1/C1BTF6xvmvcOA9G8pgWzADdTaG8hT6m+x42kLFffC47uy4fqQ1CF+7g456BanCAJ41M9pqYrh5IgIYPm3G06JyuSmAK0XiHG/l4loTfb+aGBX3htYjzoMnTdw4ZuLWSTMt+t9AWQBlITLCPCYeabFw/bTChY9N9Cc78b3zJN1pMn/8YGbotMbQKXUM1HdY5mqTQu8hheN1qlFhgKhQ/NWoUACGW6xjbXjO2Og+YOZivqguIxh/xRPciJfpXCnTfVRh4HiQgDi5vF9Uvlfj4h6Z/Z+JCivFxDg/Ce+5+xk+F4an4z4GhR9/Nit0fWTierwJb/4kfIWTGc1ycDUlgPavzXSIAXQeCOV8YzhtDWGcawhnT20o0rvZIbq/PYyho4H01cv0firRu1qib6nEYK4db9HDeAvC8GaJwRU/yOjiBxjIVekqkThfLdG8TuZIrYVjdZOo3xiOVJ5h0m9+I3zKlhlMVfHkTmak8FG8ldPwr3kd37LHBMyCN92Md2EwvhXP4V9t3D/LaOFUPNkh3EwVNuTJbC0THpaJKff8InOmQKbHJYZT/BD+5c+IITwy1qo3UxWhjOcMkQ14YbgAPo6/8mmGc0PFmprZma+xdol1fG0GTsgc+1amKV3mkksMJ0XCmxYwXtUEbAx8B5oufE0TliRJdEab2ZKssbrMxvtvC2B5okm/fUrht30yez+ROehWuBKvMjIBuEe+na5yKU6hLkGlstDGumV2VuaLl1LqNunXjyhcblQ4sUNhV41Cc6LCYIqK73+gA0kqOwVs2QIbq4rsfFDioDwjEGnJPFnvaVS50KDSskOj/guVxkKFW/PvDTR+dE10UpNqpTTPzopFDqryHBS77UjF0bLe+aNGy3ZN+Kixc5PGIbEWg4n/AA3ARBg++jI1+kUXG9xWijIdlGU6WZruJC/GgVTgkvXmbRqHt1r4+XMLdTUWTqSJ9REt+7M1RgXA8Ou2sVIiG0C/2MmhZIXNcRay3E4KE50sSggiM0oAF0bJ+sEvrTTUWtm+wUptlZVW4c+IgA6JuDpfoTVW4UCMeNdiCP1J4nkK8EiqwtZoC4lzneTEBJHlCiYp0omUO0vWd2+y8t16G1vW2NhYYqXTrTIgQC3RYopvqZRFW8l22aieY+H7OSq/xyt4kmV2CWDcTCcpUcEkzw5h3nQBzIiU9W3rA/lqTSAbqgPZvNhKR4LCthiN8lgrOfMDWZjkIN/tINHlJCHSTmmEjX1zVQ7FasRHBJEwMwT3LAMYhBT7grz7wxIb7wlQRY6oItFKtctC0ps2UucGkuOykysi800HKbMcxM1wEPGig9nPB1LyqpXYlxy4XnES+5qTaHH+CyZAp6zBdxBlAAAAAElFTkSuQmCC', 
	@IMAGE_BYTES_INACTIVE=N'iVBORw0KGgoAAAANSUhEUgAAABQAAAAUCAYAAACNiR0NAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAANNSURBVDhPfZRlS2xRFIb3HzNQsBtR7O5g7Bi7u8VAUWbGQlC32M5VDOzCL34x8Je897xrOKJXrx8We58dz3pX7KM8PT2tmZmZOi0t7UdLT0/XJSUlurq6WhcUFPz3HO8nJCRolZiY+Ofp6Qmvr694fn7+Zlx/eXnB4+Mj3t/fZf7Tube3NzidTqjk5GR9d3cH2s3NzRe7vb3F9fU1VlZW0NPTg4ODA9nn+uezPMP7a2trLiA3r66ucH5+/mEXFxe4vLzE/v6+wBobGzE5OYnT09MvZ/l9fHws60tLS1+BhNAIpoOzszPMzs6iublZYISur6/LGe4RdHh4KKFSvd1u/w6kKlPx3t4e2tra0NnZienpadTX12NkZEQun5ycCIwRbG1tYXNzE1NTU1ApKSn64eEB9/f3kgeOBDIEqqurq8PAwACGh4fR3d0tKhcWFrC9vY3d3V3s7OxgY2NDgIxC5eTkaELokYvz8/OyQQgBo6OjGBoaQldX18e8o6ND8jo4OIixsTFR5nA4ZF+xf1ZXV9He3o7W1lb09vZKWDMzM1hcXJTDhBHS19cHm80mCpkCnqPTlpYWuc9oVFJSkqZswqqqqsQLQ52YmBCVhJnGXHLO8OmITqmU92ilpaWuojDcubk5VFZWoqKiQuD0SFWfgZwTynXus/rl5eXIz8+XsaioyKWQLcAkj4+Po6ysDDU1NXLxX9jnbwKN54i8vDwYT1IUclR8f0dHR1IxNibzRKVU+RuwqakJhYWFyM7OFmUM13j3ULGxsZr9xtIvLy9LhRsaGqQ9fgOyJwmjURmVGuKgoqKiNLufMOaRRamtrZX8/Aakw6ysLKSmpiIjIwNGtyA6OtoFZKhsB7NFmBuGzAoyl8wXXwxHOjFbxfjtISYmRpQZkSI8PBwqIiJCs01YEDYqQyHQhLC3WCiLxSKJpzKzylQYFhYGQxQiIyMRGBgIFRoaqtnt/f39ooJtY7VaJY9MNFXQOy9QDSFmBMxbQECAQENCQuDn5wcVFBSkCTM7nWp4ITc3F/Hx8QLhGBcXJyERYEQlhSguLoa/v78oCw4OdgE9PDychLAFzCQTYCgXAJXRCKEKX19fuLu7w83NTb69vb3FfHx84OXlhb8CbRt956ygkAAAAABJRU5ErkJggg==', 
	@ORDER_INDEX=10,@ACTIVE=1,@PUBLISHED=1,@PATIENT_OR_ROOMBED='R',@IMAGE_NAME=N'Orange Star.png',@ICON_NAME=N'Orange Star',@SHORT_DESCRIPTION=N'Orange Star',@LONG_DESCRIPTION=N'Orange Star', 
	@COMMENT=NULL,@MOUSE_OVER_TEXT=N'Orange Star',@FACILITY_UID=NULL,@FACILITY_ICON_NAME=NULL,@FACILITY_DESCRIPTION=NULL, 
	@FACILITY_COMMENT=NULL,@FACILITY_MOUSE_OVER_TEXT=NULL,@FACILITY_PATIENT_OR_ROOMBED=' ',@FACILITY_ACTIVE=0,@FACILITY_ORDER_INDEX=0, 
	@ENTERED_BY=N'softinfo\bmsuser',@ENTERED_DATE=@DATE_NOW,@LAST_EDIT_BY=N'softinfo\bmsuser',@LAST_EDIT_DATE=@DATE_NOW

	SET @P1 = 0
	exec usp_Insert_Icon @ID=@p1 output,@ICON_FLAG_ID=NULL,@GROUP=N'WHITEBOARD_ICON',@SUBGROUP=N'STANDARD_ICON', 
	@ICON_TYPE_CODE=NULL,@ICON_TYPE_CODE_SYSTEM=NULL,@ICON_TYPE_CODE_SYSTEM_NAME=NULL,@ICON_TYPE_DISPLAY_NAME=NULL, 
	@IMAGE_BYTES=N'iVBORw0KGgoAAAANSUhEUgAAABQAAAAUCAYAAACNiR0NAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAS2SURBVDhPjdR7XM13HMfxs1mPjf25USp5SJJcki5yv3ajdDFFIRwVnbISpZAWJcsJsy5yetDRxXLr1KFo1fYw0TjFisil5tYytzpTHpVe+9Vhq9ljj/3xfjx+v+/j+3s+Pt/f9/v5inTMR2zWtzZRaFsZKQb+31gIcy0M/8rnEwwV2sKYgc0ohUjfxqTEv+Ibdj1SsLP+5H8m7t4JdtQdI6b2KNHVWURVydl8+RCRF9MJOp+EVbAr3aAiuEFOIueRdpaxu7P0X5PQXkJ86zniWgrZ/rSA6MZTbGnIZVNdFhtrMgi8moZViJsGlNyUEdGez0b1iT5Zrz5FUMsZJC+LWPtEie+jPMT12fjdlrG6JgUf1T68L+zGozQOj+I4LAKc/wY3tyvZJACanCS4pYht6tNkvUqgrM2P8lcrKGoOYM9DKeKaTLyvJONTnohXaTyLCmNYWBDNeP9574PhAhjcco6M1iSaOicAHwoR9coArjU7sl6ozq1YiseZGFxPbcU5N5JxYvv3wW4spy1RAD79B9QbFdHUOpqAsngcc6Nwyg7DQR7KGJ+5fcFQdQFfq4/zukuvB3v+sh+tr/v1gbvH3lWsapyB/ZGvsJUFMyc1iFFLZ/UFg9XF/PA6sOeDO/c+QkdvAHPsPqa944OeMXmWFoP1PyElTest2p8NykBs9gQyfY8fJp7Te++ykojmIho7rXsm363vh66uFrb2WnR0aJablq5F//5aSPe+A0VkXnZhfKyESXE+GC+c+ha8JSO8TUnkUwUP27o3QgO8eCGira3Xv+sScf9XEV1vhDHh+U2nAJa7MnarGMuoJRi5TNKAAbUHCVfnEfJbDll1kZTWhlF8ewsl9bGcvS0lvyaegpoEztTKKLmbTEF1AoqrMShVm4jPC2dsuCdmG90xdLLWgGuqU9nw/DiBD45S8cyZ3CvnSCnvQlbRSkZVF5nVcLiyU3h/RdpFNYdVHciq4HL9OlKLJ2Mo8cQ0yJmhjpYa0K8qifVNOYiFNjr04EsKhVaSXwW56jHZ137n2E01mVVNPe+ZlY3IK5+QUwM/3liJp9QRQ18njH3tMbAz14Din/ex7r4cv+sHWFX5LQevpHGyupZ01RsOXlJzpKqFY7c6BKSL1PI/yFA1s79UifsuMUb+DhivtmPY8tnozzETQOHqWnFBSkBduoDtZ8lP+1hzPprCW16oGtZy+pdkslWXyKq8Qd61o1y4G07DM1ciM6eiu2IeI8R2GC6bhcHiaejOHIdITwCXlu3CryaV5W9700UZy+L8KA5VOnP98UjqGk2502jC/Sd6lN8cyYYMO0wlbgxfZYuhcJgNPATczYbB00Z3g8YKr7OxrFTtx0uAFxVux03oTYfMMKakhjE3OZSFB8R8keTJ3J3LGR3ijYF4AUZiAVs2swfTc7VB28kK7SmmmgoXF+3Ap2IvnsIV5J6/jQXfRWB/OJTZKRImS32ZEOPDmIgljApxx0QynxHCBgwTljmkuzLXiWjPt+Azu/EMmmSCSMds+PcWa52wDFqAub8jZsKNMVZoclPvWT2t1H36h7vYMEw4Y0MdLBlia47e7HHozhiDzlRTtCebMGjiSAZaG6NjacyfJAvrHGh3eR8AAAAASUVORK5CYII=', 
	@IMAGE_BYTES_INACTIVE=N'iVBORw0KGgoAAAANSUhEUgAAABQAAAAUCAYAAACNiR0NAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAANlSURBVDhPjZVpK3VhFIbPV/+AP2CeOshQhpAcmUok0wdJSQlROB0JiVBmocxDMm4Rco55HjP7oIz/437PvXabw+l9ez+s9n6e9rqetdZzr7V1Li4uRk9PT8XNze2/zdXVVbE1Z2dnWfv4+Cg6Ly8vy+TkJPb397G1tfVP29zcxMbGBtbW1rCysoKlpSXMz89jZmYG4+PjyMzMhM7b21vhBw8PD7i7u/ur3dzc4PLyEmdnZzg8PMTu7i7MZjNWV1cFPDs7+w1UFEU+PDg4sLO9vT1xtlgsWF9fx/LyMvg9ARMTExgaGkJfXx96e3uRlpamRsgPzs/PcXR09GWEn5yc4Pr6WqJ/fHyU952dHczNzUmKIyMj6O/vR1dXF9rb25GSkmIPZDqEMcXX11d8fHz8sM/PT9zf30vdenp60NnZidbWVjQ1NSE5OdkeSNjt7S3o+Btmu35+fpZ0Gxsb0dDQgNraWiQkJPwEMjqmrjkyEjragrinrS8uLlBfXw+TyYSqqirExcXZA5+ensSBkTo6OiIsLAwvLy+y19HRAScnJ0mPa2bBCykpKUFpaSliYmLsU9bqxmgJDA8P/wI2NzfDwcEBNTU1X1FSMgUFBSgsLERUVNQ3kDdKidim+Dvl9/d3ufm3tzfwnc+FhQXk5uYiLy8PERERKnBxcVHESq1tb29LupQQtXl8fCxSoRa5xxpzza6hsAcHB5GdnY2srCyEhoaqQIqUDhQutUYoHfjkQaenp3KItq81AC9ldHRU9JeamoqQkBAVOD09LQBGSjAhjIYl4JOOhHDNnqcxeq7Ly8uRmJiIpKQkBAUFqUC2EPuZHTA1NSXvTFUbGDzg6upKICwL93l4WVmZgAg0GAwICAiAjqOLLcTbIow1GR4eljoxMkbBdz5phFJaLS0tAqGYY2NjER0dDT8/PxU4MDAgza71JvuSxkN4CZwyjJD15YijDlmz+Ph4gUVGRopefX19VSAnBWciwWx09mZdXR0qKiqkA6qrq2E0GlFUVISMjAwBaZERxtvlhVjLpwK7u7sxNjYmI6itrU36k+KtrKxEcXEx8vPzkZOTg/T0dLlR1kyLjLDg4GD4+/vDOqyhs/4CzJxj2secGDyd9WErUf3sFs0xMDBQnPV6PawjX6Ly8PCAu7u72B/aUT5Rc0z20AAAAABJRU5ErkJggg==', 
	@ORDER_INDEX=1,@ACTIVE=1,@PUBLISHED=1,@PATIENT_OR_ROOMBED='R',@IMAGE_NAME=N'Negative Pressure (Room).png',@ICON_NAME=N'Negative Pressure (Room)',@SHORT_DESCRIPTION=N'Negative Pressure (Room)',@LONG_DESCRIPTION=N'Negative Pressure (Room)', 
	@COMMENT=NULL,@MOUSE_OVER_TEXT=N'Negative Pressure (Room)',@FACILITY_UID=NULL,@FACILITY_ICON_NAME=NULL,@FACILITY_DESCRIPTION=NULL, 
	@FACILITY_COMMENT=NULL,@FACILITY_MOUSE_OVER_TEXT=NULL,@FACILITY_PATIENT_OR_ROOMBED=' ',@FACILITY_ACTIVE=0,@FACILITY_ORDER_INDEX=0, 
	@ENTERED_BY=N'softinfo\bmsuser',@ENTERED_DATE=@DATE_NOW,@LAST_EDIT_BY=N'softinfo\bmsuser',@LAST_EDIT_DATE=@DATE_NOW

	SET @P1 = 0
	exec usp_Insert_Icon @ID=@p1 output,@ICON_FLAG_ID=NULL,@GROUP=N'WHITEBOARD_ICON',@SUBGROUP=N'SITE_CONFIGURABLE_ICON', 
	@ICON_TYPE_CODE=NULL,@ICON_TYPE_CODE_SYSTEM=NULL,@ICON_TYPE_CODE_SYSTEM_NAME=NULL,@ICON_TYPE_DISPLAY_NAME=NULL, 
	@IMAGE_BYTES=N'iVBORw0KGgoAAAANSUhEUgAAABQAAAAUCAYAAACNiR0NAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAP+SURBVDhPlZRrbFNlGMdPT8+l59oucdziNzAaFeZk0YjoB4kKEylpcBek2+rKLlwDiyOOaWDrnAIDIRmBkOhIWJRFMs++GAKYYGYQDdNgp2u3bkCyC5FZYANsd7q/z2k7RJ0k+/DP+z6333ne57znMN6l7M49ZZzR4HcYgdIpiWQrRmP5I8ZHlZYy/yHLb8UDpWK6RjQa/aKxax1rMLuLmXMYfBQYeQMYWgEMLgeG3cCNPOB2PhB1YzK66r5wk2K3KWbFrbyh10m5wO/LcKNTBlPvYw2ERSRCOiZ+02D2zEbsyjxEO10Y9aiILnEg+pJISq9kJ/3fuRC/Og9maDbiv2pIhDVETvNgdlvAHjsmum2Id8u4F1Ex8i2LocUM7jAyzMeyYT6RA/PxxamVbMs/TPHh8yzGQhrGf1JILLqN+0AOJnV3L6Jj5DyPoWwWd6kosSiLtAiJ+fORWLAgtVo2+a344DMsBk4LuP6zC3/86ERXWxJoMxByIN6n4jrBBp+1UwcKJp9eCHPOHJgMk5LN9vd+7txk/C7lXcviEGwXcPWCExdalfSRewWMXuRw7TkOY4wDk08+BZOKTLsdpiD8V5bfglLeHcoPZ/O4dErE2U+l1Esxewl2iscViUNMpAFnZsLkaAzTwaZ8FE/MmoW4Q8OAg8e5Jgfamx0ELGWNiTCH/i95DGTw+NMmIMHzD4eloVZejBXQ5xTQHpBwYm8aGP838GGdPRBL0D5OwF5dQGutjKN11pGpw1iIR/ikgP6pDmcCtAsIE/BYlYIDNXSxrXs4HuQRPCEg4kofeYbAkCrg4AYVDdsI+EExa4xe4tHVIiCo8LjJ0AxnABxjeVyWeDSWqthZSdemZi1nDHcK+MGg1+4R0MPwGOOmuSrTPGSc8vpsPI7kSKiu0FBdooLZkc8Z/WdEdBGwvUXEVytEhNJQq9P/kwWLUN6hbAllPoL5dWwt0MBU5XHGLx0iLrY5cKbFgc8OSTi5LAW9ZaeZEjT2gCz7FscnO/skS4LPq2FLkY5tXicqPATc4uGM7z+X8E2LhK+PSmg7KGF/QMZx+rtcJmgfKULFEZpVUrQP2jjsXyjDW6hjw1odGwucqMxzwbdSB7PJzRnWJ9NxWEbbARmtexQcqVMQeFfBvlwZTUslfPyihA9fkFD/vIz6HBk1S2QUrdFRlu9E+VtO+D0EW52BdcsJWL6SMzoOK/iiScHxRgXH6lQ0v69iX7WK2u0aqjZq2Fymo/IdHX46Wgl1VFLgwvo1rjTIheJVGSh2W0AnmMKXubPN78nYu11Cw2YZuyoU1K5XsMOnoMqrYmuhik15anI+frcG35sainJ1vE3dFL6mo+DVlKx9/isa/gJOL1HjVgPYSAAAAABJRU5ErkJggg==', 
	@IMAGE_BYTES_INACTIVE=N'iVBORw0KGgoAAAANSUhEUgAAABQAAAAUCAYAAACNiR0NAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAALZSURBVDhPlVRbSyphFJ1/VtlFu2lpFyzT1LI0E4KC6tRDJBRBBCHUS5EU3Z4aX4q8QKJIWT3UQy9plPg71pm1Y/ScLKqHxczsb+81a69vf59SX1//x+fzqV6vtwaM+/3+GnyVPzQ0pCpOpzP59PSEYrGI5+dnQaFQwOvrK8rlMt7e3v5DqVSSONeZp9e8vLwgkUhAGR4eVu/v73F3d4fb21vw/eHhAclkEnNzc5iYmEAwGMTk5KQ8+c14KpXC4+Oj5OfzeXmenZ29E5Lo+voaNzc3snBxcQHNArS3t2NsbAxa2xgfH5cnvxnn+vn5udRks1lkMhmcnJxUCXV1JPN4PFJERcTIyAhGR0flqce47na7oaoq0uk0rq6usL+//07Idj8qY2sOhwMdHR010MyX1kmq1eP4+BjxeBy7u7tVD+kJFbS1tSEQCIBFZrMZXV1dNWCc68xjvsvlwsHBAba2tqoKT09P0draKsWDg4Nfkuk/ICnzuru7YTKZsL6+LlA0H2RTaGhnZ6e0Z7FYPlX2US3z9Jrl5WWEw+HPCT9r86sYCenlwsKCQBRyjg4PDyt/+y0hfZyenhbILudyOUSj0cpu/paQ3usHQOH54wzt7OzAaDRWNuanpGy3ublZJoRQ7Ha7enl5KS3zJDQ0NIjSnxAyr7GxUaziYeAoKX19fWosFsPR0REikYhMv8Fg+JZUJ6N/migZ8P7+/ndCjgw95GCurKzIfJGU7XA0PoJxKuP89fb2YmBgQMCZVKxWq7q3t4ft7W1sbm5ibW0N8/PzkqjdlVJINDU1CfhOW1paWqDVQhMk6OnpEQGK9neVyjY2NrC6uirDyXkKhULSgj68TOZucuOojHGS2Gw28Zsnh3FF80IlGVtdWlrC4uIiZmdnMTU1JWeV15R2CYsN/AEJqIzQiegnN0YI6+rqEjMzM6KIu8xrijv2LwmV0B+qYLGulG1zZAi+0/e/IICEb68mfkYAAAAASUVORK5CYII=', 
	@ORDER_INDEX=11,@ACTIVE=1,@PUBLISHED=1,@PATIENT_OR_ROOMBED='R',@IMAGE_NAME=N'Red Stop.png',@ICON_NAME=N'Red Stop',@SHORT_DESCRIPTION=N'Red Stop',@LONG_DESCRIPTION=N'Red Stop', 
	@COMMENT=NULL,@MOUSE_OVER_TEXT=N'Red Stop',@FACILITY_UID=NULL,@FACILITY_ICON_NAME=NULL,@FACILITY_DESCRIPTION=NULL, 
	@FACILITY_COMMENT=NULL,@FACILITY_MOUSE_OVER_TEXT=NULL,@FACILITY_PATIENT_OR_ROOMBED=' ',@FACILITY_ACTIVE=0,@FACILITY_ORDER_INDEX=0, 
	@ENTERED_BY=N'softinfo\bmsuser',@ENTERED_DATE=@DATE_NOW,@LAST_EDIT_BY=N'softinfo\bmsuser',@LAST_EDIT_DATE=@DATE_NOW

	SET @P1 = 0
	exec usp_Insert_Icon @ID=@p1 output,@ICON_FLAG_ID=NULL,@GROUP=N'WHITEBOARD_ICON',@SUBGROUP=N'STANDARD_ICON', 
	@ICON_TYPE_CODE=NULL,@ICON_TYPE_CODE_SYSTEM=NULL,@ICON_TYPE_CODE_SYSTEM_NAME=NULL,@ICON_TYPE_DISPLAY_NAME=NULL, 
	@IMAGE_BYTES=N'iVBORw0KGgoAAAANSUhEUgAAABQAAAAUCAYAAACNiR0NAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAT5SURBVDhPjZRpTJRnEMfp5V0VUUBAkMNlYWHZZRdYLsuqLMiyCCxyKIeIsrLcyo20RU6jUKvibVVqxWpFFzUVL9LY1mjTqNGYio21rbZ+MLWpVhO1/fUBrEf6pR8mb9553/k9M/P8Z6zsldNqnQKlFrsAD8uk/2sq8a/K7blN9Hez2Amfs8bLYuWkkZ4ynVvLytsWWn7opuWGMPFs/fHgK+8DvuYbB2js38+K6/uov7aXuoud1J7fQc3Z7RSe6SCgJJ4BoKXkZiftnKHtaR+rnpxiDV+yVtg6zrL6rz5WPz3NqsenaH14nJY/e2m93UPD5S4afjlEZf9uyq/souDiFgJKE4aA+d9to/pxD+X3D1Dz+AimE21II1RE12ax/NFhlgn/0rufUny3i9JrO3GVezJy9CgMzSZyLm8g+XQzySeaUZkNL4C1AlR1/yCN9GFszcfKyoqpsmmseHCUst8/o/TXPRTd+YTqW/tQzNRg5ziZlI5lAriJpM9XYDz8PgpTzKvA6ocW6kRGS/vWk9VUjHl3I5U/d1F2bz9Ftz6muH8HsS256ExJzEwzEG5OxNCeT9KRegz7apDnRL0EfHKE+r+PE5GXyBuvvc6IMaN4a/gwJrs6UXRpC+V/dBNVlTGY+cs28s1hGNryidlbiU/WrBfAd+ml+NJWPGQSvDSKwSBr+4nI1H5oy9Iov7UXd7kU3zD1c6CDmzNTJe4EL45D17kMr3TtC2ATX6BvWESIYSYeatlg0LARw4lekoI8OoTUjjLclF7MbRrq74C5iQN8NP4EZMcQsSkfacr0IWDB9x9R/+gY3qH+6LITB0v9NyjYGIlCG4TNBBu0JSnMacl7/s1VVCPxk6GcryO0fRESY9gz4PXt1NzrJmNzFSFzda/0aKKTPUkNeXhHBZHe00jksz6+Lvrs5OmGalYYAQv1BDSk4zEneAhovrqVGnEplTf3MHrkqP80Pmr5AhZd2kjKyWamm42MHTsWb38542xtiGw1EVCXhrzciFts4BBwidBSxYNuir7ZhKEmG4dpLkglnkyytSUsM5aE1QUkHa0n/lAdYbnxjLe2RhGiZtzECYTXZ+FbloB3oQGX2eLCBoC5FzoovdNFwc2dVPx2AIUhnHkJycj9FaRbGknsXYF+dzn6rkqCFxoYN348voH+AmhNcFUa0nw9ksVROOuUQ8Cc8x9S9FMnpqubMYsx9NFpMMbGI5P7kLijAv2+KnTbStBtLyEoM+YZUMlYG2vUpUY8FkXimjkDp5l+AihW14Kv2jD3b2fhhfWYLm7EM1xJXGQMEomEuA0CtKsU7Xoz2o481CmRos+jkSl8GfX2GJT5c5iaEYFzajgOEXKsHAUwvW8luVc2kXm2nQVff0Bohp6iwiJmxc1m9rpCtBvMhK3KIbg1myBR8oDAA/Vapvp64rUwiinJYTgkaJgcLvTrGCixzOttIvvbdcwT4LnHGkix1JPZ3Yixs5oZHfmEC5imMQP/2mT8K5JQiTJleXpkOdE4C5hjvFgWsQHYhXoPZZh6rJGsc2tIESsosec9MejVzNpZOqj+8PbFaJqyUNWlCmkk4lUQi8diHS6iTKfkUBzig7DTq7DRKbANlmJl7+d+UpUXi7owDqVpNn5iY/iKIfeerx0cpQH1u8/R4Co05hKtZkqkEscZchze8cE+zBu7ECm2QUJigRLs1RL+ATkOLh+9wsP/AAAAAElFTkSuQmCC', 
	@IMAGE_BYTES_INACTIVE=N'iVBORw0KGgoAAAANSUhEUgAAABQAAAAUCAYAAACNiR0NAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAPGSURBVDhPjVTZK619GN1cOIWEUFyQnMzzPBMn8zFPGUMREcd49BkjcWMW0rmQoWO2kTjmORnKEP6b9e317DbHd/VdPO32+/7e9VvPWut5FHZ2dv84OzsrHRwc/nfZ29sr/y5bW1v57+bmplS4uLgczM/P4/z8HEdHR+91cnLy6T/fHR4eYm9vT2p3dxcbGxtYXV3F0tISZmdnkZubC4Wrq6tyZ2cHLy8veH5+xtPTE15fX/H29ibFZ6zHx0fc39/j7u4OZ2dn2N7exunpqfwSeHl5+QNQqVTi5uYGFxcXuL29xa9fv+Dn54fy8vL358fHx8J4a2sLKnmgq6uLHz9+CLvJyUmMj48jMzNTzZCABLq6uhKGDQ0NUCgUUOkrgGS0v78vxbaDg4NhYWGB9vZ2ARwZGcHQ0BDS0tI+A15fXwvAzMwMmpqaMDAwICAEpGabm5uora2V1lJSUpCTkyPnhoeH0dfXh+Tk5A9AavPw8CCHtLW1oaenBx0dHVhaWmJlZUXkKC0tFeZ/F880Njaip6cH379//wAkGB1T2Q8vLy/5yNTUFB4eHiguLhamjo6Ooq0G0MrKCl+/fkVGRgY6OzsRFxf3AUgnq6urERUVBZWu8tGXL1+Qn5+PsLAw0UuVV9TX178D8gJvb29pv7m5Wb4VU+gcW/bx8UFWVpa0qmHBW4OCgmBsbIzCwkLU1dW9v6NpvCQhIQE1NTWIjIxUA1JsatTV1YX4+PhPGpmbm4sRISEh4qZGRy0tLdjY2CA0NBSpqakoKytDeHi4GnBtbU1i8+fPH8nXf4VnHhcXFzExMSGmGRgYQDVmMDExEWYlJSXIy8uTSwWQKb+8vMTCwgIqKipgbW0tGTQzM5PbNdHo7+8XSYyMjODr6ysy8DLGiMYEBgaqAQl0cHAgY8TMUYv09HRxmG2Ojo6iu7tbosHwGhoaShIIyATwWVJSEvz9/dWAc3Nz4DwzNuvr60KdB1SLQ3Tt7e1Fa2sr2traJLwaQDIlO+YvNjZWTFVwdU1PT8uA//79W7Tii5iYGKjWElpaWtDR0SHhZes0jTozWvr6+iIBz3779k2dXwJOTU3JtiAwi7mqqqqSoDJfP3/+lIxWVlZKe8wfATgEiYmJiIiIELfd3d3VgNwU3IkEpl4cdBY1IyuCUfyioiIUFBRImxrdCEaJaIgMBAHHxsZkIRB4cHBQBp2TQXZcUXReEw2aRVbR0dHCjGABAQEyMdRcoYrHPvdYdna23ErRNSJzlOg4R0/zIWeZH3t6ekoWycrJyUlkYP0L9vJXRR4B0+oAAAAASUVORK5CYII=', 
	@ORDER_INDEX=2,@ACTIVE=1,@PUBLISHED=1,@PATIENT_OR_ROOMBED='R',@IMAGE_NAME=N'Shared Bathroom (Room).png',@ICON_NAME=N'Shared Bathroom (Room)',@SHORT_DESCRIPTION=N'Shared Bathroom (Room)',@LONG_DESCRIPTION=N'Shared Bathroom (Room)', 
	@COMMENT=NULL,@MOUSE_OVER_TEXT=N'Shared Bathroom (Room)',@FACILITY_UID=NULL,@FACILITY_ICON_NAME=NULL,@FACILITY_DESCRIPTION=NULL, 
	@FACILITY_COMMENT=NULL,@FACILITY_MOUSE_OVER_TEXT=NULL,@FACILITY_PATIENT_OR_ROOMBED=' ',@FACILITY_ACTIVE=0,@FACILITY_ORDER_INDEX=0, 
	@ENTERED_BY=N'softinfo\bmsuser',@ENTERED_DATE=@DATE_NOW,@LAST_EDIT_BY=N'softinfo\bmsuser',@LAST_EDIT_DATE=@DATE_NOW

	SET @P1 = 0
	exec usp_Insert_Icon @ID=@p1 output,@ICON_FLAG_ID=NULL,@GROUP=N'WHITEBOARD_ICON',@SUBGROUP=N'STANDARD_ICON', 
	@ICON_TYPE_CODE=NULL,@ICON_TYPE_CODE_SYSTEM=NULL,@ICON_TYPE_CODE_SYSTEM_NAME=NULL,@ICON_TYPE_DISPLAY_NAME=NULL, 
	@IMAGE_BYTES=N'iVBORw0KGgoAAAANSUhEUgAAABQAAAAUCAYAAACNiR0NAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAR1SURBVDhPnZRpTBR3GIdHFkXwIuDZJk2j6YemplqPtKlHPFqbpqaXSdtYGutB1LbWk1oBqVRNMUZEPFAxHEGO0uUYYAVWQETqgYDsLru6Ciy7XLvItSCnyNP/Do3tx9YPT97MvM/85p13JiO9EVIa5Kduljf//lD+Ntn8wvglmuX9V1tlac7mnMLlZ234ZzvYnuNg2wuwNdvOnvzHxJpBen2jLM/94TpLwitYeV7PinN6VkWbWX3pPyC8FVEG3j1dxc7MWlJMfUjzt+TIi3eWsOREBcvPGVgaWcni0DwWHpSZF5AkSGZhSDaLftEIcpj3Uwpv7ktiQXAmiw5pWBJRztundOzKrENtHkB6Z/sVedm+m6wRd1kb/4jVJ0pw95yEapwnM+evZOZbq3D38GKMmwrV2HFMn7uUlxatYazXZCRJYmlIGh/E1vKzpp6smkGkFTvy5TUH7vDZBT1fpdTxUXgRXj4zWbYvmq/THayLM+HpPU252BW8NvIG32S1816omvFTprLyYDLrkuo5pLWSaxlC+nBvgfxpyF38Yo1sybDyyfFsFny5m63i5WxKs/LFZSMevrOUQDeviXwcdYPNGQ1su9LGwvUBvB8Ywwa1jWNFDRTaniJ9vr9IXn+4gm2J99mZVY9/QgUbLpTwY3YD3+c2E3imEG/vqUrg+PFe7D6WwY58h+jb2BhdysZLf/JdhoXI0mZKm54h+QVdl/3DqghQPyQwt56gXBvB2ib2FtrR+B9h2HMGGtUUXh2j4oqogxNmkbU9TPQdBOc3EpTXQEB2LZdu2ylziM9m66Eb8q4TBn4VJ8PE2L8V2DhcYiciTUf/lNnCmADuMzCpfJWK5EWvz2uEZxo5ct0+6ov9JVW2omsX7V1Hb8qBp02Ea+s5e6uZM6VNnKzsIjVay4hqGozxZcR9uhKmVMmX4bEzSIkr4mRFp+KfKmkks7qNB07RPnD8jnz0gplocTLhXivx5Q5i9F2oNTrxeK8IYzLPRNAorgkn0u89m1TtfWJ1naN+mR2tuRNLr2gfiSiXT8bUkHK7hUxTO+mGNoXU2n4Me8KE4aFMqYS5+SiB94IjSa3rf+6q9Y8ptThpGhDt8LOVcvTlOjRiB0U1XRSIOxWYO7ha4ySv6SmGkEieeYhHd/Nl0N2Hu6FnyHOMcPWRy+1QfK2oFY09tA2LwKiLVXJiio1iYztlDT3cru/+G6ey5DzHELtfnkOXmHTTpGkkGRsxil3943Vz09LNfUcfPYjA2BiDnJ7eRLmYztTaR3VLr4JRCMW6Gg6ERSjf4DyBq+4IDKWw0ky1XXguhKtv7sXSMcCgKzA53iTnZrVgsnVj7RrA0t6vNK1dQ+QU3+J8XDLnE1I5lajm4uU/iIpLIj2/WHEUhF/X1k9L9xAjrsCMxAfyNY0dq5iofXCYx31PR+kdokcYYs8M/QvX8RPBc0+4rQLngFigKzBP/KnLr3VQV+ukofEJNlvP/8Yq9t4pJhwNTHtUUFsNhnIn+rIXQ3dH7L/K9UrgLwhWinTW9LBUAAAAAElFTkSuQmCC', 
	@IMAGE_BYTES_INACTIVE=N'iVBORw0KGgoAAAANSUhEUgAAABQAAAAUCAYAAACNiR0NAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAANrSURBVDhPnVTZK29tGN0pIpH/woVy6cK1GxdmhQs35gtTKAmROUTmMfM85TUPx5AiY2ZlliFzREmh9e31nLY65+br2LXav/1717ue9Qzvq0VERCRWV1eryspKVVFR8WOUlpaq7u5upfn5+U2lp6ejqakJzc3NPwL3dnZ2YnV1FRRUAQEBSEpKQkZGBiienZ2NnJyc/wV55KekpKCxsfG3oL+/vwoNDUViYiLS0tJkMTo6GnopEBwcLODvyMhIQUhICIKCghAeHo6oqCgkJycL6HJ9fR1aYGCg4gZGKigokEVzc3OYmprCzs5OYGZmBhMTE/nP1tYW9vb2sLCwgKZpIpqXl4f29nZsb29D092pmJgY5Obmory8XBza2NggLCwMtbW1KCwshLW1tWymMLOor69HbGwsrKysJJuSkhL09vZib28Pmu5OJSQkoKioCHV1deLQzc1NmkPB4uJiCUBBOs/KyhJea2srPDw8pAw1NTUYGBjAwcEBtLi4OEVX+tiISFlZGfLz89HS0iKbGOhvQaZHLkvEDBoaGjA+Po6TkxNoujuVmZkpXWLru7q60NPTI0hNTYWXlxccHR1haWkpb29vb0mb6/rcCZ+Bp6encX5+Dk3fpOiIYrTd39+PwcFBdHR0wMfHB66urpKak5OTvPnt6+srQuSR39fXh/n5eVxfX0PT3SkWVSmFyclJsT4zMyMpubu7Sz0pZMD4bmtrE1fkj46Oygze399D01uu9KOHiYkJiTI3N4eFhQUMDw9LeoZDQ5DfdD42NvbNn52dxdbWFp6enqDpXVQsKoXW1tawsrIi2NzclA67uLh8u6RjCupnXtYN7tLSEvb39/H6+gqNlwLrtby8jN3dXRlOYmdnR8aA7j09Pb/Tr6qqwvHxsawbXLo7PT3F+/s7NH2mFIeSEUk8PDz8Bot8dHQEBwcHODs7yymhm7u7uz94DHx1dYWPjw9o+rypoaEhscw/Ly4uBJeXl1ICXhgcauO0xMfHSzYGj2+OCxvy9fUFTU9XsVNnZ2d4eHiQ6Fx8fHzE1NSUnArWmOAFwO+RkRHhEOTf3t7i+fkZfDR9hhTbf3Nzg7e3NymsAabAqH/j8/PzDx753CuC+jCrxcVFKSpTZqr/Cqb88vLyW1Cv3y82gp1iY36CjY0NuWn4/Ae4DGnOPdCkiAAAAABJRU5ErkJggg==', 
	@ORDER_INDEX=12,@ACTIVE=1,@PUBLISHED=1,@PATIENT_OR_ROOMBED='P',@IMAGE_NAME=N'Telemetry (Patient).png',@ICON_NAME=N'Telemetry (Patient)',@SHORT_DESCRIPTION=N'Telemetry (Patient)',@LONG_DESCRIPTION=N'Telemetry (Patient)', 
	@COMMENT=NULL,@MOUSE_OVER_TEXT=N'Telemetry (Patient)',@FACILITY_UID=NULL,@FACILITY_ICON_NAME=NULL,@FACILITY_DESCRIPTION=NULL, 
	@FACILITY_COMMENT=NULL,@FACILITY_MOUSE_OVER_TEXT=NULL,@FACILITY_PATIENT_OR_ROOMBED=' ',@FACILITY_ACTIVE=0,@FACILITY_ORDER_INDEX=0, 
	@ENTERED_BY=N'softinfo\bmsuser',@ENTERED_DATE=@DATE_NOW,@LAST_EDIT_BY=N'softinfo\bmsuser',@LAST_EDIT_DATE=@DATE_NOW

	SET @P1 = 0
	exec usp_Insert_Icon @ID=@p1 output,@ICON_FLAG_ID=NULL,@GROUP=N'WHITEBOARD_ICON',@SUBGROUP=N'STANDARD_ICON', 
	@ICON_TYPE_CODE=NULL,@ICON_TYPE_CODE_SYSTEM=NULL,@ICON_TYPE_CODE_SYSTEM_NAME=NULL,@ICON_TYPE_DISPLAY_NAME=NULL, 
	@IMAGE_BYTES=N'iVBORw0KGgoAAAANSUhEUgAAABQAAAAUCAYAAACNiR0NAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAATfSURBVDhPjdR7UFRlGMfxDTXG8jLKZYElVFhWQGShZQERjIuuIjcRlIsgCgq4sLoKilyVm7SmqSkOKqCDShmh4C0SDTPLdCbC0FEbJySt1BnLxjTHym/v7prWTH/0xzNn32f2fM7vfeY9R2Ln41ri6OfWIVXLO2z+b6nEf1XOz8v6decOqeg5Bbh3SBwD3E5ln38Hw/cdrL/Zzvpb/10G0TfcPERt/wfUXD9A5ZUW1vbtpaxnN8XnGtF9WodaPwsj2LF8oJmNnKXm/ifU/NxN1b1TVN45QeXdLtO65v5pqsW1QvTKBo5SfL1dVAeFVw5S8HUrK/uayevdiXp5nBlc+m0j+ttHkIWEYmlrw/Bxcmx8VFh7+zDCxVmsxzJ87BhGyuVYK32w8vJhqL0jllIpjmEa4o/XktRdi0ob/QzsbyL/zlGG2ckYIXMibu8Gcvr2kX66SfTskUgkppL5q0k7tZPkzq0EFuZiMWgIo1zciW+vJqGzCu/smS9A/UAbjr6BpJ/cQwXdrOEYBXeOYCV3fQ7KZ0wl70YL2VfrybnWzKT8HKxcPIlpKSP2YClemdPN4LIbu9Fe3I9/ho7iB50UPTpE8aN29P1tApS/AKeFkXWxkQVfbGLeGQMJbQYmJiYxfVc+M/cX4Jk+1QzmfdPIqnvtaHtbKHoohv1LG/mP21ksEo5QvEjoGBFOyqUmks+sZ87xCuLay4naX4SmQU94vQ731FAzmHu1gdI/jlHy5DCF99tY9rCdMvGQHQ3luDk6PU8Y4aumsqmY+BPVRJuwVUxv0hNWp2XKpizcEqf8A3xyVCQ7iP7XQ6ztredHxQSQDOPGYGs8LIaQbTGU3yxswGI0xyJD0bxfxDSBhW7TErwhk0nr0lHEBz0DrzVQ/PgIBfdayRGz68pNFJglT43AYCkDQ6x5NNgWBomSWIkaja40lYCGpQS9lUlAVRq+5cnIYyeZQe2VXax+cAj93ffQ3m7hckiQuGkEfwrEWEaUZ79Na8lIDKkRKLcvMWGqkkSUK+NxjvIzgzl99az8qRXdrX1k/rCPC1Hh4qZXn4N/w8brU1PKURRmRDJhQ4bA5qLMj8NDF82YCF8zmPVVHSvuvEvu9SbS+/dQ27SK3y3FdkWSf2PmXo+rO5MrUlGWJeG1QmC5kSgWT8dJ42MGMy9sYel3zWRf3kFmzzbm9NZRuTmP2zJn07xM2zQms7Cmy1tJSHkKnmuTUf6NLdIwbn4YjuFKAYpP14LPNqIVxySjZyvzP3+b5I/fZMZZAwv3FHHOXg4vjeapSLZd5YdqYzYea5LMmFYky9TgnBaKU1IwDiFeSGQCTO02kHWp3oSlCGzOh1XMFe9mXOs6pDIHTktepkS8yyNVXoRv1KEsjDdv04iJw+w0NwiHuADsgycYQUVHykc1LPxyKykCTuisJOWgwCry8I/R8IqdLQqpLTa2VoxysEcdqyF4UQIeWTMZlxZiwmSzApBGqZFO9jAnTOqsJv38ZhK71jH78BpmHyglqm45mk1aZmzREWzIJqgyg8DV8/BZEov34hicxcxeMyab5Y80UoWVxhvbSW5I7JQuJ1VLovDVxeCTLc6W+GJ4pofjLuYyPnkKrnMm4yy2MzZajVOECtk0b+zDJmL/hid2QR5IA92w9R+PjZ8CO18FfwGDbFILaZk0wQAAAABJRU5ErkJggg==', 
	@IMAGE_BYTES_INACTIVE=N'iVBORw0KGgoAAAANSUhEUgAAABQAAAAUCAYAAACNiR0NAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAOcSURBVDhPjZTVS21bFMY3+C4oiqBYD3ZiB4qomNhdYGFjByoqgmJgYaAYiNiYW7E9disiPvjvfHd/Y7OO53LuPZyHwVpzrrl+c4xvhMrGxqbV0dFRbWdn99dma2ur/tWsra1l7eLiolY5OTn9WFlZwd3dHW5vb/9oNzc3uLy8xPn5OY6Pj3FwcAC1Wo2NjQ0sLS0hKysLKmdnZzU/fn194fX1FS8vL3h6esL9/T0eHh5krexz7+LiAqenp2KHh4fY29sT6Obm5jeQN/Ggp6cn9PT0YGJiAo0E0IQBU1NTWRsbG8PMzAwaiaAJEYaGhtDX14e3tzfGxsYwPT2N1NRUrYe86erqSg4ZGRmht7cX29vbmJ+flz2VSiWmOYvZ2VlMTk6ioKAAOjo6csnw8DDGx8eRlJT0DTw5OYFGT8zNzeHz8xMfHx9yibm5+U9gQEAAjo6OsLOzI2Hm5ubK956eHgwMDCA+Pl4L5KGtrS1xmfo9Pz+LUdtfgf7+/pKAxcVFuXhoaAjR0dFoa2tDV1cXYmJitEAKywwTqiSEz7Ozs9+A6+vrEjZ1I7C7u1uALS0tiIqK0gLp/vv7O97e3qR8mE16PTU1BQsLi58h+/n5YXR0FBMTExgcHBRYR0cHmpqaUFtbi7CwsG8gYQTR6DH1iY2NRUREBHR1dWFpaSlr6lRWVia6tbe3o7GxEdXV1SgvL0dISMg3kLV2fX0tHnZ2dooe/DkhIQGRkZGIi4uTdz4Jrq+vR3NzM6qqqlBSUoLCwkIEBQVpgbu7u3h8fJRapG4VFRXyEwH/ZfxWXFwsYRKWl5eH7OxssAoEyCpnW7F0qF1NTc3/Auk1gUVFRRI6YWy5lJQUUGMBMnP0bn9/X/RjBhMTE3+DKrD09HTxLD8/H5mZmUhOThYpfHx8tMDl5WWpOZbN2toauGa3ZGRk/AtKIAEMl52iwOgxdWbrqji6FhYWxLPV1VXwnX3Jkunr6xOgkgjqWVlZKWESxlZTKiE0NBTu7u5a4MzMjEwLBca+ZK2xnTgUqI2VlZUMi7q6OuTk5EiYCiw4OBiBgYFwdXXVAtnsnIkEEzYyMiK1xUI1MDCQaaMMDu6lpaVJ9lmjhDG7vJTDQ4D0hv1JMGH9/f1obW1FQ0ODdAHDLC0tlSQwmwyVmikwX19feHh4yHBRaebbOYcCM8eDFJ5Fzb4MDw8HtWHBKl54eXmJVm5ubtCMfPHKwcEB9vb2Yv8AlVZzMpLmUh0AAAAASUVORK5CYII=', 
	@ORDER_INDEX=4,@ACTIVE=1,@PUBLISHED=1,@PATIENT_OR_ROOMBED='R',@IMAGE_NAME=N'Telemetry (Room).png',@ICON_NAME=N'Telemetry (Room)',@SHORT_DESCRIPTION=N'Telemetry (Room)',@LONG_DESCRIPTION=N'Telemetry (Room)', 
	@COMMENT=NULL,@MOUSE_OVER_TEXT=N'Telemetry (Room)',@FACILITY_UID=NULL,@FACILITY_ICON_NAME=NULL,@FACILITY_DESCRIPTION=NULL, 
	@FACILITY_COMMENT=NULL,@FACILITY_MOUSE_OVER_TEXT=NULL,@FACILITY_PATIENT_OR_ROOMBED=' ',@FACILITY_ACTIVE=0,@FACILITY_ORDER_INDEX=0, 
	@ENTERED_BY=N'softinfo\bmsuser',@ENTERED_DATE=@DATE_NOW,@LAST_EDIT_BY=N'softinfo\bmsuser',@LAST_EDIT_DATE=@DATE_NOW

	SET @P1 = 0
	exec usp_Insert_Icon @ID=@p1 output,@ICON_FLAG_ID=NULL,@GROUP=N'WHITEBOARD_ICON',@SUBGROUP=N'STANDARD_ICON', 
	@ICON_TYPE_CODE=NULL,@ICON_TYPE_CODE_SYSTEM=NULL,@ICON_TYPE_CODE_SYSTEM_NAME=NULL,@ICON_TYPE_DISPLAY_NAME=NULL, 
	@IMAGE_BYTES=N'iVBORw0KGgoAAAANSUhEUgAAABQAAAAUCAYAAACNiR0NAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAVGSURBVDhPZZRpTJRXFIZp0jSmaZsUyyLgoAPMDNvAMDMwwzKyyKaDbLIJDAoIMkAVkUUWiywCFheqFMSlSsEFRR2LWqOiibFWW6vWqqQL2lpTG2NMatMmRvv0wtT2R3/cfOfmu9/znXPu+x4bR5VHvUugwuKgdbfYvVxqEQd6WJzDlVNPu8n9y3d6mTVWS/9d7wRILQ7ijETnabFx0SnOFl/+gM4HFtrvHqZ9Qqy7R+gQcfXYFjp+PDK1Xyf2HRMjdN7aS/PtfTTdHGLNtQHqv/iIuks7Kb/Qg3ZFEpNAy4p7A2zkAhuen6Pr+RibuUTn5X78PaW0X+mnmyt0cZ6m8SHyqvNoezJK08OjNNwbpvbbIaq+2UPZ9X60FclWYOn4DlY/O0bV0xGq/7TQ8Gg/Ko0CGxsbpLNcqL7WQzUnWHSuE7fIAMp+HqBwvJ+8q91kX+wifWwd6afXoTYn/AesfzZK7dMjNPx1iqJ9Nfgq3ZFKZxKi8yWzKp21j4cpON6K74IQyu70k3+hi7zPN7ForIO0k82kftKEf/G8/wNrfz9Knfi4/qcBlNFqqm70UvPoAObe5cjcZuEsd0UjsszfVETOpU2knWgh6UgjCcN1KAti/wHe2cEaTtH44iQNL06I+AzVjw+iTgqmQoAr/zhG3cRO5maFMc3mFdJF84uvbCZDZJc62oRxbw1xeyrxyZtrBZZ9t4uKe3souryZ/LFOln22gZIzreS252I6tJrFx5tYNPoeub3LiM00kDJQydztyzG8X0D4hqXEiDhqWzmeORFW4Mpf9uKbFsZ02zcwpOmRyJ1wdrVHJzLSJOtwlDrgJnNCNV9NQJIOOxc7Zsqc8TT48La9LUENmUT0mFFkGLCR6D0tK+5/jCTEG6mzLWtvf0iwKQJ/g1Joaz3m8+0oIpVECVCRpZ68g6tx13szJyOU5L4yHDxc8CtfQEhXAbLUUCuwfGI38W15+ET5oIpW8pqQi0RkpU0NQhHlizxUgSxELsA++M1X4eHrwquilx4KCRKtB+rV6WjXZuOeqLeWbL6znTXPj9P42wgNDwfJ7jOji1KS2pLFqusbKf56K0surifvbAsJDSkE6TzQ5URiFDdtEJmpRcl+ValIjYFW4LKbfVQ9OUT5/UFKRLbvPhikWABCiubhH68hqWcZmYMVBCQGoRStiG7JIaqvFG2riYD6dPwqk/EqT8BVnJ0CFgknrPx1H6Xf76Lo1jbyr24l98stFN3uI2NLIQ62b/Hm69OITw8mbf8qgreUENSci7ouA+VKASudj2xpLJIYlRVYcKWbcqG3YlF68fh2Fn8lSry8kfiuJXjHBRC5OJKEFUbUwXKCkoIIb1mEtjkHVc1CPMuMeBTEMNsUiUuUnwCK0bX44gbMIrull7pI7i4ga6gSTaoeVbgXxk4TCw7UEL27AuN6E7p4f/xVrgRmhqDJMeAnfiYVMElmGE7hSmycBTBHmL78h52kdudPDQRvpTMLqhPIGKklbrCKcFFiqBBxoFCCvi2XMHMMXuKmJ8/OkjviaQpnRrKeGWHek0CZJetUG4U3esgerkYZpyRjWzEpwlLRuyqI3GomTNykrlX0rD4DX3EBiuWJaM2xePs4oImSI1kYjL1Ri0OIlzXDzE9bMQnbZQlv5p5uIfFwAzG7VxLZW0rYxqXo2kyoGzNRVqXgNdmzwhhmCfF7mwzMXKjHbp6a6TH+2OvFyHP0czujLjGiEWqfHD/Kwrgpk3tlR0xZaVL9bok6ZguNucZpmBmtwlk4x2mOD/ah3tgHK7APkmMXKMNRI+NviwhRg9edlxUAAAAASUVORK5CYII=', 
	@IMAGE_BYTES_INACTIVE=N'iVBORw0KGgoAAAANSUhEUgAAABQAAAAUCAYAAACNiR0NAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAPZSURBVDhPZVVVS0RbGB310Tf1RVCxsLu7u8UOxMBEsRUTRRQFA7FQEVuxHQMDOxBRFEHEf7PurG8YL5f7sDl79tl7nfWttb49Cmtr6w4HBwelra3t37CxsZG5m5ubPDW/Odfs5ZpmWFlZydzZ2VmpcHR0vN7Y2MDT0xNub2//xt3dHdbW1nB/f/+f9YuLC5yfn+P09BRHR0fY39/Hzs6O7M3Ly4PCyclJyQ0/Pz/4/v6W8fv7C6VSCTs7O3nyN99zX01NDV5fX/H4+IirqyucnZ0J8O7u7r+APPT29obn52fZ/PDwAFW5UCgUMDU1FRYfHx+Yn5+Ht7c3yJJr6+vrWFxcxOzsLGZmZpCZmalmSMD393e8vLzg8/MTo6OjUEkBMzMz+Pj4oLKyUj7GQ2FhYTg8PMTS0hJWVlYwNzeHyclJjI+PIy0t7f+ABNWUExAQgIODA9Gxv78flpaWsLCwANe7urqwvLyMiYkJjIyMYGhoCCkpKWpAfvHr60vYsTTOWXZkZKSUx4/wyQM6OjooLS0FjWSpZDYwMIDe3l4kJiaqAY+Pj0VwarKwsCCO8dnS0oKxsTFMT08Lk56eHgEl287OTtTW1qK+vl7Ytre3Iy4uTg14fX2NqKgo6OnpIT4+XsoyNjZGQkKCrJuYmEi5oaGhiIiIgKGhIczNzeHl5QUDAwOUlJSgtbVV9ioYRpbj6uoKIyMjyRdZ0IzV1VURn/PY2FhMTU0JY+5led3d3ZKCrKwsYRseHq4GJAgX/Pz8RHBtbW3ZGB0dLWDu7u4SI85DQkKg6hhoaWlB1SFQdQ4KCwtRVlYm7/5MoRkUnx1CgQMDA1FXV4e9vT3pBDrKiDBCLDUpKUk05p7i4mLk5+fLGQFkyhkVln5ycoLLy0vJGIMaHByMjo4ODA4Oin4MdnV1tZhQUVGBoqIi6ZCMjAypUAC3trZwc3MDuk1Gm5ub4jS7gW7q6+tDV1cXycnJkrempiaUl5cLWG5uLtLT0+UdJRFAxoWxYYg5CEhDGhsbpQweYFkslU5WVVUJYEFBgbyjQTTN09MTCl5H1IfsCNLW1iYsaIivry8aGhqkXGaQH2B0VEZKvAhELQlGOWieALLpqR3BeCHY29tLN7Cl+vr60NzcLCmgIWSXk5MjNxH3MrMEDwoKgouLixqQnbC9vS0ALJFs2FLMGQNLJwmm0YxmcTA+/v7+wprVqORTAzKwLJexYH8ODw8LKBmztciK3cBo0E2WGRMTI8wIRjM8PDzkhlKo/gKu+LXs7Gy5flJTU/9EpgFMP6ND5mTB2PAwg04tCUKJKAHHPwkZgm5oo11vAAAAAElFTkSuQmCC', 
	@ORDER_INDEX=3,@ACTIVE=1,@PUBLISHED=1,@PATIENT_OR_ROOMBED='R',@IMAGE_NAME=N'Lift Equipment (Room).png',@ICON_NAME=N'Lift Equipment (Room)',@SHORT_DESCRIPTION=N'Lift Equipment (Room)',@LONG_DESCRIPTION=N'Lift Equipment (Room)', 
	@COMMENT=NULL,@MOUSE_OVER_TEXT=N'Lift Equipment (Room)',@FACILITY_UID=NULL,@FACILITY_ICON_NAME=NULL,@FACILITY_DESCRIPTION=NULL, 
	@FACILITY_COMMENT=NULL,@FACILITY_MOUSE_OVER_TEXT=NULL,@FACILITY_PATIENT_OR_ROOMBED=' ',@FACILITY_ACTIVE=0,@FACILITY_ORDER_INDEX=0, 
	@ENTERED_BY=N'softinfo\bmsuser',@ENTERED_DATE=@DATE_NOW,@LAST_EDIT_BY=N'softinfo\bmsuser',@LAST_EDIT_DATE=@DATE_NOW

	SET @P1 = 0
	exec usp_Insert_Icon @ID=@p1 output,@ICON_FLAG_ID=NULL,@GROUP=N'WHITEBOARD_ICON',@SUBGROUP=N'STANDARD_ICON', 
	@ICON_TYPE_CODE=NULL,@ICON_TYPE_CODE_SYSTEM=NULL,@ICON_TYPE_CODE_SYSTEM_NAME=NULL,@ICON_TYPE_DISPLAY_NAME=NULL, 
	@IMAGE_BYTES=N'iVBORw0KGgoAAAANSUhEUgAAABQAAAAUCAYAAACNiR0NAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAVPSURBVDhPHZTbUxNWHsczO3bftp32YV92Z/p/7PRl+9Cd3rYzrmvt1lHUre5WmV1aQStoEhNICHItooDVrbPgokzhGKUIFCVccyEBQkJuBAiQG4m5IAnXfPaMD985Z87vd77n/C7fn2JxqVCezxdEOuEU+aRD5BIekY37RDy5LiLJrNiJhUQ+nhCxxL5Ixl+JQjjw2rYZC4vCakjsRCIiJf3i0j40NC4U0fDLX3b2dnH7XSz4gyx4o3gW4sx615heXCDgmcLnm2E6uIwj6CXoH2VueQ6P382SxyVXH/PLQYLrATo6/oNiM+USDqeNC+oHnFKaOFU+yvnyp3x7vY+LlSOUa/oovtIrz4cpujbJ2asm/qEU/FPZw1lVPyfVLzinERj7TTTWGVDkkm5htvn5snSSD0uDHFEvUNHmoPqulao781TecXOl2cOJCg+flmzw0Tfw15IMh79J8WHZFu9f3OaTklV6eje41diO4lUiJCzWDU6XzVGkW0XTvUyXyceQ3cmQe4on7lm6bU5u9jr5qsrDZ8ptjlbAUeUun2j2+UAFhyvS/PRslZvNzSgSaa+YtAUoUw1T3T7NU7OTpWiUWCzNWiKNL7NJILkhc7xG4z0XJ6o2+EK7x/HqKMcMUY7oCnyp3eDhyDxNLTLkeHZGjNtmuaz6iYa2PsKpMKmtFLnNfbYyBSKbEEm9JBL28kiMcL7KzOkbBc7VZiXSHK+FEzVZukcDkrBOhpxeFBb7MucvP6ZU3Y1vLUx8d0siRzydwRvZZTGeZso5xvW6W/xLa+JC+z5lzVtcatyhqBWJDEZTkJZGSbiZWhZT04tc1g9SVHwT8fMwofgqq5kkgdQm/nSBpfQWk047X6taOWNwUvK/HcrvxlG3pbh0p8B3914x+HyDlvoWFNnEqsyhF8MPU5wtu0tdcweBYJDYZopQLsdabptgdB1jn5HTxXq091e41FNA9WgbXec2ms4Chq4MA2MxGutvy5DjEUno5sZ/JzD8aOPYKQ33Oo04PB4W10M4QwH6h/v59+m/o7xwhYHHVr5/so9egN4IOokGY5x++wo3GptQ5OMxMWGdoaZrlK7JPLpWG38+eZVz3yq5XlnHuWtajn19kTN/OcPZP7xHS9FnDHRbePRLnoYhqBuGO8MvGbH7qWtoQLEbk4RTNurFJJ2WPXqn4P7gKhX1nRRfbuKr2k6aB3w8uD/Kn95+h5J3FbSc+CMjfWN02aB1AnomtpixLNFcKwlzUuRTkvDuExuP5wt028HogAHXPk+9u/R44cECPHMf0Fp1m8Nv/Ybid9+k/fin2IYn6fVAhxumHUvcrqmWVU4siQnzGB2DFgaW9xG+A5749nnm2WVQkjyTzr2StCewhyO8Q2ttG0fffIPS3/+aH/72EbPjC5iDB9jmZOPfqEWRTobEqHmUhyYrLyJ79K3t8vNansHQDqYATAQKPF/awyjPjOs7WDPQWdvE52/9irLfHeLHk5/jGZ9lRk4pfb2UXjKREi/GpxFjLuxJGImAKXrA89gBQxtglr+yhLOYYjmGo9Im7c48tN9s4eN3DnHkt4fo0KuYD4XQNMkqpxI5ORy8mKSeQ1vgTYM/BfNZsMqLvoxUimxsbzb/uslX5COTOVgBWYQaLhz9mOyaB+/6Cpo6qZS4bBuv38+Y2Yplxvka1pkZuc5hsXtx2Dxy72bENcf4vIM5uw2n1YzZPofVs4h9Xg5ml4vRMRt6g6zyw4edQ23tt9BoVa9RWamWUKLTqDGodFSrdWg1OpQ6LSqdCp32Kt8rSzGor6GqMqDW18h7eio1NVxXV/F/yBDkw8QmuPkAAAAASUVORK5CYII=', 
	@IMAGE_BYTES_INACTIVE=N'iVBORw0KGgoAAAANSUhEUgAAABQAAAAUCAYAAACNiR0NAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAANQSURBVDhPfVTHSmxREJxfURf+gH6D/6C4ceFKBQMqjgkTmHNWVMxgGsU8Y0DFHMGcUDBnTOCm3q0azjyVx1sU596+fau7q/u07ezszP75+em4ublxPDw8CLe3t8L9/b3HRjvfCfPtt4/T6XTYLi8vXV9fX9jf38fBwYHA5729PWF3d1fv32H8zHl0dITz83O0tLTAxsibm5tISUlBUlIS7Ha7zvT0dGRlZQmJiYkee3JyMn4jNTUVIyMjKCgocBOurq4iNjYW0dHRIqusrER9fT3q6upQW1uLsrIy2WNiYuQXFxenk6AtKioKQ0ND8hPh2toaEhISkJmZidbWVrhcLiwuLoKBlpeXMTMzg66uLn1ndqyGWREMxArGxsbchBR5ZWUFGRkZymZ2dhYXFxewBPfg+vpa2jY1NYmUvpSCzwTlsRqC0tJSN+HS0pKMNTU1uLu7w+vrK97f3/H29oaXlxdYPgricDhEkJeXh/z8fJ25ubnIzs7G5OSkO8OnpyfH+vq6Sk5LS4M1RiIjHh8fRXR1dQXKwp9JWFVVhYqKCpSXlyurkpISTE9P6xQhtWKU8PBwiUsCZsWymTHBoNSKpTY2NqphBmwgdRYhm0IN+ZFdY9rHx8d4fn4WWDKzHBwcVECStbe3C21tbWpiR0cH5ubmUFxc/JeQgjc0NCAkJERO29vbGlaSU/DQ0FCN1fDwMPr7+9Hd3Y2enh6ht7dXU1FUVOQmZFOam5uVdnV1NYKDgxEZGSm94uPjRRYYGIiAgABERERgYGAAExMTkocBRkdHwSoLCwvdhAsLC+js7FTa8/Pzmnp2kGQcEWbEEr28vODn54ewsDCMj4/Ll93lqLFpPwj7+vpkZOqMxuu4tbWlk03jM6+Wj48P/P39pScr2tjYkD/PH4RMn8uAP/6GIedIsZMkNZnyJh0eHnoCqmSmTuHZgO9bhQHM5uHW4TtHivNnSHmPmSG/cdhFSA2mpqZgrTKcnJzg9PT0nzDfrH+0QLy9veHr66vu8puHkBGYOufODPL3oTY2nrRbyxgfHx/SLCgoSFlTDt4kGzc1Lz47zdtAsDnfYezmZJMIzir13tnZ0YTk5OTAZo2Lk0uBy4Ew24Tj8j8YX15F48dd8AdtTsye1VGesAAAAABJRU5ErkJggg==', 
	@ORDER_INDEX=13,@ACTIVE=1,@PUBLISHED=1,@PATIENT_OR_ROOMBED='P',@IMAGE_NAME=N'Close Observation (Patient).png',@ICON_NAME=N'Close Observation (Patient)',@SHORT_DESCRIPTION=N'Close Observation (Patient)',@LONG_DESCRIPTION=N'Close Observation (Patient)', 
	@COMMENT=NULL,@MOUSE_OVER_TEXT=N'Close Observation (Patient)',@FACILITY_UID=NULL,@FACILITY_ICON_NAME=NULL,@FACILITY_DESCRIPTION=NULL, 
	@FACILITY_COMMENT=NULL,@FACILITY_MOUSE_OVER_TEXT=NULL,@FACILITY_PATIENT_OR_ROOMBED=' ',@FACILITY_ACTIVE=0,@FACILITY_ORDER_INDEX=0, 
	@ENTERED_BY=N'softinfo\bmsuser',@ENTERED_DATE=@DATE_NOW,@LAST_EDIT_BY=N'softinfo\bmsuser',@LAST_EDIT_DATE=@DATE_NOW

	SET @P1 = 0
	exec usp_Insert_Icon @ID=@p1 output,@ICON_FLAG_ID=NULL,@GROUP=N'WHITEBOARD_ICON',@SUBGROUP=N'STANDARD_ICON', 
	@ICON_TYPE_CODE=NULL,@ICON_TYPE_CODE_SYSTEM=NULL,@ICON_TYPE_CODE_SYSTEM_NAME=NULL,@ICON_TYPE_DISPLAY_NAME=NULL, 
	@IMAGE_BYTES=N'iVBORw0KGgoAAAANSUhEUgAAABQAAAAUCAYAAACNiR0NAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAOXSURBVDhPpZRrUJRVHMbf5bobaFwkZEFLNBO0SUpMKafxxsXK1NSUIE3HG1p5QctLLjmYAi631USE5RpGSnggmZRLSlrZNETWODZMNX0wv9j0QWHZZXl/HQ4To1/hw2/e9/+c5zznf8570Xq3fLpfz2kWzowvRoTryAXh2lEkNGdGfSu/34aOmyPjt7/gVD2ac+85Qfsv6I3XRgRtHfRnVcrA9LOCpk70M1dGBA0/oGeWy8AdtYK6Tij/Forb0Itb4fTXg7X9G1UrrbRdabr0UHIZyq49wFU4cx3dYkdzbT8nnEWX+Sm9iH7rJfTcZshvoyP9JH9n1KLnyzDJv4fPc2N3MeQ14z52ka79FXTtK5dU8OeH1bIZuYClCk3fdUFYElLw0Dzoes8O1uvULP8ATdOYO+EZyGyBo1dYEhWHj6cX9w+cZ/eLKzBoBuX5n4Sps7mTZpWB2xrEhtgkNfB9Si7sayE6eLyqw/2DYU8Tf2wsUXWcOQp3eiNmvyC8PTw5OmcN1gVpTAt+XI1bn0uUgWlNwjInWQk3VhbS8spH6j7A148gX396Npzl8MxUpYnEvdxdW626m/XYU3Kx7yDjFpYZqx4MvCgK5m1SwlfzD5JojuHJwHDSpy3Fw2Dgx6QcJo0KwzwqGPf6JtriDynvzJDJNCy0kBu7jgCTP8ZH/Li1yiI7XC2EfcZmZdoWEa+uheOT+WxymrrfGrFAXS3mxTC3gdzI1Q+d3cDYOG00tdHvwppiGTivUtSFr1cmb/lgAjQT/xgPUu89uE2j5om/5sNN353gk8NbhhilZ/ok0G7czFXTFu6YDsBYG66Ej2VgYrVonbR9aNWtxhdgzEkujR48hgHe9H0WgvNxBGUR6zVOaZ2P7pKaDXfQMRyBWXQ/kY/r5WwZmFQtfn06Q5m8ZIc/h74PEZ/QGbpnKLA9RG5HarfDDsmOvQk0mLgbdgRHuJV75mzuhWXTM+UEfYtz5JeyqFS44uxkjVlC/diN6BOP44jMpzsyj4KQFZSFptI30aa0+1IrlJoI24Rb+gY8igl59E4/hXuZfA97Xi0VzK+BqaWS0/RE2eiWOKKPy7pE4YiSkx/SipVviCk2nM+X4l6eJwNfswsWfY4jpmj4TC/C9VIl/W8UoDmWlQmW1uGcXTJ8ZpXgjq+hP7lQBq6sEKR+SV981fBZWIX+eh2sPYHWm1LZwk75a1rXOHzelnPT5E/knXL+A0N+C9htiwknAAAAAElFTkSuQmCC', 
	@IMAGE_BYTES_INACTIVE=N'iVBORw0KGgoAAAANSUhEUgAAABQAAAAUCAYAAACNiR0NAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAALwSURBVDhPpVXLK7RhFH9cotig1BQbajbDTpOxUTMLhGbGIJfFKOQ+cllQHyk0NzHjfhm55BKT8BoUzbgUi4myUJZ2yn/x856j9+3zfTuz+PWe5zzn+Z1zfud5ZsTq6uqfs7Mz6eDgICYcHx9LGxsbkpCJIp+fn3h/f48JHx8fuL6+htjb25Pe3t7w9PQUE15fX3FycgKxvb0tvby84OHhISY8Pz/j6OgIYnNzU4pGo7i/v0c4HGZEIhFe397eqr6bmxs1huy7u7sfeHx8xOHh4Tfh1dUV5ufncX5+jouLC1xeXvJ6Z2eHbUIwGMTi4iLvh0IhrK+vIxAIMGQOLoIJd3d3pcbGRsTFxfEBOtzf3w8hBPLz81kX+RagsLAQiYmJ2N/fh9Vq5f2/odfruQhBoy4pKeHN8fFxzpKVlcXr9PR0JvD7/bzWarWQC0BaWhoSEhJQV1cHu92O7Oxs3udERFhTU6MSDg4Osp2SkoLU1FSsrKzAZrOxz+FwYHZ2lu3c3FzIVw6np6cwm80/CSmLckCn00Gj0YCqJhmGh4eRmZmJjIwMrK2tqXLk5OSgp6cHtbW1nJgKmJiYgFhYWGANibCoqIi/paWlUKo2GAzsKy4uhtPpRFlZ2X/6EVl9fT3PQExOTkoWi4WD4uPjkZSUBEpgMpnYR1rRMKqqqtDU1MStkr+goADl5eWorKxksu7ubshcEG63W62QAvPy8tDZ2YmKigq1EhpGR0cHWltbuX2Kow7I19bWhpaWFm6fOmBC2qAg0qyhoQG9vb38Va5FdXU1+5qbm7ni5ORkJu/q6kJ7eztjYGAAHo8HwuVySWNjY6wRTYvuIB2miRqNRtazr69P9ZEUJBHFUYwCGt7U1NQ3IZU6NDTEoEwEuj6Kj+x/fUqc8h0ZGcH09DSE1+uViJky/BaUmB6Fz+eDkMkkMkZHR2OC3On3pZ+ZmZGWl5dBjt+CJKPnubS0BDE3NxeWf2T5FfwW8t8Itra2ID9jfAGWoL8xsYcxGgAAAABJRU5ErkJggg==', 
	@ORDER_INDEX=5,@ACTIVE=1,@PUBLISHED=1,@PATIENT_OR_ROOMBED='R',@IMAGE_NAME=N'Womens Program (Room).png',@ICON_NAME=N'Womens Program (Room)',@SHORT_DESCRIPTION=N'Womens Program (Room)',@LONG_DESCRIPTION=N'Womens Program (Room)', 
	@COMMENT=NULL,@MOUSE_OVER_TEXT=N'Womens Program (Room)',@FACILITY_UID=NULL,@FACILITY_ICON_NAME=NULL,@FACILITY_DESCRIPTION=NULL, 
	@FACILITY_COMMENT=NULL,@FACILITY_MOUSE_OVER_TEXT=NULL,@FACILITY_PATIENT_OR_ROOMBED=' ',@FACILITY_ACTIVE=0,@FACILITY_ORDER_INDEX=0, 
	@ENTERED_BY=N'softinfo\bmsuser',@ENTERED_DATE=@DATE_NOW,@LAST_EDIT_BY=N'softinfo\bmsuser',@LAST_EDIT_DATE=@DATE_NOW

	SET @P1 = 0
	exec usp_Insert_Icon @ID=@p1 output,@ICON_FLAG_ID=NULL,@GROUP=N'WHITEBOARD_ICON',@SUBGROUP=N'STANDARD_ICON', 
	@ICON_TYPE_CODE=NULL,@ICON_TYPE_CODE_SYSTEM=NULL,@ICON_TYPE_CODE_SYSTEM_NAME=NULL,@ICON_TYPE_DISPLAY_NAME=NULL, 
	@IMAGE_BYTES=N'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', 
	@IMAGE_BYTES_INACTIVE=N'iVBORw0KGgoAAAANSUhEUgAAABQAAAAUCAYAAACNiR0NAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAPLSURBVDhPXVRZKHZtFH3NSVKSK0OUKyFJhkSuFOWCIiUUSZIyz/NQ5tn3mWUupFeZhxCZhQtTIkMZIopcuFmftXX4+y9255zn7Gftvdbaz6O6vb3N+vj4UD8+Pqqfn5/VT09PEnz/f3D94eHhJ0/Zo+TNz8+rVff39wufn584PT3F2dmZPBknJycSyvvR0dHPmpKnPC8uLvDVGPr7+6Fi1YODA+Tl5SEnJ0ciNzdXnlzLysrC4OAgFhcX5ZvB//8Nrk1NTaGmpgYqtru3t4fU1FSkpKQgLS1NQJTIzMzE379/0dLSgoyMDAHKz8+XgtyTnJws67Ozs2hsbPwFzM7ORkFBAZKSkmBvbw8bGxuYmZnB3NwcxsbG0NbWhqmpKaytreHk5ISwsDCUlJQIcHl5OVZWVlBfX/8LWFRUJD9YTVdXF4aGhvD09IS7uzv8/Pzg4eEBX19fWFpaQktLCyqVCgEBAaiqqkJ1dbUANjQ0QPXy8qLe3d2VatSAenCDm5ubJJEqxZ+YmAClaWpqQmBgIPT19WFgYCDStLa2Ym1t7RuQ1hOQ3bW1tQkFTU1NAZyenhYaBBoeHkZ3dzc6OztRVlYmsrDL6OhocZeAQpkub21toa6uDkNDQ4iMjJREUiSgWq3G4eEhmpub0dPTg/HxcQF3dXWVvJiYGIyNjWF9fV0wxOXNzU3pjhvCw8Ml0cvLCzs7OwKwsLAgDjJvf39f2FBjMklMTMTk5CQ2Nja+AV9fXwWwq6tLNsXGxkJDQ0PcDQ0NhY+PD7y9vcWQqKgoKUQgFqXbNHFmZgbb29uora39pdzR0SEaUEPFRR0dHejp6clmJfhNORISEkRLUl5dXZXOZbCpIU2hRnSpuLhYNtvZ2UkBut7e3i5uch45i3R+eXlZcjmPlOX4+PgbkC7TRdIdGBhARUWFAHL+5ubm0NvbK4JfX1+jtLRU5OC48LRwDwH5JCDn8efokT8BSYOADg4OYhRBCHx1dYWRkRE4OjrKfwsLC8ml5mTGi0QASZlukvLo6KhMPjc4OzvLfHHgqdEXE/lHKYyMjCSHo8OzTCAO/0+HCiDnUHT4SnZxcRHXaNbd3R2+xgs87+wwODhYaNM8Hr8/f/7g/PwclZWV35TJn2ND8UlRoRQfHy+n5P39HW9vb1haWkJERIQAsyDzTExM5Fje3Nx8d8gb+PLyUqqEhITA399fnLS1tUVhYSH6+vqkGIMScC0uLg5BQUGwsrISQHZMUBnsL5rzHAPec8p9qNx7XEtPT5c7Ugm6q1yy7JTjxCuPubyx/gGLgABc/BtVWAAAAABJRU5ErkJggg==', 
	@ORDER_INDEX=15,@ACTIVE=1,@PUBLISHED=1,@PATIENT_OR_ROOMBED='P',@IMAGE_NAME=N'Respiratory Therapy (Patient).png',@ICON_NAME=N'Respiratory Therapy (Patient)',@SHORT_DESCRIPTION=N'Respiratory Therapy (Patient)',@LONG_DESCRIPTION=N'Respiratory Therapy (Patient)', 
	@COMMENT=NULL,@MOUSE_OVER_TEXT=N'Respiratory Therapy (Patient)',@FACILITY_UID=NULL,@FACILITY_ICON_NAME=NULL,@FACILITY_DESCRIPTION=NULL, 
	@FACILITY_COMMENT=NULL,@FACILITY_MOUSE_OVER_TEXT=NULL,@FACILITY_PATIENT_OR_ROOMBED=' ',@FACILITY_ACTIVE=0,@FACILITY_ORDER_INDEX=0, 
	@ENTERED_BY=N'softinfo\bmsuser',@ENTERED_DATE=@DATE_NOW,@LAST_EDIT_BY=N'softinfo\bmsuser',@LAST_EDIT_DATE=@DATE_NOW

	SET @P1 = 0
	exec usp_Insert_Icon @ID=@p1 output,@ICON_FLAG_ID=NULL,@GROUP=N'WHITEBOARD_ICON',@SUBGROUP=N'EMERGENCY_ICON', 
	@ICON_TYPE_CODE=NULL,@ICON_TYPE_CODE_SYSTEM=NULL,@ICON_TYPE_CODE_SYSTEM_NAME=NULL,@ICON_TYPE_DISPLAY_NAME=NULL, 
	@IMAGE_BYTES=N'iVBORw0KGgoAAAANSUhEUgAAABQAAAAUCAYAAACNiR0NAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAROSURBVDhPfZN7bBRVFMZ3Z2d2nrs7+6Ct3dJSWvvUal2htVjdQukTW2iLYKGKpmBCJQYQa6GKZNugGE2oCQkmagyJkUpN1kei8ZGYqPEPo5iYaqNgNHFHEqJWQSIt+/nd3dYYEv3jy52599zfOfc8XANF0oGnonLycKH63yrgmdD/2DzB80MFUtI1Zrvex9J8oLMdaGulWrJqXVgX//+9f/VZRxvQFMesrcE1FnEnoSiA5QNMiyvlowJUiHthKrKwim+b8lPC7h/xXzdxTvPAlVhCoOQGXC7ATamUj/9BiSAqh8pdkPgOU35Kp41MW3FvQY4mLQBlGqgezPo9GDY8aNdkdBkyei0Z/X4qIKOPa4cpYx33N+gy3g7K+NOWAdpD3HdLyAJzpWRmkwaIKvhkqQLLy9BdHvQukbE1V8H6iIy2sIyont1fTvsjOTK+z5cxRxtYWWgWmEcgL4AgVHgxe4OKmE/OXOzkpYPlXpy4ScWLN6rYf60XpaYHzUEPJooUzJR5camY9+hUQB1DAKMEFnqBKqpex4W4gRijFcCmPBlH6zV8sd7ETJ+Jr7oNHF+pYR/Bb9LJjys0XGYAKOFdRurYoihFBApYncZWMcDEoS5HyQBbGMVL7Qb+2hPAme0+HF9jYPouC1/SwXedBv6gfbpRB2oIXeaFk8tAEqVyEjcT1kzYJgtnCKwKK3AzySuZ09HbdXw06EN3lYqeahWn+f3LTj8u3ufDPO3T7SbQQCjPU4UCWEbgbTrSPSY+aDGwsVxFhNWUJA/yWcWG5V7Ey1S4Pax+pYq3tlk4vy+AK4w6zajTGwkVwcQ0OKVeAisJZOiXN1t4leuzhBYHsxE2s0iDDRr2cz/OvMWY6xNbLTijQVyh0g8Seg+hdzDKVTqcSgGsJlBsbPPhLJ8xuclEeSaHEhqZ7OG1Bk7e68ML/RZ2rNLwCm1+TgQxP0bgsM0o/Uj3cWqadKSYS1fiOgJ7uDHox/xDATiP2KiJ0hOBa9gyx+608PWojZlHbXzGp07z++LTIeBICOkDBO5klCwU6Nip5SxngMLD/X5gxMbvh4KZpy0Cn6OxMx7EBULmJkI4TYfvPhBA6rEg8DifvovALZxlpiUVW4yQlcWOLBBPhlBfnAW2MicvM0dzR8PA8xHgWBhrK1R01Wh4nU8/tzcACGD/1cANzCHbYY45eWPABz9nVQCrrlGwnckWUSaY5zr2mthXZA8ejuuYYrP/ylSlWVDx5FStiFAUZV22KL8NBTC0QkdtvoJijmOUE1PKAglwNVWZR3EtYDs1Ej7CDvi028S8eCEnzLmeDscrCGSriKYGG/YbepzoMLCbvbmLGuFZgg7HGeFBTs0eRjbEcdzNEXzmVh3fEnipjfdv0XGebebaWyK9l6LBDy06zrK5p9lnH1JTm01MbrFw6m4Lr7GZp6hTAxYmuX+y18BUl4F36ODj1RqmGelPbJnPSxT8DQACADHB4S8LAAAAAElFTkSuQmCC', 
	@IMAGE_BYTES_INACTIVE=N'iVBORw0KGgoAAAANSUhEUgAAABQAAAAUCAYAAACNiR0NAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAANiSURBVDhPjVRHSyZREBxFEARFVMwZFREjomJOoKiYc84554Q5Yc4KCip48OBp7ru/rfarkhncZRf20MzM6/eqq6vrjZGQkLCemZlpZmdn/zOY/5896enpppGcnPyzp6cHOzs72NrasmNzc/O3byvH9T9z29vbWFtbQ319PYzU1FSzpqYGjY2NaGho0JPR3NyM1tZWRVtbm/3O9aamJnuftZ9gFRUVX4BVVVWorKxU1NbWCtgCJNj3aGlpEVhdXR2qq6vtczxbXl7+BcgEgRhxcXEICgpCaGgowsPDERUVpYiMjERISIiCuaKiIhUmMwtYgGlpaSYXyaizs1MVXV1dYRgGYmJiVICAERER8PDw0LqnpycyMjIERsYEJqgNSJ26urowODio8PPz00EC5eXl2QwcToCXlxfCwsKQn58vMJ5rb28XqDTkqLu7uzE0NITp6WnMzMwgMDBQgGyTjLm+sLCgJ5lkZWUJYGBgAMPDw+jr69PQmDPoL4JNTU1heXlZVqFGBIyNjUVHRweurq60TlmWlpYEbBWZnZ3FyMgIaD3ZJicnx5yYmNBGenFxcRH+/v5wcnKSbmyDhVJSUuAYINbX13F0dISDgwPQfysrK+qKpFjQyM3NNefm5mTW/v5+HXR3d4ezs7P0sgbD76SkJB0+Pz/H9fU1jo+PBUoS4+Pj0tJwiGuSARMUmKb18fERQ8e1RGFhIWh8Tpuasj1K8Pj4iMvLSxweHoo1C/G8UVBQYFptkCUPBAQE2BrS9JOTk2qJ3qPW9/f3eH5+xt3dnVhSXw6tt7cXhmOTSSAmbm5ucHFxYQ8lPj5em05PT9Xm/v6+3l9fX/H29iaWZ2dn2N3d1QwomQBZgRsfHh60ia1xygSkNbj+8vKC9/d3DWR1dVUaPj09icDe3p4Gx7024MnJiQ6yenR0tAATExMlNoE+Pz/x8fEhXTlt2oUk/gq4sbGhlm9vb6WRm5ubAIODg6UbK3NYvDlcd3Fx0TWjqSkD7Wa3/H0oBHV862r5+vrC29tbniQwgz8NPi07lZaWgh7mDObn57+GYtmGVSg82fIacXNJSYmuk/V/5C+rrKxMrIuLi5Wjh63bwytsOP4aP0idrXL0dD71GR0dxdjYmBgwx+A7bcUfCCdKKfhkkB2v3i8X2BfcECL6eAAAAABJRU5ErkJggg==', 
	@ORDER_INDEX=8,@ACTIVE=1,@PUBLISHED=1,@PATIENT_OR_ROOMBED='P',@IMAGE_NAME=N'evacuate.png',@ICON_NAME=N'Evacuate',@SHORT_DESCRIPTION=N'Evacuate (Patient) (EM)',@LONG_DESCRIPTION=N'NULL', 
	@COMMENT=NULL,@MOUSE_OVER_TEXT=N'Evacuate (Patient) (EM)',@FACILITY_UID=NULL,@FACILITY_ICON_NAME=NULL,@FACILITY_DESCRIPTION=NULL, 
	@FACILITY_COMMENT=NULL,@FACILITY_MOUSE_OVER_TEXT=NULL,@FACILITY_PATIENT_OR_ROOMBED=' ',@FACILITY_ACTIVE=0,@FACILITY_ORDER_INDEX=0, 
	@ENTERED_BY=N'softinfo\bmsuser',@ENTERED_DATE=@DATE_NOW,@LAST_EDIT_BY=N'softinfo\bmsuser',@LAST_EDIT_DATE=@DATE_NOW

	SET @P1 = 0
	exec usp_Insert_Icon @ID=@p1 output,@ICON_FLAG_ID=NULL,@GROUP=N'WHITEBOARD_ICON',@SUBGROUP=N'STANDARD_ICON', 
	@ICON_TYPE_CODE=NULL,@ICON_TYPE_CODE_SYSTEM=NULL,@ICON_TYPE_CODE_SYSTEM_NAME=NULL,@ICON_TYPE_DISPLAY_NAME=NULL, 
	@IMAGE_BYTES=N'iVBORw0KGgoAAAANSUhEUgAAABQAAAAUCAYAAACNiR0NAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAT0SURBVDhPbZN5UJRlHMdXBM90PEZFncpJxzQrR02ccZqmqLAs82IkVHLWxpARM8cEBTkXVJTbxLTUQryYEXg1RO7LXZblVmAXORZYZA93XQJFOT+9bGP/xB+feea5vr/v73m/r0Tb0enf39cr9Oq1wpC+WegztgpWs1Ewm81Ct8k4KnrrY6HHrBGGOx+K57WC1WoUTF2PhZy8u4LEYDDl9vcN0qjWijxGrTbxQPOUBw0W6jSGUaluMtLQ0Ia2vhWN2khtk5kWnY6kpMtIeowWobpKy4Hgm0iD8pEGyvE8VoTXsRz2BmT9n8AsvIJy8Q4uxktWiVRWhWfoXe7cLSMuKhrJC5NFUJXpcDuaxef+razzt7DFtwM3Hy1bfDrYesRgm7v6PcEt6BlugT3iXgtf7Stn7a5MnL7PY8ORCtL+auRc/DkkvSOClZ1sD77Pl+HdrD8O7hHgcUIcRTb7Pcc1aBgXrzredT6B46L1TJv1DpOmzkciscNxhQfbThhIyTRwNv43sWWzRVBWtOEZXoD7aTOuEUOs3nyRN9/fwdKPDjN97nJRrJhVG8R2JBIWfrATp00ROH1z2jZf436Z72L0JOcaiY+/iMRqsQiKihYOnMzD6xcr7zkfxGH8JBat2sIbSz+zXXLaeJz1+zOZOGUWu+P6OHgVFjvtYMa8ZUjjnrEnppHUfAPxZ35H0mU2CSXlLfjEqPCMamHC5Ol8sS+FY7fBNwlWufzMh1tP4xn9FBdpEvvP9eEeWG0r9Onua+y/Aj8mtJKRr+NMbIIoKGZNrmwgIKEMn4sWZsxdwuI13+Lul8eu4Aq8Yjo4Kl7yE135X4eAZFiyZhsz5izi0KUBDotrocm9ZBR1EG8TFB3KlWpCLyiJuD2MR2AOMx0XYmc3lrH29tiNdWDlJ1KCr/UQmQ4HYups7ly9E4m6B3tj6tl19CpZik7iXgkqyzSc/ENB7N3nxObAqbQhDsWW2/K1ac8pxo0bx7rtgVwqhdXOO5m7YBkJuXC1CqT+Kcye+zrZKr34UcTYdImxUSjriLteQmLpEAdji/h4ozfXVJD8EFIfwfK1X7N0pTNhSY+wGzOG9dJgfoq8wwaPABYvd8bewYGbGZWcSRBj0222CvdLajh/S0VaHRxJKPz3wTd7EZZYimdAImPs7JH6nmdv0BXb3sTJU5k5ez5vvb2CtS5u/OB3lnR5IzEjDl8YTUKZopo/b1eR0QgXck2MnzAZx/kLmDNvAa9NmcZGj4Ok1Qzza7oW36gU4lMqSSp8wm2xgztayG4boLxeS3Rk1EiwW4WSUgVXs1Vktw+Squ7HW3aWxEIticWtXFPqydVBRtMQ91ogv3NEADKbIL0BUpqGxfW/UalbiB75l81WrZCvKuRGkZJ8Qx/3Ol4it0KhfpACAxToIUfXLxbr+4/M9iFyWkVh0V26bpg8/UtKGtuJio5FYuwyCznKUlIVNVSKQnLDIArDACUjiG5GQ24coLRzWASKTUMoLX2omnRERIoOLZZngrJcTUFFI7peaOyC5leIBZpHoaF7iJauYdqegqZrkEfP+6nTthN5WnxDq94sNGmakZdUUFajRvVghFobZTWjI6+tp7xaTVWVhhLxvKK2jlJFKdEnI5Dcunkj5+KF84SHhSKTyZCFi2N4iI2wsNEJCZeJe2Ecl4UREiYjSBZKeGgI4SEh/AN/2oM+OUPZYQAAAABJRU5ErkJggg==', 
	@IMAGE_BYTES_INACTIVE=N'iVBORw0KGgoAAAANSUhEUgAAABQAAAAUCAYAAACNiR0NAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAANgSURBVDhPlVRJKLVRGP7MSiyNCyvJRiHKRoSdiIUUSdkIS5mumZCpjIlkTFHkIyT3ZsqUWeZZlHlhyeb57/Pqu/dfkCye3nO+732f8w7POcrt7a3u4+NDfX5+Vl9fX9W3tzcB1z9B86XV/Gn1er2qPD4+Gj4/P3F6eoqzszOxv4F+Guh7fn4OY2Lo7++Hwiz29vZQXFyMwsLCX1FUVCS+paWlKC8vF1tSUoLp6Wk0NDRAYapbW1vIzs4W5ObmmpCTk4O8vDzZ63Q6CSQZ95mZmUhOTkZKSgqysrKEsKWl5YtwZ2cHBQUFppOrq6tBVFZWmojS09MRHh4OLy8vODs7w8nJCYqiwNfXVzKdnZ01E25vb6OsrAxVVVVCEhsbK44hISFwc3NDWloaoqKihCAgIADR0dEC7uPj41FTUwPjQNDc3GwumUSNjY0ICwuDnZ0d/P394ePjI0EMzsjIgKOjo/Spu7sbgYGBclh9fT1qa2sxNzdnznBzc1Mc+cPBwUEyGh4eRm9vLyIjIxEXFyeB7Fdra6u0hwdx39XVhaamJiwsLIiVKa+vrwt7R0eHnBoUFCSN5wBIROK+vj6RxeDgoPx3cXFBZ2enfOe3xcVFqVCGQsL29naMjo7KEFxdXWFpaQlra2tYWVkhNDRUyFRVlQOYHVswMTEhVVEdKysrZkKWzNTHx8cxNTWFkZERaQFlkpqaCltbWyQkJEgW7LGnpydmZmawtrYmsmJVTEqGopU8MDCApaUl1NXVyRCWl5fBgyj64OBg+Pn5oaenBxYWFqI/yiopKUnUYGNjg8nJSbS1tX2VvLq6KkOgHqWxxpJiYmIk6/z8fCmf4tWGwcFRi97e3oiIiAAvAJORWK2HY2NjODg4EMXb29vDw8MD7u7uIpXExETJlj2k5oaGhmAwGED9Hh4e4uTkRGKlvyRkL9g7XnRmyftK5VOslAMvPwOPjo5weXkpftzv7+8LuDYRsoecEAmurq7E+f7+XtbX19dif3qFmBnBQ3iY6XHgAObn5/Hw8ICbmxsTSPgd/vfh+u7uDsfHxyIhKZn92djYwPv7O15eXmDMWsD1d9D+0xofWRg5cHFxIQpRnp6eVJbESe/u7v4Z7DnjGM+BKcaJ6XmFKioq5Bmi/QsYw5dKs/8AHTJkrwDLsvIAAAAASUVORK5CYII=', 
	@ORDER_INDEX=16,@ACTIVE=1,@PUBLISHED=1,@PATIENT_OR_ROOMBED='P',@IMAGE_NAME=N'seizure.png',@ICON_NAME=N'Seizure Precautions',@SHORT_DESCRIPTION=N'Seizure Precautions',@LONG_DESCRIPTION=N'NULL', 
	@COMMENT=NULL,@MOUSE_OVER_TEXT=N'Seizure Precautions',@FACILITY_UID=NULL,@FACILITY_ICON_NAME=NULL,@FACILITY_DESCRIPTION=NULL, 
	@FACILITY_COMMENT=NULL,@FACILITY_MOUSE_OVER_TEXT=NULL,@FACILITY_PATIENT_OR_ROOMBED=' ',@FACILITY_ACTIVE=0,@FACILITY_ORDER_INDEX=0, 
	@ENTERED_BY=N'softinfo\bmsuser',@ENTERED_DATE=@DATE_NOW,@LAST_EDIT_BY=N'softinfo\bmsuser',@LAST_EDIT_DATE=@DATE_NOW

	SET @P1 = 0
	exec usp_Insert_Icon @ID=@p1 output,@ICON_FLAG_ID=NULL,@GROUP=N'WHITEBOARD_ICON',@SUBGROUP=N'EMERGENCY_ICON', 
	@ICON_TYPE_CODE=NULL,@ICON_TYPE_CODE_SYSTEM=NULL,@ICON_TYPE_CODE_SYSTEM_NAME=NULL,@ICON_TYPE_DISPLAY_NAME=NULL, 
	@IMAGE_BYTES=N'iVBORw0KGgoAAAANSUhEUgAAABQAAAAUCAYAAACNiR0NAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAUOSURBVDhPZZR7UJRlFIeXFZZdFlxEUHRV8MZgmpfw2qSiBSqiSJCI18IbeA8aL6MlN1mSMVFxDMtqmsmaMGSTNFG8VDqVd0lKRQTEhWUxBa97YZ/OKvVPf/xmvu9873ne3znne1/FvCDlxjy9u9HQy/P/0nsYDV2VRoOfm9HQSWE0+Iu6yXuP/6/NlVhGD6VRke2rKKdnd5g6BSZPEkVCZASMHScKh5hpsOAtWJQIiQkQEQWvjoXXJ75Y61LUZJgQTouvGkW2v5sRDw/w9hF5g6caOqhoe20Utk/SefrXNh49zOCRNZdH9fu4f7gAy5JEnvp3A6XkabUvcjVazOoOKLICBKh0A4XiudrUnljTZ2O9vw8ruTiIx8lI2pyD5XkcbczkLpupLDPQFDb8vzxXboNa2Q50V4orBU4fT558uYqnfISNaIEEgVUHjz3hmTs4xJFTSytduScbVd3OoGFCWDtU2Q6UpqMRoEqBIytBHOQgzRMFiqR8q7i3C8iuevGOlIisb5PNCeNGxVKa+wc/h75wGChArbgbr8fashE7k6isCqTstCfNTV0l2Vdg0g6nApvdl8uXu3DxQmecdj+JuWNqG8W5rTIUVQcaNW4C1Auwsxu2wonSo5Xcqh7E6PHeaHQerF6to6V1gLjRSB8DKTrYi+AgLaH9VBwt7SJxfx7a/Dh+Zgz3BnWj2UshU+6mMDJEi+1arLhJoqJ8BDp3nVSgIvwNFfXml6QNGtmsDxvSgyQuSaK8zZ0F2A+bTUP51T5UxIfSrHM5dAGn+OFokf+QodgsevZu60ny2z6c/FGSHK7ypGS8+PMPf95dpiJ1uY6q630kpsHmUHDqmpZfVoZgCZDfJlsvwFkBPLGH84ze0mgfcRSI3ebqnx6nwxeHXYfV3lHiQVLiAFrtw3ksjh/j/3ziJee6cyClP/d6uaPY0lthdArwes0iKsxLOGOK5nRTFKfMcZSbYjluiuNYwxy+r53PwZoUShs2cMK8gLL6aNF8jlUlkv7FKxTGBXM/xAUMEWC8jkuXt3Ly76sUNR3hM/MRCs0nyW/4DkP9fjLqithw8yBplUZWXy1mTcV2VlzNYtWFQtaWbWJhXjjFMcE8GCTA7IEy5RkqLv2wnK9aayl4eIOdLefIt5wlx3KSD8zlvNdYzoq6wyyt+Zqk6gKm1+4ioraQ2Jv7STy0lri1o7gy2Z8Hw1QylEHuRmI8qNk8hN23S8h90kRuczV5pt/JMf1MeuNx0kyHSK4rJulOCXNqiom5W8z0mm+Ye34PEYaFvPNmGNZILZawf4FxXjgWaTkgxy6v8iwFjb+SZzlFZuNR1ptLWSGApQJaXFXK4utlJF8vIvnKdmbsS2LA9JEYp8qpmqKmIcyz3WGsHKckNffWBbF77yoyT2xla+XHGG6VSP/OsL76LBtunGBT5bdkVn7KjvPbWfX5QobMHElmVA+cs+SWitBgGuYCDpSSowU4X66glV40ZASxKz+atMJ5vH8gDYPAPzyzjZ2/ZbHnpxS2Fc9geXoUE6aNIGdGT6yLOkK85IdL7stS8pZQAUZ6QYLskiwf13ljz5bjlN2PnIyhpGaFsDxTz7LNepJTezF3diCrY/ScWihlrpGbaIHkuQyN0WAJFWBaX+Vx02g1tWL5dpyW27LgToo3plQfLqcGUJQSQP68TmyZ2ZkdCV04OD+Am8s6YlmqpS5RS81UL2rGqrk7WMXFvh78A/yJ42cFsE9pAAAAAElFTkSuQmCC', 
	@IMAGE_BYTES_INACTIVE=N'iVBORw0KGgoAAAANSUhEUgAAABQAAAAUCAYAAACNiR0NAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAO2SURBVDhPbVTHSi1REByXgr/gxr0gigkVxY2gmAOKiDljwohXMWcRxYAoqIiKmMccrjknMG0Ec06IfkE9q+VeHry3aGbmzOk61dV1WjE1NdXY2tqqdnZ2/wTXLS0tVXNzcwkLCwvVyspK/d9+rvGfYmZmthgWFoaioiIUFBRI5OfnIzs7Gzk5OSgtLUVdXR0aGhpQU1Mj/zIzM6HRaPT7CwsLkZubC19fXyg81cvLC/7+/hI+Pj7w9PSUpKmpKZyfn+P5+Rnv7++4vb3F+vo6amtrERQUBA8PD/j5+Ukewdzc3H4B+cPd3V3C29sbXV1deH19xdfXlwDxnaB8fnx8yHNxcREJCQn6POa6urr+ApIRQXkSWRHo7e0Nj4+Pwurq6grX19e4u7vDw8ODPHnA2dkZ0tLS9KACSNFZJsvu7u7G9/e3gD09PUnyzc2NgDL4zbi/v5fgnt3dXbAHeoYEZP0ZGRmygWCbm5sYGBjA6empniVZEVSr1WJubk5YEpQHtrS0CCHRkK0ODAzE8PAwPj8/sbe3B2traxgZGSEqKgoXFxeSyPI7OjpgbGwMExMT9PT0CFvKMTExIXvJUkqOj4/HycmJAFJDQ0NDGBgYwN7eXtZ15aWnp0NRFAnaihVR29nZWXEFWQogPcQSXl5exCZlZWVii/7+fn1ZZLOysoLw8HBERkZia2tLrzEB6V/xoY2NjVpSUiIl6Tqo6y4ZkB21o1b85vvf3eb76OgosrKyhITCK1dcXIyjoyOxwf7+Pg4ODiTYQQZ13djYkOD64eEhtre35R/XqqurERERgdDQUCgODg4q6e7s7ODy8hLHx8eSwEQmra6uYnl5WTo7OTmJsbExjIyMYHBwUKKzs1P0jImJEVDFyclJzcvL018zsiRbAvIQMqB28/PzskdVVQwNDYmt+OQdj46ORmJiooAqzs7OAtjY2CjJBNSB0Y9cW1pakk7OzMyIRcbHx4Vlb28vUlJSpBnsMoEFkCVXVlYKfSZTR50+LHlhYQHT09NSsg6QDJn3U6F4kJOJTwHkSKqoqBD6TU1N6OvrE0YEX1tbk0HAkgmqA2YjXFxcEBAQIKOPXaadREPONnqPc6+5uRlVVVVyQGtrq3iRt4jasQltbW1yTQkWHBws+8iUpqdHFUdHR5Vd4ikcoGTY3t4uVqDhmZyamork5GQRnXoxmFNfX4/y8nIZttRSbPNzb7WxsbFISkoSYdkgGp2AnNYEpDYhISHCgMD0Lf/xQI6vuLg4mTg86A8Y8DLM9wswNQAAAABJRU5ErkJggg==', 
	@ORDER_INDEX=6,@ACTIVE=1,@PUBLISHED=1,@PATIENT_OR_ROOMBED='P',@IMAGE_NAME=N'negpres.png',@ICON_NAME=N'Negative Pressure Patient EM',@SHORT_DESCRIPTION=N'Negative Pressure (Patient) (EM)',@LONG_DESCRIPTION=N'NULL', 
	@COMMENT=NULL,@MOUSE_OVER_TEXT=N'Neg Pressure (Patient) (EM)',@FACILITY_UID=NULL,@FACILITY_ICON_NAME=NULL,@FACILITY_DESCRIPTION=NULL, 
	@FACILITY_COMMENT=NULL,@FACILITY_MOUSE_OVER_TEXT=NULL,@FACILITY_PATIENT_OR_ROOMBED=' ',@FACILITY_ACTIVE=0,@FACILITY_ORDER_INDEX=0, 
	@ENTERED_BY=N'softinfo\bmsuser',@ENTERED_DATE=@DATE_NOW,@LAST_EDIT_BY=N'softinfo\bmsuser',@LAST_EDIT_DATE=@DATE_NOW

	SET @P1 = 0
	exec usp_Insert_Icon @ID=@p1 output,@ICON_FLAG_ID=NULL,@GROUP=N'WHITEBOARD_ICON',@SUBGROUP=N'EMERGENCY_ICON', 
	@ICON_TYPE_CODE=NULL,@ICON_TYPE_CODE_SYSTEM=NULL,@ICON_TYPE_CODE_SYSTEM_NAME=NULL,@ICON_TYPE_DISPLAY_NAME=NULL, 
	@IMAGE_BYTES=N'iVBORw0KGgoAAAANSUhEUgAAABQAAAAUCAYAAACNiR0NAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAARoSURBVDhPfZRbbFRVFIaH6bQzZ+5z5spMO+0w0xu0MxRKQBEsESlQRARBrnIV0ShEkAAFEWxLkWLCpS3UW3w24aGvRh+I8dEn45MPRaWtJRCUAIlA5/M/UpCY6MOfffbZa3/r32vtc2ybKu2He1KOwe60879VrjVL/xNzUuvHy+2Dts6g7RsqktC2BBa3SoseqnVifDR/8v2/15YuhgUt3Aq4sHVGJg1SWgpeH3i8GiWfFJBCehd+Qqaeg5JfsuIeS3PDzUjAwNYRFdA+CWw2sEtlkkfzgB1MKSJFJxTWGJR8kksxDsVa+yb0q5I/BDoU4CxR5hKKUblNSRnNax1Q56RYX0axrgxqpClShdbjWgtZ+wQssXE7OJlRo0TAuH0QtzaHFJBUYE7Kl/L7rBiDDTHuzhHgGYPiXBfFOS5odkJBsUpytTJAf+1cxlLVPHB7GDEcAiYEjCjAyqqgH6aH+WBqhlysilQ4wp/L3LDCQ3G5pOdiq4dvZyfYU50jGkzQlG7k9hQ11XQzHPYImBIwLRfTSvmlOciztQVOzasnbYbImF4ebA3Cdj/FbSr8VoPLbUnm1xf48Kk6bIaX1WElzOmESTUlXCZgpYBTBZzt5PZCH9dXRmFnjOaKCOmoyf29YdgfgHY/HPJzc2eYu1vD3FmXxOkNsSIZgRkqRdbLqOpq68g5BmnWi4XKtMojFy4e7C0nn45Rk05S7IzDyTBfboxz4cUo44eVYJ+HazuSeHx+VldXQov2FgKMVFjAGgHnG6qTj/HNcrHbYOxIA6HyRvKZGJwV8GKSBYUUsWiUP7rTcNzH1T0ZnL4Qa+o1XyojM12M5Kwj1wu4yODOpnLuvSn7B91cO9GIWZEnn41R7JsMfSY3TsX4rVvzs3J4KsDVQ1MENFnbIIerdMnnGoyodLaOaQK+4GF8S5Dxd0JwzMuNjxqJqnuPgedM6JcGTMbPCXhGwGNZnH6TdQUBN6hhCwTMOwVsEHClMuzwUdyvjnYJeC5PvCpPQQ6xHPbKYU+MUcvheZ2iN8hwVxaXgOubBNwi4CI3o02PgC8L+Lqf8QMCdvu42ZsnUdVIU7Xq15+ATxO0zphMPBrhzvkKvQsw3J3FEHDDzCrYptq36tqojg8dWjXYOQE8qQIP5MhmczRk5OaijnjR5NKuOB9vjHC/V677vdzqqfobuLFJl1r30+rDP8CXBNluHVmZOzJ8sbsJmyNEqcvNV+0N3DyjTg6ovp+YOnKYn07X0rm+Qf8Eg7pUmO82T+XekhBj00snmrJMwFdVh71+Lr9dw/ttCY4uNjja5qNrTRU/duXU7ZBgAvbFuLS7jvbnTI497eK9WV5Ot2S4sTDO9Ubdw64669roYr6iY+9SLdo1nlYtB3Tcz6XP5OyC1Gc1w+qw1KMv54RiDkqvychy/TDmOBmrV1P2Ze1fj+gv8vPzBkP6UoY2exl6w8+Q3A4dCDB0WDoyMR7S+K70lta2e7myVmpzc2Wei+GCk+9r3fwFzhVG5rUIiUQAAAAASUVORK5CYII=', 
	@IMAGE_BYTES_INACTIVE=N'iVBORw0KGgoAAAANSUhEUgAAABQAAAAUCAYAAACNiR0NAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAANzSURBVDhPjZRHSyVREIVbEFyoG0FdGDGCIIpiVhQFQcWcc84Bc845Y845p03vZ35bzftq6Mc4MDCL4nbfcOrUqXOvER4ePpWQkGAmJSX9M1j/nz2xsbGmERkZ+bOhoUEWFhZkbm7OHrOzs9/+rTXm/16bn5+XyclJKSoqEiM6OtosKCiQ0tJSKSkp0ZEoLy+XiooKqays/BbMl5WV2fdZ+4uLiyU/P/83YF5enuTm5goj4CxyiMN/ApKAeRIXFhYqAOesYE4BWeCHbADU1tYKMrS0tEhra6sG30RjY6PU1dVJdXW1JuQcRDibk5MjRkxMjAkjFmtqaqSpqUk6Ojqkq6tLN3d3d8vAwID09/dLX1+f9PT0SGdnpyaBcXZ2tlRVVWlVdkBYkZVNjBkZGeLl5SUeHh4yMTEhMzMzMjU1pcKPjY3pHpsrxM3NTYKDg7UawLVkWl1fXy9tbW1aUkREhHbL3d1dAdfW1mR9fV1HAnY2Z6h+Tk5OEhISolUhkwLiL8AoZ2hoSBltbW1JYGCgeHp6yv7+vhweHsrJyYkcHx/L6uqqrKysqM2cnZ0lLCxMZQGUso3k5GQTXUZHR9V3sDg4OJCAgADx9/eX6+trub29Ve0o9fT0VNeXl5fF1dVVbE1VImhOH4yUlBRzcHBQdSLz7u6uHB0dqYZBQUHy/Pws7+/vEhUVpTJcXl7KxcWFbG5uiouLi9iaqlXBks4bqampJkIvLS3J9va2gnHA29tbBX99fZWXlxcFOjs7k6enJ7m7u5O9vT0FjI+P18pwARUYaWlpJh1EGzadn59riT4+PnZAWAIMUwAfHx81MYCJiYla/vDwsHrUSE9PN7mbGxsbKv7V1ZU8PDyIn5/fN4bMox/gMOYbDbEPulNlc3Pzb0Ao01my3tzcKAsAQ0ND5e3tTT4/P8VmL9UQdrClfABtPVBbAYjt7ICIbAECgG0IAAlKam9vtzMk8d8M7YB0mCyW37CQo6OjGpfO0wT0+/j4UEB0xncODg7i6+sr4+PjGlqy1RQOYmL05KLjeoxK5/AdulnNwSY8CFlZWZKZman7sB5J7LbB+ejIjbi/v1dGX19fqh+aWfaxbIPhuTlIhUu4aVxhIy4u7gfa9Pb2ysjIiExPT8vi4qJKQIKdnR01OyM+xQ3YhEZSJi8RrxOW4a38BU7mZQeJlo2/AAAAAElFTkSuQmCC', 
	@ORDER_INDEX=7,@ACTIVE=1,@PUBLISHED=1,@PATIENT_OR_ROOMBED='P',@IMAGE_NAME=N'oneto1.png',@ICON_NAME=N'One to One',@SHORT_DESCRIPTION=N'One to One (Patient) (EM)',@LONG_DESCRIPTION=N'NULL', 
	@COMMENT=NULL,@MOUSE_OVER_TEXT=N'One to One (Patient) (EM)',@FACILITY_UID=NULL,@FACILITY_ICON_NAME=NULL,@FACILITY_DESCRIPTION=NULL, 
	@FACILITY_COMMENT=NULL,@FACILITY_MOUSE_OVER_TEXT=NULL,@FACILITY_PATIENT_OR_ROOMBED=' ',@FACILITY_ACTIVE=0,@FACILITY_ORDER_INDEX=0, 
	@ENTERED_BY=N'softinfo\bmsuser',@ENTERED_DATE=@DATE_NOW,@LAST_EDIT_BY=N'softinfo\bmsuser',@LAST_EDIT_DATE=@DATE_NOW
	--END INSERT WHITEBOARD ICONS


	use $(varBMS_DS)

	INSERT INTO [dbo].[ConfigJob] VALUES (GETUTCDATE())

	DECLARE @server nvarchar(100) = N'$(varNewServer)'
	DECLARE @bmsdb nvarchar(100) = N'$(varBMS)'
	DECLARE @bmsEisdb nvarchar(100) = N'$(varBMS_EIS)'
	DECLARE @bmsEvsdb nvarchar(100) = N'$(varBMS_EVS)'
	DECLARE @bmsAuthzdb nvarchar(100) = N'$(varBMS_AUTHZ)'

	TRUNCATE TABLE [dbo].[ConfigTable]

	INSERT [dbo].[ConfigTable] ([SOURCE_SCHEMA], [SERVER_PREFIX], [LINKED_SERVER_NAME], [SOURCE_DB], [TABLE_NAME], [WHERE_CONDITION], [DESTINATION_SCHEMA], [ON_LOCAL_SERVER], [PK_COLUMNS]) VALUES ( N'dbo', N'EIS_', @server, @bmsEisdb, N'Entity', NULL, N'dbo', 0, N'PK_ENTITY')
	INSERT [dbo].[ConfigTable] ([SOURCE_SCHEMA], [SERVER_PREFIX], [LINKED_SERVER_NAME], [SOURCE_DB], [TABLE_NAME], [WHERE_CONDITION], [DESTINATION_SCHEMA], [ON_LOCAL_SERVER], [PK_COLUMNS]) VALUES ( N'dbo', N'EIS_', @server, @bmsEisdb, N'EHL7_ADDRESS', NULL, N'dbo', 0, N'PK_ADDRESS')
	INSERT [dbo].[ConfigTable] ([SOURCE_SCHEMA], [SERVER_PREFIX], [LINKED_SERVER_NAME], [SOURCE_DB], [TABLE_NAME], [WHERE_CONDITION], [DESTINATION_SCHEMA], [ON_LOCAL_SERVER], [PK_COLUMNS]) VALUES ( N'dbo', N'EIS_', @server, @bmsEisdb, N'DOMAIN', NULL, N'dbo', 0, N'PK_DOMAIN')
	INSERT [dbo].[ConfigTable] ([SOURCE_SCHEMA], [SERVER_PREFIX], [LINKED_SERVER_NAME], [SOURCE_DB], [TABLE_NAME], [WHERE_CONDITION], [DESTINATION_SCHEMA], [ON_LOCAL_SERVER], [PK_COLUMNS]) VALUES ( N'dbo', N'EIS_', @server, @bmsEisdb, N'EHL7_ROLE', NULL, N'dbo', 0, N'PK_ROLE')
	INSERT [dbo].[ConfigTable] ([SOURCE_SCHEMA], [SERVER_PREFIX], [LINKED_SERVER_NAME], [SOURCE_DB], [TABLE_NAME], [WHERE_CONDITION], [DESTINATION_SCHEMA], [ON_LOCAL_SERVER], [PK_COLUMNS]) VALUES ( N'dbo', N'EIS_', @server, @bmsEisdb, N'EHL7_ORGANIZATION', NULL, N'dbo', 0, N'PFK_ORGANIZATION')
	INSERT [dbo].[ConfigTable] ([SOURCE_SCHEMA], [SERVER_PREFIX], [LINKED_SERVER_NAME], [SOURCE_DB], [TABLE_NAME], [WHERE_CONDITION], [DESTINATION_SCHEMA], [ON_LOCAL_SERVER], [PK_COLUMNS]) VALUES ( N'dbo', N'EIS_', @server, @bmsEisdb, N'ENTITY_TYPE_ON_DOMAIN', NULL, N'dbo', 0, N'PK_ENTITY_TYPE_ON_DOMAIN')
	INSERT [dbo].[ConfigTable] ([SOURCE_SCHEMA], [SERVER_PREFIX], [LINKED_SERVER_NAME], [SOURCE_DB], [TABLE_NAME], [WHERE_CONDITION], [DESTINATION_SCHEMA], [ON_LOCAL_SERVER], [PK_COLUMNS]) VALUES ( N'dbo', N'EIS_', @server, @bmsEisdb, N'EHL7_PERSON', NULL, N'dbo', 0, N'PFK_PERSON')
	INSERT [dbo].[ConfigTable] ([SOURCE_SCHEMA], [SERVER_PREFIX], [LINKED_SERVER_NAME], [SOURCE_DB], [TABLE_NAME], [WHERE_CONDITION], [DESTINATION_SCHEMA], [ON_LOCAL_SERVER], [PK_COLUMNS]) VALUES ( N'dbo', N'EIS_', @server, @bmsEisdb, N'EHL7_UID', NULL, N'dbo', 0, N'PK_UID')
	INSERT [dbo].[ConfigTable] ([SOURCE_SCHEMA], [SERVER_PREFIX], [LINKED_SERVER_NAME], [SOURCE_DB], [TABLE_NAME], [WHERE_CONDITION], [DESTINATION_SCHEMA], [ON_LOCAL_SERVER], [PK_COLUMNS]) VALUES ( N'dbo', N'EIS_', @server, @bmsEisdb, N'EHL7_ENTITY_ADDRESS', NULL, N'dbo', 0, N'PK_ENTITY_ADDRESS')
	INSERT [dbo].[ConfigTable] ([SOURCE_SCHEMA], [SERVER_PREFIX], [LINKED_SERVER_NAME], [SOURCE_DB], [TABLE_NAME], [WHERE_CONDITION], [DESTINATION_SCHEMA], [ON_LOCAL_SERVER], [PK_COLUMNS]) VALUES ( N'dbo', N'EIS_', @server, @bmsEisdb, N'TRAIT', NULL, N'dbo', 0, N'PK_TRAIT')
	INSERT [dbo].[ConfigTable] ([SOURCE_SCHEMA], [SERVER_PREFIX], [LINKED_SERVER_NAME], [SOURCE_DB], [TABLE_NAME], [WHERE_CONDITION], [DESTINATION_SCHEMA], [ON_LOCAL_SERVER], [PK_COLUMNS]) VALUES ( N'dbo', N'EIS_', @server, @bmsEisdb, N'TRAIT_ASSIGNMENT_ENTITY_TYPE', NULL, N'dbo', 0, N'PK_TRAIT_ASSIGNMENT_ENTITY_TYPE')
	INSERT [dbo].[ConfigTable] ([SOURCE_SCHEMA], [SERVER_PREFIX], [LINKED_SERVER_NAME], [SOURCE_DB], [TABLE_NAME], [WHERE_CONDITION], [DESTINATION_SCHEMA], [ON_LOCAL_SERVER], [PK_COLUMNS]) VALUES ( N'dbo', N'EIS_', @server, @bmsEisdb, N'TRAIT_VALUE', NULL, N'dbo', 0, N'PK_TRAIT_VALUE')
	INSERT [dbo].[ConfigTable] ([SOURCE_SCHEMA], [SERVER_PREFIX], [LINKED_SERVER_NAME], [SOURCE_DB], [TABLE_NAME], [WHERE_CONDITION], [DESTINATION_SCHEMA], [ON_LOCAL_SERVER], [PK_COLUMNS]) VALUES ( N'dbo', N'EIS_', @server, @bmsEisdb, N'EHL7_PLACE', NULL, N'dbo', 0, N'PFK_PLACE')
	INSERT [dbo].[ConfigTable] ([SOURCE_SCHEMA], [SERVER_PREFIX], [LINKED_SERVER_NAME], [SOURCE_DB], [TABLE_NAME], [WHERE_CONDITION], [DESTINATION_SCHEMA], [ON_LOCAL_SERVER], [PK_COLUMNS]) VALUES ( N'dbo', N'EIS_', @server, @bmsEisdb, N'EHL7_ENTITY_TELECOM', NULL, N'dbo', 0, N'PK_ENTITY_TELECOM')
	INSERT [dbo].[ConfigTable] ([SOURCE_SCHEMA], [SERVER_PREFIX], [LINKED_SERVER_NAME], [SOURCE_DB], [TABLE_NAME], [WHERE_CONDITION], [DESTINATION_SCHEMA], [ON_LOCAL_SERVER], [PK_COLUMNS]) VALUES ( N'dbo', N'EIS_', @server, @bmsEisdb, N'EHL7_TELECOM', NULL, N'dbo', 0, N'PK_TELECOM')
	INSERT [dbo].[ConfigTable] ([SOURCE_SCHEMA], [SERVER_PREFIX], [LINKED_SERVER_NAME], [SOURCE_DB], [TABLE_NAME], [WHERE_CONDITION], [DESTINATION_SCHEMA], [ON_LOCAL_SERVER], [PK_COLUMNS]) VALUES ( N'dbo', N'EVS_', @server, @bmsEvsdb, N'codingSchemeMultiAttributes', NULL, N'dbo', 0, NULL)
	INSERT [dbo].[ConfigTable] ([SOURCE_SCHEMA], [SERVER_PREFIX], [LINKED_SERVER_NAME], [SOURCE_DB], [TABLE_NAME], [WHERE_CONDITION], [DESTINATION_SCHEMA], [ON_LOCAL_SERVER], [PK_COLUMNS]) VALUES ( N'dbo', N'EVS_', @server, @bmsEvsdb, N'voc_nested_value_set', NULL, N'dbo', 0, N'uid,valueSetID,level')
	INSERT [dbo].[ConfigTable] ([SOURCE_SCHEMA], [SERVER_PREFIX], [LINKED_SERVER_NAME], [SOURCE_DB], [TABLE_NAME], [WHERE_CONDITION], [DESTINATION_SCHEMA], [ON_LOCAL_SERVER], [PK_COLUMNS]) VALUES ( N'dbo', N'EVS_', @server, @bmsEvsdb, N'conceptAssociationsToConcept', NULL, N'dbo', 0, N'codingSchemeName,relationName,association,sourceCodingSchemeName,sourceConceptCode,targetCodingSchemeName,targetConceptCode')
	INSERT [dbo].[ConfigTable] ([SOURCE_SCHEMA], [SERVER_PREFIX], [LINKED_SERVER_NAME], [SOURCE_DB], [TABLE_NAME], [WHERE_CONDITION], [DESTINATION_SCHEMA], [ON_LOCAL_SERVER], [PK_COLUMNS]) VALUES ( N'dbo', N'EVS_', @server, @bmsEvsdb, N'conceptProperty', NULL, N'dbo', 0, N'codingSchemeName,conceptCode,propertyId')
	INSERT [dbo].[ConfigTable] ([SOURCE_SCHEMA], [SERVER_PREFIX], [LINKED_SERVER_NAME], [SOURCE_DB], [TABLE_NAME], [WHERE_CONDITION], [DESTINATION_SCHEMA], [ON_LOCAL_SERVER], [PK_COLUMNS]) VALUES ( N'dbo', N'EVS_', @server, @bmsEvsdb, N'Voc_value_set', NULL, N'dbo', 0, N'valuesetID')
	INSERT [dbo].[ConfigTable] ([SOURCE_SCHEMA], [SERVER_PREFIX], [LINKED_SERVER_NAME], [SOURCE_DB], [TABLE_NAME], [WHERE_CONDITION], [DESTINATION_SCHEMA], [ON_LOCAL_SERVER], [PK_COLUMNS]) VALUES ( N'dbo', N'AUTHZ_', @server, @bmsAuthzdb, N'ACTION', NULL, N'dbo', 0, N'ID')
	INSERT [dbo].[ConfigTable] ([SOURCE_SCHEMA], [SERVER_PREFIX], [LINKED_SERVER_NAME], [SOURCE_DB], [TABLE_NAME], [WHERE_CONDITION], [DESTINATION_SCHEMA], [ON_LOCAL_SERVER], [PK_COLUMNS]) VALUES ( N'dbo', N'AUTHZ_', @server, @bmsAuthzdb, N'ACTION_GROUP', NULL, N'dbo', 0, N'GROUP_ID,ACTION_ID')
	INSERT [dbo].[ConfigTable] ([SOURCE_SCHEMA], [SERVER_PREFIX], [LINKED_SERVER_NAME], [SOURCE_DB], [TABLE_NAME], [WHERE_CONDITION], [DESTINATION_SCHEMA], [ON_LOCAL_SERVER], [PK_COLUMNS]) VALUES ( N'dbo', N'AUTHZ_', @server, @bmsAuthzdb, N'POLICY', NULL, N'dbo', 0, N'ID')
	INSERT [dbo].[ConfigTable] ([SOURCE_SCHEMA], [SERVER_PREFIX], [LINKED_SERVER_NAME], [SOURCE_DB], [TABLE_NAME], [WHERE_CONDITION], [DESTINATION_SCHEMA], [ON_LOCAL_SERVER], [PK_COLUMNS]) VALUES ( N'dbo', N'AUTHZ_', @server, @bmsAuthzdb, N'RESOURCE', NULL, N'dbo', 0, N'ID')
	INSERT [dbo].[ConfigTable] ([SOURCE_SCHEMA], [SERVER_PREFIX], [LINKED_SERVER_NAME], [SOURCE_DB], [TABLE_NAME], [WHERE_CONDITION], [DESTINATION_SCHEMA], [ON_LOCAL_SERVER], [PK_COLUMNS]) VALUES ( N'dbo', N'AUTHZ_', @server, @bmsAuthzdb, N'RESOURCE_TYPE', NULL, N'dbo', 0, N'ID')
	INSERT [dbo].[ConfigTable] ([SOURCE_SCHEMA], [SERVER_PREFIX], [LINKED_SERVER_NAME], [SOURCE_DB], [TABLE_NAME], [WHERE_CONDITION], [DESTINATION_SCHEMA], [ON_LOCAL_SERVER], [PK_COLUMNS]) VALUES ( N'dbo', N'AUTHZ_', @server, @bmsAuthzdb, N'ROLE_POLICY', NULL, N'dbo', 0, N'ROLE_ID,POLICY_ID')
	INSERT [dbo].[ConfigTable] ([SOURCE_SCHEMA], [SERVER_PREFIX], [LINKED_SERVER_NAME], [SOURCE_DB], [TABLE_NAME], [WHERE_CONDITION], [DESTINATION_SCHEMA], [ON_LOCAL_SERVER], [PK_COLUMNS]) VALUES ( N'dbo', N'AUTHZ_', @server, @bmsAuthzdb, N'ROLE', NULL, N'dbo', 0, N'ID')
	INSERT [dbo].[ConfigTable] ([SOURCE_SCHEMA], [SERVER_PREFIX], [LINKED_SERVER_NAME], [SOURCE_DB], [TABLE_NAME], [WHERE_CONDITION], [DESTINATION_SCHEMA], [ON_LOCAL_SERVER], [PK_COLUMNS]) VALUES ( N'dbo', N'AUTHZ_', @server, @bmsAuthzdb, N'USER_ROLE', NULL, N'dbo', 0, N'PK_SID,ROLE_ID')
	INSERT [dbo].[ConfigTable] ([SOURCE_SCHEMA], [SERVER_PREFIX], [LINKED_SERVER_NAME], [SOURCE_DB], [TABLE_NAME], [WHERE_CONDITION], [DESTINATION_SCHEMA], [ON_LOCAL_SERVER], [PK_COLUMNS]) VALUES ( N'dbo', N'AUTHZ_', @server, @bmsAuthzdb, N'SID_USER', NULL, N'dbo', 0, N'PK')
	INSERT [dbo].[ConfigTable] ([SOURCE_SCHEMA], [SERVER_PREFIX], [LINKED_SERVER_NAME], [SOURCE_DB], [TABLE_NAME], [WHERE_CONDITION], [DESTINATION_SCHEMA], [ON_LOCAL_SERVER], [PK_COLUMNS]) VALUES ( N'dbo', N'BMS_', @server, @bmsdb, N'ACT', NULL, N'dbo', 0, N'ID')
	INSERT [dbo].[ConfigTable] ([SOURCE_SCHEMA], [SERVER_PREFIX], [LINKED_SERVER_NAME], [SOURCE_DB], [TABLE_NAME], [WHERE_CONDITION], [DESTINATION_SCHEMA], [ON_LOCAL_SERVER], [PK_COLUMNS]) VALUES ( N'dbo', N'BMS_', @server, @bmsdb, N'ADMISSION_EVN', NULL, N'dbo', 0, N'ID')
	INSERT [dbo].[ConfigTable] ([SOURCE_SCHEMA], [SERVER_PREFIX], [LINKED_SERVER_NAME], [SOURCE_DB], [TABLE_NAME], [WHERE_CONDITION], [DESTINATION_SCHEMA], [ON_LOCAL_SERVER], [PK_COLUMNS]) VALUES ( N'dbo', N'BMS_', @server, @bmsdb, N'ADMISSION_REQ', NULL, N'dbo', 0, N'ID')
	INSERT [dbo].[ConfigTable] ([SOURCE_SCHEMA], [SERVER_PREFIX], [LINKED_SERVER_NAME], [SOURCE_DB], [TABLE_NAME], [WHERE_CONDITION], [DESTINATION_SCHEMA], [ON_LOCAL_SERVER], [PK_COLUMNS]) VALUES ( N'dbo', N'BMS_', @server, @bmsdb, N'BED_CLEAN', NULL, N'dbo', 0, N'ID')
	INSERT [dbo].[ConfigTable] ([SOURCE_SCHEMA], [SERVER_PREFIX], [LINKED_SERVER_NAME], [SOURCE_DB], [TABLE_NAME], [WHERE_CONDITION], [DESTINATION_SCHEMA], [ON_LOCAL_SERVER], [PK_COLUMNS]) VALUES ( N'dbo', N'BMS_', @server, @bmsdb, N'BED_UNAVAILABLE', NULL, N'dbo', 0, N'ACT_ID')
	INSERT [dbo].[ConfigTable] ([SOURCE_SCHEMA], [SERVER_PREFIX], [LINKED_SERVER_NAME], [SOURCE_DB], [TABLE_NAME], [WHERE_CONDITION], [DESTINATION_SCHEMA], [ON_LOCAL_SERVER], [PK_COLUMNS]) VALUES ( N'dbo', N'BMS_', @server, @bmsdb, N'CONCEPT', NULL, N'dbo', 0, N'ID')
	INSERT [dbo].[ConfigTable] ([SOURCE_SCHEMA], [SERVER_PREFIX], [LINKED_SERVER_NAME], [SOURCE_DB], [TABLE_NAME], [WHERE_CONDITION], [DESTINATION_SCHEMA], [ON_LOCAL_SERVER], [PK_COLUMNS]) VALUES ( N'dbo', N'BMS_', @server, @bmsdb, N'DISCHARGE_EVN', NULL, N'dbo', 0, N'ID')
	INSERT [dbo].[ConfigTable] ([SOURCE_SCHEMA], [SERVER_PREFIX], [LINKED_SERVER_NAME], [SOURCE_DB], [TABLE_NAME], [WHERE_CONDITION], [DESTINATION_SCHEMA], [ON_LOCAL_SERVER], [PK_COLUMNS]) VALUES ( N'dbo', N'BMS_', @server, @bmsdb, N'DISCHARGE_INT', NULL, N'dbo', 0, N'ID')
	INSERT [dbo].[ConfigTable] ([SOURCE_SCHEMA], [SERVER_PREFIX], [LINKED_SERVER_NAME], [SOURCE_DB], [TABLE_NAME], [WHERE_CONDITION], [DESTINATION_SCHEMA], [ON_LOCAL_SERVER], [PK_COLUMNS]) VALUES ( N'dbo', N'BMS_', @server, @bmsdb, N'DISCHARGE_REQ', NULL, N'dbo', 0, N'ID')
	INSERT [dbo].[ConfigTable] ([SOURCE_SCHEMA], [SERVER_PREFIX], [LINKED_SERVER_NAME], [SOURCE_DB], [TABLE_NAME], [WHERE_CONDITION], [DESTINATION_SCHEMA], [ON_LOCAL_SERVER], [PK_COLUMNS]) VALUES ( N'dbo', N'BMS_', @server, @bmsdb, N'MOVEMENT_EVN', NULL, N'dbo', 0, N'ID')
	INSERT [dbo].[ConfigTable] ([SOURCE_SCHEMA], [SERVER_PREFIX], [LINKED_SERVER_NAME], [SOURCE_DB], [TABLE_NAME], [WHERE_CONDITION], [DESTINATION_SCHEMA], [ON_LOCAL_SERVER], [PK_COLUMNS]) VALUES ( N'dbo', N'BMS_', @server, @bmsdb, N'MOVEMENT_REQ', NULL, N'dbo', 0, N'ID')
	INSERT [dbo].[ConfigTable] ([SOURCE_SCHEMA], [SERVER_PREFIX], [LINKED_SERVER_NAME], [SOURCE_DB], [TABLE_NAME], [WHERE_CONDITION], [DESTINATION_SCHEMA], [ON_LOCAL_SERVER], [PK_COLUMNS]) VALUES ( N'dbo', N'BMS_', @server, @bmsdb, N'TRANSFER_EVN', NULL, N'dbo', 0, N'ACT_ID')
	INSERT [dbo].[ConfigTable] ([SOURCE_SCHEMA], [SERVER_PREFIX], [LINKED_SERVER_NAME], [SOURCE_DB], [TABLE_NAME], [WHERE_CONDITION], [DESTINATION_SCHEMA], [ON_LOCAL_SERVER], [PK_COLUMNS]) VALUES ( N'dbo', N'BMS_', @server, @bmsdb, N'TRANSFER_REQ', NULL, N'dbo', 0, N'ACT_ID')	
	INSERT [dbo].[ConfigTable] ([SOURCE_SCHEMA], [SERVER_PREFIX], [LINKED_SERVER_NAME], [SOURCE_DB], [TABLE_NAME], [WHERE_CONDITION], [DESTINATION_SCHEMA], [ON_LOCAL_SERVER], [PK_COLUMNS]) VALUES ( N'dbo', N'BMS_', @server, @bmsdb, N'WAITING_LIST', NULL, N'dbo', 0, N'ACT_ID')
	INSERT [dbo].[ConfigTable] ([SOURCE_SCHEMA], [SERVER_PREFIX], [LINKED_SERVER_NAME], [SOURCE_DB], [TABLE_NAME], [WHERE_CONDITION], [DESTINATION_SCHEMA], [ON_LOCAL_SERVER], [PK_COLUMNS]) VALUES ( N'dbo', N'BMS_', @server, @bmsdb, N'BED_REASON_COMMENT_HISTORY', NULL, N'dbo', 0, N'ID')
	INSERT [dbo].[ConfigTable] ([SOURCE_SCHEMA], [SERVER_PREFIX], [LINKED_SERVER_NAME], [SOURCE_DB], [TABLE_NAME], [WHERE_CONDITION], [DESTINATION_SCHEMA], [ON_LOCAL_SERVER], [PK_COLUMNS]) VALUES ( N'dbo', N'BMS_', @server, @bmsdb, N'ORDER_FACILITY', NULL, N'dbo', 0, N'ID')
	INSERT [dbo].[ConfigTable] ([SOURCE_SCHEMA], [SERVER_PREFIX], [LINKED_SERVER_NAME], [SOURCE_DB], [TABLE_NAME], [WHERE_CONDITION], [DESTINATION_SCHEMA], [ON_LOCAL_SERVER], [PK_COLUMNS]) VALUES ( N'dbo', N'BMS_', @server, @bmsdb, N'ICON_ASSOCIATION', NULL, N'dbo', 0, N'ID')
	INSERT [dbo].[ConfigTable] ([SOURCE_SCHEMA], [SERVER_PREFIX], [LINKED_SERVER_NAME], [SOURCE_DB], [TABLE_NAME], [WHERE_CONDITION], [DESTINATION_SCHEMA], [ON_LOCAL_SERVER], [PK_COLUMNS]) VALUES ( N'dbo', N'BMS_', @server, @bmsdb, N'ICON_FLAG', NULL, N'dbo', 0, N'ID')
	INSERT [dbo].[ConfigTable] ([SOURCE_SCHEMA], [SERVER_PREFIX], [LINKED_SERVER_NAME], [SOURCE_DB], [TABLE_NAME], [WHERE_CONDITION], [DESTINATION_SCHEMA], [ON_LOCAL_SERVER], [PK_COLUMNS]) VALUES ( N'dbo', N'BMS_', @server, @bmsdb, N'ICON_FLAG_FACILITY', NULL, N'dbo', 0, N'ID')
	INSERT [dbo].[ConfigTable] ([SOURCE_SCHEMA], [SERVER_PREFIX], [LINKED_SERVER_NAME], [SOURCE_DB], [TABLE_NAME], [WHERE_CONDITION], [DESTINATION_SCHEMA], [ON_LOCAL_SERVER], [PK_COLUMNS]) VALUES ( N'dbo', N'BMS_', @server, @bmsdb, N'BED_SWITCH', NULL, N'dbo', 0, N'ID')
	INSERT [dbo].[ConfigTable] ([SOURCE_SCHEMA], [SERVER_PREFIX], [LINKED_SERVER_NAME], [SOURCE_DB], [TABLE_NAME], [WHERE_CONDITION], [DESTINATION_SCHEMA], [ON_LOCAL_SERVER], [PK_COLUMNS]) VALUES ( N'dbo', N'BMS_', @server, @bmsdb, N'SPECIALTY_TRANSFER', NULL, N'dbo', 0, N'ID')
	INSERT [dbo].[ConfigTable] ([SOURCE_SCHEMA], [SERVER_PREFIX], [LINKED_SERVER_NAME], [SOURCE_DB], [TABLE_NAME], [WHERE_CONDITION], [DESTINATION_SCHEMA], [ON_LOCAL_SERVER], [PK_COLUMNS]) VALUES ( N'dbo', N'BMS_', @server, @bmsdb, N'HOSPITAL_LOCATION_APPOINTMENT', NULL, N'dbo', 0, N'ID')
	INSERT [dbo].[ConfigTable] ([SOURCE_SCHEMA], [SERVER_PREFIX], [LINKED_SERVER_NAME], [SOURCE_DB], [TABLE_NAME], [WHERE_CONDITION], [DESTINATION_SCHEMA], [ON_LOCAL_SERVER], [PK_COLUMNS]) VALUES ( N'dbo', N'BMS_', @server, @bmsdb, N'SCHEDULED_ADMISSION', NULL, N'dbo', 0, N'ID')

	USE $(varBMS_DW)

	TRUNCATE TABLE [dbo].[CONFIGTABLE]
	INSERT [dbo].[CONFIGTABLE] ([PARAMETER], [VALUE]) VALUES (N'SourceDataBase', N'$(varBMS_DS)')
	INSERT [dbo].[CONFIGTABLE] ([PARAMETER], [VALUE]) VALUES (N'HISTORY_DB', N'$(varBMS_HISTORY)')

	/****** Object:  Table [dbo].[DIM_BED_STATUS]    Script Date: 11/29/2011 11:34:09 ******/
	INSERT [dbo].[DIM_BED_STATUS] ([ID], [STATUS]) VALUES (N'AVL', N'Available')
	INSERT [dbo].[DIM_BED_STATUS] ([ID], [STATUS]) VALUES (N'BED_ASSIGNED', N'BED ASSIGNED')
	INSERT [dbo].[DIM_BED_STATUS] ([ID], [STATUS]) VALUES (N'CLN', N'Clean')
	INSERT [dbo].[DIM_BED_STATUS] ([ID], [STATUS]) VALUES (N'CLOSED', N'CLOSED')
	INSERT [dbo].[DIM_BED_STATUS] ([ID], [STATUS]) VALUES (N'DND', N'Do not display')
	INSERT [dbo].[DIM_BED_STATUS] ([ID], [STATUS]) VALUES (N'OCC', N'Occupied')
	INSERT [dbo].[DIM_BED_STATUS] ([ID], [STATUS]) VALUES (N'UVL', N'Unavailable')
	INSERT [dbo].[DIM_BED_STATUS] ([ID], [STATUS]) VALUES (N'OOS_VISTA', N'Bed Out Of Service (Thru VistA)')

END TRY
BEGIN CATCH
	DECLARE @ErrorMessage NVARCHAR(4000)
    DECLARE @ErrorSeverity INT
    DECLARE @ErrorState INT

    SELECT 
        @ErrorMessage = ERROR_MESSAGE(),
        @ErrorSeverity = ERROR_SEVERITY(),
        @ErrorState = ERROR_STATE()

	IF @@TRANCOUNT > 0
        ROLLBACK TRAN

    -- Use RAISERROR inside the CATCH block to return error
    -- information about the original error that caused
    -- execution to jump to the CATCH block.
    RAISERROR (@ErrorMessage, -- Message text.
               @ErrorSeverity, -- Severity.
               @ErrorState -- State.
               )
END CATCH

IF @@TRANCOUNT > 0
    COMMIT TRAN
